/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.zonecreate;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceZoneManager;
import org.odpi.openmetadata.accessservices.governanceprogram.samples.zonecreate.GovernanceZoneSampleDefinitions;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceZoneProperties;
import org.odpi.openmetadata.http.HttpHelper;

public class CreateGovernanceZoneSample {
    private final String serverName;
    private final String serverURLRoot;
    private final String clientUserId;
    private GovernanceZoneManager client = null;

    public CreateGovernanceZoneSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void createZone(String zoneName, String displayName, String description, String criteria) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        System.out.println("------------------------------------------------------------------------");
        System.out.println(zoneName);
        System.out.println("------------------------------------------------------------------------");
        System.out.println(" ==> zoneName: " + zoneName);
        System.out.println(" ==> displayName:   " + displayName);
        System.out.println(" ==> description:   " + description);
        System.out.println(" ==> criteria:      " + criteria);
        System.out.println(" ");
        GovernanceZoneProperties zoneProperties = new GovernanceZoneProperties();
        zoneProperties.setQualifiedName("GovernanceZone:" + zoneName);
        zoneProperties.setZoneName(zoneName);
        zoneProperties.setDisplayName(displayName);
        zoneProperties.setDescription(description);
        zoneProperties.setCriteria(criteria);
        this.client.createGovernanceZone(this.clientUserId, zoneProperties);
    }

    public void run() {
        try {
            GovernanceZoneSampleDefinitions[] zoneSampleDefinitions;
            this.client = new GovernanceZoneManager(this.serverName, this.serverURLRoot);
            for (GovernanceZoneSampleDefinitions zoneDefinition : zoneSampleDefinitions = GovernanceZoneSampleDefinitions.values()) {
                this.createZone(zoneDefinition.getZoneName(), zoneDefinition.getDisplayName(), zoneDefinition.getDescription(), zoneDefinition.getCriteria());
            }
            List zones = this.client.getGovernanceZonesForDomain(this.clientUserId, 0, 0, 0);
            int matchingZones = 0;
            for (GovernanceZoneElement zone : zones) {
                for (GovernanceZoneSampleDefinitions zoneDefinition : zoneSampleDefinitions) {
                    if (!zoneDefinition.getZoneName().equals(zone.getGovernanceZoneProperties().getZoneName())) continue;
                    if (zoneDefinition.getDisplayName().equals(zone.getGovernanceZoneProperties().getDisplayName()) && zoneDefinition.getDisplayName().equals(zone.getGovernanceZoneProperties().getDisplayName()) && zoneDefinition.getDisplayName().equals(zone.getGovernanceZoneProperties().getDisplayName())) {
                        ++matchingZones;
                        continue;
                    }
                    System.out.println("Retrieved zone: " + String.valueOf(zone) + " does not match zone definition: " + String.valueOf((Object)zoneDefinition));
                }
            }
            if (matchingZones != zoneSampleDefinitions.length) {
                System.out.println("Retrieved " + matchingZones + " zones: " + String.valueOf(zones));
            }
        }
        catch (Exception error) {
            System.out.println("There was an exception when calling the GovernanceZoneManager client.  Error message is: " + error.getMessage());
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String serverName = "simple-metadata-store";
        String serverURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("Create Governance Zones Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            CreateGovernanceZoneSample sample = new CreateGovernanceZoneSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

