/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.eventmapper;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperBase;

public class GraphOMRSRepositoryEventMapper
extends OMRSRepositoryEventMapperBase
implements VirtualConnectorExtension,
OpenMetadataTopicListener {
    private List<Connector> embeddedConnectors = null;
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.embeddedConnectors != null) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                String topicName = realTopicConnector.registerListener((OpenMetadataTopicListener)this);
                this.eventBusConnectors.add(realTopicConnector);
                if (this.auditLog == null) continue;
                OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_REGISTERED;
                this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.repositoryEventMapperName, topicName}), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.eventBusConnectors.isEmpty() && this.auditLog != null) {
            OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_DEAF;
            this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.repositoryEventMapperName}), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public void processEvent(String event) {
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

