/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSConstants;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSGraphFactory.class);
    private static JanusGraph graph;
    private static String thisRepositoryName;
    private static String thisMetadataCollectionId;
    private static String INDEX_NAME;
    private static OMRSAuditLog thisAuditLog;
    private static String controlVertexIdPropertyName;
    private static String controlVertexIdPropertyValue;
    public static final Map<String, MixedIndexMapping> corePropertyMixedIndexMappings;

    public static JanusGraph open(String metadataCollectionId, String repositoryName, OMRSAuditLog auditLog) throws RepositoryErrorException {
        Vertex controlVertex;
        String methodName = "open";
        thisMetadataCollectionId = metadataCollectionId;
        thisRepositoryName = repositoryName;
        thisAuditLog = auditLog;
        String storageBackend = "berkeleyje";
        String storagePath = "./egeria-graph-repository/berkeley";
        String indexBackend = "lucene";
        String indexPath = "./egeria-graph-repository/searchindex";
        JanusGraphFactory.Builder config = JanusGraphFactory.build().set("storage.backend", (Object)"berkeleyje").set("storage.directory", (Object)"./egeria-graph-repository/berkeley").set("index.search.backend", (Object)"lucene").set("index.search.directory", (Object)"./egeria-graph-repository/searchindex");
        try {
            graph = config.open();
        }
        catch (Exception e) {
            log.error("{} could not open graph stored at {}", (Object)"open", (Object)"./egeria-graph-repository/berkeley");
            GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("./egeria-graph-repository/berkeley", "open", GraphOMRSGraphFactory.class.getName(), repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), GraphOMRSGraphFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        GraphTraversalSource g = graph.traversal();
        boolean success = true;
        GraphTraversal vi = g.V(new Object[0]).hasLabel("Control", new String[0]).has(controlVertexIdPropertyName, (Object)controlVertexIdPropertyValue);
        if (!vi.hasNext()) {
            controlVertex = null;
        } else {
            controlVertex = (Vertex)vi.next();
            if (controlVertex == null) {
                log.error("Graph initialization failed because valid controlVertex could not be located");
                success = false;
            }
        }
        if (!success) {
            g.tx().rollback();
            graph = null;
            return graph;
        }
        g.tx().commit();
        g = graph.traversal();
        if (controlVertex == null) {
            success = GraphOMRSGraphFactory.createControlIndex();
            if (success) {
                try {
                    Date now = new Date();
                    controlVertex = (Vertex)g.addV("Control").property((Object)controlVertexIdPropertyName, (Object)controlVertexIdPropertyValue, new Object[0]).property((Object)"creationDate", (Object)now, new Object[0]).property((Object)"lastOpenDate", (Object)now, new Object[0]).property((Object)"metadataCollectionId", (Object)metadataCollectionId, new Object[0]).next();
                    now = new Date();
                    controlVertex.property("lastOpenDate", (Object)now);
                    success = true;
                }
                catch (Exception e) {
                    log.error("{} Creation of control vertex failed, exception {}", (Object)"open", (Object)e.getMessage());
                    g.tx().rollback();
                    throw e;
                }
                GraphOMRSAuditCode auditCode = GraphOMRSAuditCode.GRAPH_REPOSITORY_CREATED;
                String actionDescription = "openGraphRepository";
                thisAuditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        } else {
            try {
                success = GraphOMRSGraphFactory.checkAndUpdateControlInformation(controlVertex, "./egeria-graph-repository/berkeley");
            }
            catch (RepositoryErrorException e) {
                log.error("{} Check and update of control vertex failed, exception {}", (Object)"open", (Object)e.getMessage());
                g.tx().rollback();
                throw e;
            }
        }
        if (success) {
            try {
                log.info("Updating graph schema, if necessary");
                GraphOMRSGraphFactory.initialize(graph);
            }
            catch (RepositoryErrorException e) {
                g.tx().rollback();
                throw e;
            }
        }
        if (success) {
            g.tx().commit();
        } else {
            g.tx().rollback();
            graph = null;
        }
        return graph;
    }

    private static void initialize(JanusGraph graph) throws RepositoryErrorException {
        String methodName = "initialize";
        try {
            JanusGraphManagement management = graph.openManagement();
            if (management.getVertexLabel("Control") == null) {
                management.makeVertexLabel("Control").make();
            }
            if (management.getVertexLabel("Entity") == null) {
                management.makeVertexLabel("Entity").make();
            }
            if (management.getVertexLabel("Classification") == null) {
                management.makeVertexLabel("Classification").make();
            }
            if (management.getEdgeLabel("Relationship") == null) {
                management.makeEdgeLabel("Relationship").make();
            }
            if (management.getEdgeLabel("Classifier") == null) {
                management.makeEdgeLabel("Classifier").make();
            }
            management.commit();
            GraphOMRSGraphFactory.createCompositeIndexForVertexProperty("guid", "veguid", true);
            GraphOMRSGraphFactory.createCompositeIndexForVertexProperty("typeName", "vetypeName", false);
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("createdBy", "vecreatedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("updatedBy", "veupdatedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("maintainedBy", "vemaintainedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("metadataCollectionName", "vemetadataCollectionName");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("instanceURL", "veinstanceURL");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("instanceLicense", "veinstanceLicense");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("replicatedBy", "vereplicatedBy");
            GraphOMRSGraphFactory.createCompositeIndexForEdgeProperty("guid", "erguid");
            GraphOMRSGraphFactory.createCompositeIndexForEdgeProperty("typeName", "ertypeName");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("createdBy", "ercreatedBy");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("updatedBy", "erupdatedBy");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("maintainedBy", "ermaintainedBy");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("metadataCollectionName", "ermetadataCollectionName");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("instanceURL", "erinstanceURL");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("instanceLicense", "erinstanceLicense");
            GraphOMRSGraphFactory.createMixedIndexForEdgeCoreProperty("replicatedBy", "erreplicatedBy");
            GraphOMRSGraphFactory.createCompositeIndexForVertexProperty("typeName", "vctypeName", false);
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("classificationName", "vcclassificationName");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("createdBy", "vccreatedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("updatedBy", "vcupdatedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("maintainedBy", "vcmaintainedBy");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("metadataCollectionName", "vcmetadataCollectionName");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("instanceLicense", "vcinstanceLicense");
            GraphOMRSGraphFactory.createMixedIndexForVertexCoreProperty("replicatedBy", "vcreplicatedBy");
        }
        catch (Exception e) {
            log.error("{} Caught exception during graph initialize operation", (Object)"initialize");
            GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(thisRepositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), "GraphOMRSGraphFactory", "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void createMixedIndexForVertexCoreProperty(String propName, String propKeyName) {
        String className = GraphOMRSConstants.corePropertyTypes.get(propName);
        MixedIndexMapping mapping = corePropertyMixedIndexMappings.get(propKeyName);
        GraphOMRSGraphFactory.createMixedIndexForVertexProperty(propName, propKeyName, className, mapping);
    }

    public static void createMixedIndexForVertexProperty(String propName, String propKeyName, String className, MixedIndexMapping mapping) {
        Class<?> clazz;
        String methodName = "createMixedIndexForVertexProperty";
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} no index created for property {}; class {} not found", new Object[]{"createMixedIndexForVertexProperty", propName, className});
            return;
        }
        String indexName = "vertexIndexProperty" + propKeyName;
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists", (Object)"createMixedIndexForVertexProperty", (Object)indexName);
                management.rollback();
                return;
            }
            log.info("{} index create {} for vertex property {}", new Object[]{"createMixedIndexForVertexProperty", indexName, propKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists for property {}", (Object)"createMixedIndexForVertexProperty", (Object)propKeyName);
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createMixedIndexForVertexProperty", (Object)propKeyName);
                propertyKey = management.makePropertyKey(propKeyName).dataType(clazz).make();
            }
            log.debug("{} try to build index {}", (Object)"createMixedIndexForVertexProperty", (Object)indexName);
            JanusGraphManagement.IndexBuilder vertexIndexBuilder = management.buildIndex(indexName, Vertex.class);
            if (mapping == MixedIndexMapping.Text || mapping == MixedIndexMapping.Default) {
                vertexIndexBuilder.addKey(propertyKey);
            } else {
                vertexIndexBuilder.addKey(propertyKey, new Parameter[]{Mapping.STRING.asParameter()});
            }
            vertexIndexBuilder.buildMixedIndex("search");
            management.commit();
            log.debug("{} index created {}", (Object)"createMixedIndexForVertexProperty", (Object)indexName);
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                JanusGraphIndex index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createMixedIndexForVertexProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
            log.debug("{} index {} ready", (Object)"createMixedIndexForVertexProperty", (Object)indexName);
        }
        catch (Exception e) {
            log.error("{} !!! Caught exception from index construction for property name {}, key {}, exception {}", new Object[]{"createMixedIndexForVertexProperty", propName, propKeyName, e});
            management.rollback();
        }
    }

    private static void createCompositeIndexForVertexProperty(String propertyName, String propertyKeyName, boolean unique) {
        Class<?> clazz;
        String methodName = "createCompositeIndexForVertexProperty";
        String className = GraphOMRSConstants.corePropertyTypes.get(propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyName);
            log.error("{} NO INDEX CREATED for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyName);
            return;
        }
        String indexName = "vertexIndexComposite" + propertyKeyName;
        log.info("INDEX CREATE {}", (Object)indexName);
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists", (Object)"createCompositeIndexForVertexProperty", (Object)indexName);
                management.rollback();
                return;
            }
            log.info("{} index create {} for vertex property {}", new Object[]{"createCompositeIndexForVertexProperty", indexName, propertyKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyKeyName);
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyKeyName);
                propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
            }
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Vertex.class).addKey(propertyKey);
            if (unique) {
                indexBuilder.unique();
            }
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            if (unique) {
                management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
            }
            management.commit();
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createCompositeIndexForVertexProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"createCompositeIndexForVertexProperty", (Object)e);
            management.rollback();
        }
    }

    public static void createMixedIndexForEdgeCoreProperty(String propName, String propKeyName) {
        String className = GraphOMRSConstants.corePropertyTypes.get(propName);
        MixedIndexMapping mapping = corePropertyMixedIndexMappings.get(propKeyName);
        GraphOMRSGraphFactory.createMixedIndexForEdgeProperty(propName, propKeyName, className, mapping);
    }

    public static void createMixedIndexForEdgeProperty(String propName, String propKeyName, String className, MixedIndexMapping mapping) {
        Class<?> clazz;
        String methodName = "createMixedIndexForEdgeProperty";
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {} with class {}", new Object[]{"createMixedIndexForEdgeProperty", propName, className});
            log.error("{} NO INDEX CREATED for property {} type {}", (Object)"createMixedIndexForEdgeProperty", (Object)propName);
            return;
        }
        String indexName = "edgeIndexProperty" + propKeyName;
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists", (Object)"createMixedIndexForEdgeProperty", (Object)indexName);
                management.rollback();
                return;
            }
            log.info("{} INDEX CREATE {} for edge property {}", new Object[]{"createMixedIndexForEdgeProperty", indexName, propKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists ", (Object)"createMixedIndexForEdgeProperty");
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createMixedIndexForEdgeProperty", (Object)propKeyName);
                propertyKey = management.makePropertyKey(propKeyName).dataType(clazz).make();
            }
            log.debug("{} create index {}", (Object)"createMixedIndexForEdgeProperty", (Object)indexName);
            JanusGraphManagement.IndexBuilder edgeIndexBuilder = management.buildIndex(indexName, Edge.class);
            if (mapping == MixedIndexMapping.Text) {
                edgeIndexBuilder.addKey(propertyKey);
            } else if (mapping == MixedIndexMapping.Default) {
                edgeIndexBuilder.addKey(propertyKey, new Parameter[]{Mapping.DEFAULT.asParameter()});
            } else {
                edgeIndexBuilder.addKey(propertyKey, new Parameter[]{Mapping.STRING.asParameter()});
            }
            edgeIndexBuilder.buildMixedIndex("search");
            management.commit();
            log.debug("{} index created {}", (Object)"createMixedIndexForEdgeProperty", (Object)indexName);
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                JanusGraphIndex index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createMixedIndexForEdgeProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
            log.debug("{} index {} ready", (Object)"createMixedIndexForEdgeProperty", (Object)indexName);
        }
        catch (Exception e) {
            log.error("{} !!! Caught exception from index construction for property name {}, property key {}, exception {}", new Object[]{"createMixedIndexForEdgeProperty", propName, propKeyName, e});
            management.rollback();
        }
    }

    private static void createCompositeIndexForEdgeProperty(String propertyName, String propertyKeyName) {
        Class<?> clazz;
        String methodName = "createCompositeIndexForEdgeProperty";
        String className = GraphOMRSConstants.corePropertyTypes.get(propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyName);
            log.error("{} NO INDEX CREATED for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyName);
            return;
        }
        String indexName = "edgeIndexComposite" + propertyKeyName;
        log.info("INDEX CREATE {}", (Object)indexName);
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists for property {}", new Object[]{"createCompositeIndexForEdgeProperty", indexName, propertyKeyName});
                management.rollback();
                return;
            }
            log.info("{} INDEX CREATE {} for vertex property {}", new Object[]{"createCompositeIndexForEdgeProperty", indexName, propertyKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyKeyName);
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyKeyName);
                propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
            }
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Edge.class).addKey(propertyKey);
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            management.commit();
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createCompositeIndexForEdgeProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"createCompositeIndexForEdgeProperty", (Object)e);
            management.rollback();
        }
    }

    private static boolean createControlIndex() {
        String methodName = "createControlIndex";
        JanusGraphManagement management = graph.openManagement();
        String indexName = "controlIndex";
        try {
            JanusGraphIndex controlIndex = management.getGraphIndex(indexName);
            if (controlIndex == null) {
                log.info("{} index create {} for control vertex", (Object)"createControlIndex", (Object)indexName);
                PropertyKey propertyKey = management.getPropertyKey(controlVertexIdPropertyName);
                if (propertyKey != null) {
                    log.error("{} property key {} already exists", (Object)"createControlIndex", (Object)controlVertexIdPropertyName);
                    management.rollback();
                    return false;
                }
                log.info("{} make property key {}", (Object)"createControlIndex", (Object)controlVertexIdPropertyName);
                propertyKey = management.makePropertyKey(controlVertexIdPropertyName).dataType(String.class).make();
                if (propertyKey == null) {
                    log.error("{} property key {} could not be created", (Object)"createControlIndex", (Object)controlVertexIdPropertyName);
                    management.rollback();
                    return false;
                }
                log.info("{} create index {}", (Object)"createControlIndex", (Object)indexName);
                JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Vertex.class).addKey(propertyKey).unique();
                JanusGraphIndex index = indexBuilder.buildCompositeIndex();
                management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
                management.commit();
                log.info("{} await ENABLED for {}", (Object)"createControlIndex", (Object)indexName);
                ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
                return true;
            }
            log.error("{} control index already exists", (Object)"createControlIndex");
            management.rollback();
            return false;
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"createControlIndex", (Object)e);
            management.rollback();
            return false;
        }
    }

    private static boolean checkAndUpdateControlInformation(Vertex controlVertex, String storagePath) throws RepositoryErrorException {
        VertexProperty lastOpenDateProperty;
        VertexProperty metadataCollectionIdProperty;
        String methodName = "checkAndUpdateControlInformation";
        boolean ret = true;
        String creationDateString = null;
        String metadataCollectionIdString = null;
        String lastOpenDateString = null;
        VertexProperty creationDateProperty = controlVertex.property("creationDate");
        if (creationDateProperty != null && creationDateProperty.isPresent()) {
            creationDateString = creationDateProperty.value().toString();
        }
        if ((metadataCollectionIdProperty = controlVertex.property("metadataCollectionId")) != null && metadataCollectionIdProperty.isPresent()) {
            metadataCollectionIdString = (String)metadataCollectionIdProperty.value();
        }
        if ((lastOpenDateProperty = controlVertex.property("lastOpenDate")) != null && lastOpenDateProperty.isPresent()) {
            lastOpenDateString = lastOpenDateProperty.value().toString();
        }
        if (metadataCollectionIdString != null && !metadataCollectionIdString.equals(thisMetadataCollectionId)) {
            log.error("{} The graph database for repository {} has metadataCollectionId {}, and cannot be opened using metadataCollectionId {} ", new Object[]{"checkAndUpdateControlInformation", thisRepositoryName, metadataCollectionIdString, thisMetadataCollectionId});
            GraphOMRSAuditCode auditCode = GraphOMRSAuditCode.GRAPH_REPOSITORY_HAS_DIFFERENT_METADATA_COLLECTION_ID;
            String actionDescription = "openGraphRepository";
            thisAuditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.GRAPH_DB_HAS_DIFFERENT_METADATACOLLECTION_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(storagePath, "checkAndUpdateControlInformation", GraphOMRSGraphFactory.class.getName(), thisRepositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), GraphOMRSGraphFactory.class.getName(), "checkAndUpdateControlInformation", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        log.info("Opened graph repository: graph created at {} by metadataCollectionId {}, last opened at {}", new Object[]{creationDateString, metadataCollectionIdString, lastOpenDateString});
        log.info("Ensuring graph schema is up to date");
        try {
            GraphOMRSGraphFactory.initialize(graph);
            Date now = new Date();
            controlVertex.property("lastOpenDate", (Object)now);
            ret = true;
        }
        catch (Exception e) {
            log.error("Graph initialization failed, exception {}", (Object)e.getMessage());
            ret = false;
        }
        GraphOMRSAuditCode auditCode = GraphOMRSAuditCode.GRAPH_REPOSITORY_OPENED;
        String actionDescription = "openGraphRepository";
        thisAuditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return ret;
    }

    static {
        INDEX_NAME = "search";
        thisAuditLog = null;
        controlVertexIdPropertyName = "ControlVertexIdentifier";
        controlVertexIdPropertyValue = "ControlVertexIdentifier";
        corePropertyMixedIndexMappings = new HashMap<String, MixedIndexMapping>(){
            {
                this.put("vecreatedBy", MixedIndexMapping.String);
                this.put("veupdatedBy", MixedIndexMapping.String);
                this.put("vemaintainedBy", MixedIndexMapping.Text);
                this.put("vemetadataCollectionName", MixedIndexMapping.String);
                this.put("veinstanceURL", MixedIndexMapping.String);
                this.put("veinstanceLicense", MixedIndexMapping.String);
                this.put("vereplicatedBy", MixedIndexMapping.String);
                this.put("ercreatedBy", MixedIndexMapping.String);
                this.put("erupdatedBy", MixedIndexMapping.String);
                this.put("ermaintainedBy", MixedIndexMapping.Text);
                this.put("ermetadataCollectionName", MixedIndexMapping.String);
                this.put("erinstanceURL", MixedIndexMapping.String);
                this.put("erinstanceLicense", MixedIndexMapping.String);
                this.put("erreplicatedBy", MixedIndexMapping.String);
                this.put("vcclassificationName", MixedIndexMapping.String);
                this.put("vccreatedBy", MixedIndexMapping.String);
                this.put("vcupdatedBy", MixedIndexMapping.String);
                this.put("vcmaintainedBy", MixedIndexMapping.Text);
                this.put("vcmetadataCollectionName", MixedIndexMapping.String);
                this.put("vcinstanceLicense", MixedIndexMapping.String);
                this.put("vcreplicatedBy", MixedIndexMapping.String);
            }
        };
    }

    public static enum MixedIndexMapping {
        Default,
        Text,
        String;

    }
}

