/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSConstants;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMapperUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSRelationshipMapper {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSRelationshipMapper.class);
    private String repositoryName;
    private String metadataCollectionId;
    private OMRSRepositoryHelper repositoryHelper;

    public GraphOMRSRelationshipMapper(String metadataCollectionId, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
    }

    private Object getEdgeProperty(Edge edge, String propName) {
        Property ep = edge.property(propName);
        if (ep == null || !ep.isPresent()) {
            return null;
        }
        return ep.value();
    }

    private void addProperty(Edge edge, String propertyName, String qualifiedPropName, InstancePropertyValue ipv) {
        InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
        if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            if (primValue != null) {
                edge.property(GraphOMRSConstants.getPropertyKeyRelationship(qualifiedPropName), primValue);
            } else {
                this.removeProperty(edge, qualifiedPropName);
            }
        } else {
            log.debug("{} non-primitive instance property {}", (Object)propertyName);
        }
    }

    private void removeProperty(Edge edge, String qualifiedPropName) {
        Property ep = edge.property(GraphOMRSConstants.getPropertyKeyRelationship(qualifiedPropName));
        if (ep != null) {
            ep.remove();
        }
    }

    public void mapRelationshipToEdge(Relationship relationship, Edge edge) throws RepositoryErrorException {
        Property ep;
        Property ep2;
        String methodName = "mapRelationshipToEdge";
        boolean missingAttribute = false;
        String missingAttributeName = null;
        if (relationship.getGUID() != null) {
            edge.property("erguid", (Object)relationship.getGUID());
        } else {
            missingAttribute = true;
            missingAttributeName = "guid";
        }
        InstanceType instanceType = relationship.getType();
        if (instanceType != null && instanceType.getTypeDefName() != null) {
            edge.property("ertypeName", (Object)instanceType.getTypeDefName());
        } else {
            missingAttribute = true;
            missingAttributeName = "type or typeName";
        }
        if (this.metadataCollectionId != null) {
            edge.property("ermetadataCollectionId", (Object)this.metadataCollectionId);
        } else {
            missingAttribute = true;
            missingAttributeName = "metadataCollectionId";
        }
        if (missingAttribute) {
            log.error("{} relationship is missing a core attribute {}", (Object)"mapRelationshipToEdge", (Object)missingAttributeName);
            GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(relationship.getGUID(), "mapRelationshipToEdge", this.getClass().getName(), this.repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapRelationshipToEdge", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        edge.property("erversion", (Object)relationship.getVersion());
        if (relationship.getMetadataCollectionName() != null) {
            edge.property("ermetadataCollectionName", (Object)relationship.getMetadataCollectionName());
        } else {
            ep2 = edge.property("ermetadataCollectionName");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getCreatedBy() != null) {
            edge.property("ercreatedBy", (Object)relationship.getCreatedBy());
        } else {
            ep2 = edge.property("ercreatedBy");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getCreateTime() != null) {
            edge.property("ercreateTime", (Object)relationship.getCreateTime());
        } else {
            ep2 = edge.property("ercreateTime");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getUpdatedBy() != null) {
            edge.property("erupdatedBy", (Object)relationship.getUpdatedBy());
        } else {
            ep2 = edge.property("erupdatedBy");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getUpdateTime() != null) {
            edge.property("erupdateTime", (Object)relationship.getUpdateTime());
        } else {
            ep2 = edge.property("erupdateTime");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        edge.property("version", (Object)relationship.getVersion());
        if (relationship.getInstanceProvenanceType() != null) {
            edge.property("erprovenanceType", (Object)relationship.getInstanceProvenanceType().getOrdinal());
        } else {
            ep2 = edge.property("erprovenanceType");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getStatus() != null) {
            edge.property("erstatus", (Object)relationship.getStatus().getOrdinal());
        } else {
            ep2 = edge.property("erstatus");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getStatusOnDelete() != null) {
            edge.property("erstatusOnDelete", (Object)relationship.getStatusOnDelete().getOrdinal());
        } else {
            ep2 = edge.property("erstatusOnDelete");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getInstanceURL() != null) {
            edge.property("erinstanceURL", (Object)relationship.getInstanceURL());
        } else {
            ep2 = edge.property("erinstanceURL");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        if (relationship.getInstanceLicense() != null) {
            edge.property("erinstanceLicense", (Object)relationship.getInstanceLicense());
        } else {
            ep2 = edge.property("erinstanceLicense");
            if (ep2 != null) {
                ep2.remove();
            }
        }
        List maintainedByList = relationship.getMaintainedBy();
        if (maintainedByList != null && !maintainedByList.isEmpty()) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String jsonString = objectMapper.writeValueAsString((Object)maintainedByList);
                edge.property("ermaintainedBy", (Object)jsonString);
            }
            catch (Throwable exc) {
                GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("mapRelationshipToEdge", this.getClass().getName(), this.repositoryName);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapRelationshipToEdge", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            ep = edge.property("ermaintainedBy");
            if (ep != null) {
                ep.remove();
            }
        }
        if (relationship.getReplicatedBy() != null) {
            edge.property("erreplicatedBy", (Object)relationship.getReplicatedBy());
        } else {
            ep = edge.property("erreplicatedBy");
            if (ep != null) {
                ep.remove();
            }
        }
        InstanceProperties instanceProperties = relationship.getProperties();
        if (instanceProperties != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String jsonString = objectMapper.writeValueAsString((Object)instanceProperties);
                edge.property("relationshipProperties", (Object)jsonString);
            }
            catch (Throwable exc) {
                GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("mapRelationshipToEdge", this.getClass().getName(), this.repositoryName);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapRelationshipToEdge", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            String typeName = relationship.getType().getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            Map<String, String> qualifiedPropertyNames = GraphOMRSMapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "mapRelationshipToEdge");
            for (TypeDefAttribute propertyDef : propertiesDef) {
                String propertyName = propertyDef.getAttributeName();
                String qualifiedPropName = qualifiedPropertyNames.get(propertyName);
                InstancePropertyValue ipv = instanceProperties.getPropertyValue(propertyName);
                if (ipv != null) {
                    this.addProperty(edge, propertyName, qualifiedPropName, ipv);
                    continue;
                }
                this.removeProperty(edge, qualifiedPropName);
            }
        } else {
            log.debug("{} relationship has no properties", (Object)"mapRelationshipToEdge");
        }
    }

    public void mapEdgeToRelationship(Edge edge, Relationship relationship) throws RepositoryErrorException {
        String methodName = "mapEdgeToRelationship";
        relationship.setGUID((String)this.getEdgeProperty(edge, "erguid"));
        relationship.setMetadataCollectionId((String)this.getEdgeProperty(edge, "ermetadataCollectionId"));
        relationship.setMetadataCollectionName((String)this.getEdgeProperty(edge, "ermetadataCollectionName"));
        relationship.setCreatedBy((String)this.getEdgeProperty(edge, "ercreatedBy"));
        relationship.setCreateTime((Date)this.getEdgeProperty(edge, "ercreateTime"));
        relationship.setUpdatedBy((String)this.getEdgeProperty(edge, "erupdatedBy"));
        relationship.setUpdateTime((Date)this.getEdgeProperty(edge, "erupdateTime"));
        relationship.setVersion(((Long)this.getEdgeProperty(edge, "erversion")).longValue());
        relationship.setInstanceLicense((String)this.getEdgeProperty(edge, "erinstanceLicense"));
        relationship.setInstanceURL((String)this.getEdgeProperty(edge, "erinstanceURL"));
        String typeName = (String)this.getEdgeProperty(edge, "ertypeName");
        try {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            TypeDefSummary typeDefSummary = new TypeDefSummary(TypeDefCategory.RELATIONSHIP_DEF, typeName, typeDef.getName(), typeDef.getVersion(), typeDef.getVersionName());
            InstanceType instanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, typeDefSummary);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("{} caught TypeErrorException {}", (Object)"mapEdgeToRelationship", (Object)e.getMessage());
            GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_TYPE_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(typeName, "mapEdgeToRelationship", this.getClass().getName(), this.repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapEdgeToRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        Integer provenanceOrdinal = (Integer)this.getEdgeProperty(edge, "erprovenanceType");
        InstanceProvenanceType instanceProvenanceType = GraphOMRSMapperUtils.mapProvenanceOrdinalToEnum(provenanceOrdinal);
        relationship.setInstanceProvenanceType(instanceProvenanceType);
        Integer statusOrdinal = (Integer)this.getEdgeProperty(edge, "erstatus");
        InstanceStatus instanceStatus = GraphOMRSMapperUtils.mapStatusOrdinalToEnum(statusOrdinal);
        relationship.setStatus(instanceStatus);
        Integer statusOnDeleteOrdinal = (Integer)this.getEdgeProperty(edge, "erstatusOnDelete");
        InstanceStatus statusOnDelete = GraphOMRSMapperUtils.mapStatusOrdinalToEnum(statusOnDeleteOrdinal);
        relationship.setStatusOnDelete(statusOnDelete);
        String maintainedByString = (String)this.getEdgeProperty(edge, "ermaintainedBy");
        if (maintainedByString != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                List maintainedByList = (List)objectMapper.readValue(maintainedByString, List.class);
                log.debug("{} edge has deserialized maintainedBy list {}", (Object)"mapEdgeToRelationship", (Object)maintainedByList);
                relationship.setMaintainedBy(maintainedByList);
            }
            catch (Throwable exc) {
                GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(relationship.getGUID(), "mapEdgeToRelationship", this.getClass().getName(), this.repositoryName);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapEdgeToRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        relationship.setReplicatedBy((String)this.getEdgeProperty(edge, "erreplicatedBy"));
        String stringProps = (String)this.getEdgeProperty(edge, "relationshipProperties");
        if (stringProps != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                InstanceProperties instanceProperties = (InstanceProperties)objectMapper.readValue(stringProps, InstanceProperties.class);
                log.debug("{} relationship has deserialized properties {}", (Object)"mapEdgeToRelationship", (Object)instanceProperties);
                relationship.setProperties(instanceProperties);
            }
            catch (Throwable exc) {
                GraphOMRSErrorCode errorCode = GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(relationship.getGUID(), "mapEdgeToRelationship", this.getClass().getName(), this.repositoryName);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapEdgeToRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            log.debug("{} relationship has no properties", (Object)"mapEdgeToRelationship");
        }
    }

    public String getRelationshipMetadataCollectionId(Edge edge) {
        String metadataCollectionId = null;
        metadataCollectionId = (String)this.getEdgeProperty(edge, "ermetadataCollectionId");
        return metadataCollectionId;
    }
}

