/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GraphOMRSAuditCode {
    GRAPH_REPOSITORY_CREATED("OMRS-GRAPH-REPOSITORY-0001", OMRSAuditLogRecordSeverity.INFO, "The OMRS Graph Repository has been created.", "The local server has created and initialized the Local OMRS Graph Repository database.", "No action is required. This is part of the normal operation of the Graph Repository."),
    GRAPH_REPOSITORY_HAS_DIFFERENT_METADATA_COLLECTION_ID("OMRS-GRAPH-REPOSITORY-0002", OMRSAuditLogRecordSeverity.EXCEPTION, "The OMRS Graph Database contains a metadataCollectionId that does not match the repository's metadataCollectionId.", "The graph database is for a different metadata repository. Cannot proceed.", "Check whether the repository has been reconfigured with a different metadataCollectionId. If necessary, update the repository connection configuration to match the metadataCollectionId for the database."),
    GRAPH_REPOSITORY_OPENED("OMRS-GRAPH-REPOSITORY-0003", OMRSAuditLogRecordSeverity.INFO, "The OMRS Graph Repository has been opened.", "The local server has created and initialized the Local OMRS Graph Repository database.", "No action is required. This is part of the normal operation of the Graph Repository.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private GraphOMRSAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== OMRS Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> OMRS Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(GraphOMRSAuditCode.class);
    }
}

