/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSClassificationMapper;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSConstants;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMapperUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSEntityMapper {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSEntityMapper.class);
    private String metadataCollectionId;
    private String repositoryName;
    private OMRSRepositoryHelper repositoryHelper;
    private GraphOMRSClassificationMapper classificationMapper;

    GraphOMRSEntityMapper(String metadataCollectionId, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
        this.classificationMapper = new GraphOMRSClassificationMapper(metadataCollectionId, repositoryName, repositoryHelper);
    }

    private Object getVertexProperty(Vertex vertex, String propName) {
        VertexProperty vp = vertex.property(propName);
        if (vp == null || !vp.isPresent()) {
            return null;
        }
        return vp.value();
    }

    private void addProperty(Vertex vertex, String propertyName, String qualifiedPropName, InstancePropertyValue ipv) {
        InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
        if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            if (primValue != null) {
                vertex.property(GraphOMRSConstants.getPropertyKeyEntity(qualifiedPropName), primValue);
            } else {
                this.removeProperty(vertex, qualifiedPropName);
            }
        } else {
            log.debug("non-primitive instance property {}", (Object)propertyName);
        }
    }

    private void removeProperty(Vertex vertex, String qualifiedPropName) {
        VertexProperty vp = vertex.property(GraphOMRSConstants.getPropertyKeyEntity(qualifiedPropName));
        if (vp != null) {
            vp.remove();
        }
    }

    private void removeCoreProperty(Vertex vertex, String prefixedPropName) {
        VertexProperty vp = vertex.property(prefixedPropName);
        if (vp != null) {
            vp.remove();
        }
    }

    void mapEntityDetailToVertex(EntityDetail entity, Vertex vertex) throws RepositoryErrorException {
        String methodName = "mapEntityDetailToVertex";
        this.mapEntitySummaryToVertex((EntitySummary)entity, vertex);
        vertex.property("veentityIsProxy", (Object)false);
        InstanceProperties instanceProperties = entity.getProperties();
        if (instanceProperties != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String jsonString = objectMapper.writeValueAsString((Object)instanceProperties);
                log.debug("{} entity has serialized properties {}", (Object)"mapEntityDetailToVertex", (Object)jsonString);
                vertex.property("instanceProperties", (Object)jsonString);
            }
            catch (Throwable exc) {
                log.error("{} Caught exception from entity mapper", (Object)"mapEntityDetailToVertex");
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), "mapEntityDetailToVertex", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "mapEntityDetailToVertex", exc);
            }
            String typeName = entity.getType().getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            Map<String, String> qualifiedPropertyNames = GraphOMRSMapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "mapEntityDetailToVertex");
            for (TypeDefAttribute propertyDef : propertiesDef) {
                String propertyName = propertyDef.getAttributeName();
                String qualifiedPropName = qualifiedPropertyNames.get(propertyName);
                InstancePropertyValue ipv = instanceProperties.getPropertyValue(propertyName);
                if (ipv != null) {
                    this.addProperty(vertex, propertyName, qualifiedPropName, ipv);
                    continue;
                }
                this.removeProperty(vertex, qualifiedPropName);
            }
        }
    }

    void mapEntityProxyToVertex(EntityProxy entity, Vertex vertex) throws RepositoryErrorException {
        String methodName = "mapEntityProxyToVertex";
        this.mapEntitySummaryToVertex((EntitySummary)entity, vertex);
        vertex.property("veentityIsProxy", (Object)true);
        InstanceProperties uniqueProperties = entity.getUniqueProperties();
        if (uniqueProperties != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String jsonString = objectMapper.writeValueAsString((Object)uniqueProperties);
                log.debug("{} entity proxy has serialized unique properties {}", (Object)"mapEntityProxyToVertex", (Object)jsonString);
                vertex.property("instanceProperties", (Object)jsonString);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)"mapEntityProxyToVertex", (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), "mapEntityProxyToVertex", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "mapEntityProxyToVertex", exc);
            }
            String typeName = entity.getType().getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            Map<String, String> qualifiedPropertyNames = GraphOMRSMapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "mapEntityProxyToVertex");
            for (TypeDefAttribute propertyDef : propertiesDef) {
                String propertyName = propertyDef.getAttributeName();
                String qualifiedPropName = qualifiedPropertyNames.get(propertyName);
                InstancePropertyValue ipv = uniqueProperties.getPropertyValue(propertyName);
                if (ipv != null) {
                    this.addProperty(vertex, propertyName, qualifiedPropName, ipv);
                    continue;
                }
                this.removeProperty(vertex, qualifiedPropName);
            }
        }
    }

    private void mapEntitySummaryToVertex(EntitySummary entity, Vertex vertex) throws RepositoryErrorException {
        String jsonString;
        ObjectMapper objectMapper;
        String methodName = "mapEntitySummaryToVertex";
        boolean missingAttribute = false;
        String missingAttributeName = null;
        if (entity.getGUID() != null) {
            vertex.property("veguid", (Object)entity.getGUID());
        } else {
            log.debug("{} missing attribute: guid", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "guid";
        }
        InstanceType instanceType = entity.getType();
        if (instanceType != null && instanceType.getTypeDefName() != null) {
            vertex.property("vetypeName", (Object)instanceType.getTypeDefName());
        } else {
            log.debug("{} missing attribute: type name", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "type or typeDefName";
        }
        if (entity.getMetadataCollectionId() != null) {
            vertex.property("vemetadataCollectionId", (Object)entity.getMetadataCollectionId());
        } else {
            log.debug("{} missing attribute: metadataCollectionId", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "metadataCollectionId";
        }
        if (missingAttribute) {
            log.error("{} entity is missing core attribute {}", (Object)methodName, (Object)missingAttributeName);
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        vertex.property("veversion", (Object)entity.getVersion());
        if (entity.getMetadataCollectionName() != null) {
            vertex.property("vemetadataCollectionName", (Object)entity.getMetadataCollectionName());
        } else {
            VertexProperty vp = vertex.property("vemetadataCollectionName");
            if (vp != null) {
                vp.remove();
            }
        }
        if (entity.getCreatedBy() != null) {
            vertex.property("vecreatedBy", (Object)entity.getCreatedBy());
        } else {
            this.removeCoreProperty(vertex, "vecreatedBy");
        }
        if (entity.getCreateTime() != null) {
            vertex.property("vecreateTime", (Object)entity.getCreateTime());
        } else {
            this.removeCoreProperty(vertex, "vecreateTime");
        }
        if (entity.getUpdatedBy() != null) {
            vertex.property("veupdatedBy", (Object)entity.getUpdatedBy());
        } else {
            this.removeCoreProperty(vertex, "veupdatedBy");
        }
        if (entity.getUpdateTime() != null) {
            vertex.property("veupdateTime", (Object)entity.getUpdateTime());
        } else {
            this.removeCoreProperty(vertex, "veupdateTime");
        }
        if (entity.getInstanceProvenanceType() != null) {
            vertex.property("veprovenanceType", (Object)entity.getInstanceProvenanceType().getOrdinal());
        } else {
            this.removeCoreProperty(vertex, "veprovenanceType");
        }
        if (entity.getStatus() != null) {
            vertex.property("vestatus", (Object)entity.getStatus().getOrdinal());
        } else {
            this.removeCoreProperty(vertex, "vestatus");
        }
        if (entity.getStatusOnDelete() != null) {
            vertex.property("vestatusOnDelete", (Object)entity.getStatusOnDelete().getOrdinal());
        } else {
            this.removeCoreProperty(vertex, "vestatusOnDelete");
        }
        if (entity.getInstanceURL() != null) {
            vertex.property("veinstanceURL", (Object)entity.getInstanceURL());
        } else {
            this.removeCoreProperty(vertex, "veinstanceURL");
        }
        if (entity.getInstanceLicense() != null) {
            vertex.property("veinstanceLicense", (Object)entity.getInstanceLicense());
        } else {
            this.removeCoreProperty(vertex, "veinstanceLicense");
        }
        if (entity.getMaintainedBy() != null) {
            List maintainers = entity.getMaintainedBy();
            objectMapper = new ObjectMapper();
            try {
                jsonString = objectMapper.writeValueAsString((Object)maintainers);
                log.debug("{} entity maintainedBy serialized to {}", (Object)methodName, (Object)jsonString);
                vertex.property("vemaintainedBy", (Object)jsonString);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        } else {
            this.removeCoreProperty(vertex, "vemaintainedBy");
        }
        if (entity.getReplicatedBy() != null) {
            vertex.property("vereplicatedBy", (Object)entity.getReplicatedBy());
        } else {
            this.removeCoreProperty(vertex, "vereplicatedBy");
        }
        if (entity.getMappingProperties() != null) {
            Map mappingProperties = entity.getMappingProperties();
            objectMapper = new ObjectMapper();
            try {
                jsonString = objectMapper.writeValueAsString((Object)mappingProperties);
                log.debug("{} entity maintainedBy serialized to {}", (Object)methodName, (Object)jsonString);
                vertex.property("vemappingProperties", (Object)jsonString);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        } else {
            this.removeCoreProperty(vertex, "vemappingProperties");
        }
    }

    void mapVertexToEntityDetail(Vertex vertex, EntityDetail entity) throws RepositoryErrorException, EntityProxyOnlyException {
        String methodName = "mapVertexToEntityDetail";
        Boolean isProxy = (Boolean)this.getVertexProperty(vertex, "veentityIsProxy");
        if (isProxy.booleanValue()) {
            log.error("{} an EntityProxy cannot be retrieved as an EntityDetail {}", (Object)methodName, (Object)entity.getGUID());
            throw new EntityProxyOnlyException(GraphOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        this.mapVertexToEntitySummary(vertex, (EntitySummary)entity);
        String stringProps = (String)this.getVertexProperty(vertex, "instanceProperties");
        if (stringProps != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                InstanceProperties instanceProperties = (InstanceProperties)objectMapper.readValue(stringProps, InstanceProperties.class);
                log.debug("{} entity has deserialized properties {}", (Object)methodName, (Object)instanceProperties);
                entity.setProperties(instanceProperties);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void mapVertexToEntityProxy(Vertex vertex, EntityProxy entity) throws RepositoryErrorException {
        TypeDef typeDef;
        String methodName = "mapVertexToEntityProxy";
        this.mapVertexToEntitySummary(vertex, (EntitySummary)entity);
        InstanceType type = entity.getType();
        try {
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entity-type-guid", "entity-type-name", type.getTypeDefGUID(), type.getTypeDefName(), methodName);
        }
        catch (Exception e) {
            log.error("{} caught exception {}", (Object)methodName, (Object)e.getMessage());
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_TYPE_ERROR.getMessageDefinition(type.getTypeDefName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
        }
        String stringProps = (String)this.getVertexProperty(vertex, "instanceProperties");
        if (stringProps != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                InstanceProperties instanceProperties = (InstanceProperties)objectMapper.readValue(stringProps, InstanceProperties.class);
                log.debug("{} entity has deserialized properties {}", (Object)methodName, (Object)instanceProperties);
                List propertiesDefinition = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, methodName);
                InstanceProperties uniqueAttributes = new InstanceProperties();
                if (propertiesDefinition != null) {
                    for (TypeDefAttribute typeDefAttribute : propertiesDefinition) {
                        InstancePropertyValue propertyValue;
                        if (typeDefAttribute == null) continue;
                        String propertyName = typeDefAttribute.getAttributeName();
                        if (!typeDefAttribute.isUnique() || propertyName == null || (propertyValue = instanceProperties.getPropertyValue(propertyName)) == null) continue;
                        uniqueAttributes.setProperty(propertyName, propertyValue);
                    }
                }
                if (uniqueAttributes.getPropertyCount() <= 0) return;
                entity.setUniqueProperties(uniqueAttributes);
                return;
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        } else {
            log.debug("{} vertex has no instance properties", (Object)methodName);
        }
    }

    void mapVertexToEntitySummary(Vertex vertex, EntitySummary entity) throws RepositoryErrorException {
        String methodName = "mapVertexToEntitySummary";
        entity.setGUID((String)this.getVertexProperty(vertex, "veguid"));
        entity.setMetadataCollectionId((String)this.getVertexProperty(vertex, "vemetadataCollectionId"));
        entity.setMetadataCollectionName((String)this.getVertexProperty(vertex, "vemetadataCollectionName"));
        entity.setCreatedBy((String)this.getVertexProperty(vertex, "vecreatedBy"));
        entity.setCreateTime((Date)this.getVertexProperty(vertex, "vecreateTime"));
        entity.setUpdatedBy((String)this.getVertexProperty(vertex, "veupdatedBy"));
        entity.setUpdateTime((Date)this.getVertexProperty(vertex, "veupdateTime"));
        entity.setVersion(((Long)this.getVertexProperty(vertex, "veversion")).longValue());
        entity.setInstanceLicense((String)this.getVertexProperty(vertex, "veinstanceLicense"));
        entity.setInstanceURL((String)this.getVertexProperty(vertex, "veinstanceURL"));
        try {
            String typeName = (String)this.getVertexProperty(vertex, "vetypeName");
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            InstanceType instanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, (TypeDefSummary)typeDef);
            entity.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("{} caught exception {}", (Object)methodName, (Object)e.getMessage());
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
        }
        Integer provenanceOrdinal = (Integer)this.getVertexProperty(vertex, "veprovenanceType");
        InstanceProvenanceType instanceProvenanceType = GraphOMRSMapperUtils.mapProvenanceOrdinalToEnum(provenanceOrdinal);
        entity.setInstanceProvenanceType(instanceProvenanceType);
        Integer statusOrdinal = (Integer)this.getVertexProperty(vertex, "vestatus");
        InstanceStatus instanceStatus = GraphOMRSMapperUtils.mapStatusOrdinalToEnum(statusOrdinal);
        entity.setStatus(instanceStatus);
        Integer statusOnDeleteOrdinal = (Integer)this.getVertexProperty(vertex, "vestatusOnDelete");
        InstanceStatus statusOnDelete = GraphOMRSMapperUtils.mapStatusOrdinalToEnum(statusOnDeleteOrdinal);
        entity.setStatusOnDelete(statusOnDelete);
        String maintainedByString = (String)this.getVertexProperty(vertex, "vemaintainedBy");
        if (maintainedByString != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                List maintainedByList = (List)objectMapper.readValue(maintainedByString, List.class);
                log.debug("{} entity has deserialized maintainedBy {}", (Object)methodName, (Object)maintainedByList);
                entity.setMaintainedBy(maintainedByList);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
        entity.setReplicatedBy((String)this.getVertexProperty(vertex, "vereplicatedBy"));
        String mappingPropertiesString = (String)this.getVertexProperty(vertex, "vemappingProperties");
        if (mappingPropertiesString != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                TypeReference<Map<String, Serializable>> typeReference = new TypeReference<Map<String, Serializable>>(){};
                Map mappingPropertiesMap = (Map)objectMapper.readValue(mappingPropertiesString, (TypeReference)typeReference);
                log.debug("{} entity has deserialized mappingProperties {}", (Object)methodName, (Object)mappingPropertiesMap);
                entity.setMappingProperties(mappingPropertiesMap);
            }
            catch (Throwable exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        Iterator classifierEdges = vertex.edges(Direction.OUT, new String[]{"Classifier"});
        while (classifierEdges.hasNext()) {
            Edge classifierEdge = (Edge)classifierEdges.next();
            Classification classification = new Classification();
            Vertex classificationVertex = classifierEdge.inVertex();
            this.classificationMapper.mapVertexToClassification(classificationVertex, classification);
            log.debug("{} entity has classification: {} ", (Object)methodName, (Object)classification.getName());
            classifications.add(classification);
        }
        if (classifications.isEmpty()) {
            classifications = null;
        }
        entity.setClassifications(classifications);
    }

    Boolean isProxy(Vertex vertex) {
        Boolean isProxy = (Boolean)this.getVertexProperty(vertex, "veentityIsProxy");
        return isProxy;
    }

    public void setProxy(Vertex vertex) {
        vertex.property("veentityIsProxy", (Object)true);
    }

    void clearProxy(Vertex vertex) {
        vertex.property("veentityIsProxy", (Object)false);
    }

    String getEntityGUID(Vertex vertex) {
        return (String)this.getVertexProperty(vertex, "veguid");
    }

    String getEntityMetadataCollectionId(Vertex vertex) {
        return (String)this.getVertexProperty(vertex, "vemetadataCollectionId");
    }
}

