/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSMapperUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSMapperUtils.class);

    public static InstanceProvenanceType mapProvenanceOrdinalToEnum(Integer provenanceOrdinal) {
        InstanceProvenanceType instanceProvenanceType;
        if (provenanceOrdinal == null) {
            return null;
        }
        switch (provenanceOrdinal) {
            case 0: {
                instanceProvenanceType = InstanceProvenanceType.UNKNOWN;
                break;
            }
            case 1: {
                instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
                break;
            }
            case 2: {
                instanceProvenanceType = InstanceProvenanceType.EXPORT_ARCHIVE;
                break;
            }
            case 3: {
                instanceProvenanceType = InstanceProvenanceType.CONTENT_PACK;
                break;
            }
            case 4: {
                instanceProvenanceType = InstanceProvenanceType.DEREGISTERED_REPOSITORY;
                break;
            }
            case 5: {
                instanceProvenanceType = InstanceProvenanceType.CONFIGURATION;
                break;
            }
            case 6: {
                instanceProvenanceType = InstanceProvenanceType.EXTERNAL_SOURCE;
                break;
            }
            default: {
                instanceProvenanceType = InstanceProvenanceType.UNKNOWN;
            }
        }
        return instanceProvenanceType;
    }

    public static InstanceStatus mapStatusOrdinalToEnum(Integer statusOrdinal) {
        InstanceStatus instanceStatus;
        if (statusOrdinal == null) {
            return null;
        }
        switch (statusOrdinal) {
            case 0: {
                instanceStatus = InstanceStatus.UNKNOWN;
                break;
            }
            case 1: {
                instanceStatus = InstanceStatus.DRAFT;
                break;
            }
            case 2: {
                instanceStatus = InstanceStatus.PREPARED;
                break;
            }
            case 3: {
                instanceStatus = InstanceStatus.PROPOSED;
                break;
            }
            case 4: {
                instanceStatus = InstanceStatus.APPROVED;
                break;
            }
            case 5: {
                instanceStatus = InstanceStatus.REJECTED;
                break;
            }
            case 6: {
                instanceStatus = InstanceStatus.APPROVED_CONCEPT;
                break;
            }
            case 7: {
                instanceStatus = InstanceStatus.UNDER_DEVELOPMENT;
                break;
            }
            case 8: {
                instanceStatus = InstanceStatus.DEVELOPMENT_COMPLETE;
                break;
            }
            case 9: {
                instanceStatus = InstanceStatus.APPROVED_FOR_DEPLOYMENT;
                break;
            }
            case 10: {
                instanceStatus = InstanceStatus.STANDBY;
                break;
            }
            case 15: {
                instanceStatus = InstanceStatus.ACTIVE;
                break;
            }
            case 20: {
                instanceStatus = InstanceStatus.FAILED;
                break;
            }
            case 21: {
                instanceStatus = InstanceStatus.DISABLED;
                break;
            }
            case 22: {
                instanceStatus = InstanceStatus.COMPLETE;
                break;
            }
            case 30: {
                instanceStatus = InstanceStatus.DEPRECATED;
                break;
            }
            case 50: {
                instanceStatus = InstanceStatus.OTHER;
                break;
            }
            case 99: {
                instanceStatus = InstanceStatus.DELETED;
                break;
            }
            default: {
                instanceStatus = InstanceStatus.UNKNOWN;
            }
        }
        return instanceStatus;
    }

    public static ClassificationOrigin mapClassificationOriginOrdinalToEnum(Integer originOrdinal) {
        ClassificationOrigin classificationOrigin;
        if (originOrdinal == null) {
            return null;
        }
        switch (originOrdinal) {
            case 0: {
                classificationOrigin = ClassificationOrigin.ASSIGNED;
                break;
            }
            case 1: {
                classificationOrigin = ClassificationOrigin.PROPAGATED;
                break;
            }
            default: {
                classificationOrigin = ClassificationOrigin.ASSIGNED;
            }
        }
        return classificationOrigin;
    }

    public static Map<String, String> getQualifiedPropertyNamesForTypeDef(TypeDef typeDef, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        String QUALIFIED_PROPERTY_SEPARATOR = "x";
        HashMap<String, String> qualifiedPropertyNames = new HashMap<String, String>();
        if (typeDef != null) {
            List propertiesDefinition = typeDef.getPropertiesDefinition();
            if (propertiesDefinition != null) {
                for (TypeDefAttribute tda : propertiesDefinition) {
                    String propName = tda.getAttributeName();
                    String qualifiedName = typeDef.getName() + "x" + propName;
                    qualifiedPropertyNames.put(propName, qualifiedName);
                }
            }
            TypeDefLink superTypeLink = typeDef.getSuperType();
            while (superTypeLink != null) {
                String superTypeName = superTypeLink.getName();
                TypeDef superTypeDef = repositoryHelper.getTypeDefByName(repositoryName, superTypeName);
                List superTypePropertiesDefinition = superTypeDef.getPropertiesDefinition();
                if (superTypePropertiesDefinition != null) {
                    for (TypeDefAttribute tda : superTypePropertiesDefinition) {
                        String propName = tda.getAttributeName();
                        String qualifiedName = superTypeName + "x" + propName;
                        qualifiedPropertyNames.put(propName, qualifiedName);
                    }
                }
                superTypeLink = superTypeDef.getSuperType();
            }
        }
        return qualifiedPropertyNames;
    }
}

