/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.attribute.Text;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSClassificationMapper;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSConstants;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSEntityMapper;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSGraphFactory;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMapperUtils;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRelationshipMapper;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphOMRSMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSMetadataStore.class);
    private String repositoryName;
    private String metadataCollectionId;
    private OMRSRepositoryHelper repositoryHelper;
    GraphOMRSGraphFactory graphFactory;
    private JanusGraph instanceGraph;
    private GraphOMRSRelationshipMapper relationshipMapper;
    private GraphOMRSEntityMapper entityMapper;
    private GraphOMRSClassificationMapper classificationMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphOMRSMetadataStore(String metadataCollectionId, String repositoryName, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog, Map<String, Object> storageProperties) throws RepositoryErrorException {
        String methodName = "GraphOMRSMetadataStore";
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
        try {
            this.graphFactory = new GraphOMRSGraphFactory();
            Class<GraphOMRSMetadataStore> clazz = GraphOMRSMetadataStore.class;
            synchronized (GraphOMRSMetadataStore.class) {
                this.instanceGraph = this.graphFactory.open(metadataCollectionId, repositoryName, auditLog, storageProperties);
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
        }
        catch (RepositoryErrorException e) {
            log.error("{} Could not open graph database", (Object)"GraphOMRSMetadataStore");
            throw e;
        }
        {
            this.relationshipMapper = new GraphOMRSRelationshipMapper(metadataCollectionId, repositoryName, repositoryHelper);
            this.entityMapper = new GraphOMRSEntityMapper(metadataCollectionId, repositoryName, repositoryHelper);
            this.classificationMapper = new GraphOMRSClassificationMapper(metadataCollectionId, repositoryName, repositoryHelper);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized EntityDetail createEntityInStore(EntityDetail entity) throws RepositoryErrorException, InvalidParameterException {
        Vertex vertex;
        String methodName = "createEntityInStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entity.getGUID());
        if (vertexIt.hasNext()) {
            vertex = (Vertex)vertexIt.next();
            log.debug("{} found existing vertex {}", (Object)"createEntityInStore", (Object)vertex);
            if (!this.entityMapper.isProxy(vertex).booleanValue()) {
                log.error("{} existing vertex for GUID {} and it is not a proxy", (Object)"createEntityInStore", (Object)entity.getGUID());
                g.tx().rollback();
                String parameterName = "entity";
                throw new InvalidParameterException(GraphOMRSErrorCode.ENTITY_ALREADY_EXISTS.getMessageDefinition(entity.getGUID(), "createEntityInStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "createEntityInStore", parameterName);
            }
            if (this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                log.error("{} existing vertex apparently a proxy, but has local metadataCollectionId", (Object)"createEntityInStore");
                g.tx().rollback();
                String parameterName = "metadataCollectionId";
                throw new InvalidParameterException(GraphOMRSErrorCode.ENTITY_ALREADY_EXISTS.getMessageDefinition(entity.getGUID(), "createEntityInStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "createEntityInStore", "metadataCollectionId");
            }
            log.debug("{} existing vertex is a proxy", (Object)"createEntityInStore");
            this.entityMapper.clearProxy(vertex);
        } else {
            log.debug("{} create vertex for entity {}", (Object)"createEntityInStore", (Object)entity.getGUID());
            vertex = (Vertex)g.addV("Entity").next();
        }
        try {
            this.entityMapper.mapEntityDetailToVertex(entity, vertex);
            List classifications = entity.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    log.debug("{} add classification: {} ", (Object)"createEntityInStore", (Object)classification.getName());
                    Vertex classificationVertex = (Vertex)g.addV("Classification").next();
                    this.classificationMapper.mapClassificationToVertex(classification, classificationVertex);
                    vertex.addEdge("Classifier", classificationVertex, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("{} Caught exception from entity mapper {}", (Object)"createEntityInStore", (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_CREATED.getMessageDefinition(entity.getGUID(), "createEntityInStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "createEntityInStore", (Throwable)e);
        }
        g.tx().commit();
        return entity;
    }

    synchronized void createEntityProxyInStore(EntityProxy entityProxy) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "createEntityProxyInStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityProxy.getGUID());
        if (vertexIt.hasNext()) {
            Vertex vertex = (Vertex)vertexIt.next();
            log.error("{} createEntityProxyInStore found existing vertex {}", (Object)"createEntityProxyInStore", (Object)vertex);
            g.tx().rollback();
            throw new InvalidParameterException(GraphOMRSErrorCode.ENTITY_ALREADY_EXISTS.getMessageDefinition(entityProxy.getGUID(), "createEntityProxyInStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "createEntityProxyInStore", "entityProxy");
        }
        Vertex vertex = (Vertex)g.addV("Entity").next();
        try {
            this.entityMapper.mapEntityProxyToVertex(entityProxy, vertex);
            List classifications = entityProxy.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    log.debug("{} add classification {}", (Object)"createEntityProxyInStore", (Object)classification.getName());
                    Vertex classificationVertex = (Vertex)g.addV("Classification").next();
                    this.classificationMapper.mapClassificationToVertex(classification, classificationVertex);
                    vertex.addEdge("Classifier", classificationVertex, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("{} Caught exception from entity mapper {}", (Object)"createEntityProxyInStore", (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_CREATED.getMessageDefinition(entityProxy.getGUID(), "createEntityProxyInStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "createEntityProxyInStore", (Throwable)e);
        }
        g.tx().commit();
    }

    synchronized void saveEntityReferenceCopyToStore(EntityDetail entity) throws InvalidParameterException, RepositoryErrorException {
        Vertex vertex;
        String methodName = "saveEntityReferenceCopyToStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entity.getGUID());
        if (vertexIt.hasNext()) {
            vertex = (Vertex)vertexIt.next();
            log.debug("{} found existing vertex {}", (Object)"saveEntityReferenceCopyToStore", (Object)vertex);
            String vertexMetadataCollectionId = this.entityMapper.getEntityMetadataCollectionId(vertex);
            if (this.metadataCollectionId.equals(entity.getMetadataCollectionId()) || !vertexMetadataCollectionId.equals(entity.getMetadataCollectionId())) {
                log.error("{} found an existing vertex from a different source, with metadataCollectionId {}", (Object)"saveEntityReferenceCopyToStore", (Object)vertexMetadataCollectionId);
                g.tx().rollback();
                throw new InvalidParameterException(GraphOMRSErrorCode.ENTITY_ALREADY_EXISTS.getMessageDefinition(entity.getGUID(), "saveEntityReferenceCopyToStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "saveEntityReferenceCopyToStore", "entity");
            }
        } else {
            log.debug("{} create vertex for entity {}", (Object)"saveEntityReferenceCopyToStore", (Object)entity.getGUID());
            vertex = (Vertex)g.addV("Entity").next();
        }
        try {
            this.entityMapper.mapEntityDetailToVertex(entity, vertex);
            List classifications = entity.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    log.debug("{} add classification: {} ", (Object)"saveEntityReferenceCopyToStore", (Object)classification.getName());
                    Vertex classificationVertex = (Vertex)g.addV("Classification").next();
                    this.classificationMapper.mapClassificationToVertex(classification, classificationVertex);
                    vertex.addEdge("Classifier", classificationVertex, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("{} Caught exception from entity mapper {}", (Object)"saveEntityReferenceCopyToStore", (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_CREATED.getMessageDefinition(entity.getGUID(), "saveEntityReferenceCopyToStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "saveEntityReferenceCopyToStore", (Throwable)e);
        }
        g.tx().commit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized EntityDetail getEntityDetailFromStore(String guid) throws EntityNotKnownException, EntityProxyOnlyException, RepositoryErrorException {
        String methodName = "getEntityDetailFromStore";
        EntityDetail entity = null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)guid);
        if (!gt.hasNext()) {
            log.error("{} entity with GUID {} not found", (Object)methodName, (Object)guid);
            g.tx().rollback();
            throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        Vertex vertex = (Vertex)gt.next();
        log.debug("{} found vertex {}", (Object)methodName, (Object)vertex);
        try {
            if (vertex != null) {
                log.debug("{} found entity vertex {}", (Object)methodName, (Object)vertex);
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) {
                    log.warn("{} found entity but it is only a proxy, guid {}", (Object)methodName, (Object)guid);
                    g.tx().rollback();
                    throw new EntityProxyOnlyException(GraphOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
                }
                entity = new EntityDetail();
                this.entityMapper.mapVertexToEntityDetail(vertex, entity);
            }
        }
        catch (RepositoryErrorException e) {
            log.error("{} Caught exception {}", (Object)methodName, (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
        }
        g.tx().commit();
        return entity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized EntitySummary getEntitySummaryFromStore(String guid) throws EntityNotKnownException, RepositoryErrorException {
        String methodName = "getEntitySummaryFromStore";
        EntitySummary entity = null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)guid);
        if (!gt.hasNext()) {
            log.error("{} entity with GUID {} not found", (Object)methodName, (Object)guid);
            g.tx().rollback();
            throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        Vertex vertex = (Vertex)gt.next();
        log.debug("{} found vertex {}", (Object)methodName, (Object)vertex);
        try {
            if (vertex != null) {
                log.debug("{} found entity vertex {}", (Object)methodName, (Object)vertex);
                entity = new EntitySummary();
                this.entityMapper.mapVertexToEntitySummary(vertex, entity);
            }
        }
        catch (RepositoryErrorException e) {
            log.error("{} Caught exception {}", (Object)methodName, (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
        }
        g.tx().commit();
        return entity;
    }

    synchronized EntityProxy getEntityProxyFromStore(String guid) throws RepositoryErrorException {
        String methodName = "getEntityProxyFromStore";
        EntityProxy entityProxy = null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal vi = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)guid);
        if (vi.hasNext()) {
            Vertex vertex = (Vertex)vi.next();
            try {
                if (vertex != null) {
                    log.debug("{} entity vertex {}", (Object)methodName, (Object)vertex);
                    entityProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertex, entityProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)methodName, (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(guid, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
            }
        }
        g.tx().commit();
        return entityProxy;
    }

    synchronized void createRelationshipInStore(Relationship relationship) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "createRelationshipInStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal edgeIt = g.E(new Object[0]).hasLabel("Relationship", new String[0]).has("erguid", (Object)relationship.getGUID());
        if (edgeIt.hasNext()) {
            Edge edge = (Edge)edgeIt.next();
            log.error("{} found existing edge {}", (Object)methodName, (Object)edge);
            g.tx().rollback();
            throw new InvalidParameterException(GraphOMRSErrorCode.RELATIONSHIP_ALREADY_EXISTS.getMessageDefinition(relationship.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "relationship");
        }
        String entityOneGUID = relationship.getEntityOneProxy().getGUID();
        String entityTwoGUID = relationship.getEntityTwoProxy().getGUID();
        Vertex vertexOne = null;
        Vertex vertexTwo = null;
        GraphTraversal vi = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityOneGUID);
        if (vi.hasNext()) {
            vertexOne = (Vertex)vi.next();
            log.debug("{} found entityOne vertex {}", (Object)methodName, (Object)vertexOne);
        }
        if ((vi = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityTwoGUID)).hasNext()) {
            vertexTwo = (Vertex)vi.next();
            log.debug("{} found entityTwo vertex {}", (Object)methodName, (Object)vertexTwo);
        }
        if (vertexOne == null || vertexTwo == null) {
            log.error("{} Could not find both ends for relationship {}", (Object)methodName, (Object)relationship.getGUID());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_CREATED.getMessageDefinition(relationship.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        Edge edge = vertexOne.addEdge("Relationship", vertexTwo, new Object[0]);
        try {
            this.relationshipMapper.mapRelationshipToEdge(relationship, edge);
        }
        catch (Exception e) {
            log.error("{} Caught exception from relationship mapper {}", (Object)methodName, (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_CREATED.getMessageDefinition(relationship.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
        }
        log.debug("{} Commit tx containing creation of edge", (Object)methodName);
        g.tx().commit();
    }

    synchronized void saveRelationshipReferenceCopyToStore(Relationship relationship) throws InvalidParameterException, RepositoryErrorException {
        Edge edge;
        Vertex vertex;
        String methodName = "saveRelationshipReferenceCopyToStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        EntityProxy entityOne = relationship.getEntityOneProxy();
        GraphTraversal vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityOne.getGUID());
        if (vertexIt.hasNext()) {
            vertex = (Vertex)vertexIt.next();
            log.debug("{} found existing vertex for end1 {}", (Object)"saveRelationshipReferenceCopyToStore", (Object)vertex);
        } else {
            this.createEntityProxyInStore(entityOne);
        }
        EntityProxy entityTwo = relationship.getEntityTwoProxy();
        vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityTwo.getGUID());
        if (vertexIt.hasNext()) {
            vertex = (Vertex)vertexIt.next();
            log.debug("{} found existing vertex for end2 {}", (Object)"saveRelationshipReferenceCopyToStore", (Object)vertex);
        } else {
            this.createEntityProxyInStore(entityTwo);
        }
        Vertex vertexOne = null;
        Vertex vertexTwo = null;
        vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityOne.getGUID());
        if (vertexIt.hasNext()) {
            vertexOne = (Vertex)vertexIt.next();
        }
        if ((vertexIt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityTwo.getGUID())).hasNext()) {
            vertexTwo = (Vertex)vertexIt.next();
        }
        if (vertexOne == null || vertexTwo == null) {
            log.error("{} Could not locate or create vertex for entity with guid {} used in relationship {}", new Object[]{"saveRelationshipReferenceCopyToStore", vertexOne == null ? entityOne.getGUID() : entityTwo.getGUID(), relationship.getGUID()});
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_CREATED.getMessageDefinition(relationship.getGUID(), "saveRelationshipReferenceCopyToStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "saveRelationshipReferenceCopyToStore");
        }
        GraphTraversal edgeIt = g.E(new Object[0]).hasLabel("Relationship", new String[0]).has("erguid", (Object)relationship.getGUID());
        if (edgeIt.hasNext()) {
            edge = (Edge)edgeIt.next();
            log.debug("{} found existing edge {}", (Object)"saveRelationshipReferenceCopyToStore", (Object)edge);
            String edgeMetadataCollectionId = this.relationshipMapper.getRelationshipMetadataCollectionId(edge);
            if (this.metadataCollectionId.equals(relationship.getMetadataCollectionId()) || !edgeMetadataCollectionId.equals(relationship.getMetadataCollectionId())) {
                log.error("{} found an existing edge from a different source, with metadataCollectionId {}", (Object)"saveRelationshipReferenceCopyToStore", (Object)edgeMetadataCollectionId);
                g.tx().rollback();
                String parameterName = "relationship";
                throw new InvalidParameterException(GraphOMRSErrorCode.RELATIONSHIP_ALREADY_EXISTS.getMessageDefinition(relationship.getGUID(), "saveRelationshipReferenceCopyToStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "saveRelationshipReferenceCopyToStore", "relationship");
            }
        } else {
            edge = vertexOne.addEdge("Relationship", vertexTwo, new Object[0]);
        }
        try {
            this.relationshipMapper.mapRelationshipToEdge(relationship, edge);
        }
        catch (Exception e) {
            log.error("{} Caught exception from relationship mapper {}", (Object)"saveRelationshipReferenceCopyToStore", (Object)e.getMessage());
            g.tx().rollback();
            throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_CREATED.getMessageDefinition(relationship.getGUID(), "saveRelationshipReferenceCopyToStore", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "saveRelationshipReferenceCopyToStore", (Throwable)e);
        }
        log.debug("{} Commit tx containing creation or update of edge", (Object)"saveRelationshipReferenceCopyToStore");
        g.tx().commit();
    }

    synchronized Relationship getRelationshipFromStore(String guid) throws RepositoryErrorException {
        String methodName = "getRelationshipFromStore";
        Relationship relationship = null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal edgeIt = g.E(new Object[0]).hasLabel("Relationship", new String[0]).has("erguid", (Object)guid);
        if (edgeIt.hasNext()) {
            Edge edge = (Edge)edgeIt.next();
            log.debug("{} found existing edge {}", (Object)methodName, (Object)edge);
            relationship = new Relationship();
            this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
            Vertex vertex = null;
            try {
                vertex = edge.outVertex();
                if (vertex != null) {
                    log.debug("{} entity vertex {}", (Object)methodName, (Object)vertex);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertex, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)methodName, (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if ((vertex = edge.inVertex()) != null) {
                    log.debug("{} entity vertex {}", (Object)methodName, (Object)vertex);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertex, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)methodName, (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)methodName, (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_FOUND.getMessageDefinition(this.entityMapper.getEntityGUID(vertex), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
            }
        }
        g.tx().commit();
        return relationship;
    }

    synchronized void updateEntityInStore(EntityDetail entity) throws RepositoryErrorException {
        String methodName = "updateEntityInStore";
        String guid = entity.getGUID();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)guid);
        if ((gt = gt.has("veentityIsProxy", (Object)false)).hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found entity vertex {}", (Object)methodName, (Object)vertex);
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (!isProxy.booleanValue()) {
                    this.entityMapper.mapEntityDetailToVertex(entity, vertex);
                    this.updateEntityClassifications((EntitySummary)entity, vertex, g);
                }
            }
            catch (Exception e) {
                log.error("{} caught exception {}", (Object)methodName, (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_NOT_UPDATED.getMessageDefinition(entity.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
            }
        }
        log.debug("{} commit entity update tx: ", (Object)methodName);
        g.tx().commit();
    }

    private void updateEntityClassifications(EntitySummary entity, Vertex vertex, GraphTraversalSource g) throws RepositoryErrorException {
        String methodName = "updateEntityClassifications";
        HashMap<String, Classification> entityClassificationsByName = new HashMap<String, Classification>();
        HashMap<String, Vertex> existingClassificationVerticesByName = new HashMap<String, Vertex>();
        HashMap<String, Edge> existingClassifierEdgesByName = new HashMap<String, Edge>();
        List classifications = entity.getClassifications();
        if (classifications != null) {
            for (Classification entityClassification : classifications) {
                log.debug("{} entity should have classification: {}", (Object)"updateEntityClassifications", (Object)entityClassification.getName());
                entityClassificationsByName.put(entityClassification.getName(), entityClassification);
            }
        }
        Iterator classifierEdges = vertex.edges(Direction.OUT, new String[]{"Classifier"});
        while (classifierEdges.hasNext()) {
            Edge classifierEdge = (Edge)classifierEdges.next();
            Vertex existingClassificationVertex = classifierEdge.inVertex();
            Classification existingClassification = new Classification();
            this.classificationMapper.mapVertexToClassification(existingClassificationVertex, existingClassification);
            log.debug("{} entity already has classification: {}", (Object)"updateEntityClassifications", (Object)existingClassification.getName());
            existingClassificationVerticesByName.put(existingClassification.getName(), existingClassificationVertex);
            existingClassifierEdgesByName.put(existingClassification.getName(), classifierEdge);
        }
        HashSet<Object> namesToRemoveSet = new HashSet<Object>();
        for (Object existingName : existingClassificationVerticesByName.keySet()) {
            if (entityClassificationsByName.containsKey(existingName)) continue;
            log.debug("{} entity remove classification: {}", (Object)"updateEntityClassifications", existingName);
            Vertex vertex2 = (Vertex)existingClassificationVerticesByName.get(existingName);
            vertex2.remove();
            namesToRemoveSet.add(existingName);
            Edge classifierEdge = (Edge)existingClassifierEdgesByName.get(existingName);
            classifierEdge.remove();
            existingClassifierEdgesByName.remove(existingName);
        }
        for (String string : namesToRemoveSet) {
            existingClassificationVerticesByName.remove(string);
        }
        for (String string : entityClassificationsByName.keySet()) {
            Vertex classificationVertex;
            if (!existingClassificationVerticesByName.containsKey(string)) {
                log.debug("{} entity add classification: {}", (Object)"updateEntityClassifications", (Object)string);
                classificationVertex = (Vertex)g.addV("Classification").next();
                this.classificationMapper.mapClassificationToVertex((Classification)entityClassificationsByName.get(string), classificationVertex);
                vertex.addEdge("Classifier", classificationVertex, new Object[0]);
                continue;
            }
            log.debug("{} entity update classification: {}", (Object)"updateEntityClassifications", (Object)string);
            classificationVertex = (Vertex)existingClassificationVerticesByName.get(string);
            this.classificationMapper.mapClassificationToVertex((Classification)entityClassificationsByName.get(string), classificationVertex);
        }
    }

    synchronized void updateRelationshipInStore(Relationship relationship) throws RepositoryErrorException {
        String methodName = "updateRelationshipInStore";
        String guid = relationship.getGUID();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal edgeIt = g.E(new Object[0]).hasLabel("Relationship", new String[0]).has("erguid", (Object)guid);
        if (edgeIt.hasNext()) {
            Edge edge = (Edge)edgeIt.next();
            log.debug("{} found existing edge {}", (Object)methodName, (Object)edge);
            try {
                this.relationshipMapper.mapRelationshipToEdge(relationship, edge);
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship mapper {}", (Object)methodName, (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_UPDATED.getMessageDefinition(relationship.getGUID(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, (Throwable)e);
            }
        }
        g.tx().commit();
    }

    synchronized void removeEntityFromStore(String entityGUID) {
        Vertex vertex;
        Boolean isProxy;
        String methodName = "removeEntityFromStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityGUID);
        if ((gt = gt.has("veentityIsProxy", (Object)false)).hasNext() && !(isProxy = this.entityMapper.isProxy(vertex = (Vertex)gt.next())).booleanValue()) {
            log.debug("{} found entity vertex {} to be removed", (Object)"removeEntityFromStore", (Object)vertex);
            Iterator classifierEdges = vertex.edges(Direction.OUT, new String[]{"Classifier"});
            while (classifierEdges.hasNext()) {
                Edge classifierEdge = (Edge)classifierEdges.next();
                Vertex classificationVertex = classifierEdge.inVertex();
                Classification existingClassification = new Classification();
                try {
                    this.classificationMapper.mapVertexToClassification(classificationVertex, existingClassification);
                }
                catch (Exception e) {
                    log.error("{} caught exception from classification mapper for classification {}", (Object)"removeEntityFromStore", (Object)existingClassification.getName());
                }
                log.debug("{} removing classification {} from entity", (Object)"removeEntityFromStore", (Object)existingClassification.getName());
                classifierEdge.remove();
                classificationVertex.remove();
            }
            vertex.remove();
            log.debug("{} removed entity vertex with guid {}", (Object)"removeEntityFromStore", (Object)entityGUID);
        }
        g.tx().commit();
    }

    synchronized void removeRelationshipFromStore(String relationshipGUID) {
        String methodName = "removeRelationshipFromStore";
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal edgeIt = g.E(new Object[0]).hasLabel("Relationship", new String[0]).has("erguid", (Object)relationshipGUID);
        if (edgeIt.hasNext()) {
            Edge edge = (Edge)edgeIt.next();
            log.debug("{} found existing edge {}", (Object)"removeRelationshipFromStore", (Object)edge);
            edge.remove();
            log.debug("{} removed relationship edge with guid {}", (Object)"removeRelationshipFromStore", (Object)relationshipGUID);
        }
        g.tx().commit();
    }

    synchronized List<Relationship> getRelationshipsForEntity(String entityGUID) throws RepositoryErrorException {
        String methodName = "getRelationshipsForEntity";
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal vi = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityGUID);
        if (vi.hasNext()) {
            Vertex vertex = (Vertex)vi.next();
            log.debug("{} found entity vertex {}", (Object)"getRelationshipsForEntity", (Object)vertex);
            Iterator edges = vertex.edges(Direction.BOTH, new String[]{"Relationship"});
            log.debug("{} entity has these edges {}", (Object)"getRelationshipsForEntity", (Object)edges);
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                log.debug("{} entity has edge {}", (Object)"getRelationshipsForEntity", (Object)edge);
                Relationship relationship = new Relationship();
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                try {
                    vertex = edge.outVertex();
                    if (vertex != null) {
                        log.debug("{} entity vertex {}", (Object)"getRelationshipsForEntity", (Object)vertex);
                        EntityProxy entityOneProxy = new EntityProxy();
                        this.entityMapper.mapVertexToEntityProxy(vertex, entityOneProxy);
                        log.debug("{} entityOneProxy {}", (Object)"getRelationshipsForEntity", (Object)entityOneProxy);
                        relationship.setEntityOneProxy(entityOneProxy);
                    }
                    if ((vertex = edge.inVertex()) != null) {
                        log.debug("{} entity vertex {}", (Object)"getRelationshipsForEntity", (Object)vertex);
                        EntityProxy entityTwoProxy = new EntityProxy();
                        this.entityMapper.mapVertexToEntityProxy(vertex, entityTwoProxy);
                        log.debug("{} entityTwoProxy {}", (Object)"getRelationshipsForEntity", (Object)entityTwoProxy);
                        relationship.setEntityTwoProxy(entityTwoProxy);
                    }
                }
                catch (Exception e) {
                    log.error("{} Caught exception from entity mapper {}", (Object)"getRelationshipsForEntity", (Object)e.getMessage());
                    g.tx().rollback();
                    throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_NOT_FOUND.getMessageDefinition(this.entityMapper.getEntityGUID(vertex), "getRelationshipsForEntity", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getRelationshipsForEntity", (Throwable)e);
                }
                relationships.add(relationship);
            }
        }
        g.tx().commit();
        return relationships;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<EntityDetail> findEntitiesByPropertyForType(String typeDefName, InstanceProperties matchProperties, MatchCriteria matchCriteria, Boolean fullMatch) throws InvalidParameterException {
        GraphTraversal gt;
        GraphTraversalSource g;
        ArrayList<EntityDetail> entities;
        block29: {
            String methodName = "findEntitiesByPropertyForType";
            entities = new ArrayList<EntityDetail>();
            g = this.instanceGraph.traversal();
            gt = g.V(new Object[0]).hasLabel("Entity", new String[0]);
            if (typeDefName != null) {
                gt = gt.has("vetypeName", (Object)typeDefName);
            }
            gt = gt.has("veentityIsProxy", (Object)false);
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
            GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
            Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            Set<String> typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
            if (matchProperties == null) break block29;
            ArrayList<DefaultGraphTraversal> propCriteria = new ArrayList<DefaultGraphTraversal>();
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                GraphOMRSGraphFactory.MixedIndexMapping mapping;
                String propNameToSearch;
                String propName;
                block31: {
                    block30: {
                        propName = (String)propNames.next();
                        propNameToSearch = null;
                        mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        if (!corePropertyNames.contains(propName)) break block30;
                        String javaTypeForMatchProperty = null;
                        InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                        InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                        if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                            PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                            javaTypeForMatchProperty = mpCat.getJavaClassName();
                        } else {
                            log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForType", (Object)propName);
                        }
                        String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                        if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) break block31;
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findEntitiesByPropertyForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByPropertyForType", "matchProperties");
                        propNameToSearch = "ve" + propName;
                        mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameToSearch);
                        break block31;
                    }
                    if (typeDefinedPropertyNames.contains(propName)) {
                        List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "findEntitiesByPropertyForType");
                        for (TypeDefAttribute propertyDef : propertiesDef) {
                            String definedPropertyName = propertyDef.getAttributeName();
                            if (!definedPropertyName.equals(propName)) continue;
                            PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                            InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                            InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                                PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                                mpCat = ppv.getPrimitiveDefCategory();
                            } else {
                                log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForType", (Object)propName);
                            }
                            PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                            AttributeTypeDef atd = propertyDef.getAttributeType();
                            AttributeTypeDefCategory atdCat = atd.getCategory();
                            if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                                PrimitiveDef pdef = (PrimitiveDef)atd;
                                pdCat = pdef.getPrimitiveDefCategory();
                            }
                            if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) break;
                            String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                            propNameToSearch = "ve" + qualifiedPropertyName;
                            mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                            break;
                        }
                    }
                }
                if (propNameToSearch == null) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                    PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                    Object primValue = ppv.getPrimitiveValue();
                    log.debug("{} primitive match property has key {} value {}", new Object[]{"findEntitiesByPropertyForType", propName, primValue});
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    switch (pCat) {
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                            log.debug("{} primitive match property search string {}", (Object)"findEntitiesByPropertyForType", (Object)searchString);
                            if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                t = t.has(propNameToSearch, Text.textContainsRegex((Object)searchString));
                                break;
                            }
                            if (!fullMatch.booleanValue()) {
                                String ANYCHARS = ".*";
                                t = t.has(propNameToSearch, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                break;
                            }
                            t = t.has(propNameToSearch, Text.textRegex((Object)searchString));
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (corePropertyNames.contains(propName)) {
                                Date dateValue = new Date((Long)primValue);
                                t = t.has(propNameToSearch, (Object)dateValue);
                                break;
                            }
                            t = t.has(propNameToSearch, primValue);
                            break;
                        }
                        default: {
                            t = t.has(propNameToSearch, primValue);
                        }
                    }
                    log.debug("{} primitive match property has property criterion {}", (Object)"findEntitiesByPropertyForType", (Object)t);
                    propCriteria.add(t);
                    continue;
                }
                log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForType", (Object)propName);
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForType", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForType", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForType", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesByPropertyForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByPropertyForType", "matchCriteria");
                    }
                }
            }
        }
        while (gt.hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found vertex {}", (Object)"findEntitiesByPropertyForType", (Object)vertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} caught exception from entity mapper, entity being ignored, {}", (Object)"findEntitiesByPropertyForType", (Object)e.getMessage());
            }
        }
        g.tx().commit();
        return entities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<EntityDetail> findEntitiesByPropertyForTypes(List<String> entityTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findEntitiesByPropertyForTypes";
        boolean performTypeFiltering = filterTypeName != null;
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]);
        gt = gt.has("veentityIsProxy", (Object)false);
        ArrayList propCriteria = new ArrayList();
        if (matchProperties != null) {
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
            Set<String> typeDefinedPropertyNames = null;
            if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
                typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
            }
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                String qualifiedName;
                List<String> qNameList;
                HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
                String propName = (String)propNames.next();
                if (corePropertyNames.contains(propName)) {
                    String javaTypeForMatchProperty = null;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                        javaTypeForMatchProperty = mpCat.getJavaClassName();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForTypes", (Object)propName);
                    }
                    String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                    if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findEntitiesByPropertyForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByPropertyForTypes", "matchProperties");
                        String matchedPropName = "ve" + propName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty() && (qualifiedName = qNameList.get(0)) != null) {
                    TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
                    PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    AttributeTypeDef atd = propertyDef.getAttributeType();
                    AttributeTypeDefCategory atdCat = atd.getCategory();
                    if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef pdef = (PrimitiveDef)atd;
                        pdCat = pdef.getPrimitiveDefCategory();
                    }
                    PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        mpCat = ppv.getPrimitiveDefCategory();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForTypes", (Object)propName);
                    }
                    if (mpCat == pdCat && mpCat != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) {
                        String matchedPropName = "ve" + qualifiedName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                }
                if (matchedPropToMapping.isEmpty()) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                ArrayList<DefaultGraphTraversal> localCriteria = new ArrayList<DefaultGraphTraversal>();
                Set matchedPropNames = matchedPropToMapping.keySet();
                for (String thisMatchedPropName : matchedPropNames) {
                    GraphOMRSGraphFactory.MixedIndexMapping mapping = (GraphOMRSGraphFactory.MixedIndexMapping)((Object)matchedPropToMapping.get(thisMatchedPropName));
                    InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                    if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                        PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                        Object primValue = ppv.getPrimitiveValue();
                        log.debug("{} primitive match property has key {} value {}", new Object[]{"findEntitiesByPropertyForTypes", propName, primValue});
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        switch (pCat) {
                            case OM_PRIMITIVE_TYPE_STRING: {
                                String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                                log.debug("{} primitive match property search string {}", (Object)"findEntitiesByPropertyForTypes", (Object)searchString);
                                if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                    t = t.has(thisMatchedPropName, Text.textContainsRegex((Object)searchString));
                                    break;
                                }
                                boolean fullMatch = true;
                                if (!fullMatch) {
                                    String ANYCHARS = ".*";
                                    t = t.has(thisMatchedPropName, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                    break;
                                }
                                t = t.has(thisMatchedPropName, Text.textRegex((Object)searchString));
                                break;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                if (corePropertyNames.contains(propName)) {
                                    Date dateValue = new Date((Long)primValue);
                                    t = t.has(thisMatchedPropName, (Object)dateValue);
                                    break;
                                }
                                t = t.has(thisMatchedPropName, primValue);
                                break;
                            }
                            default: {
                                t = t.has(thisMatchedPropName, primValue);
                            }
                        }
                        log.debug("{} primitive match property has property criterion {}", (Object)"findEntitiesByPropertyForTypes", (Object)t);
                        localCriteria.add(t);
                        continue;
                    }
                    log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByPropertyForTypes", (Object)propName);
                }
                propCriteria.add(localCriteria.get(0));
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForTypes", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForTypes", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByPropertyForTypes", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesByPropertyForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByPropertyForTypes", "matchCriteria");
                    }
                }
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("vetypeName", P.within(entityTypeNames));
        }
        while (gt.hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found vertex {}", (Object)"findEntitiesByPropertyForTypes", (Object)vertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)"findEntitiesByPropertyForTypes", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entityDetail.getGUID(), "findEntitiesByPropertyForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByPropertyForTypes", (Throwable)e);
            }
        }
        g.tx().commit();
        return entities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<EntityDetail> findEntitiesByPropertyValueForTypes(List<String> entityTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findEntitiesByProperty";
        boolean performTypeFiltering = filterTypeName != null;
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]);
        gt = gt.has("veentityIsProxy", (Object)false);
        ArrayList propCriteria = new ArrayList();
        if (matchProperties != null) {
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
            Set<String> typeDefinedPropertyNames = null;
            if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
                typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
            }
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                List<String> qNameList;
                HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
                String propName = (String)propNames.next();
                if (corePropertyNames.contains(propName)) {
                    String javaTypeForMatchProperty = null;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                        javaTypeForMatchProperty = mpCat.getJavaClassName();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByProperty", (Object)propName);
                    }
                    String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                    if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findEntitiesByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByProperty", "matchProperties");
                        String matchedPropName = "ve" + propName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty()) {
                    for (String qualifiedName : qNameList) {
                        if (qualifiedName == null) continue;
                        TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
                        PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                        AttributeTypeDef atd = propertyDef.getAttributeType();
                        AttributeTypeDefCategory atdCat = atd.getCategory();
                        if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                            PrimitiveDef pdef = (PrimitiveDef)atd;
                            pdCat = pdef.getPrimitiveDefCategory();
                        }
                        PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                        InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                        InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                        if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                            mpCat = ppv.getPrimitiveDefCategory();
                        } else {
                            log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByProperty", (Object)propName);
                        }
                        if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) continue;
                        String matchedPropName = "ve" + qualifiedName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                }
                if (matchedPropToMapping.isEmpty()) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                ArrayList<DefaultGraphTraversal> localCriteria = new ArrayList<DefaultGraphTraversal>();
                Set matchedPropNames = matchedPropToMapping.keySet();
                for (String thisMatchedPropName : matchedPropNames) {
                    GraphOMRSGraphFactory.MixedIndexMapping mapping = (GraphOMRSGraphFactory.MixedIndexMapping)((Object)matchedPropToMapping.get(thisMatchedPropName));
                    InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                    if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                        PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                        Object primValue = ppv.getPrimitiveValue();
                        log.debug("{} primitive match property has key {} value {}", new Object[]{"findEntitiesByProperty", propName, primValue});
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        switch (pCat) {
                            case OM_PRIMITIVE_TYPE_STRING: {
                                String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                                log.debug("{} primitive match property search string {}", (Object)"findEntitiesByProperty", (Object)searchString);
                                if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                    t = t.has(thisMatchedPropName, Text.textContainsRegex((Object)searchString));
                                    break;
                                }
                                boolean fullMatch = true;
                                if (!fullMatch) {
                                    String ANYCHARS = ".*";
                                    t = t.has(thisMatchedPropName, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                    break;
                                }
                                t = t.has(thisMatchedPropName, Text.textRegex((Object)searchString));
                                break;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                if (corePropertyNames.contains(propName)) {
                                    Date dateValue = new Date((Long)primValue);
                                    t = t.has(thisMatchedPropName, (Object)dateValue);
                                    break;
                                }
                                t = t.has(thisMatchedPropName, primValue);
                                break;
                            }
                            default: {
                                t = t.has(thisMatchedPropName, primValue);
                            }
                        }
                        log.debug("{} primitive match property has property criterion {}", (Object)"findEntitiesByProperty", (Object)t);
                        localCriteria.add(t);
                        continue;
                    }
                    log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByProperty", (Object)propName);
                }
                propCriteria.addAll(localCriteria);
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByProperty", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByProperty", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByProperty", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByProperty", "matchCriteria");
                    }
                }
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("vetypeName", P.within(entityTypeNames));
        }
        while (gt.hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found vertex {}", (Object)"findEntitiesByProperty", (Object)vertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)"findEntitiesByProperty", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entityDetail.getGUID(), "findEntitiesByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByProperty", (Throwable)e);
            }
        }
        g.tx().commit();
        return entities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Relationship> findRelationshipsByPropertyForType(String typeDefName, InstanceProperties matchProperties, MatchCriteria matchCriteria, Boolean fullMatch) throws InvalidParameterException, RepositoryErrorException {
        GraphTraversal gt;
        GraphTraversalSource g;
        ArrayList<Relationship> relationships;
        block31: {
            String methodName = "findRelationshipsByPropertyForType";
            relationships = new ArrayList<Relationship>();
            g = this.instanceGraph.traversal();
            gt = g.E(new Object[0]).hasLabel("Relationship", new String[0]);
            if (typeDefName != null) {
                gt = gt.has("ertypeName", (Object)typeDefName);
            }
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
            GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
            Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            Set<String> typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
            if (matchProperties == null) break block31;
            ArrayList<DefaultGraphTraversal> propCriteria = new ArrayList<DefaultGraphTraversal>();
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                GraphOMRSGraphFactory.MixedIndexMapping mapping;
                String propNameToSearch;
                String propName;
                block33: {
                    block32: {
                        propName = (String)propNames.next();
                        propNameToSearch = null;
                        mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        if (!corePropertyNames.contains(propName)) break block32;
                        String javaTypeForMatchProperty = null;
                        InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                        InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                        if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                            PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                            javaTypeForMatchProperty = mpCat.getJavaClassName();
                        } else {
                            log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyForType", (Object)propName);
                        }
                        String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                        if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) break block33;
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findRelationshipsByPropertyForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyForType", "matchProperties");
                        propNameToSearch = "er" + propName;
                        mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameToSearch);
                        break block33;
                    }
                    if (typeDefinedPropertyNames.contains(propName)) {
                        List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "findRelationshipsByPropertyForType");
                        for (TypeDefAttribute propertyDef : propertiesDef) {
                            String definedPropertyName = propertyDef.getAttributeName();
                            if (!definedPropertyName.equals(propName)) continue;
                            PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                            InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                            InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                                PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                                mpCat = ppv.getPrimitiveDefCategory();
                            } else {
                                log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyForType", (Object)propName);
                            }
                            PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                            AttributeTypeDef atd = propertyDef.getAttributeType();
                            AttributeTypeDefCategory atdCat = atd.getCategory();
                            if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                                PrimitiveDef pdef = (PrimitiveDef)atd;
                                pdCat = pdef.getPrimitiveDefCategory();
                            }
                            if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) break;
                            String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                            propNameToSearch = "er" + qualifiedPropertyName;
                            mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                            break;
                        }
                    }
                }
                if (propNameToSearch == null) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                    PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                    Object primValue = ppv.getPrimitiveValue();
                    log.debug("{} primitive match property has key {} value {}", new Object[]{"findRelationshipsByPropertyForType", propName, primValue});
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    switch (pCat) {
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                            log.debug("{} primitive match property search string {}", (Object)"findRelationshipsByPropertyForType", (Object)searchString);
                            if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                t = t.has(propNameToSearch, Text.textContainsRegex((Object)searchString));
                                break;
                            }
                            if (!fullMatch.booleanValue()) {
                                String ANYCHARS = ".*";
                                t = t.has(propNameToSearch, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                break;
                            }
                            t = t.has(propNameToSearch, Text.textRegex((Object)searchString));
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (corePropertyNames.contains(propName)) {
                                Date dateValue = new Date((Long)primValue);
                                t = t.has(propNameToSearch, (Object)dateValue);
                                break;
                            }
                            t = t.has(propNameToSearch, primValue);
                            break;
                        }
                        default: {
                            t = t.has(propNameToSearch, primValue);
                        }
                    }
                    log.debug("{} primitive match property has property criterion {}", (Object)"findRelationshipsByPropertyForType", (Object)t);
                    propCriteria.add(t);
                    continue;
                }
                log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyForType", (Object)propName);
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyForType", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyForType", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyForType", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findRelationshipsByPropertyForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyForType", "matchCriteria");
                    }
                }
            }
        }
        while (gt.hasNext()) {
            Edge edge = (Edge)gt.next();
            log.debug("{} found edge {}", (Object)"findRelationshipsByPropertyForType", (Object)edge);
            Relationship relationship = new Relationship();
            try {
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                Vertex vertexOne = edge.outVertex();
                Vertex vertexTwo = edge.inVertex();
                if (vertexOne != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByPropertyForType", (Object)vertexOne);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexOne, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)"findRelationshipsByPropertyForType", (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if (vertexTwo != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByPropertyForType", (Object)vertexTwo);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexTwo, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)"findRelationshipsByPropertyForType", (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship or entity mapper {}", (Object)"findRelationshipsByPropertyForType", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR.getMessageDefinition(relationship.getGUID(), "findRelationshipsByPropertyForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyForType", (Throwable)e);
            }
            relationships.add(relationship);
        }
        g.tx().commit();
        return relationships;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Relationship> findRelationshipsByPropertyForTypes(List<String> relationshipTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findRelationshipsByProperty";
        boolean performTypeFiltering = filterTypeName != null;
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.E(new Object[0]).hasLabel("Relationship", new String[0]);
        ArrayList propCriteria = new ArrayList();
        if (matchProperties != null) {
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
            Set<String> typeDefinedPropertyNames = null;
            if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
                typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
            }
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                String qualifiedName;
                List<String> qNameList;
                HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
                String propName = (String)propNames.next();
                if (corePropertyNames.contains(propName)) {
                    String javaTypeForMatchProperty = null;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                        javaTypeForMatchProperty = mpCat.getJavaClassName();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByProperty", (Object)propName);
                    }
                    String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                    if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findRelationshipsByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByProperty", "matchProperties");
                        String matchedPropName = "er" + propName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty() && (qualifiedName = qNameList.get(0)) != null) {
                    TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
                    PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    AttributeTypeDef atd = propertyDef.getAttributeType();
                    AttributeTypeDefCategory atdCat = atd.getCategory();
                    if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef pdef = (PrimitiveDef)atd;
                        pdCat = pdef.getPrimitiveDefCategory();
                    }
                    PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        mpCat = ppv.getPrimitiveDefCategory();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByProperty", (Object)propName);
                    }
                    if (mpCat == pdCat && mpCat != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) {
                        String matchedPropName = "er" + qualifiedName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                }
                if (matchedPropToMapping.isEmpty()) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                ArrayList<DefaultGraphTraversal> localCriteria = new ArrayList<DefaultGraphTraversal>();
                Set matchedPropNames = matchedPropToMapping.keySet();
                for (String thisMatchedPropName : matchedPropNames) {
                    GraphOMRSGraphFactory.MixedIndexMapping mapping = (GraphOMRSGraphFactory.MixedIndexMapping)((Object)matchedPropToMapping.get(thisMatchedPropName));
                    InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                    if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                        PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                        Object primValue = ppv.getPrimitiveValue();
                        log.debug("{} primitive match property has key {} value {}", new Object[]{"findRelationshipsByProperty", propName, primValue});
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        switch (pCat) {
                            case OM_PRIMITIVE_TYPE_STRING: {
                                String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                                log.debug("{} primitive match property search string {}", (Object)"findRelationshipsByProperty", (Object)searchString);
                                if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                    t = t.has(thisMatchedPropName, Text.textContainsRegex((Object)searchString));
                                    break;
                                }
                                boolean fullMatch = true;
                                if (!fullMatch) {
                                    String ANYCHARS = ".*";
                                    t = t.has(thisMatchedPropName, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                    break;
                                }
                                t = t.has(thisMatchedPropName, Text.textRegex((Object)searchString));
                                break;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                if (corePropertyNames.contains(propName)) {
                                    Date dateValue = new Date((Long)primValue);
                                    t = t.has(thisMatchedPropName, (Object)dateValue);
                                    break;
                                }
                                t = t.has(thisMatchedPropName, primValue);
                                break;
                            }
                            default: {
                                t = t.has(thisMatchedPropName, primValue);
                            }
                        }
                        log.debug("{} primitive match property has property criterion {}", (Object)"findRelationshipsByProperty", (Object)t);
                        localCriteria.add(t);
                        continue;
                    }
                    log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByProperty", (Object)propName);
                }
                propCriteria.add(localCriteria.get(0));
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByProperty", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByProperty", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByProperty", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findRelationshipsByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByProperty", "matchCriteria");
                    }
                }
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("ertypeName", P.within(relationshipTypeNames));
        }
        while (gt.hasNext()) {
            Edge edge = (Edge)gt.next();
            log.debug("{} found edge {}", (Object)"findRelationshipsByProperty", (Object)edge);
            Relationship relationship = new Relationship();
            try {
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                Vertex vertexOne = edge.outVertex();
                Vertex vertexTwo = edge.inVertex();
                if (vertexOne != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByProperty", (Object)vertexOne);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexOne, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)"findRelationshipsByProperty", (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if (vertexTwo != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByProperty", (Object)vertexTwo);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexTwo, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)"findRelationshipsByProperty", (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship or entity mapper {}", (Object)"findRelationshipsByProperty", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR.getMessageDefinition(relationship.getGUID(), "findRelationshipsByProperty", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByProperty", (Throwable)e);
            }
            relationships.add(relationship);
        }
        g.tx().commit();
        return relationships;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Relationship> findRelationshipsByPropertyValueForTypes(List<String> validTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findRelationshipsByPropertyValueForTypes";
        boolean performTypeFiltering = filterTypeName != null;
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.E(new Object[0]).hasLabel("Relationship", new String[0]);
        ArrayList propCriteria = new ArrayList();
        if (matchProperties != null) {
            Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
            Set<String> typeDefinedPropertyNames = null;
            if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
                typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
            }
            Iterator propNames = matchProperties.getPropertyNames();
            while (propNames.hasNext()) {
                List<String> qNameList;
                HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
                String propName = (String)propNames.next();
                if (corePropertyNames.contains(propName)) {
                    String javaTypeForMatchProperty = null;
                    InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                        javaTypeForMatchProperty = mpCat.getJavaClassName();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyValueForTypes", (Object)propName);
                    }
                    String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                    if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                        if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findRelationshipsByPropertyValueForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyValueForTypes", "matchProperties");
                        String matchedPropName = "er" + propName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty()) {
                    for (String qualifiedName : qNameList) {
                        if (qualifiedName == null) continue;
                        TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
                        PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                        AttributeTypeDef atd = propertyDef.getAttributeType();
                        AttributeTypeDefCategory atdCat = atd.getCategory();
                        if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                            PrimitiveDef pdef = (PrimitiveDef)atd;
                            pdCat = pdef.getPrimitiveDefCategory();
                        }
                        PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                        InstancePropertyValue mpv = matchProperties.getPropertyValue(propName);
                        InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                        if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                            mpCat = ppv.getPrimitiveDefCategory();
                        } else {
                            log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyValueForTypes", (Object)propName);
                        }
                        if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) continue;
                        String matchedPropName = "er" + qualifiedName;
                        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                        matchedPropToMapping.put(matchedPropName, mapping);
                    }
                }
                if (matchedPropToMapping.isEmpty()) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                ArrayList<DefaultGraphTraversal> localCriteria = new ArrayList<DefaultGraphTraversal>();
                Set matchedPropNames = matchedPropToMapping.keySet();
                for (String thisMatchedPropName : matchedPropNames) {
                    GraphOMRSGraphFactory.MixedIndexMapping mapping = (GraphOMRSGraphFactory.MixedIndexMapping)((Object)matchedPropToMapping.get(thisMatchedPropName));
                    InstancePropertyValue ipv = matchProperties.getPropertyValue(propName);
                    InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                    if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                        PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                        Object primValue = ppv.getPrimitiveValue();
                        log.debug("{} primitive match property has key {} value {}", new Object[]{"findRelationshipsByPropertyValueForTypes", propName, primValue});
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        switch (pCat) {
                            case OM_PRIMITIVE_TYPE_STRING: {
                                String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                                log.debug("{} primitive match property search string {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)searchString);
                                if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                    t = t.has(thisMatchedPropName, Text.textContainsRegex((Object)searchString));
                                    break;
                                }
                                boolean fullMatch = true;
                                if (!fullMatch) {
                                    String ANYCHARS = ".*";
                                    t = t.has(thisMatchedPropName, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                    break;
                                }
                                t = t.has(thisMatchedPropName, Text.textRegex((Object)searchString));
                                break;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                if (corePropertyNames.contains(propName)) {
                                    Date dateValue = new Date((Long)primValue);
                                    t = t.has(thisMatchedPropName, (Object)dateValue);
                                    break;
                                }
                                t = t.has(thisMatchedPropName, primValue);
                                break;
                            }
                            default: {
                                t = t.has(thisMatchedPropName, primValue);
                            }
                        }
                        log.debug("{} primitive match property has property criterion {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)t);
                        localCriteria.add(t);
                        continue;
                    }
                    log.debug("{} non-primitive match property {} ignored", (Object)"findRelationshipsByPropertyValueForTypes", (Object)propName);
                }
                propCriteria.addAll(localCriteria);
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyValueForTypes", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (propCriteria.isEmpty()) {
                            g.tx().rollback();
                            return null;
                        }
                        gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyValueForTypes", (Object)gt);
                        break;
                    }
                    case NONE: {
                        DefaultGraphTraversal t = new DefaultGraphTraversal();
                        t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        gt = gt.not((Traversal)t);
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsByPropertyValueForTypes", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findRelationshipsByPropertyValueForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyValueForTypes", "matchCriteria");
                    }
                }
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("ertypeName", P.within(validTypeNames));
        }
        while (gt.hasNext()) {
            Edge edge = (Edge)gt.next();
            log.debug("{} found edge {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)edge);
            Relationship relationship = new Relationship();
            try {
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                Vertex vertexOne = edge.outVertex();
                Vertex vertexTwo = edge.inVertex();
                if (vertexOne != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)vertexOne);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexOne, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if (vertexTwo != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)vertexTwo);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexTwo, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship or entity mapper {}", (Object)"findRelationshipsByPropertyValueForTypes", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR.getMessageDefinition(relationship.getGUID(), "findRelationshipsByPropertyValueForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsByPropertyValueForTypes", (Throwable)e);
            }
            relationships.add(relationship);
        }
        g.tx().commit();
        return relationships;
    }

    private String convertSearchStringToJanusRegex(String str) {
        String outputString;
        if (str == null || str.length() == 0) {
            return null;
        }
        boolean caseInsensitive = false;
        if (str.startsWith("(?i)")) {
            caseInsensitive = true;
            str = str.substring(4);
        }
        boolean prefixed = false;
        boolean suffixed = str.endsWith(".*");
        if (!suffixed || str.length() > 2) {
            prefixed = str.startsWith(".*");
        }
        String innerString = str;
        if (suffixed) {
            innerString = innerString.substring(0, innerString.length() - 2);
        }
        if (prefixed) {
            innerString = innerString.substring(2);
        }
        if (innerString.length() == 0) {
            return str;
        }
        boolean literalized = false;
        if (this.repositoryHelper.isExactMatchRegex(innerString)) {
            if (innerString.length() == 4) {
                return null;
            }
            literalized = true;
            innerString = innerString.substring(2, innerString.length() - 2);
        }
        if (!caseInsensitive && !literalized) {
            outputString = innerString;
        } else {
            StringBuilder outputStringBldr = new StringBuilder();
            block3: for (int i = 0; i < innerString.length(); ++i) {
                Character c = Character.valueOf(innerString.charAt(i));
                if (!literalized && !caseInsensitive) {
                    outputStringBldr.append(c);
                    continue;
                }
                switch (c.charValue()) {
                    case '#': 
                    case '$': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '<': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        if (literalized) {
                            outputStringBldr.append('\\').append(c);
                            continue block3;
                        }
                        outputStringBldr.append(c);
                        continue block3;
                    }
                    default: {
                        if (c.charValue() >= 'a' && c.charValue() <= 'z') {
                            if (caseInsensitive) {
                                outputStringBldr.append("[").append(c).append(Character.toUpperCase(c.charValue())).append("]");
                                continue block3;
                            }
                            outputStringBldr.append(c);
                            continue block3;
                        }
                        if (c.charValue() >= 'A' && c.charValue() <= 'Z') {
                            if (caseInsensitive) {
                                outputStringBldr.append("[").append(Character.toLowerCase(c.charValue())).append(c).append("]");
                                continue block3;
                            }
                            outputStringBldr.append(c);
                            continue block3;
                        }
                        outputStringBldr.append(c);
                    }
                }
            }
            outputString = outputStringBldr.toString();
        }
        if (suffixed) {
            outputString = outputString + ".*";
        }
        if (prefixed) {
            outputString = ".*" + outputString;
        }
        return outputString;
    }

    InstanceProperties constructMatchPropertiesForSearchCriteriaForTypes(TypeDefCategory category, String searchCriteria, String filterTypeName, List<String> validTypeNames) {
        String methodName = "constructMatchPropertiesForSearchCriteria";
        boolean performTypeFiltering = filterTypeName != null;
        InstanceProperties stringMatchProperties = new InstanceProperties();
        Set<Object> relevantCoreProperties = new HashSet();
        switch (category) {
            case ENTITY_DEF: {
                relevantCoreProperties = GraphOMRSConstants.corePropertiesEntity.keySet();
                break;
            }
            case RELATIONSHIP_DEF: {
                relevantCoreProperties = GraphOMRSConstants.corePropertiesRelationship.keySet();
                break;
            }
            case CLASSIFICATION_DEF: {
                relevantCoreProperties = GraphOMRSConstants.corePropertiesClassification.keySet();
                break;
            }
            default: {
                return stringMatchProperties;
            }
        }
        for (String string : relevantCoreProperties) {
            if (!GraphOMRSConstants.corePropertyTypes.get(string).equals("java.lang.String") || string.equals("typeName")) continue;
            PrimitivePropertyValue ppv = new PrimitivePropertyValue();
            ppv.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            ppv.setPrimitiveValue((Object)searchCriteria);
            log.debug("{} include string type core property {} value {}", new Object[]{"constructMatchPropertiesForSearchCriteria", string, ppv});
            stringMatchProperties.setProperty(string, (InstancePropertyValue)ppv);
        }
        for (String typeName : validTypeNames) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            List propertiesDefinition = null;
            propertiesDefinition = performTypeFiltering && typeName.equals(filterTypeName) ? this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "constructMatchPropertiesForSearchCriteria") : typeDef.getPropertiesDefinition();
            if (propertiesDefinition != null) {
                for (TypeDefAttribute typeDefAttribute : propertiesDefinition) {
                    PrimitiveDef primDef;
                    PrimitiveDefCategory primDefCat;
                    AttributeTypeDef atd;
                    AttributeTypeDefCategory atdCategory;
                    String propertyName;
                    if (typeDefAttribute == null || (propertyName = typeDefAttribute.getAttributeName()) == null || relevantCoreProperties.contains(propertyName) || (atdCategory = (atd = typeDefAttribute.getAttributeType()).getCategory()) != AttributeTypeDefCategory.PRIMITIVE || (primDefCat = (primDef = (PrimitiveDef)atd).getPrimitiveDefCategory()) != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) continue;
                    PrimitivePropertyValue ppv = new PrimitivePropertyValue();
                    ppv.setPrimitiveDefCategory(primDefCat);
                    ppv.setPrimitiveValue((Object)searchCriteria);
                    log.debug("{} include search property {} value {}", new Object[]{"constructMatchPropertiesForSearchCriteria", propertyName, ppv});
                    stringMatchProperties.setProperty(propertyName, (InstancePropertyValue)ppv);
                }
                continue;
            }
            log.debug("{} no type-specific search properties to add", (Object)"constructMatchPropertiesForSearchCriteria");
        }
        return stringMatchProperties;
    }

    void createEntityIndexes(TypeDef typeDef) {
        String methodName = "createEntityIndexes";
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        List propertyDefs = typeDef.getPropertiesDefinition();
        if (propertyDefs == null || propertyDefs.isEmpty()) {
            log.debug("{} no vertex indexes needed for type {}", (Object)"createEntityIndexes", (Object)typeDef.getName());
            return;
        }
        log.debug("{} create vertex indexes for type {}", (Object)"createEntityIndexes", (Object)typeDef.getName());
        for (TypeDefAttribute typeDefAttribute : propertyDefs) {
            AttributeTypeDef atd;
            AttributeTypeDefCategory atdCategory;
            String propertyName;
            if (typeDefAttribute == null || (propertyName = typeDefAttribute.getAttributeName()) == null || (atdCategory = (atd = typeDefAttribute.getAttributeType()).getCategory()) != AttributeTypeDefCategory.PRIMITIVE) continue;
            String qualifiedPropertyName = qualifiedPropertyNames.get(propertyName);
            log.debug("{} qualified property name {}", (Object)"createEntityIndexes", (Object)qualifiedPropertyName);
            PrimitiveDef primDef = (PrimitiveDef)atd;
            PrimitiveDefCategory primDefCat = primDef.getPrimitiveDefCategory();
            GraphOMRSGraphFactory.MixedIndexMapping mapping = primDefCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING ? GraphOMRSGraphFactory.MixedIndexMapping.String : GraphOMRSGraphFactory.MixedIndexMapping.Default;
            this.graphFactory.createMixedIndexForVertexProperty(qualifiedPropertyName, GraphOMRSConstants.getPropertyKeyEntity(qualifiedPropertyName), primDefCat.getJavaClassName(), mapping);
        }
    }

    void createClassificationIndexes(TypeDef typeDef) {
        String methodName = "createClassificationIndexes";
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        List propertyDefs = typeDef.getPropertiesDefinition();
        if (propertyDefs == null || propertyDefs.isEmpty()) {
            log.debug("{} no vertex indexes needed for type {}", (Object)"createClassificationIndexes", (Object)typeDef.getName());
            return;
        }
        log.debug("{} create vertex indexes for type {}", (Object)"createClassificationIndexes", (Object)typeDef.getName());
        for (TypeDefAttribute typeDefAttribute : propertyDefs) {
            AttributeTypeDef atd;
            AttributeTypeDefCategory atdCategory;
            String propertyName;
            if (typeDefAttribute == null || (propertyName = typeDefAttribute.getAttributeName()) == null || (atdCategory = (atd = typeDefAttribute.getAttributeType()).getCategory()) != AttributeTypeDefCategory.PRIMITIVE) continue;
            String qualifiedPropertyName = qualifiedPropertyNames.get(propertyName);
            PrimitiveDef primDef = (PrimitiveDef)atd;
            PrimitiveDefCategory primDefCat = primDef.getPrimitiveDefCategory();
            GraphOMRSGraphFactory.MixedIndexMapping mapping = primDefCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING ? GraphOMRSGraphFactory.MixedIndexMapping.String : GraphOMRSGraphFactory.MixedIndexMapping.Default;
            this.graphFactory.createMixedIndexForVertexProperty(qualifiedPropertyName, GraphOMRSConstants.getPropertyKeyClassification(qualifiedPropertyName), primDefCat.getJavaClassName(), mapping);
        }
    }

    void createRelationshipIndexes(TypeDef typeDef) {
        String methodName = "createRelationshipIndexes";
        List propertyDefs = typeDef.getPropertiesDefinition();
        if (propertyDefs == null || propertyDefs.isEmpty()) {
            log.debug("{} no edge indexes needed for type {}", (Object)"createRelationshipIndexes", (Object)typeDef.getName());
            return;
        }
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        log.debug("{} create edge indexes for type {}", (Object)"createRelationshipIndexes", (Object)typeDef.getName());
        for (TypeDefAttribute typeDefAttribute : propertyDefs) {
            AttributeTypeDef atd;
            AttributeTypeDefCategory atdCategory;
            String propertyName;
            if (typeDefAttribute == null || (propertyName = typeDefAttribute.getAttributeName()) == null || (atdCategory = (atd = typeDefAttribute.getAttributeType()).getCategory()) != AttributeTypeDefCategory.PRIMITIVE) continue;
            String qualifiedPropertyName = qualifiedPropertyNames.get(propertyName);
            PrimitiveDef primDef = (PrimitiveDef)atd;
            PrimitiveDefCategory primDefCat = primDef.getPrimitiveDefCategory();
            GraphOMRSGraphFactory.MixedIndexMapping mapping = primDefCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING ? GraphOMRSGraphFactory.MixedIndexMapping.String : GraphOMRSGraphFactory.MixedIndexMapping.Default;
            this.graphFactory.createMixedIndexForEdgeProperty(qualifiedPropertyName, GraphOMRSConstants.getPropertyKeyRelationship(qualifiedPropertyName), primDefCat.getJavaClassName(), mapping);
        }
    }

    public List<EntityDetail> findEntitiesByClassification(String classificationName, InstanceProperties classificationProperties, MatchCriteria matchCriteria, boolean performTypeFiltering, List<String> entityTypeNames) throws InvalidParameterException {
        String methodName = "findEntitiesByClassification";
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Classification", new String[0]);
        if (classificationName != null) {
            gt = gt.has("vcclassificationName", (Object)classificationName);
        }
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesClassification.keySet();
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, classificationName);
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        Set<String> typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
        if (classificationProperties != null) {
            ArrayList<DefaultGraphTraversal> propCriteria = new ArrayList<DefaultGraphTraversal>();
            Iterator propNames = classificationProperties.getPropertyNames();
            while (propNames.hasNext()) {
                GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                String propName = (String)propNames.next();
                String propNameToSearch = null;
                if (corePropertyNames.contains(propName)) {
                    String javaTypeForCoreProperty;
                    String javaTypeForMatchProperty = null;
                    InstancePropertyValue mpv = classificationProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                        javaTypeForMatchProperty = mpCat.getJavaClassName();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByClassification", (Object)propName);
                    }
                    if ((javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName)) == null || javaTypeForMatchProperty == null) continue;
                    if (javaTypeForCoreProperty.equals(javaTypeForMatchProperty) || javaTypeForCoreProperty.equals("java.util.Date") && javaTypeForMatchProperty.equals("java.lang.Long")) {
                        propNameToSearch = "vc" + propName;
                        mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameToSearch);
                        continue;
                    }
                    throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, "findEntitiesByClassification", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByClassification", "classificationProperties");
                }
                if (!typeDefinedPropertyNames.contains(propName)) continue;
                List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "findEntitiesByClassification");
                for (TypeDefAttribute propertyDef : propertiesDef) {
                    String definedPropertyName = propertyDef.getAttributeName();
                    if (!definedPropertyName.equals(propName)) continue;
                    PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    InstancePropertyValue mpv = classificationProperties.getPropertyValue(propName);
                    InstancePropertyCategory mpvCat = mpv.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)mpv;
                        mpCat = ppv.getPrimitiveDefCategory();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByClassification", (Object)propName);
                    }
                    PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    AttributeTypeDef atd = propertyDef.getAttributeType();
                    AttributeTypeDefCategory atdCat = atd.getCategory();
                    if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef pdef = (PrimitiveDef)atd;
                        pdCat = pdef.getPrimitiveDefCategory();
                    }
                    if (mpCat != pdCat || pdCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) break;
                    String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                    propNameToSearch = "vc" + qualifiedPropertyName;
                    mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                    break;
                }
                if (propNameToSearch == null) {
                    if (matchCriteria != MatchCriteria.ALL) continue;
                    g.tx().rollback();
                    return null;
                }
                InstancePropertyValue ipv = classificationProperties.getPropertyValue(propName);
                InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
                if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
                    PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                    Object primValue = ppv.getPrimitiveValue();
                    log.debug("{} primitive match property has key {} value {}", new Object[]{"findEntitiesByClassification", propName, primValue});
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    switch (pCat) {
                        case OM_PRIMITIVE_TYPE_STRING: {
                            boolean fullMatch = true;
                            String searchString = this.convertSearchStringToJanusRegex((String)primValue);
                            log.debug("{} primitive match property search string {}", (Object)"findEntitiesByClassification", (Object)searchString);
                            if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                                t = t.has(propNameToSearch, Text.textContainsRegex((Object)searchString));
                                break;
                            }
                            if (!fullMatch) {
                                String ANYCHARS = ".*";
                                t = t.has(propNameToSearch, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
                                break;
                            }
                            t = t.has(propNameToSearch, Text.textRegex((Object)searchString));
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (corePropertyNames.contains(propName)) {
                                Date dateValue = new Date((Long)primValue);
                                t = t.has(propNameToSearch, (Object)dateValue);
                                break;
                            }
                            t = t.has(propNameToSearch, primValue);
                            break;
                        }
                        default: {
                            t = t.has(propNameToSearch, primValue);
                        }
                    }
                    log.debug("{} primitive match property has property criterion {}", (Object)"findEntitiesByClassification", (Object)t);
                    propCriteria.add(t);
                    continue;
                }
                log.debug("{} non-primitive match property {} ignored", (Object)"findEntitiesByClassification", (Object)propName);
            }
            if (matchCriteria != null) {
                switch (matchCriteria) {
                    case ALL: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByClassification", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByClassification", (Object)gt);
                        break;
                    }
                    case NONE: {
                        if (!propCriteria.isEmpty()) {
                            DefaultGraphTraversal t = new DefaultGraphTraversal();
                            t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                            gt = gt.not((Traversal)t);
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesByClassification", (Object)gt);
                        break;
                    }
                    default: {
                        g.tx().rollback();
                        String parameterName = "matchCriteria";
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesByClassification", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesByClassification", "matchCriteria");
                    }
                }
            }
        }
        gt = gt.in(new String[]{"Classifier"}).has("veentityIsProxy", (Object)false);
        if (performTypeFiltering) {
            gt = gt.has("vetypeName", P.within(entityTypeNames));
        }
        while (gt.hasNext()) {
            Vertex entityVertex = (Vertex)gt.next();
            log.debug("{} found entity vertex {}", (Object)"findEntitiesByClassification", (Object)entityVertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(entityVertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(entityVertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} caught exception from entity mapper - entity will be ignored, {}", (Object)"findEntitiesByClassification", (Object)e.getMessage());
            }
        }
        g.tx().commit();
        return entities;
    }

    InstanceGraph getSubGraph(String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, int level) throws TypeErrorException, EntityNotKnownException {
        String methodName = "getSubGraph";
        String entTypeGUIDsParameterName = "entityTypeGUIDs";
        String relTypeGUIDsParameterName = "relationshipTypeGUIDs";
        boolean limited = true;
        log.debug("{} entityGUID = {}, entityTypeGUIDs = {}, relationshipTypeGUIDs = {}, limitResultsByStatus = {}, limitResultsByClassification = {}, level = {}", new Object[]{"getSubGraph", entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, level});
        if (level == -1) {
            limited = false;
        }
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        InstanceGraph subGraph = new InstanceGraph();
        ArrayList<String> entityTypeNames = new ArrayList<String>();
        boolean entitiesWithin = false;
        if (entityTypeGUIDs != null) {
            entitiesWithin = true;
            for (String entTypeGUID : entityTypeGUIDs) {
                try {
                    TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUIDs", entTypeGUID, "getSubGraph");
                    String entTypeName = typeDef.getName();
                    entityTypeNames.add(entTypeName);
                }
                catch (Exception e) {
                    log.error("{} caught exception from repository helper trying to resolve type with GUID {}", (Object)"getSubGraph", (Object)entTypeGUID);
                    throw new TypeErrorException(GraphOMRSErrorCode.ENTITY_TYPE_GUID_NOT_KNOWN.getMessageDefinition(entTypeGUID, "getSubGraph", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getSubGraph", (Throwable)e);
                }
            }
        }
        ArrayList<String> relationshipTypeNames = new ArrayList<String>();
        boolean relationshipsWithin = false;
        if (relationshipTypeGUIDs != null) {
            relationshipsWithin = true;
            for (String relTypeGUID : relationshipTypeGUIDs) {
                try {
                    TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUIDs", relTypeGUID, "getSubGraph");
                    String relTypeName = typeDef.getName();
                    relationshipTypeNames.add(relTypeName);
                }
                catch (Exception e) {
                    log.error("{} caught exception from repository helper trying to resolve type with GUID {}", (Object)"getSubGraph", (Object)relTypeGUID);
                    throw new TypeErrorException(GraphOMRSErrorCode.RELATIONSHIP_TYPE_GUID_NOT_KNOWN.getMessageDefinition(relTypeGUID, "getSubGraph", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getSubGraph", (Throwable)e);
                }
            }
        }
        ArrayList<Integer> statusOrdinals = new ArrayList<Integer>();
        boolean statusWithin = false;
        if (limitResultsByStatus == null) {
            statusOrdinals.add(InstanceStatus.DELETED.getOrdinal());
        } else {
            statusWithin = true;
            for (InstanceStatus iStatus : limitResultsByStatus) {
                statusOrdinals.add(iStatus.getOrdinal());
            }
        }
        ArrayList<String> classificationNames = new ArrayList<String>();
        boolean classificationWithin = false;
        if (limitResultsByClassification != null) {
            classificationWithin = true;
            classificationNames.addAll(limitResultsByClassification);
        }
        GraphTraversalSource g = this.instanceGraph.traversal();
        try {
            GraphTraversal t = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityGUID);
            if (!t.hasNext()) {
                log.error("{} could not retrieve start entity with GUID {}", (Object)"getSubGraph", (Object)entityGUID);
                g.tx().rollback();
                throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(entityGUID, "getSubGraph", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getSubGraph");
            }
            Vertex rootVertex = (Vertex)t.next();
            log.debug("{} found root entity vertex {}", (Object)"getSubGraph", (Object)rootVertex);
            try {
                EntityDetail rootEntity = new EntityDetail();
                this.entityMapper.mapVertexToEntityDetail(rootVertex, rootEntity);
                entities.add(rootEntity);
                g.tx().commit();
            }
            catch (EntityProxyOnlyException | RepositoryErrorException e) {
                log.error("{} caught exception whilst trying to map entity with GUID {}, exception {}", new Object[]{"getSubGraph", entityGUID, e.getMessage()});
                g.tx().rollback();
                throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(entityGUID, "getSubGraph", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getSubGraph", e);
            }
            if (level != 0) {
                g = this.instanceGraph.traversal();
                DefaultGraphTraversal edgesTraversal = new DefaultGraphTraversal();
                edgesTraversal = edgesTraversal.bothE(new String[]{"Relationship"});
                edgesTraversal = statusWithin ? edgesTraversal.has("ercurrentStatus", P.within(statusOrdinals)) : edgesTraversal.has("ercurrentStatus", P.without(statusOrdinals));
                if (relationshipsWithin) {
                    edgesTraversal = edgesTraversal.has("ertypeName", P.within(relationshipTypeNames));
                }
                GraphTraversal vertexTraversal = edgesTraversal.as("r", new String[0]).otherV();
                vertexTraversal = statusWithin ? vertexTraversal.has("vecurrentStatus", P.within(statusOrdinals)) : vertexTraversal.has("vecurrentStatus", P.without(statusOrdinals));
                if (entitiesWithin) {
                    vertexTraversal = vertexTraversal.has("vetypeName", P.within(entityTypeNames));
                }
                if (classificationWithin) {
                    vertexTraversal = vertexTraversal.where((Traversal)__.out((String[])new String[]{"Classifier"}).has("vcclassificationName", P.within(classificationNames)));
                }
                vertexTraversal = vertexTraversal.as("e", new String[0]);
                vertexTraversal = vertexTraversal.simplePath();
                GraphTraversal overallTraversal = limited ? g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityGUID).repeat((Traversal)vertexTraversal).times(level).emit().select("r", "e", new String[0]) : g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)entityGUID).repeat((Traversal)vertexTraversal).emit().select("r", "e", new String[0]);
                while (overallTraversal.hasNext()) {
                    Map resTuple = (Map)overallTraversal.next();
                    Edge edge = (Edge)resTuple.get("r");
                    Vertex vertex = (Vertex)resTuple.get("e");
                    log.debug("{} subgraph has edge {} and vertex {}", new Object[]{"getSubGraph", edge, vertex});
                    if (edge == null || vertex == null) continue;
                    log.debug("{} save the relationship for edge {}", (Object)"getSubGraph", (Object)edge);
                    Relationship relationship = new Relationship();
                    this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                    relationships.add(relationship);
                    try {
                        Vertex vin;
                        Vertex vout = edge.outVertex();
                        if (vout != null) {
                            log.debug("{} Create proxy for end 1 entity vertex {}", (Object)"getSubGraph", (Object)vout);
                            EntityProxy entityOneProxy = new EntityProxy();
                            this.entityMapper.mapVertexToEntityProxy(vout, entityOneProxy);
                            log.debug("{} entityOneProxy {}", (Object)"getSubGraph", (Object)entityOneProxy);
                            relationship.setEntityOneProxy(entityOneProxy);
                        }
                        if ((vin = edge.inVertex()) != null) {
                            log.debug("{} Create proxy for end 2 entity vertex {}", (Object)"getSubGraph", (Object)vin);
                            EntityProxy entityTwoProxy = new EntityProxy();
                            this.entityMapper.mapVertexToEntityProxy(vin, entityTwoProxy);
                            log.debug("{} entityTwoProxy {}", (Object)"getSubGraph", (Object)entityTwoProxy);
                            relationship.setEntityTwoProxy(entityTwoProxy);
                        }
                        log.debug("{} Create entity detail for remote vertex {}", (Object)"getSubGraph", (Object)vertex);
                        if (this.entityMapper.isProxy(vertex).booleanValue()) continue;
                        EntityDetail entityDetail = new EntityDetail();
                        this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                        log.debug("{} entityDetail {}", (Object)"getSubGraph", (Object)entityDetail);
                        entities.add(entityDetail);
                    }
                    catch (EntityProxyOnlyException | RepositoryErrorException e) {
                        log.error("{} caught exception whilst trying to map entity, exception {}", (Object)"getSubGraph", (Object)e.getMessage());
                        g.tx().rollback();
                        throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(this.entityMapper.getEntityGUID(vertex), "getSubGraph", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getSubGraph", e);
                    }
                }
                g.tx().commit();
            }
            subGraph.setEntities(entities);
            subGraph.setRelationships(relationships);
            return subGraph;
        }
        catch (EntityNotKnownException e) {
            log.error("{} caught entity not known exception from subgraph traversal {}", (Object)"getSubGraph", (Object)e.getMessage());
            g.tx().rollback();
            throw e;
        }
        catch (Exception e) {
            log.error("{} caught exception from subgraph traversal {}", (Object)"getSubGraph", (Object)e.getMessage());
            g.tx().rollback();
            return null;
        }
    }

    public InstanceGraph getPaths(String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, int maxPaths, int maxDepth) {
        String methodName = "getPaths";
        log.debug("{} startEntityGUID = {}, endEntityGUID = {}, limitResultsByStatus = {}, maxPaths = {}, maxDepth {}", new Object[]{"getPaths", startEntityGUID, endEntityGUID, limitResultsByStatus, maxPaths, maxDepth});
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        InstanceGraph subGraph = new InstanceGraph();
        ArrayList<Integer> statusOrdinals = new ArrayList<Integer>();
        boolean statusWithin = false;
        if (limitResultsByStatus == null) {
            statusOrdinals.add(InstanceStatus.DELETED.getOrdinal());
        } else {
            statusWithin = true;
            for (InstanceStatus iStatus : limitResultsByStatus) {
                statusOrdinals.add(iStatus.getOrdinal());
            }
        }
        GraphTraversalSource g = this.instanceGraph.traversal();
        try {
            GraphTraversal t = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)startEntityGUID);
            if (!t.hasNext()) {
                log.error("{} could not retrieve start entity with GUID {}", (Object)"getPaths", (Object)startEntityGUID);
                g.tx().rollback();
                throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(startEntityGUID, "getPaths", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getPaths");
            }
            Vertex rootVertex = (Vertex)t.next();
            log.debug("{} found root entity vertex {}", (Object)"getPaths", (Object)rootVertex);
            try {
                EntityDetail rootEntity = new EntityDetail();
                this.entityMapper.mapVertexToEntityDetail(rootVertex, rootEntity);
                log.debug("{} mapped root entity {}", (Object)"getPaths", (Object)rootEntity);
                if (startEntityGUID.equals(endEntityGUID)) {
                    entities.add(rootEntity);
                }
                g.tx().commit();
            }
            catch (EntityProxyOnlyException | RepositoryErrorException e) {
                log.error("{} caught exception whilst trying to map entity with GUID {}, exception {}", new Object[]{"getPaths", startEntityGUID, e.getMessage()});
                g.tx().rollback();
                throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(startEntityGUID, "getPaths", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getPaths", e);
            }
            g = this.instanceGraph.traversal();
            DefaultGraphTraversal edgesTraversal = new DefaultGraphTraversal();
            edgesTraversal = edgesTraversal.bothE(new String[]{"Relationship"});
            edgesTraversal = statusWithin ? edgesTraversal.has("ercurrentStatus", P.within(statusOrdinals)) : edgesTraversal.has("ercurrentStatus", P.without(statusOrdinals));
            GraphTraversal vertexTraversal = edgesTraversal.otherV();
            vertexTraversal = statusWithin ? vertexTraversal.has("vecurrentStatus", P.within(statusOrdinals)) : vertexTraversal.has("vecurrentStatus", P.without(statusOrdinals));
            vertexTraversal = vertexTraversal.simplePath();
            DefaultGraphTraversal untilTraversal = new DefaultGraphTraversal();
            untilTraversal = untilTraversal.has("veguid", (Object)endEntityGUID).or(new Traversal[0]).loops().is(P.gte((Object)maxDepth));
            GraphTraversal overallTraversal = g.V(new Object[0]).hasLabel("Entity", new String[0]).has("veguid", (Object)startEntityGUID).repeat((Traversal)vertexTraversal).until((Traversal)untilTraversal).has("veguid", (Object)endEntityGUID).path().limit((long)maxPaths).unfold().dedup(new String[0]).fold();
            block9: while (overallTraversal.hasNext()) {
                List resList = (List)overallTraversal.next();
                if (resList.isEmpty()) continue;
                for (Object object : resList) {
                    Vertex vertex;
                    if (object instanceof Vertex) {
                        vertex = (Vertex)object;
                        log.debug("{} subgraph has vertex {}", (Object)"getPaths", (Object)vertex);
                        if (this.entityMapper.isProxy(vertex).booleanValue()) continue;
                        try {
                            EntityDetail entityDetail = new EntityDetail();
                            this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                            log.debug("{} entityDetail {}", (Object)"getPaths", (Object)entityDetail);
                            entities.add(entityDetail);
                            continue;
                        }
                        catch (EntityProxyOnlyException | RepositoryErrorException e) {
                            log.error("{} could not map vertex returned in path expression, entity GUID {}, exception {}", new Object[]{"getPaths", this.entityMapper.getEntityGUID(vertex), e.getMessage()});
                            g.tx().rollback();
                            throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(startEntityGUID, "getPaths", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getPaths");
                        }
                    }
                    if (object instanceof Edge) {
                        Edge edge = (Edge)object;
                        log.debug("{} subgraph has edge {} ", (Object)"getPaths", (Object)edge);
                        Relationship relationship = new Relationship();
                        this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                        relationships.add(relationship);
                        vertex = null;
                        try {
                            vertex = edge.outVertex();
                            if (vertex != null) {
                                log.debug("{} end 1 entity vertex {}", (Object)"getPaths", (Object)vertex);
                                EntityProxy entityOneProxy = new EntityProxy();
                                this.entityMapper.mapVertexToEntityProxy(vertex, entityOneProxy);
                                log.debug("{} entityOneProxy {}", (Object)"getPaths", (Object)entityOneProxy);
                                relationship.setEntityOneProxy(entityOneProxy);
                            }
                            if ((vertex = edge.inVertex()) == null) continue;
                            log.debug("{} end 2 entity vertex {}", (Object)"getPaths", (Object)vertex);
                            EntityProxy entityTwoProxy = new EntityProxy();
                            this.entityMapper.mapVertexToEntityProxy(vertex, entityTwoProxy);
                            log.debug("{} entityTwoProxy {}", (Object)"getPaths", (Object)entityTwoProxy);
                            relationship.setEntityTwoProxy(entityTwoProxy);
                            continue;
                        }
                        catch (RepositoryErrorException e) {
                            log.error("{} caught exception whilst trying to map entity, exception {}", (Object)"getPaths", (Object)e.getMessage());
                            g.tx().rollback();
                            throw new EntityNotKnownException(GraphOMRSErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(this.entityMapper.getEntityGUID(vertex), "getPaths", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getPaths", (Throwable)e);
                        }
                    }
                    log.error("{} unknown path element type - element {}", (Object)"getPaths", object);
                    continue block9;
                }
            }
            g.tx().commit();
            subGraph.setEntities(entities);
            subGraph.setRelationships(relationships);
            return subGraph;
        }
        catch (Exception e) {
            log.error("{} caught exception from subgraph traversal {}", (Object)"getPaths", (Object)e.getMessage());
            g.tx().rollback();
            return null;
        }
    }

    List<EntityDetail> findEntitiesForType(String typeDefName, SearchProperties searchProperties, boolean fullMatch) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findEntitiesForType";
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]);
        if (typeDefName != null) {
            gt = gt.has("vetypeName", (Object)typeDefName);
        }
        gt = gt.has("veentityIsProxy", (Object)false);
        if (searchProperties != null) {
            try {
                List<GraphTraversal<Vertex, Vertex>> propCriteria = this.processEntitySearchPropertiesForType(typeDefName, searchProperties, fullMatch);
                switch (searchProperties.getMatchCriteria()) {
                    case ALL: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForType", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForType", (Object)gt);
                        break;
                    }
                    case NONE: {
                        if (!propCriteria.isEmpty()) {
                            DefaultGraphTraversal t = new DefaultGraphTraversal();
                            t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                            gt = gt.not((Traversal)t);
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForType", (Object)gt);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesForType", "searchProperties");
                    }
                }
            }
            catch (Exception e) {
                g.tx().rollback();
                throw e;
            }
        }
        while (gt.hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found vertex {}", (Object)"findEntitiesForType", (Object)vertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)"findEntitiesForType", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entityDetail.getGUID(), "findEntitiesForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesForType", (Throwable)e);
            }
        }
        g.tx().commit();
        return entities;
    }

    List<EntityDetail> findEntitiesForTypes(List<String> validTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, SearchProperties searchProperties) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findEntitiesForTypes";
        boolean performTypeFiltering = filterTypeName != null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.V(new Object[0]).hasLabel("Entity", new String[0]);
        gt = gt.has("veentityIsProxy", (Object)false);
        if (searchProperties != null) {
            try {
                List<GraphTraversal<Vertex, Vertex>> propCriteria = this.processEntitySearchPropertiesForTypes(searchProperties, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames);
                switch (searchProperties.getMatchCriteria()) {
                    case ALL: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForTypes", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForTypes", (Object)gt);
                        break;
                    }
                    case NONE: {
                        if (!propCriteria.isEmpty()) {
                            DefaultGraphTraversal t = new DefaultGraphTraversal();
                            t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                            gt = gt.not((Traversal)t);
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findEntitiesForTypes", (Object)gt);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findEntitiesForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesForTypes", "searchProperties");
                    }
                }
            }
            catch (Exception e) {
                g.tx().rollback();
                throw e;
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("vetypeName", P.within(validTypeNames));
        }
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        while (gt.hasNext()) {
            Vertex vertex = (Vertex)gt.next();
            log.debug("{} found vertex {}", (Object)"findEntitiesForTypes", (Object)vertex);
            EntityDetail entityDetail = new EntityDetail();
            try {
                Boolean isProxy = this.entityMapper.isProxy(vertex);
                if (isProxy.booleanValue()) continue;
                this.entityMapper.mapVertexToEntityDetail(vertex, entityDetail);
                entities.add(entityDetail);
            }
            catch (Exception e) {
                log.error("{} Caught exception from entity mapper {}", (Object)"findEntitiesForTypes", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.ENTITY_PROPERTIES_ERROR.getMessageDefinition(entityDetail.getGUID(), "findEntitiesForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findEntitiesForTypes", (Throwable)e);
            }
        }
        g.tx().commit();
        return entities;
    }

    List<Relationship> findRelationshipsForTypes(List<String> validTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, SearchProperties searchProperties) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findRelationshipsForTypes";
        boolean performTypeFiltering = filterTypeName != null;
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.E(new Object[0]).hasLabel("Relationship", new String[0]);
        if (searchProperties != null) {
            try {
                List<GraphTraversal<Edge, Edge>> propCriteria = this.processRelationshipSearchPropertiesForTypes(searchProperties, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames);
                switch (searchProperties.getMatchCriteria()) {
                    case ALL: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForTypes", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForTypes", (Object)gt);
                        break;
                    }
                    case NONE: {
                        if (!propCriteria.isEmpty()) {
                            DefaultGraphTraversal t = new DefaultGraphTraversal();
                            t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                            gt = gt.not((Traversal)t);
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForTypes", (Object)gt);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findRelationshipsForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsForTypes", "searchProperties");
                    }
                }
            }
            catch (Exception e) {
                g.tx().rollback();
                throw e;
            }
        }
        if (performTypeFiltering) {
            gt = gt.has("ertypeName", P.within(validTypeNames));
        }
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        while (gt.hasNext()) {
            Edge edge = (Edge)gt.next();
            log.debug("{} found edge {}", (Object)"findRelationshipsForTypes", (Object)edge);
            Relationship relationship = new Relationship();
            try {
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                Vertex vertexOne = edge.outVertex();
                Vertex vertexTwo = edge.inVertex();
                if (vertexOne != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsForTypes", (Object)vertexOne);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexOne, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)"findRelationshipsForTypes", (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if (vertexTwo != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsForTypes", (Object)vertexTwo);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexTwo, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)"findRelationshipsForTypes", (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship or entity mapper {}", (Object)"findRelationshipsForTypes", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR.getMessageDefinition(relationship.getGUID(), "findRelationshipsForTypes", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsForTypes", (Throwable)e);
            }
            relationships.add(relationship);
        }
        g.tx().commit();
        return relationships;
    }

    List<Relationship> findRelationshipsForType(String typeDefName, SearchProperties searchProperties, boolean fullMatch) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findRelationshipsForType";
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        GraphTraversalSource g = this.instanceGraph.traversal();
        GraphTraversal gt = g.E(new Object[0]).hasLabel("Relationship", new String[0]);
        if (typeDefName != null) {
            gt = gt.has("ertypeName", (Object)typeDefName);
        }
        if (searchProperties != null) {
            try {
                List<GraphTraversal<Edge, Edge>> propCriteria = this.processRelationshipSearchPropertiesForType(typeDefName, searchProperties, fullMatch);
                switch (searchProperties.getMatchCriteria()) {
                    case ALL: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.and((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForType", (Object)gt);
                        break;
                    }
                    case ANY: {
                        if (!propCriteria.isEmpty()) {
                            gt = gt.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForType", (Object)gt);
                        break;
                    }
                    case NONE: {
                        if (!propCriteria.isEmpty()) {
                            DefaultGraphTraversal t = new DefaultGraphTraversal();
                            t = t.or((Traversal[])propCriteria.toArray(new GraphTraversal[0]));
                            gt = gt.not((Traversal)t);
                        }
                        log.debug("{} traversal looks like this --> {} ", (Object)"findRelationshipsForType", (Object)gt);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("findRelationshipsForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsForType", "searchProperties");
                    }
                }
            }
            catch (Exception e) {
                g.tx().rollback();
                throw e;
            }
        }
        while (gt.hasNext()) {
            Edge edge = (Edge)gt.next();
            log.debug("{} found edge {}", (Object)"findRelationshipsForType", (Object)edge);
            Relationship relationship = new Relationship();
            try {
                this.relationshipMapper.mapEdgeToRelationship(edge, relationship);
                Vertex vertexOne = edge.outVertex();
                Vertex vertexTwo = edge.inVertex();
                if (vertexOne != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsForType", (Object)vertexOne);
                    EntityProxy entityOneProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexOne, entityOneProxy);
                    log.debug("{} entityOneProxy {}", (Object)"findRelationshipsForType", (Object)entityOneProxy);
                    relationship.setEntityOneProxy(entityOneProxy);
                }
                if (vertexTwo != null) {
                    log.debug("{} entity vertex {}", (Object)"findRelationshipsForType", (Object)vertexTwo);
                    EntityProxy entityTwoProxy = new EntityProxy();
                    this.entityMapper.mapVertexToEntityProxy(vertexTwo, entityTwoProxy);
                    log.debug("{} entityTwoProxy {}", (Object)"findRelationshipsForType", (Object)entityTwoProxy);
                    relationship.setEntityTwoProxy(entityTwoProxy);
                }
            }
            catch (Exception e) {
                log.error("{} Caught exception from relationship or entity mapper {}", (Object)"findRelationshipsForType", (Object)e.getMessage());
                g.tx().rollback();
                throw new RepositoryErrorException(GraphOMRSErrorCode.RELATIONSHIP_PROPERTIES_ERROR.getMessageDefinition(relationship.getGUID(), "findRelationshipsForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "findRelationshipsForType", (Throwable)e);
            }
            relationships.add(relationship);
        }
        g.tx().commit();
        return relationships;
    }

    private List<GraphTraversal<Vertex, Vertex>> processEntitySearchPropertiesForType(String typeDefName, SearchProperties searchProperties, boolean fullMatch) throws InvalidParameterException, FunctionNotSupportedException {
        String methodName = "processEntitySearchPropertiesForType";
        ArrayList<GraphTraversal<Vertex, Vertex>> propCriteria = new ArrayList<GraphTraversal<Vertex, Vertex>>();
        List conditions = searchProperties.getConditions();
        for (PropertyCondition condition : conditions) {
            boolean localCondition = this.validatePropertyCondition(condition);
            if (localCondition) {
                InstancePropertyValue value;
                PropertyComparisonOperator operator;
                String propertyName = condition.getProperty();
                GraphTraversal<Vertex, Vertex> propertyCriterion = this.parseEntityPropertyConditionToCriterionForType(typeDefName, propertyName, operator = condition.getOperator(), value = condition.getValue(), fullMatch);
                if (propertyCriterion == null) continue;
                propCriteria.add(propertyCriterion);
                continue;
            }
            SearchProperties nestedConditions = condition.getNestedConditions();
            List<GraphTraversal<Vertex, Vertex>> subCriteria = this.processEntitySearchPropertiesForType(typeDefName, nestedConditions, fullMatch);
            DefaultGraphTraversal propertyCriterion = new DefaultGraphTraversal();
            switch (nestedConditions.getMatchCriteria()) {
                case ALL: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.and((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case ANY: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case NONE: {
                    if (subCriteria.isEmpty()) break;
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    propertyCriterion = propertyCriterion.not((Traversal)t);
                    break;
                }
                default: {
                    throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("processEntitySearchPropertiesForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "processEntitySearchPropertiesForType", "searchProperties");
                }
            }
            if (propertyCriterion == null) continue;
            propCriteria.add((GraphTraversal<Vertex, Vertex>)propertyCriterion);
        }
        return propCriteria;
    }

    private List<GraphTraversal<Edge, Edge>> processRelationshipSearchPropertiesForType(String typeDefName, SearchProperties searchProperties, boolean fullMatch) throws InvalidParameterException, FunctionNotSupportedException {
        String methodName = "processRelationshipSearchPropertiesForType";
        ArrayList<GraphTraversal<Edge, Edge>> propCriteria = new ArrayList<GraphTraversal<Edge, Edge>>();
        List conditions = searchProperties.getConditions();
        for (PropertyCondition condition : conditions) {
            boolean localCondition = this.validatePropertyCondition(condition);
            if (localCondition) {
                InstancePropertyValue value;
                PropertyComparisonOperator operator;
                String propertyName = condition.getProperty();
                GraphTraversal<Edge, Edge> propertyCriterion = this.parseRelationshipPropertyConditionToCriterionForType(typeDefName, propertyName, operator = condition.getOperator(), value = condition.getValue(), fullMatch);
                if (propertyCriterion == null) continue;
                propCriteria.add(propertyCriterion);
                continue;
            }
            SearchProperties nestedConditions = condition.getNestedConditions();
            List<GraphTraversal<Edge, Edge>> subCriteria = this.processRelationshipSearchPropertiesForType(typeDefName, nestedConditions, fullMatch);
            DefaultGraphTraversal propertyCriterion = new DefaultGraphTraversal();
            switch (nestedConditions.getMatchCriteria()) {
                case ALL: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.and((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case ANY: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case NONE: {
                    if (subCriteria.isEmpty()) break;
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    propertyCriterion = propertyCriterion.not((Traversal)t);
                    break;
                }
                default: {
                    throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("processRelationshipSearchPropertiesForType", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "processRelationshipSearchPropertiesForType", "searchProperties");
                }
            }
            if (propertyCriterion == null) continue;
            propCriteria.add((GraphTraversal<Edge, Edge>)propertyCriterion);
        }
        return propCriteria;
    }

    private List<GraphTraversal<Vertex, Vertex>> processEntitySearchPropertiesForTypes(SearchProperties searchProperties, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames) throws InvalidParameterException, FunctionNotSupportedException {
        String methodName = "processEntitySearchProperties";
        ArrayList<GraphTraversal<Vertex, Vertex>> propCriteria = new ArrayList<GraphTraversal<Vertex, Vertex>>();
        List conditions = searchProperties.getConditions();
        for (PropertyCondition condition : conditions) {
            boolean localCondition = this.validatePropertyCondition(condition);
            if (localCondition) {
                InstancePropertyValue value;
                PropertyComparisonOperator operator;
                String propertyName = condition.getProperty();
                GraphTraversal<Vertex, Vertex> propertyCriterion = this.parseEntityPropertyConditionToCriterionForTypes(propertyName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, operator = condition.getOperator(), value = condition.getValue());
                if (propertyCriterion == null) continue;
                propCriteria.add(propertyCriterion);
                continue;
            }
            SearchProperties nestedConditions = condition.getNestedConditions();
            List<GraphTraversal<Vertex, Vertex>> subCriteria = this.processEntitySearchPropertiesForTypes(nestedConditions, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames);
            DefaultGraphTraversal propertyCriterion = new DefaultGraphTraversal();
            switch (nestedConditions.getMatchCriteria()) {
                case ALL: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.and((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case ANY: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case NONE: {
                    if (subCriteria.isEmpty()) break;
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    propertyCriterion = propertyCriterion.not((Traversal)t);
                    break;
                }
                default: {
                    throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("processEntitySearchProperties", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "processEntitySearchProperties", "searchProperties");
                }
            }
            if (propertyCriterion == null) continue;
            propCriteria.add((GraphTraversal<Vertex, Vertex>)propertyCriterion);
        }
        return propCriteria;
    }

    private List<GraphTraversal<Edge, Edge>> processRelationshipSearchPropertiesForTypes(SearchProperties searchProperties, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames) throws InvalidParameterException, FunctionNotSupportedException {
        String methodName = "processEntitySearchProperties";
        ArrayList<GraphTraversal<Edge, Edge>> propCriteria = new ArrayList<GraphTraversal<Edge, Edge>>();
        List conditions = searchProperties.getConditions();
        for (PropertyCondition condition : conditions) {
            boolean localCondition = this.validatePropertyCondition(condition);
            if (localCondition) {
                InstancePropertyValue value;
                PropertyComparisonOperator operator;
                String propertyName = condition.getProperty();
                GraphTraversal<Edge, Edge> propertyCriterion = this.parseRelationshipPropertyConditionToCriterionForTypes(propertyName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, operator = condition.getOperator(), value = condition.getValue());
                if (propertyCriterion == null) continue;
                propCriteria.add(propertyCriterion);
                continue;
            }
            SearchProperties nestedConditions = condition.getNestedConditions();
            List<GraphTraversal<Edge, Edge>> subCriteria = this.processRelationshipSearchPropertiesForTypes(nestedConditions, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames);
            DefaultGraphTraversal propertyCriterion = new DefaultGraphTraversal();
            switch (nestedConditions.getMatchCriteria()) {
                case ALL: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.and((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case ANY: {
                    if (subCriteria.isEmpty()) break;
                    propertyCriterion = propertyCriterion.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    break;
                }
                case NONE: {
                    if (subCriteria.isEmpty()) break;
                    DefaultGraphTraversal t = new DefaultGraphTraversal();
                    t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                    propertyCriterion = propertyCriterion.not((Traversal)t);
                    break;
                }
                default: {
                    throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_CRITERIA.getMessageDefinition("processEntitySearchProperties", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "processEntitySearchProperties", "searchProperties");
                }
            }
            if (propertyCriterion == null) continue;
            propCriteria.add((GraphTraversal<Edge, Edge>)propertyCriterion);
        }
        return propCriteria;
    }

    boolean validatePropertyCondition(PropertyCondition condition) throws InvalidParameterException {
        boolean localCondition;
        String methodName = "validatePropertyCondition";
        String propertyName = condition.getProperty();
        PropertyComparisonOperator operator = condition.getOperator();
        InstancePropertyValue value = condition.getValue();
        SearchProperties nestedConditions = condition.getNestedConditions();
        if (propertyName != null && operator != null && value != null && nestedConditions == null) {
            localCondition = true;
        } else if (propertyName == null && operator == null && value == null && nestedConditions != null) {
            localCondition = false;
        } else {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_PROPERTY_CONDITION.getMessageDefinition("validatePropertyCondition", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "validatePropertyCondition", "searchProperties");
        }
        return localCondition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Vertex, Vertex> parseEntityPropertyConditionToCriterionForType(String typeDefName, String propName, PropertyComparisonOperator operator, InstancePropertyValue value, boolean fullMatch) throws InvalidParameterException, FunctionNotSupportedException {
        GraphOMRSGraphFactory.MixedIndexMapping mapping;
        String propNameInGraph;
        GraphTraversal<Vertex, Vertex> propertyCriterion;
        String methodName;
        block16: {
            Set<String> typeDefinedPropertyNames;
            Map<String, String> qualifiedPropertyNames;
            TypeDef typeDef;
            block15: {
                methodName = "parseEntityPropertyConditionToCriterion";
                if (operator == PropertyComparisonOperator.IN) {
                    throw new FunctionNotSupportedException(GraphOMRSErrorCode.UNSUPPORTED_SEARCH_PROPERTY_OPERATOR.getMessageDefinition(operator.toString(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
                }
                propertyCriterion = null;
                Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
                typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
                GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
                qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
                typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
                propNameInGraph = null;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                if (!corePropertyNames.contains(propName)) break block15;
                String javaTypeForMatchProperty = null;
                InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
                if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                    javaTypeForMatchProperty = mpCat.getJavaClassName();
                } else {
                    log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
                }
                String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) break block16;
                if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "matchProperties");
                propNameInGraph = "ve" + propName;
                mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameInGraph);
                break block16;
            }
            if (typeDefinedPropertyNames.contains(propName)) {
                List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, methodName);
                for (TypeDefAttribute propertyDef : propertiesDef) {
                    String definedPropertyName = propertyDef.getAttributeName();
                    if (!definedPropertyName.equals(propName)) continue;
                    PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                        mpCat = ppv.getPrimitiveDefCategory();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
                    }
                    PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    AttributeTypeDef atd = propertyDef.getAttributeType();
                    AttributeTypeDefCategory atdCat = atd.getCategory();
                    if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef pdef = (PrimitiveDef)atd;
                        pdCat = pdef.getPrimitiveDefCategory();
                    }
                    if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) break;
                    String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                    propNameInGraph = "ve" + qualifiedPropertyName;
                    mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                    break;
                }
            }
        }
        if (propNameInGraph != null) {
            InstancePropertyCategory ipvCat = value.getInstancePropertyCategory();
            if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                GraphTraversal<Vertex, Vertex> t;
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                Object primValue = ppv.getPrimitiveValue();
                log.debug("{} primitive match property has key {} value {}", new Object[]{methodName, propName, primValue});
                switch (pCat) {
                    case OM_PRIMITIVE_TYPE_STRING: {
                        t = this.vertexApplyOperatorToString(propNameInGraph, operator, primValue, mapping, fullMatch);
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        t = this.vertexApplyOperatorToDate(propNameInGraph, operator, primValue, propName, pCat);
                        break;
                    }
                    default: {
                        t = this.vertexApplyOperatorToObject(propNameInGraph, operator, primValue);
                    }
                }
                log.debug("{} primitive search property has property criterion {}", (Object)methodName, t);
                return t;
            }
        } else {
            GraphTraversal<Vertex, Vertex> t = new GraphTraversal<Vertex, Vertex>();
            return t = t.has("vetypeName", (Object)("InvalidTypeForProperty" + propName));
        }
        log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
        return propertyCriterion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Vertex, Vertex> parseEntityPropertyConditionToCriterionForTypes(String propName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, PropertyComparisonOperator operator, InstancePropertyValue value) throws InvalidParameterException, FunctionNotSupportedException {
        String qualifiedName;
        List<String> qNameList;
        String methodName = "parseEntityPropertyConditionToCriterion";
        if (operator == PropertyComparisonOperator.IN) {
            throw new FunctionNotSupportedException(GraphOMRSErrorCode.UNSUPPORTED_SEARCH_PROPERTY_OPERATOR.getMessageDefinition(operator.toString(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        GraphTraversal propertyCriterion = null;
        Set<String> typeDefinedPropertyNames = null;
        if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
            typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
        }
        HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
        if (corePropertyNames.contains(propName)) {
            String javaTypeForMatchProperty = null;
            InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                javaTypeForMatchProperty = mpCat.getJavaClassName();
            } else {
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
            if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "matchProperties");
                String matchedPropName = "ve" + propName;
                mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                matchedPropToMapping.put(matchedPropName, mapping);
            }
        } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty() && (qualifiedName = qNameList.get(0)) != null) {
            TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
            AttributeTypeDef atd = propertyDef.getAttributeType();
            PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
            AttributeTypeDefCategory atdCat = atd.getCategory();
            if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                PrimitiveDef pdef = (PrimitiveDef)atd;
                pdCat = pdef.getPrimitiveDefCategory();
            }
            PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
            InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                mpCat = ppv.getPrimitiveDefCategory();
            } else {
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            if (mpCat == pdCat && mpCat != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) {
                String matchedPropName = "ve" + qualifiedName;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                matchedPropToMapping.put(matchedPropName, mapping);
            }
        }
        if (!matchedPropToMapping.isEmpty()) {
            ArrayList<GraphTraversal<Vertex, Vertex>> localCriteria = new ArrayList<GraphTraversal<Vertex, Vertex>>();
            Set matchedPropNames = matchedPropToMapping.keySet();
            Iterator matchPropNameIterator = matchedPropNames.iterator();
            while (matchPropNameIterator.hasNext()) {
                String thisMatchedPropName = (String)matchPropNameIterator.next();
                InstancePropertyCategory ipvCat = value.getInstancePropertyCategory();
                if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                    GraphTraversal<Vertex, Vertex> t;
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                    Object primValue = ppv.getPrimitiveValue();
                    log.debug("{} primitive match property has key {} value {}", new Object[]{methodName, propName, primValue});
                    switch (pCat) {
                        case OM_PRIMITIVE_TYPE_STRING: {
                            t = this.vertexApplyOperatorToString(thisMatchedPropName, operator, primValue, mapping, true);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            t = this.vertexApplyOperatorToDate(thisMatchedPropName, operator, primValue, propName, pCat);
                            break;
                        }
                        default: {
                            t = this.vertexApplyOperatorToObject(thisMatchedPropName, operator, primValue);
                        }
                    }
                    log.debug("{} primitive search property has property criterion {}", (Object)methodName, t);
                    localCriteria.add(t);
                    continue;
                }
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            return (GraphTraversal)localCriteria.get(0);
        }
        DefaultGraphTraversal t = new DefaultGraphTraversal();
        t = t.has("vetypeName", (Object)("InvalidTypeForProperty" + propName));
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Edge, Edge> parseRelationshipPropertyConditionToCriterionForType(String typeDefName, String propName, PropertyComparisonOperator operator, InstancePropertyValue value, boolean fullMatch) throws InvalidParameterException, FunctionNotSupportedException {
        GraphOMRSGraphFactory.MixedIndexMapping mapping;
        String propNameInGraph;
        GraphTraversal<Edge, Edge> propertyCriterion;
        String methodName;
        block16: {
            Set<String> typeDefinedPropertyNames;
            Map<String, String> qualifiedPropertyNames;
            TypeDef typeDef;
            block15: {
                methodName = "parseRelationshipPropertyConditionToCriterion";
                if (operator == PropertyComparisonOperator.IN) {
                    throw new FunctionNotSupportedException(GraphOMRSErrorCode.UNSUPPORTED_SEARCH_PROPERTY_OPERATOR.getMessageDefinition(operator.toString(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
                }
                propertyCriterion = null;
                Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
                typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
                GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
                qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
                typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
                propNameInGraph = null;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                if (!corePropertyNames.contains(propName)) break block15;
                String javaTypeForMatchProperty = null;
                InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
                if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                    javaTypeForMatchProperty = mpCat.getJavaClassName();
                } else {
                    log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
                }
                String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
                if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) break block16;
                if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "matchProperties");
                propNameInGraph = "er" + propName;
                mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameInGraph);
                break block16;
            }
            if (typeDefinedPropertyNames.contains(propName)) {
                List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, methodName);
                for (TypeDefAttribute propertyDef : propertiesDef) {
                    String definedPropertyName = propertyDef.getAttributeName();
                    if (!definedPropertyName.equals(propName)) continue;
                    PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
                    if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                        mpCat = ppv.getPrimitiveDefCategory();
                    } else {
                        log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
                    }
                    PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                    AttributeTypeDef atd = propertyDef.getAttributeType();
                    AttributeTypeDefCategory atdCat = atd.getCategory();
                    if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef pdef = (PrimitiveDef)atd;
                        pdCat = pdef.getPrimitiveDefCategory();
                    }
                    if (mpCat != pdCat || mpCat == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) break;
                    String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                    propNameInGraph = "er" + qualifiedPropertyName;
                    mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                    break;
                }
            }
        }
        if (propNameInGraph != null) {
            InstancePropertyCategory ipvCat = value.getInstancePropertyCategory();
            if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                GraphTraversal<Edge, Edge> t;
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                Object primValue = ppv.getPrimitiveValue();
                log.debug("{} primitive match property has key {} value {}", new Object[]{methodName, propName, primValue});
                switch (pCat) {
                    case OM_PRIMITIVE_TYPE_STRING: {
                        t = this.edgeApplyOperatorToString(propNameInGraph, operator, primValue, mapping, fullMatch);
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        t = this.edgeApplyOperatorToDate(propNameInGraph, operator, primValue, propName, pCat);
                        break;
                    }
                    default: {
                        t = this.edgeApplyOperatorToObject(propNameInGraph, operator, primValue);
                    }
                }
                log.debug("{} primitive search property has property criterion {}", (Object)methodName, t);
                return t;
            }
        } else {
            GraphTraversal<Edge, Edge> t = new GraphTraversal<Edge, Edge>();
            return t = t.has("ertypeName", (Object)("InvalidTypeForProperty" + propName));
        }
        log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
        return propertyCriterion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Edge, Edge> parseRelationshipPropertyConditionToCriterionForTypes(String propName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, PropertyComparisonOperator operator, InstancePropertyValue value) throws InvalidParameterException, FunctionNotSupportedException {
        String qualifiedName;
        List<String> qNameList;
        String methodName = "parseRelationshipPropertyConditionToCriterion";
        if (operator == PropertyComparisonOperator.IN) {
            throw new FunctionNotSupportedException(GraphOMRSErrorCode.UNSUPPORTED_SEARCH_PROPERTY_OPERATOR.getMessageDefinition(operator.toString(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        GraphTraversal propertyCriterion = null;
        Set<String> typeDefinedPropertyNames = null;
        if (!shortPropertyNameToQualifiedPropertyNames.isEmpty()) {
            typeDefinedPropertyNames = shortPropertyNameToQualifiedPropertyNames.keySet();
        }
        HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping> matchedPropToMapping = new HashMap<String, GraphOMRSGraphFactory.MixedIndexMapping>();
        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
        if (corePropertyNames.contains(propName)) {
            String javaTypeForMatchProperty = null;
            InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                PrimitiveDefCategory mpCat = ppv.getPrimitiveDefCategory();
                javaTypeForMatchProperty = mpCat.getJavaClassName();
            } else {
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
            if (javaTypeForCoreProperty != null && javaTypeForMatchProperty != null) {
                if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_MATCH_PROPERTY.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "matchProperties");
                String matchedPropName = "er" + propName;
                mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(matchedPropName);
                matchedPropToMapping.put(matchedPropName, mapping);
            }
        } else if (typeDefinedPropertyNames != null && typeDefinedPropertyNames.contains(propName) && (qNameList = shortPropertyNameToQualifiedPropertyNames.get(propName)) != null && !qNameList.isEmpty() && (qualifiedName = qNameList.get(0)) != null) {
            TypeDefAttribute propertyDef = qualifiedPropertyNameToTypeDefinedAttribute.get(qualifiedName);
            AttributeTypeDef atd = propertyDef.getAttributeType();
            PrimitiveDefCategory pdCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
            AttributeTypeDefCategory atdCat = atd.getCategory();
            if (atdCat == AttributeTypeDefCategory.PRIMITIVE) {
                PrimitiveDef pdef = (PrimitiveDef)atd;
                pdCat = pdef.getPrimitiveDefCategory();
            }
            PrimitiveDefCategory mpCat = PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
            InstancePropertyCategory mpvCat = value.getInstancePropertyCategory();
            if (mpvCat == InstancePropertyCategory.PRIMITIVE) {
                PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                mpCat = ppv.getPrimitiveDefCategory();
            } else {
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            if (mpCat == pdCat && mpCat != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) {
                String matchedPropName = "er" + qualifiedName;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                matchedPropToMapping.put(matchedPropName, mapping);
            }
        }
        if (!matchedPropToMapping.isEmpty()) {
            ArrayList<GraphTraversal<Edge, Edge>> localCriteria = new ArrayList<GraphTraversal<Edge, Edge>>();
            Set matchedPropNames = matchedPropToMapping.keySet();
            Iterator matchPropNameIterator = matchedPropNames.iterator();
            while (matchPropNameIterator.hasNext()) {
                String thisMatchedPropName = (String)matchPropNameIterator.next();
                InstancePropertyCategory ipvCat = value.getInstancePropertyCategory();
                if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
                    GraphTraversal<Edge, Edge> t;
                    PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory pCat = ppv.getPrimitiveDefCategory();
                    Object primValue = ppv.getPrimitiveValue();
                    log.debug("{} primitive match property has key {} value {}", new Object[]{methodName, propName, primValue});
                    switch (pCat) {
                        case OM_PRIMITIVE_TYPE_STRING: {
                            t = this.edgeApplyOperatorToString(thisMatchedPropName, operator, primValue, mapping, true);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            t = this.edgeApplyOperatorToDate(thisMatchedPropName, operator, primValue, propName, pCat);
                            break;
                        }
                        default: {
                            t = this.edgeApplyOperatorToObject(thisMatchedPropName, operator, primValue);
                        }
                    }
                    log.debug("{} primitive search property has property criterion {}", (Object)methodName, t);
                    localCriteria.add(t);
                    continue;
                }
                log.debug("{} non-primitive match property {} ignored", (Object)methodName, (Object)propName);
            }
            return (GraphTraversal)localCriteria.get(0);
        }
        DefaultGraphTraversal t = new DefaultGraphTraversal();
        t = t.has("vetypeName", (Object)("InvalidTypeForProperty" + propName));
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Vertex, Vertex> parseEntityInOperatorToCriterion(String typeDefName, String propName, InstancePropertyValue value) throws InvalidParameterException {
        boolean isCoreProperty;
        String methodName = "parseEntityInOperatorToCriterion";
        ArrayPropertyValue apv = (ArrayPropertyValue)value;
        if (apv.getArrayCount() <= 0) {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        InstanceProperties arrayValues = apv.getArrayValues();
        Map arrayElementProperties = arrayValues.getInstanceProperties();
        Collection arrayPropValues = arrayElementProperties.values();
        PrimitiveDefCategory allElementsPrimCat = null;
        for (InstancePropertyValue elementValue : arrayPropValues) {
            InstancePropertyCategory elementCategory = elementValue.getInstancePropertyCategory();
            if (elementCategory != InstancePropertyCategory.PRIMITIVE) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            PrimitivePropertyValue primElementValue = (PrimitivePropertyValue)elementValue;
            PrimitiveDefCategory thisElementPrimCat = primElementValue.getPrimitiveDefCategory();
            if (allElementsPrimCat == null) {
                allElementsPrimCat = thisElementPrimCat;
                continue;
            }
            if (thisElementPrimCat == allElementsPrimCat) continue;
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        if (allElementsPrimCat == null) {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        Set<String> typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
        if (corePropertyNames.contains(propName)) {
            isCoreProperty = true;
        } else {
            if (!typeDefinedPropertyNames.contains(propName)) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_NAME.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "propName");
            isCoreProperty = false;
        }
        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
        String propNameInGraph = null;
        if (isCoreProperty) {
            String javaTypeForMatchProperty = allElementsPrimCat.getJavaClassName();
            String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
            if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_TYPE.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_TYPE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            propNameInGraph = "ve" + propName;
            mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameInGraph);
        } else {
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, methodName);
            for (TypeDefAttribute propertyDef : propertiesDef) {
                PrimitiveDef pdef;
                PrimitiveDefCategory pdCat;
                String definedPropertyName = propertyDef.getAttributeName();
                if (!definedPropertyName.equals(propName)) continue;
                AttributeTypeDef atd = propertyDef.getAttributeType();
                AttributeTypeDefCategory atdCat = atd.getCategory();
                if (atdCat != AttributeTypeDefCategory.PRIMITIVE || (pdCat = (pdef = (PrimitiveDef)atd).getPrimitiveDefCategory()) != allElementsPrimCat) break;
                String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                propNameInGraph = "ve" + qualifiedPropertyName;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                break;
            }
        }
        GraphTraversal<Vertex, Vertex> propertyCriterion = null;
        if (propNameInGraph != null) {
            InstancePropertyCategory ipvCat = value.getInstancePropertyCategory();
            switch (allElementsPrimCat) {
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    Boolean[] booleanArray = this.marshallValuesAsBooleans(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, booleanArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BYTE: {
                    Byte[] byteArray = this.marshallValuesAsBytes(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, byteArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_CHAR: {
                    Character[] characterArray = this.marshallValuesAsCharacters(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, characterArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_SHORT: {
                    Short[] shortArray = this.marshallValuesAsShorts(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, shortArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_INT: {
                    Integer[] integerArray = this.marshallValuesAsIntegers(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, integerArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_LONG: {
                    Long[] longArray = this.marshallValuesAsLongs(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, longArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_FLOAT: {
                    Float[] floatArray = this.marshallValuesAsFloats(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, floatArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_DOUBLE: {
                    Double[] doubleArray = this.marshallValuesAsDoubles(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, doubleArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                    BigInteger[] bigIntegerArray = this.marshallValuesAsBigIntegers(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, bigIntegerArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                    BigDecimal[] bigDecimalArray = this.marshallValuesAsBigDecimals(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, bigDecimalArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_STRING: {
                    String[] stringArray = this.marshallValuesAsStrings(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, stringArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_DATE: {
                    if (isCoreProperty) {
                        Date[] dateArray = this.marshallValuesAsDates(apv);
                        propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, dateArray);
                        break;
                    }
                    Long[] timestampArray = this.marshallValuesAsLongs(apv);
                    propertyCriterion = this.vertexApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, timestampArray);
                }
            }
            log.debug("{} primitive search property has property criterion {}", (Object)methodName, propertyCriterion);
            return propertyCriterion;
        }
        GraphTraversal<Vertex, Vertex> t = new GraphTraversal<Vertex, Vertex>();
        return t = t.has("vetypeName", (Object)("InvalidTypeForProperty" + propName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GraphTraversal<Edge, Edge> parseRelationshipInOperatorToCriterion(String typeDefName, String propName, InstancePropertyValue value) throws InvalidParameterException {
        boolean isCoreProperty;
        String methodName = "parseRelationshipInOperatorToCriterion";
        ArrayPropertyValue apv = (ArrayPropertyValue)value;
        if (apv.getArrayCount() <= 0) {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        InstanceProperties arrayValues = apv.getArrayValues();
        Map arrayElementProperties = arrayValues.getInstanceProperties();
        Collection arrayPropValues = arrayElementProperties.values();
        PrimitiveDefCategory allElementsPrimCat = null;
        for (InstancePropertyValue elementValue : arrayPropValues) {
            InstancePropertyCategory elementCategory = elementValue.getInstancePropertyCategory();
            if (elementCategory != InstancePropertyCategory.PRIMITIVE) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            PrimitivePropertyValue primElementValue = (PrimitivePropertyValue)elementValue;
            PrimitiveDefCategory thisElementPrimCat = primElementValue.getPrimitiveDefCategory();
            if (allElementsPrimCat == null) {
                allElementsPrimCat = thisElementPrimCat;
                continue;
            }
            if (thisElementPrimCat == allElementsPrimCat) continue;
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        if (allElementsPrimCat == null) {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_VALUE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
        }
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefName);
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
        Set<String> typeDefinedPropertyNames = qualifiedPropertyNames.keySet();
        if (corePropertyNames.contains(propName)) {
            isCoreProperty = true;
        } else {
            if (!typeDefinedPropertyNames.contains(propName)) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_NAME.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "propName");
            isCoreProperty = false;
        }
        GraphOMRSGraphFactory.MixedIndexMapping mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
        String propNameInGraph = null;
        if (isCoreProperty) {
            String javaTypeForMatchProperty = allElementsPrimCat.getJavaClassName();
            String javaTypeForCoreProperty = GraphOMRSConstants.corePropertyTypes.get(propName);
            if (javaTypeForCoreProperty == null || javaTypeForMatchProperty == null) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_TYPE.getMessageDefinition(propName, javaTypeForMatchProperty, javaTypeForCoreProperty, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            if (!javaTypeForCoreProperty.equals(javaTypeForMatchProperty) && (!javaTypeForCoreProperty.equals("java.util.Date") || !javaTypeForMatchProperty.equals("java.lang.Long"))) throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_SEARCH_PROPERTY_TYPE.getMessageDefinition(propName, methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, "value");
            propNameInGraph = "er" + propName;
            mapping = GraphOMRSGraphFactory.corePropertyMixedIndexMappings.get(propNameInGraph);
        } else {
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, methodName);
            for (TypeDefAttribute propertyDef : propertiesDef) {
                PrimitiveDef pdef;
                PrimitiveDefCategory pdCat;
                String definedPropertyName = propertyDef.getAttributeName();
                if (!definedPropertyName.equals(propName)) continue;
                AttributeTypeDef atd = propertyDef.getAttributeType();
                AttributeTypeDefCategory atdCat = atd.getCategory();
                if (atdCat != AttributeTypeDefCategory.PRIMITIVE || (pdCat = (pdef = (PrimitiveDef)atd).getPrimitiveDefCategory()) != allElementsPrimCat) break;
                String qualifiedPropertyName = qualifiedPropertyNames.get(propName);
                propNameInGraph = "er" + qualifiedPropertyName;
                mapping = GraphOMRSGraphFactory.MixedIndexMapping.String;
                break;
            }
        }
        DefaultGraphTraversal propertyCriterion = null;
        if (propNameInGraph != null) {
            switch (allElementsPrimCat) {
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    Boolean[] booleanArray = this.marshallValuesAsBooleans(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, booleanArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BYTE: {
                    Byte[] byteArray = this.marshallValuesAsBytes(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, byteArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_CHAR: {
                    Character[] characterArray = this.marshallValuesAsCharacters(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, characterArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_SHORT: {
                    Short[] shortArray = this.marshallValuesAsShorts(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, shortArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_INT: {
                    Integer[] integerArray = this.marshallValuesAsIntegers(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, integerArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_LONG: {
                    Long[] longArray = this.marshallValuesAsLongs(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, longArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_FLOAT: {
                    Float[] floatArray = this.marshallValuesAsFloats(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, floatArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_DOUBLE: {
                    Double[] doubleArray = this.marshallValuesAsDoubles(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, doubleArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                    BigInteger[] bigIntegerArray = this.marshallValuesAsBigIntegers(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, bigIntegerArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                    BigDecimal[] bigDecimalArray = this.marshallValuesAsBigDecimals(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, bigDecimalArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_STRING: {
                    String[] stringArray = this.marshallValuesAsStrings(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, stringArray);
                    break;
                }
                case OM_PRIMITIVE_TYPE_DATE: {
                    if (isCoreProperty) {
                        Date[] dateArray = this.marshallValuesAsDates(apv);
                        propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, dateArray);
                        break;
                    }
                    Long[] timestampArray = this.marshallValuesAsLongs(apv);
                    propertyCriterion = this.edgeApplyOperatorToObject(propNameInGraph, PropertyComparisonOperator.IN, timestampArray);
                }
            }
        } else {
            DefaultGraphTraversal t = new DefaultGraphTraversal();
            return t = t.has("vetypeName", (Object)("InvalidTypeForProperty" + propName));
        }
        log.debug("{} primitive search property has property criterion {}", (Object)methodName, propertyCriterion);
        return propertyCriterion;
    }

    private GraphTraversal<Vertex, Vertex> vertexApplyOperatorToString(String propNameInGraph, PropertyComparisonOperator operator, Object primValue, GraphOMRSGraphFactory.MixedIndexMapping mapping, boolean fullMatch) {
        String methodName = "vertexApplyOperatorToString";
        GraphTraversal t = new DefaultGraphTraversal();
        if (operator == PropertyComparisonOperator.LIKE) {
            String searchString = this.convertSearchStringToJanusRegex((String)primValue);
            log.debug("{} primitive match property search string {}", (Object)methodName, (Object)searchString);
            if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                t = t.has(propNameInGraph, Text.textContainsRegex((Object)searchString));
            } else if (!fullMatch) {
                String ANYCHARS = ".*";
                t = t.has(propNameInGraph, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
            } else {
                t = t.has(propNameInGraph, Text.textRegex((Object)searchString));
            }
        } else {
            t = this.vertexApplyOperatorToObject(propNameInGraph, operator, primValue);
        }
        return t;
    }

    private GraphTraversal<Vertex, Vertex> vertexApplyOperatorToDate(String propNameInGraph, PropertyComparisonOperator operator, Object primValue, String shortPropName, PrimitiveDefCategory pCat) {
        GraphTraversal<Vertex, Vertex> t = new GraphTraversal<Vertex, Vertex>();
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesEntity.keySet();
        String javaTypeForMatchProperty = pCat.getJavaClassName();
        if (corePropertyNames.contains(shortPropName)) {
            if (javaTypeForMatchProperty.equals("java.lang.Long")) {
                Date dateValue = new Date((Long)primValue);
                t = this.vertexApplyOperatorToObject(propNameInGraph, operator, dateValue);
            } else {
                t = this.vertexApplyOperatorToObject(propNameInGraph, operator, primValue);
            }
        } else if (javaTypeForMatchProperty.equals("java.lang.Long")) {
            Long longValue = (Long)primValue;
            t = this.vertexApplyOperatorToObject(propNameInGraph, operator, longValue);
        }
        return t;
    }

    private GraphTraversal<Vertex, Vertex> vertexApplyOperatorToObject(String propNameInGraph, PropertyComparisonOperator operator, Object primValue) {
        DefaultGraphTraversal t = new DefaultGraphTraversal();
        switch (operator) {
            case EQ: {
                t = t.has(propNameInGraph, P.eq((Object)primValue));
                break;
            }
            case NEQ: {
                t = t.has(propNameInGraph, P.neq((Object)primValue));
                break;
            }
            case LT: {
                t = t.has(propNameInGraph, P.lt((Object)primValue));
                break;
            }
            case LTE: {
                t = t.has(propNameInGraph, P.lte((Object)primValue));
                break;
            }
            case GT: {
                t = t.has(propNameInGraph, P.gt((Object)primValue));
                break;
            }
            case GTE: {
                t = t.has(propNameInGraph, P.gte((Object)primValue));
                break;
            }
            case IN: {
                t = t.has(propNameInGraph, P.within((Object[])new Object[]{primValue}));
                break;
            }
            case IS_NULL: {
                DefaultGraphTraversal nonExistent = new DefaultGraphTraversal();
                DefaultGraphTraversal existentNull = new DefaultGraphTraversal();
                nonExistent = nonExistent.hasNot(propNameInGraph);
                existentNull = existentNull.has(propNameInGraph, P.eq(null));
                ArrayList<DefaultGraphTraversal> subCriteria = new ArrayList<DefaultGraphTraversal>();
                subCriteria.add(nonExistent);
                subCriteria.add(existentNull);
                t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                break;
            }
            case NOT_NULL: {
                t = t.has(propNameInGraph, P.neq(null));
            }
        }
        return t;
    }

    private GraphTraversal<Edge, Edge> edgeApplyOperatorToString(String propNameInGraph, PropertyComparisonOperator operator, Object primValue, GraphOMRSGraphFactory.MixedIndexMapping mapping, boolean fullMatch) {
        String methodName = "edgeApplyOperatorToString";
        GraphTraversal t = new DefaultGraphTraversal();
        if (operator == PropertyComparisonOperator.LIKE) {
            String searchString = this.convertSearchStringToJanusRegex((String)primValue);
            log.debug("{} primitive match property search string {}", (Object)methodName, (Object)searchString);
            if (mapping == GraphOMRSGraphFactory.MixedIndexMapping.Text) {
                t = t.has(propNameInGraph, Text.textContainsRegex((Object)searchString));
            } else if (!fullMatch) {
                String ANYCHARS = ".*";
                t = t.has(propNameInGraph, Text.textRegex((Object)(ANYCHARS + searchString + ANYCHARS)));
            } else {
                t = t.has(propNameInGraph, Text.textRegex((Object)searchString));
            }
        } else {
            t = this.edgeApplyOperatorToObject(propNameInGraph, operator, primValue);
        }
        return t;
    }

    private GraphTraversal<Edge, Edge> edgeApplyOperatorToDate(String propNameInGraph, PropertyComparisonOperator operator, Object primValue, String shortPropName, PrimitiveDefCategory pCat) {
        GraphTraversal<Edge, Edge> t = new GraphTraversal<Edge, Edge>();
        Set<String> corePropertyNames = GraphOMRSConstants.corePropertiesRelationship.keySet();
        String javaTypeForMatchProperty = pCat.getJavaClassName();
        if (corePropertyNames.contains(shortPropName)) {
            if (javaTypeForMatchProperty.equals("java.lang.Long")) {
                Date dateValue = new Date((Long)primValue);
                t = this.edgeApplyOperatorToObject(propNameInGraph, operator, dateValue);
            } else {
                t = this.edgeApplyOperatorToObject(propNameInGraph, operator, primValue);
            }
        } else if (javaTypeForMatchProperty.equals("java.lang.Long")) {
            Long longValue = (Long)primValue;
            t = this.edgeApplyOperatorToObject(propNameInGraph, operator, longValue);
        }
        return t;
    }

    private GraphTraversal<Edge, Edge> edgeApplyOperatorToObject(String propNameInGraph, PropertyComparisonOperator operator, Object primValue) {
        DefaultGraphTraversal t = new DefaultGraphTraversal();
        switch (operator) {
            case EQ: {
                t = t.has(propNameInGraph, P.eq((Object)primValue));
                break;
            }
            case NEQ: {
                t = t.has(propNameInGraph, P.neq((Object)primValue));
                break;
            }
            case LT: {
                t = t.has(propNameInGraph, P.lt((Object)primValue));
                break;
            }
            case LTE: {
                t = t.has(propNameInGraph, P.lte((Object)primValue));
                break;
            }
            case GT: {
                t = t.has(propNameInGraph, P.gt((Object)primValue));
                break;
            }
            case GTE: {
                t = t.has(propNameInGraph, P.gte((Object)primValue));
                break;
            }
            case IN: {
                t = t.has(propNameInGraph, P.within((Object[])new Object[]{primValue}));
                break;
            }
            case IS_NULL: {
                DefaultGraphTraversal nonExistent = new DefaultGraphTraversal();
                DefaultGraphTraversal existentNull = new DefaultGraphTraversal();
                nonExistent = nonExistent.hasNot(propNameInGraph);
                existentNull = existentNull.has(propNameInGraph, P.eq(null));
                ArrayList<DefaultGraphTraversal> subCriteria = new ArrayList<DefaultGraphTraversal>();
                subCriteria.add(nonExistent);
                subCriteria.add(existentNull);
                t = t.or((Traversal[])subCriteria.toArray(new GraphTraversal[0]));
                break;
            }
            case NOT_NULL: {
                t = t.has(propNameInGraph, P.neq(null));
            }
        }
        return t;
    }

    private Collection<InstancePropertyValue> getArrayElementValues(ArrayPropertyValue apv) {
        InstanceProperties arrayValues = apv.getArrayValues();
        Map arrayElementProperties = arrayValues.getInstanceProperties();
        return arrayElementProperties.values();
    }

    private Boolean[] marshallValuesAsBooleans(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Boolean[] booleanArray = new Boolean[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            booleanArray[index++] = (Boolean)primValue;
        }
        return booleanArray;
    }

    private Byte[] marshallValuesAsBytes(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Byte[] byteArray = new Byte[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            byteArray[index++] = (Byte)primValue;
        }
        return byteArray;
    }

    private Character[] marshallValuesAsCharacters(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Character[] characterArray = new Character[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            characterArray[index++] = (Character)primValue;
        }
        return characterArray;
    }

    private Short[] marshallValuesAsShorts(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Short[] shortArray = new Short[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            shortArray[index++] = (Short)primValue;
        }
        return shortArray;
    }

    private Integer[] marshallValuesAsIntegers(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Integer[] integerArray = new Integer[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            integerArray[index++] = (Integer)primValue;
        }
        return integerArray;
    }

    private Long[] marshallValuesAsLongs(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Long[] longArray = new Long[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            longArray[index++] = (Long)primValue;
        }
        return longArray;
    }

    private Float[] marshallValuesAsFloats(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Float[] floatArray = new Float[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            floatArray[index++] = (Float)primValue;
        }
        return floatArray;
    }

    private Double[] marshallValuesAsDoubles(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Double[] doubleArray = new Double[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            doubleArray[index++] = (Double)primValue;
        }
        return doubleArray;
    }

    private BigInteger[] marshallValuesAsBigIntegers(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        BigInteger[] bigIntegerArray = new BigInteger[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            bigIntegerArray[index++] = (BigInteger)primValue;
        }
        return bigIntegerArray;
    }

    private BigDecimal[] marshallValuesAsBigDecimals(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        BigDecimal[] bigDecimalArray = new BigDecimal[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            bigDecimalArray[index++] = (BigDecimal)primValue;
        }
        return bigDecimalArray;
    }

    private String[] marshallValuesAsStrings(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        String[] stringArray = new String[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            stringArray[index++] = (String)primValue;
        }
        return stringArray;
    }

    private Date[] marshallValuesAsDates(ArrayPropertyValue arrayPropertyValue) {
        int arrayLength = arrayPropertyValue.getArrayCount();
        Collection<InstancePropertyValue> arrayElementValues = this.getArrayElementValues(arrayPropertyValue);
        Date[] dateArray = new Date[arrayLength];
        int index = 0;
        for (InstancePropertyValue ipv : arrayElementValues) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            dateArray[index++] = new Date((Long)primValue);
        }
        return dateArray;
    }
}

