/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMetadataStore;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSQueryPlan;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRepositoryConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSDynamicTypeMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSMetadataCollection
extends OMRSDynamicTypeMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSMetadataCollection.class);
    private GraphOMRSMetadataStore graphStore = null;

    GraphOMRSMetadataCollection(GraphOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, AuditLog auditLog, Map<String, Object> storageProperties) throws RepositoryErrorException {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        String methodName = "GraphOMRSMetadataCollection";
        this.parentConnector = parentConnector;
        try {
            this.graphStore = new GraphOMRSMetadataStore(metadataCollectionId, repositoryName, repositoryHelper, auditLog, storageProperties);
        }
        catch (RepositoryErrorException e) {
            log.error("{} could not create graph metadata collection for repository name {}", (Object)"GraphOMRSMetadataCollection", (Object)repositoryName);
            throw e;
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        boolean result = super.verifyTypeDef(userId, typeDef);
        TypeDefCategory typeDefCategory = typeDef.getCategory();
        switch (typeDefCategory) {
            case ENTITY_DEF: {
                this.graphStore.createEntityIndexes(typeDef);
                break;
            }
            case RELATIONSHIP_DEF: {
                this.graphStore.createRelationshipIndexes(typeDef);
                break;
            }
            case CLASSIFICATION_DEF: {
                this.graphStore.createClassificationIndexes(typeDef);
            }
        }
        return result;
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        TypeDef typeDef = super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(this.metadataCollectionName);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        newEntity = this.graphStore.createEntityInStore(newEntity);
        return newEntity;
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        TypeDef typeDef = super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(externalSourceName);
        newEntity.setReplicatedBy(this.metadataCollectionId);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        newEntity = this.graphStore.createEntityInStore(newEntity);
        return newEntity;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        EntityDetail entity = this.isEntityKnown(userId, entityProxy.getGUID());
        if (entity == null) {
            this.graphStore.createEntityProxyInStore(entityProxy);
        }
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        try {
            entity = this.graphStore.getEntityDetailFromStore(guid);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "isEntityKnown");
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.error("{} entity with GUID {} does not exist in repository {} or is a proxy", new Object[]{"isEntityKnown", guid, this.repositoryName});
            entity = null;
        }
        return entity;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        Relationship relationship;
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        try {
            relationship = this.graphStore.getRelationshipFromStore(guid);
            this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "isRelationshipKnown");
        }
        catch (RelationshipNotKnownException e) {
            log.warn("{} relationship with GUID {} does not exist in repository {}", new Object[]{"isRelationshipKnown", guid, this.repositoryName});
            relationship = null;
        }
        return relationship;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary entity = this.graphStore.getEntitySummaryFromStore(guid);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntitySummary");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntitySummary");
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        String guidParameterName = "guid";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.graphStore.getEntityDetailFromStore(guid);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntityDetail");
        return entity;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties);
        EntityProxy entityOneProxy = this.graphStore.getEntityProxyFromStore(entityOneGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityOneGUID, (EntitySummary)entityOneProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityOneProxy, "addRelationship");
        EntityProxy entityTwoProxy = this.graphStore.getEntityProxyFromStore(entityTwoGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityTwoGUID, (EntitySummary)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateRelationshipEnds(this.repositoryName, entityOneProxy, entityTwoProxy, typeDef, "addRelationship");
        relationship.setEntityOneProxy(entityOneProxy);
        relationship.setEntityTwoProxy(entityTwoProxy);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        this.graphStore.createRelationshipInStore(relationship);
        return relationship;
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties);
        relationship.setMetadataCollectionName(externalSourceName);
        relationship.setReplicatedBy(this.metadataCollectionId);
        EntityProxy entityOneProxy = this.graphStore.getEntityProxyFromStore(entityOneGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityOneGUID, (EntitySummary)entityOneProxy, "addExternalRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityOneProxy, "addExternalRelationship");
        EntityProxy entityTwoProxy = this.graphStore.getEntityProxyFromStore(entityTwoGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityTwoGUID, (EntitySummary)entityTwoProxy, "addExternalRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityTwoProxy, "addExternalRelationship");
        this.repositoryValidator.validateRelationshipEnds(this.repositoryName, entityOneProxy, entityTwoProxy, typeDef, "addExternalRelationship");
        relationship.setEntityOneProxy(entityOneProxy);
        relationship.setEntityTwoProxy(entityTwoProxy);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        this.graphStore.createRelationshipInStore(relationship);
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        Relationship relationship = this.graphStore.getRelationshipFromStore(guid);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "getRelationship");
        return relationship;
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        TypeDef typeDef;
        EntityDetail entity;
        String methodName = "updateEntityStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"updateEntityStatus", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(new String[]{"updateEntityStatus", ((Object)((Object)this)).getClass().getName(), this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", (Throwable)e);
        }
        catch (EntityNotKnownException e) {
            log.error("{} entity wth GUID {} not found ", (Object)"updateEntityStatus", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "updateEntityStatus", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", (Throwable)e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"updateEntityStatus", (Object)entityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityStatus");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityStatus");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityStatus");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        String entityTypeGUID = entity.getType().getTypeDefGUID();
        String entityTypeName = entity.getType().getTypeDefName();
        try {
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "updateEntityStatus");
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{entityTypeName, entityTypeGUID, "entityType", "updateEntityStatus", ((Object)((Object)this)).getClass().getName(), this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", (Throwable)e);
        }
        this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateEntityStatus");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setStatus(newStatus);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        TypeDef typeDef;
        EntityDetail entity;
        String methodName = "updateEntityProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} not found or only a proxy", (Object)"updateEntityProperties", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(new String[]{"updateEntityProperties", ((Object)((Object)this)).getClass().getName(), this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"updateEntityProperties", (Object)entityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityProperties");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityProperties");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityProperties");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        String entityTypeGUID = entity.getType().getTypeDefGUID();
        String entityTypeName = entity.getType().getTypeDefName();
        try {
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "updateEntityProperties");
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{entityTypeName, entityTypeGUID, "entityType", "updateEntityProperties", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", (Throwable)e);
        }
        this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateEntityProperties");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setProperties(properties);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        TypeDef typeDef;
        String methodName = "updateRelationshipStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipStatus");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        String relationshipTypeGUID = relationship.getType().getTypeDefGUID();
        String relationshipTypeName = relationship.getType().getTypeDefName();
        try {
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "updateRelationshipStatus");
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{relationshipTypeName, relationshipTypeGUID, "relationshipType", "updateRelationshipStatus", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateRelationshipStatus", (Throwable)e);
        }
        this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateRelationshipStatus");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatus(newStatus);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.updateRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        TypeDef typeDef;
        String methodName = "updateRelationshipProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        String relationshipTypeGUID = relationship.getType().getTypeDefGUID();
        String relationshipTypeName = relationship.getType().getTypeDefName();
        try {
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "updateRelationshipProperties");
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{relationshipTypeName, relationshipTypeGUID, "relationshipType", "updateRelationshipProperties", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateRelationshipProperties", (Throwable)e);
        }
        this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateRelationshipProperties");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setProperties(properties);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.updateRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        try {
            entity = this.graphStore.getEntityDetailFromStore(deletedEntityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.error("{} entity wth GUID {} not found or only a proxy", (Object)"purgeEntity", (Object)deletedEntityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(new String[]{"purgeEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "purgeEntity", e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"purgeEntity", (Object)deletedEntityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "purgeEntity");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entity, "purgeEntity");
        this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "purgeEntity");
        try {
            List<Relationship> relationships = this.getRelationshipsForEntity(userId, deletedEntityGUID, null, 0, null, null, null, null, 10000);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    this.graphStore.removeRelationshipFromStore(relationship.getGUID());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.graphStore.removeEntityFromStore(entity.getGUID());
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        Relationship relationship = this.graphStore.getRelationshipFromStore(deletedRelationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "purgeRelationship");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "purgeRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "purgeRelationship");
        this.graphStore.removeRelationshipFromStore(relationship.getGUID());
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "getRelationshipsForEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getRelationshipsForEntity");
        ArrayList entityRelationships = new ArrayList();
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"getRelationshipsForEntity");
            super.reportUnsupportedOptionalFunction("getRelationshipsForEntity");
        }
        ArrayList<Relationship> filteredRelationships = new ArrayList<Relationship>();
        List<Relationship> relationships = this.graphStore.getRelationshipsForEntity(entityGUID);
        for (Relationship relationship : relationships) {
            if (relationship == null || relationship.getStatus() == InstanceStatus.DELETED || limitResultsByStatus != null && (limitResultsByStatus == null || limitResultsByStatus.isEmpty() || !limitResultsByStatus.contains(relationship.getStatus())) || relationshipTypeGUID != null && !relationshipTypeGUID.equals(relationship.getType().getTypeDefGUID())) continue;
            filteredRelationships.add(relationship);
        }
        if (filteredRelationships.isEmpty()) {
            return null;
        }
        return this.repositoryHelper.formatRelationshipResults(filteredRelationships, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        List entities = null;
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findEntitiesByProperty");
            super.reportUnsupportedOptionalFunction("findEntitiesByProperty");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.ENTITY_DEF, matchProperties, entityTypeGUID, null);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<EntityDetail> foundEntities = null;
        foundEntities = queryPlan.getQueryStrategy() == GraphOMRSQueryPlan.QueryStrategy.Iterate ? this.findEntitiesByPropertyIteratively(validTypeNames, matchProperties, matchCriteria) : this.graphStore.findEntitiesByPropertyForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties, matchCriteria);
        if (foundEntities != null) {
            ArrayList<EntityDetail> retainedEntities = new ArrayList<EntityDetail>();
            for (EntityDetail entity : foundEntities) {
                if (entity == null || entity.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)entity) || !this.repositoryValidator.verifyEntityIsClassified(limitResultsByClassification, (EntitySummary)entity)) continue;
                retainedEntities.add(entity);
            }
            entities = this.repositoryHelper.formatEntityResults(retainedEntities, fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return entities;
    }

    public List<EntityDetail> findEntitiesByPropertyIteratively(List<String> validTypeNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException {
        String methodName = "findEntitiesByPropertyIteratively";
        ArrayList<EntityDetail> returnEntities = null;
        for (String typeName : validTypeNames) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            List<EntityDetail> entitiesForCurrentType = this.graphStore.findEntitiesByPropertyForType(typeName, matchProperties, matchCriteria, true);
            if (entitiesForCurrentType != null && !entitiesForCurrentType.isEmpty()) {
                if (returnEntities == null) {
                    returnEntities = new ArrayList<EntityDetail>();
                }
                log.info("{}: for type {} found {} entities", new Object[]{"findEntitiesByPropertyIteratively", typeDef.getName(), entitiesForCurrentType.size()});
                returnEntities.addAll(entitiesForCurrentType);
                continue;
            }
            log.info("{}: for type {} found no entities", (Object)"findEntitiesByPropertyIteratively", (Object)typeDef.getName());
        }
        return returnEntities;
    }

    public List<EntityDetail> findEntitiesIteratively(List<String> validTypeNames, SearchProperties searchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findEntitiesIteratively";
        ArrayList<EntityDetail> returnEntities = null;
        for (String typeName : validTypeNames) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            List<EntityDetail> entitiesForCurrentType = this.graphStore.findEntitiesForType(typeName, searchProperties, true);
            if (entitiesForCurrentType != null && !entitiesForCurrentType.isEmpty()) {
                if (returnEntities == null) {
                    returnEntities = new ArrayList<EntityDetail>();
                }
                log.info("{}: for type {} found {} entities", new Object[]{"findEntitiesIteratively", typeDef.getName(), entitiesForCurrentType.size()});
                returnEntities.addAll(entitiesForCurrentType);
                continue;
            }
            log.info("{}: for type {} found no entities", (Object)"findEntitiesIteratively", (Object)typeDef.getName());
        }
        return returnEntities;
    }

    public List<Relationship> findRelationshipsForTypes(List<String> validTypeNames, SearchProperties searchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String methodName = "findRelationshipsForTypes";
        ArrayList<Relationship> returnRelationships = null;
        for (String typeName : validTypeNames) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            List<Relationship> relationshipsForCurrentType = this.graphStore.findRelationshipsForType(typeName, searchProperties, true);
            if (relationshipsForCurrentType != null && !relationshipsForCurrentType.isEmpty()) {
                if (returnRelationships == null) {
                    returnRelationships = new ArrayList<Relationship>();
                }
                log.info("{}: for type {} found {} relationships", new Object[]{"findRelationshipsForTypes", typeDef.getName(), relationshipsForCurrentType.size()});
                returnRelationships.addAll(relationshipsForCurrentType);
                continue;
            }
            log.info("{}: for type {} found no relationships", (Object)"findRelationshipsForTypes", (Object)typeDef.getName());
        }
        return returnRelationships;
    }

    public List<Relationship> findRelationshipsByPropertyIteratively(List<String> validTypeNames, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findRelationshipsByPropertyIteratively";
        ArrayList<Relationship> returnRelationships = null;
        for (String typeName : validTypeNames) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            List<Relationship> relationshipsForCurrentType = this.graphStore.findRelationshipsByPropertyForType(typeName, matchProperties, matchCriteria, true);
            if (relationshipsForCurrentType != null && !relationshipsForCurrentType.isEmpty()) {
                if (returnRelationships == null) {
                    returnRelationships = new ArrayList<Relationship>();
                }
                log.info("{}: for type {} found {} relationships", new Object[]{"findRelationshipsByPropertyIteratively", typeDef.getName(), relationshipsForCurrentType.size()});
                returnRelationships.addAll(relationshipsForCurrentType);
                continue;
            }
            log.info("{}: for type {} found no relationships", (Object)"findRelationshipsByPropertyIteratively", (Object)typeDef.getName());
        }
        return returnRelationships;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        String guidParameterName = "relationshipTypeGUID";
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.validateTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "findRelationshipsByProperty");
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findRelationshipsByProperty");
            super.reportUnsupportedOptionalFunction("findRelationshipsByProperty");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.RELATIONSHIP_DEF, matchProperties, relationshipTypeGUID, null);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<Relationship> foundRelationships = null;
        foundRelationships = queryPlan.getQueryStrategy() == GraphOMRSQueryPlan.QueryStrategy.Iterate ? this.findRelationshipsByPropertyIteratively(validTypeNames, matchProperties, matchCriteria) : this.graphStore.findRelationshipsByPropertyForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties, matchCriteria);
        List relationships = null;
        if (foundRelationships != null) {
            ArrayList<Relationship> retainedRelationships = new ArrayList<Relationship>();
            for (Relationship relationship : foundRelationships) {
                if (relationship == null || relationship.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)relationship)) continue;
                retainedRelationships.add(relationship);
            }
            relationships = this.repositoryHelper.formatRelationshipResults(retainedRelationships, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return relationships;
    }

    public void validateTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws TypeErrorException {
        TypeDef typeDef;
        if (guid != null && (typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, guidParameterName, guid, methodName)) == null) {
            throw new TypeErrorException(OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN.getMessageDefinition(new String[]{guid, guidParameterName, methodName, sourceName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        List entities = null;
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findEntitiesByPropertyValue");
            super.reportUnsupportedOptionalFunction("findEntitiesByPropertyValue");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.ENTITY_DEF, entityTypeGUID, null);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<EntityDetail> foundEntities = null;
        foundEntities = this.findEntitiesByPropertyValueForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, searchCriteria);
        if (foundEntities != null) {
            ArrayList<EntityDetail> retainedEntities = new ArrayList<EntityDetail>();
            for (EntityDetail entity : foundEntities) {
                if (entity == null || entity.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)entity) || !this.repositoryValidator.verifyEntityIsClassified(limitResultsByClassification, (EntitySummary)entity)) continue;
                retainedEntities.add(entity);
            }
            entities = this.repositoryHelper.formatEntityResults(retainedEntities, fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return entities;
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findRelationshipsByPropertyValue");
            super.reportUnsupportedOptionalFunction("findRelationshipsByPropertyValue");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.RELATIONSHIP_DEF, relationshipTypeGUID, null);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<Relationship> foundRelationships = this.findRelationshipsByPropertyValueForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, searchCriteria);
        List relationships = null;
        if (foundRelationships != null) {
            ArrayList<Relationship> retainedRelationships = new ArrayList<Relationship>();
            for (Relationship relationship : foundRelationships) {
                if (relationship == null || relationship.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)relationship)) continue;
                retainedRelationships.add(relationship);
            }
            relationships = this.repositoryHelper.formatRelationshipResults(retainedRelationships, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return relationships;
    }

    public List<EntityDetail> findEntitiesByPropertyValueForTypes(List<String> validTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, String searchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findEntitiesByPropertyValue";
        InstanceProperties matchProperties = this.graphStore.constructMatchPropertiesForSearchCriteriaForTypes(TypeDefCategory.ENTITY_DEF, searchCriteria, filterTypeName, validTypeNames);
        List<EntityDetail> matchingEntities = this.graphStore.findEntitiesByPropertyValueForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties, MatchCriteria.ANY);
        return matchingEntities;
    }

    public List<Relationship> findRelationshipsByPropertyValueForTypes(List<String> validTypeNames, String filterTypeName, Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute, Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames, String searchCriteria) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValueIteratively";
        InstanceProperties matchProperties = this.graphStore.constructMatchPropertiesForSearchCriteriaForTypes(TypeDefCategory.RELATIONSHIP_DEF, searchCriteria, filterTypeName, validTypeNames);
        List<Relationship> matchingRelationships = this.graphStore.findRelationshipsByPropertyValueForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties, MatchCriteria.ANY);
        return matchingRelationships;
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        String methodName = "findEntities";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        List entities = null;
        super.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findEntities");
            super.reportUnsupportedOptionalFunction("findEntities");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.ENTITY_DEF, matchProperties, entityTypeGUID, entitySubtypeGUIDs);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<EntityDetail> foundEntities = null;
        foundEntities = queryPlan.getQueryStrategy() == GraphOMRSQueryPlan.QueryStrategy.Iterate ? this.findEntitiesIteratively(validTypeNames, matchProperties, MatchCriteria.ANY) : this.graphStore.findEntitiesForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties);
        if (foundEntities != null) {
            ArrayList<EntityDetail> retainedEntities = new ArrayList<EntityDetail>();
            for (EntityDetail entity : foundEntities) {
                if (entity == null || entity.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)entity) || !this.repositoryValidator.verifyMatchingClassifications(matchClassifications, (EntitySummary)entity)) continue;
                retainedEntities.add(entity);
            }
            entities = this.repositoryHelper.formatEntityResults(retainedEntities, fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return entities;
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        String methodName = "findRelationships";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        super.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findRelationships");
            super.reportUnsupportedOptionalFunction("findRelationships");
        }
        GraphOMRSQueryPlan queryPlan = new GraphOMRSQueryPlan(this.repositoryName, this.metadataCollectionId, this.repositoryHelper, TypeDefCategory.RELATIONSHIP_DEF, matchProperties, relationshipTypeGUID, relationshipSubtypeGUIDs);
        Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute = queryPlan.getQualifiedPropertyNameToTypeDefinedAttribute();
        Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames = queryPlan.getShortPropertyNameToQualifiedPropertyNames();
        List<String> validTypeNames = queryPlan.getValidTypeNames();
        String filterTypeName = queryPlan.getFilterTypeName();
        if (validTypeNames.isEmpty()) {
            return null;
        }
        List<Relationship> foundRelationships = null;
        foundRelationships = queryPlan.getQueryStrategy() == GraphOMRSQueryPlan.QueryStrategy.Iterate ? this.findRelationshipsForTypes(validTypeNames, matchProperties, MatchCriteria.ANY) : this.graphStore.findRelationshipsForTypes(validTypeNames, filterTypeName, qualifiedPropertyNameToTypeDefinedAttribute, shortPropertyNameToQualifiedPropertyNames, matchProperties);
        List relationships = null;
        if (foundRelationships != null) {
            ArrayList<Relationship> retainedRelationships = new ArrayList<Relationship>();
            for (Relationship relationship : foundRelationships) {
                if (relationship == null || relationship.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)relationship)) continue;
                retainedRelationships.add(relationship);
            }
            relationships = this.repositoryHelper.formatRelationshipResults(retainedRelationships, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return relationships;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException {
        Classification newClassification;
        EntityDetail entity;
        String methodName = "classifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} not found or only a proxy", (Object)"classifyEntity", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "classifyEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity", e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"classifyEntity", (Object)entityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        InstanceType entityType = entity.getType();
        this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity");
        try {
            this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity");
            newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), ClassificationOrigin.ASSIGNED, null, classificationProperties);
        }
        catch (PropertyErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", error);
        }
        EntityDetail updatedEntity = this.repositoryHelper.addClassificationToEntity(this.repositoryName, entity, newClassification, "classifyEntity");
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        Classification newClassification;
        EntityDetail entity;
        String methodName = "classifyEntity (detailed)";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity (detailed)");
        this.parentConnector.validateRepositoryIsActive("classifyEntity (detailed)");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity (detailed)");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity (detailed)");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} not found or only a proxy", (Object)"classifyEntity (detailed)", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "classifyEntity (detailed)", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed)", e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"classifyEntity (detailed)", (Object)entityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity (detailed)");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity (detailed)");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        InstanceType entityType = entity.getType();
        this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity (detailed)");
        try {
            this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity (detailed)");
            if (externalSourceGUID == null) {
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
            } else {
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
                newClassification.setMetadataCollectionName(externalSourceName);
                newClassification.setReplicatedBy(this.metadataCollectionId);
            }
        }
        catch (PropertyErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed)", error);
        }
        EntityDetail updatedEntity = this.repositoryHelper.addClassificationToEntity(this.repositoryName, entity, newClassification, "classifyEntity (detailed)");
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "declassifyEntity";
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} not found or only a proxy", (Object)"declassifyEntity", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(new String[]{"declassifyEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "declassifyEntity", e);
        }
        catch (RepositoryErrorException e) {
            log.error("{} repository exception during retrieval of entity wth GUID {}", (Object)"declassifyEntity", (Object)entityGUID);
            throw e;
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "declassifyEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "declassifyEntity");
        EntityDetail updatedEntity = this.repositoryHelper.deleteClassificationFromEntity(this.repositoryName, entity, classificationName, "declassifyEntity");
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, FunctionNotSupportedException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        List<EntityDetail> entitiesWithClassification;
        String methodName = "findEntitiesByClassification";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"findEntitiesByClassification");
            super.reportUnsupportedOptionalFunction("findEntitiesByClassification");
        }
        String filterTypeName = null;
        if (entityTypeGUID != null) {
            TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByClassification");
            filterTypeName = typeDef.getName();
        }
        TypeDefGallery activeTypes = this.repositoryHelper.getActiveTypeDefGallery();
        ArrayList allTypeDefs = activeTypes.getTypeDefs();
        ArrayList<String> validTypeNames = new ArrayList<String>();
        if (filterTypeName != null) {
            for (TypeDef typeDef : allTypeDefs) {
                Object actualTypeName;
                boolean typeMatch;
                if (typeDef.getCategory() != TypeDefCategory.ENTITY_DEF || !(typeMatch = this.repositoryHelper.isTypeOf(this.metadataCollectionId, (String)(actualTypeName = typeDef.getName()), filterTypeName))) continue;
                validTypeNames.add((String)actualTypeName);
            }
            if (validTypeNames.isEmpty()) {
                return null;
            }
        }
        if ((entitiesWithClassification = this.graphStore.findEntitiesByClassification(classificationName, matchClassificationProperties, matchCriteria, filterTypeName != null, validTypeNames)) == null || entitiesWithClassification.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> retainedEntities = null;
        for (EntityDetail entity : entitiesWithClassification) {
            if (entity == null) continue;
            boolean retainEntity = true;
            if (entity.getStatus() == InstanceStatus.DELETED || !this.repositoryValidator.verifyInstanceHasRightStatus(limitResultsByStatus, (InstanceHeader)entity)) {
                retainEntity = false;
            }
            if (!retainEntity) continue;
            if (retainedEntities == null) {
                retainedEntities = new ArrayList<EntityDetail>();
            }
            retainedEntities.add(entity);
        }
        List returnEntities = null;
        if (retainedEntities == null) {
            log.info("{}: found no entities", (Object)"findEntitiesByClassification");
        } else {
            log.info("{}: found {} entities", (Object)"findEntitiesByClassification", (Object)retainedEntities.size());
            returnEntities = this.repositoryHelper.formatEntityResults((List)retainedEntities, fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return returnEntities;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        super.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        EntityDetail entityDetail = null;
        try {
            entityDetail = this.graphStore.getEntityDetailFromStore(obsoleteEntityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, obsoleteEntityGUID, entityDetail, "deleteEntity");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"deleteEntity", (Object)obsoleteEntityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{obsoleteEntityGUID, "deleteEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "deleteEntity", (Throwable)e);
        }
        catch (EntityNotKnownException e) {
            log.error("{} entity wth GUID {} not found", (Object)"deleteEntity", (Object)obsoleteEntityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{obsoleteEntityGUID, "deleteEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "deleteEntity", (Throwable)e);
        }
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entityDetail, "deleteEntity");
        this.repositoryValidator.validateInstanceStatusForDelete(this.repositoryName, (InstanceHeader)entityDetail, "deleteEntity");
        try {
            List<Relationship> relationships = this.getRelationshipsForEntity(userId, obsoleteEntityGUID, null, 0, null, null, null, null, 10000);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    InstanceType type;
                    if (relationship == null || (type = relationship.getType()) == null) continue;
                    this.deleteRelationship(userId, type.getTypeDefGUID(), type.getTypeDefName(), relationship.getGUID());
                }
            }
        }
        catch (Throwable error) {
            log.error("{} entity wth GUID {} caused throwable", new Object[]{"deleteEntity", obsoleteEntityGUID, error});
        }
        EntityDetail updatedEntity = new EntityDetail(entityDetail);
        updatedEntity.setStatusOnDelete(entityDetail.getStatus());
        updatedEntity.setStatus(InstanceStatus.DELETED);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entityDetail, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        try {
            entity = this.graphStore.getEntityDetailFromStore(deletedEntityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "restoreEntity");
            this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "restoreEntity");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"restoreEntity", (Object)deletedEntityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{deletedEntityGUID, "restoreEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "restoreEntity", (Throwable)e);
        }
        EntityDetail restoredEntity = new EntityDetail(entity);
        restoredEntity.setStatus(entity.getStatusOnDelete());
        restoredEntity.setStatusOnDelete(null);
        restoredEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, restoredEntity);
        this.graphStore.updateEntityInStore(restoredEntity);
        return restoredEntity;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship relationship = this.getRelationship(userId, obsoleteRelationshipGUID);
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "deleteRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatusOnDelete(relationship.getStatus());
        updatedRelationship.setStatus(InstanceStatus.DELETED);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.updateRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        Relationship relationship = this.graphStore.getRelationshipFromStore(deletedRelationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "restoreRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "restoreRelationship");
        Relationship restoredRelationship = new Relationship(relationship);
        restoredRelationship.setStatus(relationship.getStatusOnDelete());
        relationship.setStatusOnDelete(null);
        restoredRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, restoredRelationship);
        this.graphStore.updateRelationshipInStore(restoredRelationship);
        return restoredRelationship;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        EntityDetail entity = null;
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reIdentifyEntity");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"reIdentifyEntity", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "reIdentifyEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "reIdentifyEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reIdentifyEntity");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setGUID(newEntityGUID);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.removeEntityFromStore(entityGUID);
        this.graphStore.createEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reHomeEntity");
            this.repositoryValidator.validateEntityCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reHomeEntity");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"reHomeEntity", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "reHomeEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "reHomeEntity", (Throwable)e);
        }
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setMetadataCollectionId(newHomeMetadataCollectionId);
        updatedEntity.setMetadataCollectionName(newHomeMetadataCollectionName);
        updatedEntity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        EntityDetail entity = null;
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reTypeEntity");
            this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reTypeEntity");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
            this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, entity.getProperties(), "reTypeEntity");
            this.repositoryValidator.validateClassificationList(this.repositoryName, "entityGUID", entity.getClassifications(), newTypeDefSummary.getName(), "reTypeEntity");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"reTypeEntity", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "reTypeEntity", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "reTypeEntity", (Throwable)e);
        }
        EntityDetail updatedEntity = new EntityDetail(entity);
        InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
        updatedEntity.setType(newInstanceType);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(entity);
        return updatedEntity;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        super.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reIdentifyRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setGUID(newRelationshipGUID);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.removeRelationshipFromStore(relationshipGUID);
        this.graphStore.createRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reTypeRelationship");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, relationship.getProperties(), "reTypeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
        updatedRelationship.setType(newInstanceType);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.updateRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String relationshipParameterName = "relationshipGUID";
        super.reHomeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reHomeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setMetadataCollectionId(newHomeMetadataCollectionId);
        updatedRelationship.setMetadataCollectionName(newHomeMetadataCollectionName);
        updatedRelationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.graphStore.updateRelationshipInStore(updatedRelationship);
        return updatedRelationship;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        super.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        EntityDetail entity = null;
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityClassification");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityClassification");
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"updateEntityClassification", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "updateEntityClassification", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", (Throwable)e);
        }
        Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "updateEntityClassification");
        Classification newClassification = new Classification(classification);
        newClassification.setProperties(properties);
        this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)classification, newClassification);
        EntityDetail updatedEntity = this.repositoryHelper.updateClassificationInEntity(this.repositoryName, userId, entity, newClassification, "updateEntityClassification");
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.graphStore.updateEntityInStore(updatedEntity);
        return updatedEntity;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "saveEntityReferenceCopy");
        this.graphStore.saveEntityReferenceCopyToStore(entity);
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        List retrievedClassifications;
        String methodName = "getHomeClassifications";
        this.validateRepositoryConnector("getHomeClassifications");
        this.parentConnector.validateRepositoryIsActive("getHomeClassifications");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.debug("{} entity wth GUID {} not known or only a proxy", (Object)"getHomeClassifications", (Object)entityGUID);
        }
        ArrayList<Classification> homeClassifications = new ArrayList<Classification>();
        if (retrievedEntity != null && (retrievedClassifications = retrievedEntity.getClassifications()) != null) {
            for (Classification retrievedClassification : retrievedClassifications) {
                if (retrievedClassification == null || !this.metadataCollectionId.equals(retrievedClassification.getMetadataCollectionId())) continue;
                homeClassifications.add(retrievedClassification);
            }
        }
        if (homeClassifications.isEmpty()) {
            return null;
        }
        return homeClassifications;
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        EntityDetail entity = null;
        try {
            entity = this.graphStore.getEntityDetailFromStore(entityGUID);
        }
        catch (EntityProxyOnlyException e) {
            log.warn("{} entity wth GUID {} only a proxy", (Object)"purgeEntityReferenceCopy", (Object)entityGUID);
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, "purgeEntityReferenceCopy", this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "purgeEntityReferenceCopy", (Throwable)e);
        }
        if (entity != null) {
            this.graphStore.removeEntityFromStore(entityGUID);
        } else {
            super.reportEntityNotKnown(entityGUID, "purgeEntityReferenceCopy");
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy";
        String classificationParameterName = "classification";
        String propertiesParameterName = "classification.getProperties()";
        this.validateRepositoryConnector("saveClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveClassificationReferenceCopy");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.graphStore.getEntityDetailFromStore(entity.getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.debug("{} entity wth GUID {} not known or only a proxy", (Object)"saveClassificationReferenceCopy", (Object)entity.getGUID());
        }
        if (retrievedEntity == null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            retrievedEntity = entity;
        }
        if (retrievedEntity != null) {
            try {
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, entity.getGUID(), retrievedEntity, "saveClassificationReferenceCopy");
                this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)retrievedEntity, "saveClassificationReferenceCopy");
                this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
                InstanceType entityType = entity.getType();
                this.repositoryValidator.validateClassification(this.repositoryName, "classification", classification.getName(), entityType.getTypeDefName(), "saveClassificationReferenceCopy");
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classification.getName(), "classification.getProperties()", classification.getProperties(), "saveClassificationReferenceCopy");
                EntityDetail updatedEntity = this.repositoryHelper.addClassificationToEntity(this.repositoryName, retrievedEntity, classification, "saveClassificationReferenceCopy");
                if (this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                    updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)retrievedEntity, updatedEntity);
                    this.graphStore.updateEntityInStore(updatedEntity);
                } else {
                    this.graphStore.saveEntityReferenceCopyToStore(entity);
                }
            }
            catch (EntityNotKnownException entityType) {
            }
            catch (ClassificationErrorException error) {
                throw new TypeErrorException((OMRSCheckedExceptionBase)error);
            }
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy";
        this.validateRepositoryConnector("purgeClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("purgeClassificationReferenceCopy");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.graphStore.getEntityDetailFromStore(entity.getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.debug("{} entity wth GUID {} not known or only a proxy", (Object)"purgeClassificationReferenceCopy", (Object)entity.getGUID());
        }
        if (retrievedEntity == null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            retrievedEntity = entity;
        }
        if (retrievedEntity != null) {
            try {
                EntityDetail updatedEntity = this.repositoryHelper.deleteClassificationFromEntity(this.repositoryName, entity, classification.getName(), "purgeClassificationReferenceCopy");
                if (this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                    updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)retrievedEntity, updatedEntity);
                    this.graphStore.updateEntityInStore(updatedEntity);
                } else {
                    this.graphStore.saveEntityReferenceCopyToStore(entity);
                }
            }
            catch (ClassificationErrorException error) {
                throw new TypeErrorException((OMRSCheckedExceptionBase)error);
            }
        }
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        this.graphStore.saveRelationshipReferenceCopyToStore(relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        this.graphStore.removeRelationshipFromStore(relationshipGUID);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        String entityGUIDParameterName = "entityGUID";
        String entityTypeGUIDParameterName = "entityTypeGUIDs";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUIDs";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        String asOfTimeParameter = "asOfTime";
        this.validateRepositoryConnector("getEntityNeighborhood");
        this.parentConnector.validateRepositoryIsActive("getEntityNeighborhood");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityNeighborhood");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getEntityNeighborhood");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getEntityNeighborhood");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.validateTypeGUID(this.repositoryName, "entityTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (relationshipTypeGUIDs != null) {
            for (String guid : relationshipTypeGUIDs) {
                this.validateTypeGUID(this.repositoryName, "relationshipTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getEntityNeighborhood");
            }
        }
        if (asOfTime != null) {
            log.error("{} does not support asOfTime parameter", (Object)"getEntityNeighborhood");
            super.reportUnsupportedOptionalFunction("getEntityNeighborhood");
        }
        return this.graphStore.getSubGraph(entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, level);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        InstanceGraph adjacentGraph;
        String methodName = "getRelatedEntities";
        this.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"getRelatedEntities");
            super.reportUnsupportedOptionalFunction("getRelatedEntities");
        }
        if ((adjacentGraph = this.getEntityNeighborhood(userId, startEntityGUID, entityTypeGUIDs, null, limitResultsByStatus, limitResultsByClassification, null, -1)) != null) {
            List adjacentEntities = adjacentGraph.getEntities();
            return this.repositoryHelper.formatEntityResults(adjacentEntities, fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return null;
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        if (asOfTime != null) {
            log.error("{} does not support asOfTime searches", (Object)"getLinkingEntities");
            super.reportUnsupportedOptionalFunction("getLinkingEntities");
        }
        int maxPaths = 20;
        int maxDepth = 40;
        try {
            return this.graphStore.getPaths(startEntityGUID, endEntityGUID, limitResultsByStatus, maxPaths, maxDepth);
        }
        catch (Exception e) {
            throw new RepositoryErrorException(GraphOMRSErrorCode.CONNECTED_ENTITIES_FAILURE.getMessageDefinition(startEntityGUID, endEntityGUID, "getLinkingEntities", ((Object)((Object)this)).getClass().getName(), this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getLinkingEntities");
        }
    }
}

