/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSMapperUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSMapperUtils.class);

    public InstanceProvenanceType mapProvenanceOrdinalToEnum(Integer provenanceOrdinal) {
        if (provenanceOrdinal == null) {
            return null;
        }
        return switch (provenanceOrdinal) {
            case 0 -> InstanceProvenanceType.UNKNOWN;
            case 1 -> InstanceProvenanceType.LOCAL_COHORT;
            case 2 -> InstanceProvenanceType.EXPORT_ARCHIVE;
            case 3 -> InstanceProvenanceType.CONTENT_PACK;
            case 4 -> InstanceProvenanceType.DEREGISTERED_REPOSITORY;
            case 5 -> InstanceProvenanceType.CONFIGURATION;
            case 6 -> InstanceProvenanceType.EXTERNAL_SOURCE;
            default -> InstanceProvenanceType.UNKNOWN;
        };
    }

    public InstanceStatus mapStatusOrdinalToEnum(Integer statusOrdinal) {
        if (statusOrdinal == null) {
            return null;
        }
        return switch (statusOrdinal) {
            case 0 -> InstanceStatus.UNKNOWN;
            case 1 -> InstanceStatus.DRAFT;
            case 2 -> InstanceStatus.PREPARED;
            case 3 -> InstanceStatus.PROPOSED;
            case 4 -> InstanceStatus.APPROVED;
            case 5 -> InstanceStatus.REJECTED;
            case 6 -> InstanceStatus.APPROVED_CONCEPT;
            case 7 -> InstanceStatus.UNDER_DEVELOPMENT;
            case 8 -> InstanceStatus.DEVELOPMENT_COMPLETE;
            case 9 -> InstanceStatus.APPROVED_FOR_DEPLOYMENT;
            case 10 -> InstanceStatus.STANDBY;
            case 15 -> InstanceStatus.ACTIVE;
            case 20 -> InstanceStatus.FAILED;
            case 21 -> InstanceStatus.DISABLED;
            case 22 -> InstanceStatus.COMPLETE;
            case 30 -> InstanceStatus.DEPRECATED;
            case 50 -> InstanceStatus.OTHER;
            case 99 -> InstanceStatus.DELETED;
            default -> InstanceStatus.UNKNOWN;
        };
    }

    public ClassificationOrigin mapClassificationOriginOrdinalToEnum(Integer originOrdinal) {
        if (originOrdinal == null) {
            return null;
        }
        return switch (originOrdinal) {
            case 0 -> ClassificationOrigin.ASSIGNED;
            case 1 -> ClassificationOrigin.PROPAGATED;
            default -> ClassificationOrigin.ASSIGNED;
        };
    }

    public Map<String, String> getQualifiedPropertyNamesForTypeDef(TypeDef typeDef, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        String QUALIFIED_PROPERTY_SEPARATOR = "x";
        HashMap<String, String> qualifiedPropertyNames = new HashMap<String, String>();
        if (typeDef != null) {
            List propertiesDefinition = typeDef.getPropertiesDefinition();
            if (propertiesDefinition != null) {
                for (TypeDefAttribute tda : propertiesDefinition) {
                    String propName = tda.getAttributeName();
                    String qualifiedName = typeDef.getName() + "x" + propName;
                    qualifiedPropertyNames.put(propName, qualifiedName);
                }
            }
            TypeDefLink superTypeLink = typeDef.getSuperType();
            while (superTypeLink != null) {
                String superTypeName = superTypeLink.getName();
                TypeDef superTypeDef = repositoryHelper.getTypeDefByName(repositoryName, superTypeName);
                List superTypePropertiesDefinition = superTypeDef.getPropertiesDefinition();
                if (superTypePropertiesDefinition != null) {
                    for (TypeDefAttribute tda : superTypePropertiesDefinition) {
                        String propName = tda.getAttributeName();
                        String qualifiedName = superTypeName + "x" + propName;
                        qualifiedPropertyNames.put(propName, qualifiedName);
                    }
                }
                superTypeLink = superTypeDef.getSuperType();
            }
        }
        return qualifiedPropertyNames;
    }

    Map<String, TypeDefAttribute> getUniquePropertyDefsForTypeDef(String sourceName, TypeDef typeDef, OMRSRepositoryHelper repositoryHelper) {
        HashMap<String, TypeDefAttribute> uniquePropertyDefsForType = new HashMap<String, TypeDefAttribute>();
        List propertiesDefinition = typeDef.getPropertiesDefinition();
        if (propertiesDefinition != null) {
            for (TypeDefAttribute propDef : propertiesDefinition) {
                uniquePropertyDefsForType.put(propDef.getAttributeName(), propDef);
            }
        }
        TypeDefLink superTypeLink = typeDef.getSuperType();
        while (superTypeLink != null) {
            TypeDef superTypeDef = repositoryHelper.getTypeDefByName(sourceName, superTypeLink.getName());
            if (superTypeDef != null) {
                List superTypePropertiesDefinition = superTypeDef.getPropertiesDefinition();
                if (superTypePropertiesDefinition != null) {
                    for (TypeDefAttribute propDef : superTypePropertiesDefinition) {
                        uniquePropertyDefsForType.put(propDef.getAttributeName(), propDef);
                    }
                }
                superTypeLink = superTypeDef.getSuperType();
                continue;
            }
            superTypeLink = null;
        }
        return uniquePropertyDefsForType;
    }
}

