/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMapperUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSQueryPlan {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSQueryPlan.class);
    private QueryStrategy queryStrategy;
    private Map<String, TypeDefAttribute> qualifiedPropertyNameToTypeDefinedAttribute;
    private Map<String, List<String>> shortPropertyNameToQualifiedPropertyNames;
    private List<String> validTypeNames;
    private String filterTypeName;

    public GraphOMRSQueryPlan() {
    }

    public GraphOMRSQueryPlan(String repositoryName, String metadataCollectionId, OMRSRepositoryHelper repositoryHelper, TypeDefCategory typeDefCategory, InstanceProperties matchProperties, String filterTypeGUID, List<String> subTypeGUIDs) throws InvalidParameterException, TypeErrorException {
        List<String> queryPropertyNames = this.extractPropertyNamesFromMatchProperties(matchProperties);
        this.generateQueryPlan(repositoryName, metadataCollectionId, repositoryHelper, typeDefCategory, queryPropertyNames, filterTypeGUID, subTypeGUIDs);
    }

    public GraphOMRSQueryPlan(String repositoryName, String metadataCollectionId, OMRSRepositoryHelper repositoryHelper, TypeDefCategory typeDefCategory, SearchProperties searchProperties, String filterTypeGUID, List<String> subTypeGUIDs) throws InvalidParameterException, TypeErrorException {
        List<String> queryPropertyNames = this.extractPropertyNamesFromSearchProperties(searchProperties, repositoryName);
        this.generateQueryPlan(repositoryName, metadataCollectionId, repositoryHelper, typeDefCategory, queryPropertyNames, filterTypeGUID, subTypeGUIDs);
    }

    public GraphOMRSQueryPlan(String repositoryName, String metadataCollectionId, OMRSRepositoryHelper repositoryHelper, TypeDefCategory typeDefCategory, String filterTypeGUID, List<String> subTypeGUIDs) throws InvalidParameterException, TypeErrorException {
        this.generateQueryPlan(repositoryName, metadataCollectionId, repositoryHelper, typeDefCategory, null, filterTypeGUID, subTypeGUIDs);
    }

    public QueryStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public Map<String, TypeDefAttribute> getQualifiedPropertyNameToTypeDefinedAttribute() {
        return this.qualifiedPropertyNameToTypeDefinedAttribute;
    }

    public Map<String, List<String>> getShortPropertyNameToQualifiedPropertyNames() {
        return this.shortPropertyNameToQualifiedPropertyNames;
    }

    public List<String> getValidTypeNames() {
        return this.validTypeNames;
    }

    public String getFilterTypeName() {
        return this.filterTypeName;
    }

    private void generateQueryPlan(String repositoryName, String metadataCollectionId, OMRSRepositoryHelper repositoryHelper, TypeDefCategory typeDefCategory, List<String> queryPropertyNames, String filterTypeGUID, List<String> subTypeGUIDs) throws TypeErrorException {
        String methodName = "createQueryPlan";
        String filterTypeGUIDParameterName = "filterTypeGUID";
        this.qualifiedPropertyNameToTypeDefinedAttribute = new HashMap<String, TypeDefAttribute>();
        this.shortPropertyNameToQualifiedPropertyNames = new HashMap<String, List<String>>();
        this.filterTypeName = null;
        this.validTypeNames = new ArrayList<String>();
        if (filterTypeGUID != null) {
            TypeDef typeDef = repositoryHelper.getTypeDef(repositoryName, "filterTypeGUID", filterTypeGUID, "createQueryPlan");
            this.filterTypeName = typeDef.getName();
        }
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        TypeDefGallery activeTypes = repositoryHelper.getActiveTypeDefGallery();
        ArrayList allTypeDefs = activeTypes.getTypeDefs();
        boolean dups = false;
        for (TypeDef typeDef : allTypeDefs) {
            Map<String, TypeDefAttribute> propertyDefs;
            Map<String, String> qualifiedPropertyNames;
            if (typeDef.getCategory() != typeDefCategory) continue;
            String typeName = typeDef.getName();
            if (this.filterTypeName != null && !repositoryHelper.isTypeOf(metadataCollectionId, typeName, this.filterTypeName)) continue;
            String typeGUID = typeDef.getGUID();
            if (this.filterTypeName != null && !this.filterTypeName.equals(typeName) && subTypeGUIDs != null && !subTypeGUIDs.contains(typeGUID)) continue;
            this.validTypeNames.add(typeName);
            if (this.filterTypeName != null && this.filterTypeName.equals(typeName)) {
                qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, repositoryName, repositoryHelper);
                Set<String> uniquePropertyNames = qualifiedPropertyNames.keySet();
                propertyDefs = mapperUtils.getUniquePropertyDefsForTypeDef(repositoryName, typeDef, repositoryHelper);
                for (String shortName : uniquePropertyNames) {
                    if (queryPropertyNames != null && !queryPropertyNames.contains(shortName)) continue;
                    TypeDefAttribute tda = propertyDefs.get(shortName);
                    String qualifiedName = qualifiedPropertyNames.get(shortName);
                    this.qualifiedPropertyNameToTypeDefinedAttribute.put(qualifiedName, tda);
                    List<String> qNameList = this.shortPropertyNameToQualifiedPropertyNames.get(shortName);
                    if (qNameList == null) {
                        qNameList = new ArrayList<String>();
                        this.shortPropertyNameToQualifiedPropertyNames.put(shortName, qNameList);
                    } else {
                        dups = true;
                    }
                    qNameList.add(qualifiedName);
                }
                continue;
            }
            qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, repositoryName, repositoryHelper);
            propertyDefs = mapperUtils.getUniquePropertyDefsForTypeDef(repositoryName, typeDef, repositoryHelper);
            List localPropertiesDef = typeDef.getPropertiesDefinition();
            if (localPropertiesDef == null) continue;
            for (TypeDefAttribute tda : localPropertiesDef) {
                String shortName = tda.getAttributeName();
                if (queryPropertyNames != null && !queryPropertyNames.contains(shortName)) continue;
                TypeDefAttribute propertyDef = propertyDefs.get(shortName);
                String qualifiedName = qualifiedPropertyNames.get(shortName);
                this.qualifiedPropertyNameToTypeDefinedAttribute.put(qualifiedName, propertyDef);
                List<String> qNameList = this.shortPropertyNameToQualifiedPropertyNames.get(shortName);
                if (qNameList == null) {
                    qNameList = new ArrayList<String>();
                    this.shortPropertyNameToQualifiedPropertyNames.put(shortName, qNameList);
                    qNameList.add(qualifiedName);
                    continue;
                }
                if (qNameList.contains(qualifiedName)) continue;
                qNameList.add(qualifiedName);
                dups = true;
            }
        }
        this.queryStrategy = dups ? QueryStrategy.Iterate : QueryStrategy.Delegate;
    }

    boolean validatePropertyCondition(PropertyCondition condition, String repositoryName) throws InvalidParameterException {
        boolean localCondition;
        String methodName = "validatePropertyCondition";
        String propertyName = condition.getProperty();
        PropertyComparisonOperator operator = condition.getOperator();
        InstancePropertyValue value = condition.getValue();
        SearchProperties nestedConditions = condition.getNestedConditions();
        if (propertyName != null && operator != null && value != null && nestedConditions == null) {
            localCondition = true;
        } else if (propertyName == null && operator == null && value == null && nestedConditions != null) {
            localCondition = false;
        } else {
            throw new InvalidParameterException(GraphOMRSErrorCode.INVALID_PROPERTY_CONDITION.getMessageDefinition("validatePropertyCondition", this.getClass().getName(), repositoryName), this.getClass().getName(), "validatePropertyCondition", "searchProperties");
        }
        return localCondition;
    }

    List<String> extractPropertyNamesFromSearchProperties(SearchProperties searchProperties, String repositoryName) throws InvalidParameterException {
        ArrayList<String> propertyNames = null;
        if (searchProperties != null) {
            propertyNames = new ArrayList<String>();
            List conditions = searchProperties.getConditions();
            for (PropertyCondition condition : conditions) {
                boolean localCondition = this.validatePropertyCondition(condition, repositoryName);
                if (localCondition) {
                    String propertyName = condition.getProperty();
                    if (propertyName == null) continue;
                    propertyNames.add(propertyName);
                    continue;
                }
                SearchProperties nestedConditions = condition.getNestedConditions();
                List<String> moreProperties = this.extractPropertyNamesFromSearchProperties(nestedConditions, repositoryName);
                if (moreProperties == null || moreProperties.isEmpty()) continue;
                propertyNames.addAll(moreProperties);
            }
            if (propertyNames.isEmpty()) {
                propertyNames = null;
            }
        }
        return propertyNames;
    }

    List<String> extractPropertyNamesFromMatchProperties(InstanceProperties matchProperties) {
        ArrayList propertyNames = null;
        if (matchProperties != null) {
            Set propertyKeys;
            propertyNames = new ArrayList();
            Map propertyMap = matchProperties.getInstanceProperties();
            if (propertyMap != null && !(propertyKeys = propertyMap.keySet()).isEmpty()) {
                propertyNames.addAll(propertyKeys);
            }
            if (propertyNames.isEmpty()) {
                propertyNames = null;
            }
        }
        return propertyNames;
    }

    public static enum QueryStrategy {
        Iterate,
        Delegate;

    }
}

