/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSConstants;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSMapperUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOMRSClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(GraphOMRSClassificationMapper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private final String metadataCollectionId;
    private final String repositoryName;
    private final OMRSRepositoryHelper repositoryHelper;

    public GraphOMRSClassificationMapper(String metadataCollectionId, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
    }

    private Object getVertexProperty(Vertex vertex, String propName) {
        VertexProperty vp = vertex.property(propName);
        if (vp == null || !vp.isPresent()) {
            return null;
        }
        return vp.value();
    }

    private void addProperty(Vertex vertex, String propertyName, String qualifiedPropName, InstancePropertyValue ipv) {
        InstancePropertyCategory ipvCat = ipv.getInstancePropertyCategory();
        if (ipvCat == InstancePropertyCategory.PRIMITIVE) {
            PrimitivePropertyValue ppv = (PrimitivePropertyValue)ipv;
            Object primValue = ppv.getPrimitiveValue();
            if (primValue != null) {
                vertex.property(GraphOMRSConstants.getPropertyKeyClassification(qualifiedPropName), primValue);
            } else {
                this.removeProperty(vertex, qualifiedPropName);
            }
        } else {
            log.debug("non-primitive instance property {}", (Object)propertyName);
        }
    }

    private void removeProperty(Vertex vertex, String qualifiedPropName) {
        VertexProperty vp = vertex.property(GraphOMRSConstants.getPropertyKeyClassification(qualifiedPropName));
        if (vp != null) {
            vp.remove();
        }
    }

    public void mapClassificationToVertex(Classification classification, Vertex vertex) throws RepositoryErrorException {
        String methodName = "mapClassificationToVertex";
        this.mapInstanceAuditHeaderToVertex(classification, vertex);
        InstanceProperties classificationProperties = classification.getProperties();
        if (classificationProperties != null) {
            try {
                String jsonString = OBJECT_WRITER.writeValueAsString((Object)classificationProperties);
                log.debug("{} classification has serialized properties {}", (Object)"mapClassificationToVertex", (Object)jsonString);
                vertex.property("classificationProperties", (Object)jsonString);
            }
            catch (Exception exc) {
                log.error("{} Caught exception from classification mapper", (Object)"mapClassificationToVertex");
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), "mapClassificationToVertex", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "mapClassificationToVertex", exc);
            }
            String typeName = classification.getType().getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
            Map<String, String> qualifiedPropertyNames = mapperUtils.getQualifiedPropertyNamesForTypeDef(typeDef, this.repositoryName, this.repositoryHelper);
            List propertiesDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.repositoryName, typeDef, "mapClassificationToVertex");
            for (TypeDefAttribute propertyDef : propertiesDef) {
                String propertyName = propertyDef.getAttributeName();
                String qualifiedPropName = qualifiedPropertyNames.get(propertyName);
                InstancePropertyValue ipv = classificationProperties.getPropertyValue(propertyName);
                if (ipv != null) {
                    this.addProperty(vertex, propertyName, qualifiedPropName, ipv);
                    continue;
                }
                this.removeProperty(vertex, qualifiedPropName);
            }
        }
    }

    public void mapInstanceAuditHeaderToVertex(Classification classification, Vertex vertex) throws RepositoryErrorException {
        VertexProperty vp;
        VertexProperty vp2;
        String methodName = "mapInstanceAuditHeaderToVertex";
        boolean missingAttribute = false;
        String missingAttributeName = null;
        if (classification.getName() != null) {
            vertex.property("vcclassificationName", (Object)classification.getName());
        } else {
            log.debug("{} missing attribute: guid", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "guid";
        }
        InstanceType instanceType = classification.getType();
        if (instanceType != null && instanceType.getTypeDefName() != null) {
            vertex.property("vctypeName", (Object)instanceType.getTypeDefName());
        } else {
            log.debug("{} missing attribute: type name", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "type or typeName";
        }
        if (this.metadataCollectionId != null) {
            vertex.property("vcmetadataCollectionId", (Object)this.metadataCollectionId);
        } else {
            log.debug("{} missing attribute: metadataCollectionId", (Object)methodName);
            missingAttribute = true;
            missingAttributeName = "metadataCollectionId";
        }
        if (missingAttribute) {
            log.error("{} entity is missing a core attribute {}", (Object)methodName, (Object)missingAttributeName);
            throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        vertex.property("vcversion", (Object)classification.getVersion());
        if (classification.getMetadataCollectionName() != null) {
            vertex.property("vcmetadataCollectionName", (Object)classification.getMetadataCollectionName());
        } else {
            vp2 = vertex.property("vcmetadataCollectionName");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getCreatedBy() != null) {
            vertex.property("vccreatedBy", (Object)classification.getCreatedBy());
        } else {
            vp2 = vertex.property("vccreatedBy");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getCreateTime() != null) {
            vertex.property("vccreateTime", (Object)classification.getCreateTime());
        } else {
            vp2 = vertex.property("vccreateTime");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getUpdatedBy() != null) {
            vertex.property("vcupdatedBy", (Object)classification.getUpdatedBy());
        } else {
            vp2 = vertex.property("vcupdatedBy");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getUpdateTime() != null) {
            vertex.property("vcupdateTime", (Object)classification.getUpdateTime());
        } else {
            vp2 = vertex.property("vcupdateTime");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getInstanceProvenanceType() != null) {
            vertex.property("vcinstanceProvenanceType", (Object)classification.getInstanceProvenanceType().getOrdinal());
        } else {
            vp2 = vertex.property("vcinstanceProvenanceType");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getStatus() != null) {
            vertex.property("vccurrentStatus", (Object)classification.getStatus().getOrdinal());
        } else {
            vp2 = vertex.property("vccurrentStatus");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getStatusOnDelete() != null) {
            vertex.property("vcstatusOnDelete", (Object)classification.getStatusOnDelete().getOrdinal());
        } else {
            vp2 = vertex.property("vcstatusOnDelete");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getInstanceLicense() != null) {
            vertex.property("vcinstanceLicense", (Object)classification.getInstanceLicense());
        } else {
            vp2 = vertex.property("vcinstanceLicense");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getClassificationOrigin() != null) {
            vertex.property("vcclassificationOrigin", (Object)classification.getClassificationOrigin().getOrdinal());
        } else {
            vp2 = vertex.property("vcclassificationOrigin");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        if (classification.getClassificationOriginGUID() != null) {
            vertex.property("vcclassificationOriginGUID", (Object)classification.getClassificationOriginGUID());
        } else {
            vp2 = vertex.property("vcclassificationOriginGUID");
            if (vp2 != null) {
                vp2.remove();
            }
        }
        List maintainedByList = classification.getMaintainedBy();
        if (maintainedByList != null && !maintainedByList.isEmpty()) {
            try {
                String jsonString = OBJECT_WRITER.writeValueAsString((Object)maintainedByList);
                vertex.property("vcmaintainedBy", (Object)jsonString);
            }
            catch (Exception exc) {
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        } else {
            vp = vertex.property("vcmaintainedBy");
            if (vp != null) {
                vp.remove();
            }
        }
        if (classification.getReplicatedBy() != null) {
            vertex.property("vcreplicatedBy", (Object)classification.getReplicatedBy());
        } else {
            vp = vertex.property("vcreplicatedBy");
            if (vp != null) {
                vp.remove();
            }
        }
        Map mappingProperties = classification.getMappingProperties();
        if (mappingProperties != null && !mappingProperties.isEmpty()) {
            try {
                String jsonString = OBJECT_WRITER.writeValueAsString((Object)mappingProperties);
                vertex.property("vcmappingProperties", (Object)jsonString);
            }
            catch (Exception exc) {
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        } else {
            VertexProperty vp3 = vertex.property("vcmappingProperties");
            if (vp3 != null) {
                vp3.remove();
            }
        }
    }

    public void mapVertexToClassification(Vertex vertex, Classification classification) throws RepositoryErrorException {
        String methodName = "mapVertexToClassification";
        this.mapVertexToInstanceAuditHeader(vertex, classification);
        String stringProps = (String)this.getVertexProperty(vertex, "classificationProperties");
        if (stringProps != null) {
            try {
                InstanceProperties instanceProperties = (InstanceProperties)OBJECT_READER.readValue(stringProps, InstanceProperties.class);
                log.debug("{} classification has deserialized properties {}", (Object)methodName, (Object)instanceProperties);
                classification.setProperties(instanceProperties);
            }
            catch (Exception exc) {
                log.error("{} caught exception {}", (Object)methodName, (Object)exc.getMessage());
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
    }

    public void mapVertexToInstanceAuditHeader(Vertex vertex, Classification classification) throws RepositoryErrorException {
        String methodName = "mapVertexToInstanceAuditHeader";
        classification.setName((String)this.getVertexProperty(vertex, "vcclassificationName"));
        classification.setMetadataCollectionId((String)this.getVertexProperty(vertex, "vcmetadataCollectionId"));
        classification.setMetadataCollectionName((String)this.getVertexProperty(vertex, "vcmetadataCollectionName"));
        classification.setClassificationOriginGUID((String)this.getVertexProperty(vertex, "vcclassificationOriginGUID"));
        classification.setCreatedBy((String)this.getVertexProperty(vertex, "vccreatedBy"));
        classification.setCreateTime((Date)this.getVertexProperty(vertex, "vccreateTime"));
        classification.setUpdatedBy((String)this.getVertexProperty(vertex, "vcupdatedBy"));
        classification.setUpdateTime((Date)this.getVertexProperty(vertex, "vcupdateTime"));
        classification.setVersion(((Long)this.getVertexProperty(vertex, "vcversion")).longValue());
        classification.setInstanceLicense((String)this.getVertexProperty(vertex, "vcinstanceLicense"));
        try {
            String typeName = (String)this.getVertexProperty(vertex, "vctypeName");
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeName);
            InstanceType instanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, (TypeDefSummary)typeDef);
            classification.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("{} caught exception {}", (Object)methodName, (Object)e.getMessage());
            throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        GraphOMRSMapperUtils mapperUtils = new GraphOMRSMapperUtils();
        Integer provenanceOrdinal = (Integer)this.getVertexProperty(vertex, "vcinstanceProvenanceType");
        InstanceProvenanceType instanceProvenanceType = mapperUtils.mapProvenanceOrdinalToEnum(provenanceOrdinal);
        classification.setInstanceProvenanceType(instanceProvenanceType);
        Integer statusOrdinal = (Integer)this.getVertexProperty(vertex, "vccurrentStatus");
        InstanceStatus instanceStatus = mapperUtils.mapStatusOrdinalToEnum(statusOrdinal);
        classification.setStatus(instanceStatus);
        Integer statusOnDeleteOrdinal = (Integer)this.getVertexProperty(vertex, "vcstatusOnDelete");
        InstanceStatus instanceStatusOnDelete = mapperUtils.mapStatusOrdinalToEnum(statusOnDeleteOrdinal);
        classification.setStatusOnDelete(instanceStatusOnDelete);
        Integer originOrdinal = (Integer)this.getVertexProperty(vertex, "vcclassificationOrigin");
        ClassificationOrigin classificationOrigin = mapperUtils.mapClassificationOriginOrdinalToEnum(originOrdinal);
        classification.setClassificationOrigin(classificationOrigin);
        String maintainedByString = (String)this.getVertexProperty(vertex, "vcmaintainedBy");
        if (maintainedByString != null) {
            try {
                List maintainedByList = (List)OBJECT_READER.readValue(maintainedByString, List.class);
                log.debug("{} vertex has deserialized maintainedBy list {}", (Object)methodName, (Object)maintainedByList);
                classification.setMaintainedBy(maintainedByList);
            }
            catch (Exception exc) {
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
        classification.setReplicatedBy((String)this.getVertexProperty(vertex, "vcreplicatedBy"));
        String mappingPropertiesString = (String)this.getVertexProperty(vertex, "vcmappingProperties");
        if (mappingPropertiesString != null) {
            try {
                TypeReference<Map<String, Serializable>> typeReference = new TypeReference<Map<String, Serializable>>(){};
                Map mappingPropertiesMap = (Map)OBJECT_MAPPER.readValue(mappingPropertiesString, (TypeReference)typeReference);
                log.debug("{} vertex has deserialized mappingProperties {}", (Object)methodName, (Object)mappingPropertiesMap);
                classification.setMappingProperties(mappingPropertiesMap);
            }
            catch (Exception exc) {
                throw new RepositoryErrorException(GraphOMRSErrorCode.CLASSIFICATION_PROPERTIES_ERROR.getMessageDefinition(classification.getName(), methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName, exc);
            }
        }
    }
}

