/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.http.HttpHeadersThreadLocal;

public class HttpRequestHeadersFilter
implements Filter {
    private List<String> headerNames;

    public HttpRequestHeadersFilter(List<String> headerNames) {
        this.headerNames = headerNames;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HashMap<String, String> threadLocalHeaders = new HashMap<String, String>();
        for (String headerName : this.headerNames) {
            String headerValue = req.getHeader(headerName);
            threadLocalHeaders.put(headerName, headerValue);
        }
        HttpHeadersThreadLocal.getHeadersThreadLocal().set(threadLocalHeaders);
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

