/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.http.HttpHeadersThreadLocal;

public class HttpRequestHeadersFilter
implements Filter {
    private final List<String> headerNames;

    public HttpRequestHeadersFilter(List<String> headerNames) {
        this.headerNames = headerNames == null ? new ArrayList<String>() : headerNames;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HashMap<String, String> threadLocalHeaders = new HashMap<String, String>();
        for (String headerName : this.headerNames) {
            String headerValue = req.getHeader(headerName);
            if (headerValue == null || headerValue.isEmpty()) continue;
            threadLocalHeaders.put(headerName, headerValue);
        }
        HttpHeadersThreadLocal.getHeadersThreadLocal().set(threadLocalHeaders);
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

