/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.ia.clientlibrary;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Column;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.ColumnAnalysisResults;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.DataQualityProblem;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.DataSource;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Format;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Project;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.PublishResults;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.RunColumnAnalysis;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.RunDataQualityAnalysis;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.ScheduledTask;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Schema;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Table;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.TaskExecutionReport;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.TaskExecutionSchedule;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IARestClient {
    private static final Logger log = LoggerFactory.getLogger(IARestClient.class);
    private String authorization;
    private String baseURL;
    private List<String> cookies = null;
    private RestTemplate restTemplate;
    private XmlMapper mapper;
    private DocumentBuilder xmlParser;
    private Transformer xmlTransformer;
    private static final String EP_BASE_API = "/ibm/iis/ia/api/";
    private static final String EP_PROJECT = "/ibm/iis/ia/api/project";
    private static final String EP_PROJECTS = "/ibm/iis/ia/api/projects";
    private static final String EP_COL_ANALYSIS_BASE = "/ibm/iis/ia/api/columnAnalysis/";
    private static final String EP_COL_ANALYSIS_RESULTS = "/ibm/iis/ia/api/columnAnalysis/results";
    private static final String EP_FORMAT_DISTRIBUTION = "/ibm/iis/ia/api/columnAnalysis/formatDistribution";
    private static final String EP_FREQ_DISTRIBUTION = "/ibm/iis/ia/api/columnAnalysis/frequencyDistribution";
    private static final String EP_DQ_ANALYSIS_BASE = "/ibm/iis/ia/api/dataQualityAnalysis/";
    private static final String EP_DQ_ANALYSIS_RESULTS = "/ibm/iis/ia/api/dataQualityAnalysis/results";
    private static final String EP_PUBLISHED_RESULTS = "/ibm/iis/ia/api/publishedResults";
    private static final String EP_EXECUTE_TASK = "/ibm/iis/ia/api/executeTasks";
    private static final String EP_TASK_STATUS = "/ibm/iis/ia/api/analysisStatus";
    private static final String EP_PUBLISH = "/ibm/iis/ia/api/publishResults";
    private static final String EP_LOGOUT = "/ibm/iis/ia/api/logout";

    public IARestClient(String host, String port, String user, String password) {
        this("https://" + host + ":" + port, IARestClient.encodeBasicAuth(user, password));
    }

    private IARestClient(String baseURL, String authorization) {
        this.baseURL = baseURL;
        this.authorization = authorization;
        WstxInputFactory inputFactory = new WstxInputFactory();
        WstxOutputFactory outputFactory = new WstxOutputFactory();
        XmlFactory xf = new XmlFactory((XMLInputFactory)inputFactory, (XMLOutputFactory)outputFactory);
        this.mapper = new XmlMapper(xf);
        this.mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.xmlParser = documentBuilderFactory.newDocumentBuilder();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.xmlTransformer = transformerFactory.newTransformer();
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to instantiate an XML parser.", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            log.error("Unable to instantiate an XML transformer.", (Throwable)e);
        }
        this.restTemplate = new RestTemplate();
        List converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        log.debug("Constructing IARestClient...");
    }

    private static String encodeBasicAuth(String username, String password) {
        return Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private HttpHeaders getHttpHeaders(boolean forceLogin) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache");
        headers.add("Content-Type", "application/xml");
        if (this.cookies != null && !forceLogin) {
            headers.addAll("Cookie", this.cookies);
        } else {
            String auth = "Basic " + this.authorization;
            headers.add("Authorization", auth);
        }
        return headers;
    }

    private ResponseEntity<String> openNewSessionWithRequest(String url, HttpMethod method, String payload, boolean alreadyTriedNewSession) {
        if (alreadyTriedNewSession) {
            log.error("Opening a new session already attempted without success -- giving up on {} to {} with {}", new Object[]{method, url, payload});
            return null;
        }
        this.cookies = null;
        return this.makeRequest(url, method, payload, true);
    }

    private void setCookiesFromResponse(ResponseEntity<String> response) {
        if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.CREATED || response.getStatusCode() == HttpStatus.NO_CONTENT) {
            HttpHeaders headers = response.getHeaders();
            if (headers.get((Object)"Set-Cookie") != null) {
                this.cookies = headers.get((Object)"Set-Cookie");
            }
        } else {
            log.error("Unable to make request or unexpected status: {}", (Object)response.getStatusCode());
        }
    }

    private ResponseEntity<String> makeRequest(String url, HttpMethod method, String payload, boolean forceLogin) {
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        HttpEntity toSend = payload != null ? new HttpEntity((Object)payload, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            log.debug("{}ing to {} with: {}", new Object[]{method, url, payload});
            response = this.restTemplate.exchange(url, method, toSend, String.class, new Object[0]);
            this.setCookiesFromResponse((ResponseEntity<String>)response);
        }
        catch (HttpClientErrorException e) {
            log.warn("Request failed -- session may have expired, retrying...", (Throwable)e);
            response = this.openNewSessionWithRequest(url, method, payload, forceLogin);
        }
        catch (RestClientException e) {
            log.error("Request failed -- check IA environment connectivity and authentication details.", (Throwable)e);
        }
        return response;
    }

    private String makeRequest(String endpoint, HttpMethod method, String payload) {
        ResponseEntity<String> response = this.makeRequest(this.baseURL + endpoint, method, payload, false);
        String body = null;
        if (response == null) {
            log.error("Unable to complete request -- check IA environment connectivity and authentication details.");
            throw new RuntimeException("Unable to complete request -- check IA environment connectivity and authentication details.");
        }
        if (response.hasBody() && (body = (String)response.getBody()) != null) {
            try {
                Document xmlDoc = this.xmlParser.parse(new InputSource(new StringReader(body)));
                this.minimizeXML(xmlDoc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                this.xmlTransformer.transform(new DOMSource(xmlDoc), result);
                body = writer.toString();
            }
            catch (TransformerException e) {
                log.error("Unable to transform parsed response body back to String: {}", (Object)body, (Object)e);
            }
            catch (IOException | SAXException e) {
                log.error("Unable to parse the response body as XML: {}", (Object)body, (Object)e);
            }
        }
        return body;
    }

    public void disconnect() {
        this.makeRequest(EP_LOGOUT, HttpMethod.GET, null);
    }

    public List<Project> getProjectList() {
        String response = this.makeRequest(EP_PROJECTS, HttpMethod.GET, null);
        List<Project> lProjects = new ArrayList<Project>();
        try {
            lProjects = (List)this.mapper.readValue(response, (TypeReference)new TypeReference<List<Project>>(){});
        }
        catch (IOException e) {
            log.error("Unable to parse projects response: {}", (Object)response, (Object)e);
        }
        return lProjects;
    }

    public Project getProjectDetails(String projectName) {
        String response = this.makeRequest("/ibm/iis/ia/api/project?projectName=" + this.encodeParameterForURL(projectName), HttpMethod.GET, null);
        Project project = null;
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            log.error("Unable to parse project details for project '{}': {}", new Object[]{projectName, response, e});
        }
        return project;
    }

    public List<String> getTablesInProject(Project details) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (DataSource dataSource : details.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    String qualifiedName = dataSource.getName() + "." + schema.getName() + "." + table.getName();
                    tableNames.add(qualifiedName);
                }
            }
        }
        return tableNames;
    }

    public List<String> getColumnsInProject(Project details) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (DataSource dataSource : details.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        String qualifiedName = dataSource.getName() + "." + schema.getName() + "." + table.getName() + "." + column.getName();
                        columnNames.add(qualifiedName);
                    }
                }
            }
        }
        return columnNames;
    }

    public Map<String, ColumnAnalysisResults> getColumnAnalysisResultsForTable(String projectName, String tableName) {
        Project results = this.getColumnAnalysisResults(projectName, tableName + ".*");
        HashMap<String, ColumnAnalysisResults> map = new HashMap<String, ColumnAnalysisResults>();
        for (DataSource dataSource : results.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        ColumnAnalysisResults columnAnalysisResults = column.getColumnAnalysisResults();
                        if (columnAnalysisResults == null) continue;
                        map.put(column.getName(), columnAnalysisResults);
                    }
                }
            }
        }
        return map;
    }

    public Map<String, List<DataQualityProblem>> getDataQualityAnalysisResultsForTable(String projectName, String tableName) {
        Project results = this.getDataQualityAnalysisResults(projectName, tableName);
        HashMap<String, List<DataQualityProblem>> map = new HashMap<String, List<DataQualityProblem>>();
        for (DataSource dataSource : results.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        List<DataQualityProblem> dataQualityProblems = column.getDataQualityProblems();
                        if (dataQualityProblems == null) continue;
                        map.put(column.getName(), dataQualityProblems);
                    }
                }
            }
        }
        return map;
    }

    private Project getColumnAnalysisResults(String projectName, String columnName) {
        return this.makeColumnBasedRequest(projectName, columnName, EP_COL_ANALYSIS_RESULTS, "getColumnAnalysisResults");
    }

    public Map<String, List<Format>> getFormatDistribution(String projectName, String columnName) {
        if (columnName == null) {
            throw new RuntimeException("The 'columnName' parameter is required for 'getFormatDistribution'.");
        }
        Project response = this.makeColumnBasedRequest(projectName, columnName, EP_FORMAT_DISTRIBUTION, "getFormatDistribution");
        HashMap<String, List<Format>> map = new HashMap<String, List<Format>>();
        if (response != null) {
            List<DataSource> dataSourceList = response.getDataSources();
            for (DataSource source : dataSourceList) {
                String dataSourceName = source.getName();
                for (Schema schema : source.getSchemas()) {
                    String schemaName = schema.getName();
                    for (Table table : schema.getTables()) {
                        String tableName = table.getName();
                        for (Column column : table.getColumns()) {
                            String name = column.getName();
                            String qualifiedName = dataSourceName + "." + schemaName + "." + tableName + "." + name;
                            map.put(qualifiedName, column.getColumnAnalysisResults().getFormatDistribution().getFormats());
                        }
                    }
                }
            }
        }
        return map;
    }

    public Map<String, List<Value>> getFrequencyDistribution(String projectName, String columnName) {
        if (columnName == null) {
            throw new RuntimeException("The 'columnName' parameter is required for 'getFrequencyDistribution'.");
        }
        Project response = this.makeColumnBasedRequest(projectName, columnName, EP_FREQ_DISTRIBUTION, "getFrequencyDistribution");
        HashMap<String, List<Value>> map = new HashMap<String, List<Value>>();
        if (response != null) {
            List<DataSource> dataSourceList = response.getDataSources();
            for (DataSource source : dataSourceList) {
                String dataSourceName = source.getName();
                for (Schema schema : source.getSchemas()) {
                    String schemaName = schema.getName();
                    for (Table table : schema.getTables()) {
                        String tableName = table.getName();
                        for (Column column : table.getColumns()) {
                            String name = column.getName();
                            String qualifiedName = dataSourceName + "." + schemaName + "." + tableName + "." + name;
                            map.put(qualifiedName, column.getColumnAnalysisResults().getFrequencyDistribution().getValues());
                        }
                    }
                }
            }
        }
        return map;
    }

    private Project getDataQualityAnalysisResults(String projectName, String tableName) {
        return this.makeTableBasedRequest(projectName, tableName, EP_DQ_ANALYSIS_RESULTS, "getDataQualityAnalysisResults");
    }

    public Map<String, Date> getPublishedResults(String projectName) {
        List<Table> results;
        Project publishedResults = this.makeColumnBasedRequest(projectName, null, EP_PUBLISHED_RESULTS, "getPublishedResults");
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (publishedResults != null && (results = publishedResults.getPublishedResults()) != null) {
            for (Table table : results) {
                map.put(table.getName(), table.getPublicationDateOfAnalysisResults());
            }
        }
        return map;
    }

    public TaskExecutionReport runColumnAnalysis(String projectName, String columnName) {
        Column column = new Column();
        column.setName(columnName);
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(column);
        RunColumnAnalysis runColumnAnalysis = new RunColumnAnalysis();
        runColumnAnalysis.setColumns(columns);
        return this.makeTaskRequest(projectName, runColumnAnalysis, "runColumnAnalysis");
    }

    public TaskExecutionReport runDataQualityAnalysis(String projectName, String tableName) {
        Table table = new Table();
        table.setName(tableName);
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(table);
        RunDataQualityAnalysis runDataQualityAnalysis = new RunDataQualityAnalysis();
        runDataQualityAnalysis.setTables(tables);
        return this.makeTaskRequest(projectName, runDataQualityAnalysis, "runDataQualityAnalysis");
    }

    public boolean publishResults(String projectName, String tableName) {
        Table table = new Table();
        table.setName(tableName);
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(table);
        PublishResults toPublish = new PublishResults();
        toPublish.setTableList(tables);
        return this.publishResults(projectName, toPublish);
    }

    public List<TaskExecutionSchedule> getTaskStatus(TaskExecutionReport taskExecutionReport) {
        ArrayList<TaskExecutionSchedule> taskExecutionSchedules = new ArrayList<TaskExecutionSchedule>();
        for (ScheduledTask scheduledTask : taskExecutionReport.getScheduledTaskList()) {
            TaskExecutionSchedule taskExecutionSchedule = this.getTaskStatus(scheduledTask.getScheduleId());
            if (taskExecutionSchedule == null) continue;
            taskExecutionSchedules.add(taskExecutionSchedule);
        }
        return taskExecutionSchedules;
    }

    public TaskExecutionSchedule getTaskStatus(String scheduleId) {
        String response = this.makeRequest("/ibm/iis/ia/api/analysisStatus?scheduleID=" + scheduleId, HttpMethod.GET, null);
        TaskExecutionSchedule taskExecutionSchedule = null;
        try {
            taskExecutionSchedule = (TaskExecutionSchedule)this.mapper.readValue(response, TaskExecutionSchedule.class);
        }
        catch (IOException e) {
            log.error("Unable to parse execution status for '{}': {}", new Object[]{scheduleId, response, e});
        }
        return taskExecutionSchedule;
    }

    public static String getUnqualifiedNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.contains(".")) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        }
        return qualifiedName;
    }

    private boolean publishResults(String projectName, PublishResults details) {
        String xmlPayload = this.getTaskPayload(projectName, details);
        log.debug("Task request payload: " + xmlPayload);
        String response = this.makeRequest(EP_PUBLISH, HttpMethod.POST, xmlPayload);
        if (response != null) {
            throw new RuntimeException("Error publishing: " + response);
        }
        return true;
    }

    private String getTaskPayload(String projectName, Object value) {
        StringWriter out = new StringWriter();
        try {
            XMLStreamWriter xmlWriter = this.mapper.getFactory().getXMLOutputFactory().createXMLStreamWriter(out);
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement("iaapi", "Project", "http://www.ibm.com/investigate/api/iaapi");
            xmlWriter.writeAttribute("name", projectName);
            xmlWriter.writeStartElement("Tasks");
            this.mapper.writeValue(xmlWriter, value);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (JsonProcessingException e) {
            log.error("Unable to translate provided {} object to XML: {}", new Object[]{value.getClass().getName(), value, e});
        }
        catch (XMLStreamException e) {
            log.error("Unable to write to XML stream: {}", value, (Object)e);
        }
        catch (IOException e) {
            log.error("Unable to translate provided {} object to XML stream: {}", new Object[]{value.getClass().getName(), value, e});
        }
        return out.toString();
    }

    private TaskExecutionReport makeTaskRequest(String projectName, Object details, String methodName) {
        String xmlPayload = this.getTaskPayload(projectName, details);
        log.debug("Task request payload: " + xmlPayload);
        String response = this.makeRequest(EP_EXECUTE_TASK, HttpMethod.POST, xmlPayload);
        TaskExecutionReport taskExecutionReport = null;
        try {
            taskExecutionReport = (TaskExecutionReport)this.mapper.readValue(response, TaskExecutionReport.class);
        }
        catch (IOException e) {
            log.error("Unable to parse {} execution report for project '{}': {}", new Object[]{methodName, projectName, response, e});
        }
        return taskExecutionReport;
    }

    private Project makeColumnBasedRequest(String projectName, String columnName, String urlBase, String methodName) {
        String url = urlBase + "?projectName=" + this.encodeParameterForURL(projectName);
        if (columnName != null) {
            url = url + "&columnName=" + this.encodeParameterForURL(columnName);
        }
        String response = this.makeRequest(url, HttpMethod.GET, null);
        Project project = null;
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            if (columnName == null) {
                log.error("Unable to parse {} results for project '{}': {}", new Object[]{methodName, projectName, response, e});
            }
            log.error("Unable to parse {} results for project '{}' and column '{}': {}", new Object[]{methodName, projectName, columnName, response, e});
        }
        return project;
    }

    private Project makeTableBasedRequest(String projectName, String tableName, String urlBase, String methodName) {
        String url = urlBase + "?projectName=" + this.encodeParameterForURL(projectName);
        if (tableName != null) {
            url = url + "&tableName=" + this.encodeParameterForURL(tableName);
        }
        String response = this.makeRequest(url, HttpMethod.GET, null);
        Project project = null;
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            if (tableName == null) {
                log.error("Unable to parse {} results for project '{}': {}", new Object[]{methodName, projectName, response, e});
            }
            log.error("Unable to parse {} results for project '{}' and table '{}': {}", new Object[]{methodName, projectName, tableName, response, e});
        }
        return project;
    }

    private String encodeParameterForURL(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to encode parameter value for a URL: {}", (Object)value, (Object)e);
        }
        return encoded;
    }

    private void minimizeXML(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            this.minimizeXML(child);
        }
    }
}

