/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.ia.clientlibrary;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.IARestConstants;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.errors.IAConnectivityException;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.errors.IAParsingException;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Column;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.ColumnAnalysisResults;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.DataQualityProblem;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.DataSource;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Format;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Project;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.PublishResults;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.RunColumnAnalysis;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.RunDataQualityAnalysis;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.ScheduledTask;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Schema;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Table;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.TaskExecutionReport;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.TaskExecutionSchedule;
import org.odpi.egeria.connectors.ibm.ia.clientlibrary.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IARestClient {
    private static final Logger log = LoggerFactory.getLogger(IARestClient.class);
    private String authorization;
    private String baseURL;
    private List<String> cookies = null;
    private RestTemplate restTemplate;
    private XmlMapper mapper;
    private DocumentBuilder xmlParser;
    private Transformer xmlTransformer;
    private static final String EP_BASE_API = "/ibm/iis/ia/api/";
    private static final String EP_PROJECT = "/ibm/iis/ia/api/project";
    private static final String EP_PROJECTS = "/ibm/iis/ia/api/projects";
    private static final String EP_COL_ANALYSIS_BASE = "/ibm/iis/ia/api/columnAnalysis/";
    private static final String EP_COL_ANALYSIS_RESULTS = "/ibm/iis/ia/api/columnAnalysis/results";
    private static final String EP_FORMAT_DISTRIBUTION = "/ibm/iis/ia/api/columnAnalysis/formatDistribution";
    private static final String EP_FREQ_DISTRIBUTION = "/ibm/iis/ia/api/columnAnalysis/frequencyDistribution";
    private static final String EP_DQ_ANALYSIS_BASE = "/ibm/iis/ia/api/dataQualityAnalysis/";
    private static final String EP_DQ_ANALYSIS_RESULTS = "/ibm/iis/ia/api/dataQualityAnalysis/results";
    private static final String EP_PUBLISHED_RESULTS = "/ibm/iis/ia/api/publishedResults";
    private static final String EP_EXECUTE_TASK = "/ibm/iis/ia/api/executeTasks";
    private static final String EP_TASK_STATUS = "/ibm/iis/ia/api/analysisStatus";
    private static final String EP_PUBLISH = "/ibm/iis/ia/api/publishResults";
    private static final String EP_LOGOUT = "/ibm/iis/ia/api/logout";

    public IARestClient(String host, String port, String user, String password) {
        this("https://" + host + ":" + port, IARestClient.encodeBasicAuth(user, password));
    }

    private IARestClient(String baseURL, String authorization) {
        this.baseURL = baseURL;
        this.authorization = authorization;
        WstxInputFactory inputFactory = new WstxInputFactory();
        WstxOutputFactory outputFactory = new WstxOutputFactory();
        XmlFactory xf = new XmlFactory((XMLInputFactory)inputFactory, (XMLOutputFactory)outputFactory);
        this.mapper = new XmlMapper(xf);
        this.mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            this.xmlParser = documentBuilderFactory.newDocumentBuilder();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.xmlTransformer = transformerFactory.newTransformer();
        }
        catch (ParserConfigurationException e) {
            throw new IAParsingException("Unable to instantiate an XML parser.", e);
        }
        catch (TransformerConfigurationException e) {
            throw new IAParsingException("Unable to instantiate an XML transformer.", e);
        }
        this.restTemplate = new RestTemplate();
        List converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    private static String encodeBasicAuth(String username, String password) {
        return Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private HttpHeaders getHttpHeaders(boolean forceLogin) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache");
        headers.add("Content-Type", "application/xml");
        if (this.cookies != null && !forceLogin) {
            headers.addAll("Cookie", this.cookies);
        } else {
            String auth = "Basic " + this.authorization;
            headers.add("Authorization", auth);
        }
        return headers;
    }

    private ResponseEntity<String> openNewSessionWithRequest(String url, HttpMethod method, String payload, boolean alreadyTriedNewSession) {
        if (alreadyTriedNewSession) {
            String formattedMessage = method + " to " + url + " with: " + payload;
            throw new IAConnectivityException("Opening a new session already attempted without success -- giving up.", formattedMessage);
        }
        this.cookies = null;
        return this.makeRequest(url, method, payload, true);
    }

    private void setCookiesFromResponse(ResponseEntity<String> response) {
        if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.CREATED || response.getStatusCode() == HttpStatus.NO_CONTENT) {
            List candidateCookies;
            HttpHeaders headers = response.getHeaders();
            if (headers.get((Object)"Set-Cookie") != null && (candidateCookies = headers.get((Object)"Set-Cookie")) != null) {
                this.cookies = new ArrayList<String>();
                for (String candidate : candidateCookies) {
                    String[] tokens = candidate.split("=");
                    if (tokens.length < 2) {
                        throw new IAConnectivityException("An invalid cookie was found, which could present a security problem.", candidate);
                    }
                    String cookieName = tokens[0];
                    if (!IARestConstants.getValidCookieNames().contains(cookieName)) {
                        throw new IAConnectivityException("An invalid cookie was found, which could present a security problem.", candidate);
                    }
                    Matcher m = IARestConstants.COOKIE_WHITELIST.matcher(candidate);
                    if (m.matches()) {
                        this.cookies.add(candidate);
                        continue;
                    }
                    throw new IAConnectivityException("A cookie was found that has invalid characters and could therefore present a security problem.", candidate);
                }
            }
        } else {
            throw new IAConnectivityException("Unable to make request or unexpected status.", response.getStatusCode().toString());
        }
    }

    private ResponseEntity<String> makeRequest(String url, HttpMethod method, String payload, boolean forceLogin) {
        ResponseEntity response;
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        HttpEntity toSend = payload != null ? new HttpEntity((Object)payload, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        try {
            log.debug("{}ing to {} with: {}", new Object[]{method, url, payload});
            response = this.restTemplate.exchange(url, method, toSend, String.class, new Object[0]);
            this.setCookiesFromResponse((ResponseEntity<String>)response);
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.Unauthorized e) {
            log.warn("Request failed -- session may have expired, retrying...", e);
            response = this.openNewSessionWithRequest(url, method, payload, forceLogin);
        }
        catch (RestClientException e) {
            throw new IAConnectivityException("Request failed -- check IA environment connectivity and authentication details.", e);
        }
        return response;
    }

    private String makeRequest(String endpoint, HttpMethod method, String payload) {
        ResponseEntity<String> response = this.makeRequest(this.baseURL + endpoint, method, payload, false);
        String body = null;
        if (response == null) {
            String formattedMessage = method + " to " + endpoint + " with: " + payload;
            throw new IAConnectivityException("Unable to complete request -- check IA environment connectivity and authentication details.", formattedMessage);
        }
        if (response.hasBody() && (body = (String)response.getBody()) != null) {
            try {
                Document xmlDoc = this.xmlParser.parse(new InputSource(new StringReader(body)));
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                this.xmlTransformer.transform(new DOMSource(xmlDoc), result);
                body = writer.toString();
            }
            catch (TransformerException e) {
                throw new IAParsingException("Unable to transform parsed response body back to String.", body, e);
            }
            catch (IOException | SAXException e) {
                throw new IAParsingException("Unable to parse the response body as XML.", body, e);
            }
        }
        return body;
    }

    public void disconnect() {
        this.makeRequest(EP_LOGOUT, HttpMethod.GET, null);
    }

    public List<Project> getProjectList() {
        List lProjects;
        String response = this.makeRequest(EP_PROJECTS, HttpMethod.GET, null);
        try {
            lProjects = (List)this.mapper.readValue(response, (TypeReference)new TypeReference<List<Project>>(){});
        }
        catch (IOException e) {
            throw new IAParsingException("Unable to parse projects response.", response, e);
        }
        return lProjects;
    }

    public Project getProjectDetails(String projectName) {
        Project project;
        String response = this.makeRequest("/ibm/iis/ia/api/project?projectName=" + this.encodeParameterForURL(projectName), HttpMethod.GET, null);
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            throw new IAParsingException("Unable to parse project details for project '" + projectName + "'.", response, e);
        }
        return project;
    }

    public List<String> getTablesInProject(Project details) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (DataSource dataSource : details.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    String qualifiedName = dataSource.getName() + "." + schema.getName() + "." + table.getName();
                    tableNames.add(qualifiedName);
                }
            }
        }
        return tableNames;
    }

    public List<String> getColumnsInProject(Project details) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (DataSource dataSource : details.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        String qualifiedName = dataSource.getName() + "." + schema.getName() + "." + table.getName() + "." + column.getName();
                        columnNames.add(qualifiedName);
                    }
                }
            }
        }
        return columnNames;
    }

    public Map<String, ColumnAnalysisResults> getColumnAnalysisResultsForTable(String projectName, String tableName) {
        Project results = this.getColumnAnalysisResults(projectName, tableName + ".*");
        HashMap<String, ColumnAnalysisResults> map = new HashMap<String, ColumnAnalysisResults>();
        for (DataSource dataSource : results.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        ColumnAnalysisResults columnAnalysisResults = column.getColumnAnalysisResults();
                        if (columnAnalysisResults == null) continue;
                        map.put(column.getName(), columnAnalysisResults);
                    }
                }
            }
        }
        return map;
    }

    public Map<String, List<DataQualityProblem>> getDataQualityAnalysisResultsForTable(String projectName, String tableName) {
        Project results = this.getDataQualityAnalysisResults(projectName, tableName);
        HashMap<String, List<DataQualityProblem>> map = new HashMap<String, List<DataQualityProblem>>();
        for (DataSource dataSource : results.getDataSources()) {
            for (Schema schema : dataSource.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        List<DataQualityProblem> dataQualityProblems = column.getDataQualityProblems();
                        if (dataQualityProblems == null) continue;
                        map.put(column.getName(), dataQualityProblems);
                    }
                }
            }
        }
        return map;
    }

    private Project getColumnAnalysisResults(String projectName, String columnName) {
        return this.makeColumnBasedRequest(projectName, columnName, EP_COL_ANALYSIS_RESULTS, "getColumnAnalysisResults");
    }

    public Map<String, List<Format>> getFormatDistribution(String projectName, String columnName) {
        if (columnName == null) {
            throw new IAParsingException("The 'columnName' parameter is required for 'getFormatDistribution'.", null);
        }
        Project response = this.makeColumnBasedRequest(projectName, columnName, EP_FORMAT_DISTRIBUTION, "getFormatDistribution");
        HashMap<String, List<Format>> map = new HashMap<String, List<Format>>();
        if (response != null) {
            List<DataSource> dataSourceList = response.getDataSources();
            for (DataSource source : dataSourceList) {
                String dataSourceName = source.getName();
                for (Schema schema : source.getSchemas()) {
                    String schemaName = schema.getName();
                    for (Table table : schema.getTables()) {
                        String tableName = table.getName();
                        for (Column column : table.getColumns()) {
                            String name = column.getName();
                            String qualifiedName = dataSourceName + "." + schemaName + "." + tableName + "." + name;
                            map.put(qualifiedName, column.getColumnAnalysisResults().getFormatDistribution().getFormats());
                        }
                    }
                }
            }
        }
        return map;
    }

    public Map<String, List<Value>> getFrequencyDistribution(String projectName, String columnName) {
        if (columnName == null) {
            throw new IAParsingException("The 'columnName' parameter is required for 'getFrequencyDistribution'.", null);
        }
        Project response = this.makeColumnBasedRequest(projectName, columnName, EP_FREQ_DISTRIBUTION, "getFrequencyDistribution");
        HashMap<String, List<Value>> map = new HashMap<String, List<Value>>();
        if (response != null) {
            List<DataSource> dataSourceList = response.getDataSources();
            for (DataSource source : dataSourceList) {
                String dataSourceName = source.getName();
                for (Schema schema : source.getSchemas()) {
                    String schemaName = schema.getName();
                    for (Table table : schema.getTables()) {
                        String tableName = table.getName();
                        for (Column column : table.getColumns()) {
                            String name = column.getName();
                            String qualifiedName = dataSourceName + "." + schemaName + "." + tableName + "." + name;
                            map.put(qualifiedName, column.getColumnAnalysisResults().getFrequencyDistribution().getValues());
                        }
                    }
                }
            }
        }
        return map;
    }

    private Project getDataQualityAnalysisResults(String projectName, String tableName) {
        return this.makeTableBasedRequest(projectName, tableName, EP_DQ_ANALYSIS_RESULTS, "getDataQualityAnalysisResults");
    }

    public Map<String, Date> getPublishedResults(String projectName) {
        List<Table> results;
        Project publishedResults = this.makeColumnBasedRequest(projectName, null, EP_PUBLISHED_RESULTS, "getPublishedResults");
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (publishedResults != null && (results = publishedResults.getPublishedResults()) != null) {
            for (Table table : results) {
                map.put(table.getName(), table.getPublicationDateOfAnalysisResults());
            }
        }
        return map;
    }

    public TaskExecutionReport runColumnAnalysis(String projectName, String columnName) {
        Column column = new Column();
        column.setName(columnName);
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(column);
        RunColumnAnalysis runColumnAnalysis = new RunColumnAnalysis();
        runColumnAnalysis.setColumns(columns);
        return this.makeTaskRequest(projectName, runColumnAnalysis, "runColumnAnalysis");
    }

    public TaskExecutionReport runDataQualityAnalysis(String projectName, String tableName) {
        Table table = new Table();
        table.setName(tableName);
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(table);
        RunDataQualityAnalysis runDataQualityAnalysis = new RunDataQualityAnalysis();
        runDataQualityAnalysis.setTables(tables);
        return this.makeTaskRequest(projectName, runDataQualityAnalysis, "runDataQualityAnalysis");
    }

    public boolean publishResults(String projectName, String tableName) {
        Table table = new Table();
        table.setName(tableName);
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(table);
        PublishResults toPublish = new PublishResults();
        toPublish.setTableList(tables);
        return this.publishResults(projectName, toPublish);
    }

    public List<TaskExecutionSchedule> getTaskStatus(TaskExecutionReport taskExecutionReport) {
        ArrayList<TaskExecutionSchedule> taskExecutionSchedules = new ArrayList<TaskExecutionSchedule>();
        for (ScheduledTask scheduledTask : taskExecutionReport.getScheduledTaskList()) {
            TaskExecutionSchedule taskExecutionSchedule = this.getTaskStatus(scheduledTask.getScheduleId());
            if (taskExecutionSchedule == null) continue;
            taskExecutionSchedules.add(taskExecutionSchedule);
        }
        return taskExecutionSchedules;
    }

    public TaskExecutionSchedule getTaskStatus(String scheduleId) {
        TaskExecutionSchedule taskExecutionSchedule;
        String response = this.makeRequest("/ibm/iis/ia/api/analysisStatus?scheduleID=" + scheduleId, HttpMethod.GET, null);
        try {
            taskExecutionSchedule = (TaskExecutionSchedule)this.mapper.readValue(response, TaskExecutionSchedule.class);
        }
        catch (IOException e) {
            throw new IAParsingException("Unable to parse execution status for '" + scheduleId + "'.", response, e);
        }
        return taskExecutionSchedule;
    }

    public static String getUnqualifiedNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.contains(".")) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        }
        return qualifiedName;
    }

    private boolean publishResults(String projectName, PublishResults details) {
        String xmlPayload = this.getTaskPayload(projectName, details);
        log.debug("Task request payload: {}", (Object)xmlPayload);
        String response = this.makeRequest(EP_PUBLISH, HttpMethod.POST, xmlPayload);
        if (response != null) {
            throw new IAConnectivityException("Error publishing.", response);
        }
        return true;
    }

    private String getTaskPayload(String projectName, Object value) {
        StringWriter out = new StringWriter();
        try {
            XMLStreamWriter xmlWriter = this.mapper.getFactory().getXMLOutputFactory().createXMLStreamWriter(out);
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement("iaapi", "Project", "http://www.ibm.com/investigate/api/iaapi");
            xmlWriter.writeAttribute("name", projectName);
            xmlWriter.writeStartElement("Tasks");
            this.mapper.writeValue(xmlWriter, value);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (JsonProcessingException e) {
            throw new IAParsingException("Unable to translate provided '" + value.getClass().getName() + "' object to XML.", value.toString(), e);
        }
        catch (XMLStreamException e) {
            throw new IAParsingException("Unable to write to XML stream.", value.toString(), e);
        }
        catch (IOException e) {
            throw new IAParsingException("Unable to translate provided '" + value.getClass().getName() + "' object to XML stream.", value.toString(), e);
        }
        return out.toString();
    }

    private TaskExecutionReport makeTaskRequest(String projectName, Object details, String methodName) {
        TaskExecutionReport taskExecutionReport;
        String xmlPayload = this.getTaskPayload(projectName, details);
        log.debug("Task request payload: {}", (Object)xmlPayload);
        String response = this.makeRequest(EP_EXECUTE_TASK, HttpMethod.POST, xmlPayload);
        try {
            taskExecutionReport = (TaskExecutionReport)this.mapper.readValue(response, TaskExecutionReport.class);
        }
        catch (IOException e) {
            throw new IAParsingException("Unable to parse '" + methodName + "' execution report for project '" + projectName + "'.", response, e);
        }
        return taskExecutionReport;
    }

    private Project makeColumnBasedRequest(String projectName, String columnName, String urlBase, String methodName) {
        Project project;
        String url = urlBase + "?projectName=" + this.encodeParameterForURL(projectName);
        if (columnName != null) {
            url = url + "&columnName=" + this.encodeParameterForURL(columnName);
        }
        String response = this.makeRequest(url, HttpMethod.GET, null);
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            if (columnName == null) {
                throw new IAParsingException("Unable to parse '" + methodName + "' results for project '" + projectName + "'.", response, e);
            }
            throw new IAParsingException("Unable to parse '" + methodName + "' results for project '" + projectName + "' and column '" + columnName + "'.", response, e);
        }
        return project;
    }

    private Project makeTableBasedRequest(String projectName, String tableName, String urlBase, String methodName) {
        Project project;
        String url = urlBase + "?projectName=" + this.encodeParameterForURL(projectName);
        if (tableName != null) {
            url = url + "&tableName=" + this.encodeParameterForURL(tableName);
        }
        String response = this.makeRequest(url, HttpMethod.GET, null);
        try {
            project = (Project)this.mapper.readValue(response, Project.class);
        }
        catch (IOException e) {
            if (tableName == null) {
                throw new IAParsingException("Unable to parse '" + methodName + "' results for project '" + projectName + "'.", response, e);
            }
            throw new IAParsingException("Unable to parse '" + methodName + "' results for project '" + projectName + "' and table '" + tableName + "'.", response, e);
        }
        return project;
    }

    private String encodeParameterForURL(String value) {
        String encoded;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IAParsingException("Unable to encode parameter value for a URL.", value, e);
        }
        return encoded;
    }
}

