/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * POJO for the {@code composite_view} asset type in IGC, displayed as '{@literal Composite View}' in the IGC UI.
 * <br><br>
 * (this code has been created based on out-of-the-box IGC metadata types.
 *  If modifications are needed, eg. to handle custom attributes,
 *  extending from this class in your own custom class is the best approach.)
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_type", visible=true, defaultImpl=CompositeView.class)
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("composite_view")
public class CompositeView extends InformationAsset {

    @JsonProperty("alias_(business_name)")
    protected String aliasBusinessName;

    @JsonProperty("composite_view")
    protected MemberType compositeView;

    @JsonProperty("member_type")
    protected MemberType memberType;

    /**
     * Valid values are:
     * <ul>
     *   <li>MEMBER (displayed in the UI as 'MEMBER')</li>
     *   <li>ENTITY (displayed in the UI as 'ENTITY')</li>
     * </ul>
     */
    @JsonProperty("type")
    protected String type;

    /**
     * Retrieve the {@code alias_(business_name)} property (displayed as '{@literal Alias (Business Name)}') of the object.
     * @return {@code String}
     */
    @JsonProperty("alias_(business_name)")
    public String getAliasBusinessName() { return this.aliasBusinessName; }

    /**
     * Set the {@code alias_(business_name)} property (displayed as {@code Alias (Business Name)}) of the object.
     * @param aliasBusinessName the value to set
     */
    @JsonProperty("alias_(business_name)")
    public void setAliasBusinessName(String aliasBusinessName) { this.aliasBusinessName = aliasBusinessName; }

    /**
     * Retrieve the {@code composite_view} property (displayed as '{@literal Composite View}') of the object.
     * @return {@code MemberType}
     */
    @JsonProperty("composite_view")
    public MemberType getCompositeView() { return this.compositeView; }

    /**
     * Set the {@code composite_view} property (displayed as {@code Composite View}) of the object.
     * @param compositeView the value to set
     */
    @JsonProperty("composite_view")
    public void setCompositeView(MemberType compositeView) { this.compositeView = compositeView; }

    /**
     * Retrieve the {@code member_type} property (displayed as '{@literal Member Type}') of the object.
     * @return {@code MemberType}
     */
    @JsonProperty("member_type")
    public MemberType getMemberType() { return this.memberType; }

    /**
     * Set the {@code member_type} property (displayed as {@code Member Type}) of the object.
     * @param memberType the value to set
     */
    @JsonProperty("member_type")
    public void setMemberType(MemberType memberType) { this.memberType = memberType; }

    /**
     * Retrieve the {@code type} property (displayed as '{@literal Type}') of the object.
     * @return {@code String}
     */
    @JsonProperty("type")
    public String getTheType() { return this.type; }

    /**
     * Set the {@code type} property (displayed as {@code Type}) of the object.
     * @param type the value to set
     */
    @JsonProperty("type")
    public void setTheType(String type) { this.type = type; }

}
