/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;

/**
 * POJO for the {@code data_file_definition_record} asset type in IGC, displayed as '{@literal Data File Definition Record}' in the IGC UI.
 * <br><br>
 * (this code has been created based on out-of-the-box IGC metadata types.
 *  If modifications are needed, eg. to handle custom attributes,
 *  extending from this class in your own custom class is the best approach.)
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_type", visible=true, defaultImpl=DataFileDefinitionRecord.class)
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("data_file_definition_record")
public class DataFileDefinitionRecord extends InformationAsset {

    @JsonProperty("alias_(business_name)")
    protected String aliasBusinessName;

    @JsonProperty("data_file_definition")
    protected DataFileDefinition dataFileDefinition;

    @JsonProperty("data_file_definition_fields")
    protected ItemList<DataFileDefinitionField> dataFileDefinitionFields;

    @JsonProperty("imported_from")
    protected String importedFrom;

    /**
     * Retrieve the {@code alias_(business_name)} property (displayed as '{@literal Alias (Business Name)}') of the object.
     * @return {@code String}
     */
    @JsonProperty("alias_(business_name)")
    public String getAliasBusinessName() { return this.aliasBusinessName; }

    /**
     * Set the {@code alias_(business_name)} property (displayed as {@code Alias (Business Name)}) of the object.
     * @param aliasBusinessName the value to set
     */
    @JsonProperty("alias_(business_name)")
    public void setAliasBusinessName(String aliasBusinessName) { this.aliasBusinessName = aliasBusinessName; }

    /**
     * Retrieve the {@code data_file_definition} property (displayed as '{@literal Data File Definition}') of the object.
     * @return {@code DataFileDefinition}
     */
    @JsonProperty("data_file_definition")
    public DataFileDefinition getDataFileDefinition() { return this.dataFileDefinition; }

    /**
     * Set the {@code data_file_definition} property (displayed as {@code Data File Definition}) of the object.
     * @param dataFileDefinition the value to set
     */
    @JsonProperty("data_file_definition")
    public void setDataFileDefinition(DataFileDefinition dataFileDefinition) { this.dataFileDefinition = dataFileDefinition; }

    /**
     * Retrieve the {@code data_file_definition_fields} property (displayed as '{@literal Data File Definition Fields}') of the object.
     * @return {@code ItemList<DataFileDefinitionField>}
     */
    @JsonProperty("data_file_definition_fields")
    public ItemList<DataFileDefinitionField> getDataFileDefinitionFields() { return this.dataFileDefinitionFields; }

    /**
     * Set the {@code data_file_definition_fields} property (displayed as {@code Data File Definition Fields}) of the object.
     * @param dataFileDefinitionFields the value to set
     */
    @JsonProperty("data_file_definition_fields")
    public void setDataFileDefinitionFields(ItemList<DataFileDefinitionField> dataFileDefinitionFields) { this.dataFileDefinitionFields = dataFileDefinitionFields; }

    /**
     * Retrieve the {@code imported_from} property (displayed as '{@literal Imported From}') of the object.
     * @return {@code String}
     */
    @JsonProperty("imported_from")
    public String getImportedFrom() { return this.importedFrom; }

    /**
     * Set the {@code imported_from} property (displayed as {@code Imported From}) of the object.
     * @param importedFrom the value to set
     */
    @JsonProperty("imported_from")
    public void setImportedFrom(String importedFrom) { this.importedFrom = importedFrom; }

}
