/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import java.util.List;

/**
 * POJO for the {@code database_index} asset type in IGC, displayed as '{@literal Database Index}' in the IGC UI.
 * <br><br>
 * (this code has been created based on out-of-the-box IGC metadata types.
 *  If modifications are needed, eg. to handle custom attributes,
 *  extending from this class in your own custom class is the best approach.)
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_type", visible=true, defaultImpl=DatabaseIndex.class)
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("database_index")
public class DatabaseIndex extends Reference {

    @JsonProperty("expression")
    protected List<String> expression;

    @JsonProperty("function")
    protected Boolean function;

    @JsonProperty("indexed_database_columns")
    protected ItemList<DatabaseColumn> indexedDatabaseColumns;

    @JsonProperty("join")
    protected Boolean join;

    @JsonProperty("joined_database_columns")
    protected ItemList<DatabaseColumn> joinedDatabaseColumns;

    @JsonProperty("long_description")
    protected String longDescription;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("native_id")
    protected String nativeId;

    @JsonProperty("partition")
    protected Boolean partition;

    @JsonProperty("short_description")
    protected String shortDescription;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("unique")
    protected Boolean unique;

    /**
     * Retrieve the {@code expression} property (displayed as '{@literal Expression}') of the object.
     * @return {@code List<String>}
     */
    @JsonProperty("expression")
    public List<String> getExpression() { return this.expression; }

    /**
     * Set the {@code expression} property (displayed as {@code Expression}) of the object.
     * @param expression the value to set
     */
    @JsonProperty("expression")
    public void setExpression(List<String> expression) { this.expression = expression; }

    /**
     * Retrieve the {@code function} property (displayed as '{@literal Function}') of the object.
     * @return {@code Boolean}
     */
    @JsonProperty("function")
    public Boolean getFunction() { return this.function; }

    /**
     * Set the {@code function} property (displayed as {@code Function}) of the object.
     * @param function the value to set
     */
    @JsonProperty("function")
    public void setFunction(Boolean function) { this.function = function; }

    /**
     * Retrieve the {@code indexed_database_columns} property (displayed as '{@literal Database Columns}') of the object.
     * @return {@code ItemList<DatabaseColumn>}
     */
    @JsonProperty("indexed_database_columns")
    public ItemList<DatabaseColumn> getIndexedDatabaseColumns() { return this.indexedDatabaseColumns; }

    /**
     * Set the {@code indexed_database_columns} property (displayed as {@code Database Columns}) of the object.
     * @param indexedDatabaseColumns the value to set
     */
    @JsonProperty("indexed_database_columns")
    public void setIndexedDatabaseColumns(ItemList<DatabaseColumn> indexedDatabaseColumns) { this.indexedDatabaseColumns = indexedDatabaseColumns; }

    /**
     * Retrieve the {@code join} property (displayed as '{@literal Join}') of the object.
     * @return {@code Boolean}
     */
    @JsonProperty("join")
    public Boolean getJoin() { return this.join; }

    /**
     * Set the {@code join} property (displayed as {@code Join}) of the object.
     * @param join the value to set
     */
    @JsonProperty("join")
    public void setJoin(Boolean join) { this.join = join; }

    /**
     * Retrieve the {@code joined_database_columns} property (displayed as '{@literal Joined Database Columns}') of the object.
     * @return {@code ItemList<DatabaseColumn>}
     */
    @JsonProperty("joined_database_columns")
    public ItemList<DatabaseColumn> getJoinedDatabaseColumns() { return this.joinedDatabaseColumns; }

    /**
     * Set the {@code joined_database_columns} property (displayed as {@code Joined Database Columns}) of the object.
     * @param joinedDatabaseColumns the value to set
     */
    @JsonProperty("joined_database_columns")
    public void setJoinedDatabaseColumns(ItemList<DatabaseColumn> joinedDatabaseColumns) { this.joinedDatabaseColumns = joinedDatabaseColumns; }

    /**
     * Retrieve the {@code long_description} property (displayed as '{@literal Long Description}') of the object.
     * @return {@code String}
     */
    @JsonProperty("long_description")
    public String getLongDescription() { return this.longDescription; }

    /**
     * Set the {@code long_description} property (displayed as {@code Long Description}) of the object.
     * @param longDescription the value to set
     */
    @JsonProperty("long_description")
    public void setLongDescription(String longDescription) { this.longDescription = longDescription; }

    /**
     * Retrieve the {@code name} property (displayed as '{@literal Name}') of the object.
     * @return {@code String}
     */
    @JsonProperty("name")
    public String getTheName() { return this.name; }

    /**
     * Set the {@code name} property (displayed as {@code Name}) of the object.
     * @param name the value to set
     */
    @JsonProperty("name")
    public void setTheName(String name) { this.name = name; }

    /**
     * Retrieve the {@code native_id} property (displayed as '{@literal Native ID}') of the object.
     * @return {@code String}
     */
    @JsonProperty("native_id")
    public String getNativeId() { return this.nativeId; }

    /**
     * Set the {@code native_id} property (displayed as {@code Native ID}) of the object.
     * @param nativeId the value to set
     */
    @JsonProperty("native_id")
    public void setNativeId(String nativeId) { this.nativeId = nativeId; }

    /**
     * Retrieve the {@code partition} property (displayed as '{@literal Partition}') of the object.
     * @return {@code Boolean}
     */
    @JsonProperty("partition")
    public Boolean getPartition() { return this.partition; }

    /**
     * Set the {@code partition} property (displayed as {@code Partition}) of the object.
     * @param partition the value to set
     */
    @JsonProperty("partition")
    public void setPartition(Boolean partition) { this.partition = partition; }

    /**
     * Retrieve the {@code short_description} property (displayed as '{@literal Short Description}') of the object.
     * @return {@code String}
     */
    @JsonProperty("short_description")
    public String getShortDescription() { return this.shortDescription; }

    /**
     * Set the {@code short_description} property (displayed as {@code Short Description}) of the object.
     * @param shortDescription the value to set
     */
    @JsonProperty("short_description")
    public void setShortDescription(String shortDescription) { this.shortDescription = shortDescription; }

    /**
     * Retrieve the {@code type} property (displayed as '{@literal Type}') of the object.
     * @return {@code String}
     */
    @JsonProperty("type")
    public String getTheType() { return this.type; }

    /**
     * Set the {@code type} property (displayed as {@code Type}) of the object.
     * @param type the value to set
     */
    @JsonProperty("type")
    public void setTheType(String type) { this.type = type; }

    /**
     * Retrieve the {@code unique} property (displayed as '{@literal Unique Index}') of the object.
     * @return {@code Boolean}
     */
    @JsonProperty("unique")
    public Boolean getUnique() { return this.unique; }

    /**
     * Set the {@code unique} property (displayed as {@code Unique Index}) of the object.
     * @param unique the value to set
     */
    @JsonProperty("unique")
    public void setUnique(Boolean unique) { this.unique = unique; }

}
