/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;

/**
 * POJO for the {@code primarycategory} asset type in IGC, displayed as '{@literal PrimaryCategory}' in the IGC UI.
 * <br><br>
 * (this code has been created based on out-of-the-box IGC metadata types.
 *  If modifications are needed, eg. to handle custom attributes,
 *  extending from this class in your own custom class is the best approach.)
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_type", visible=true, defaultImpl=Primarycategory.class)
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("primarycategory")
public class Primarycategory extends Reference {

    @JsonProperty("color")
    protected String color;

    @JsonProperty("icon")
    protected String icon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("uses_business_category")
    protected MainObject usesBusinessCategory;

    /**
     * Retrieve the {@code color} property (displayed as '{@literal Color}') of the object.
     * @return {@code String}
     */
    @JsonProperty("color")
    public String getColor() { return this.color; }

    /**
     * Set the {@code color} property (displayed as {@code Color}) of the object.
     * @param color the value to set
     */
    @JsonProperty("color")
    public void setColor(String color) { this.color = color; }

    /**
     * Retrieve the {@code icon} property (displayed as '{@literal Icon}') of the object.
     * @return {@code String}
     */
    @JsonProperty("icon")
    public String getIcon() { return this.icon; }

    /**
     * Set the {@code icon} property (displayed as {@code Icon}) of the object.
     * @param icon the value to set
     */
    @JsonProperty("icon")
    public void setIcon(String icon) { this.icon = icon; }

    /**
     * Retrieve the {@code name} property (displayed as '{@literal Name}') of the object.
     * @return {@code String}
     */
    @JsonProperty("name")
    public String getTheName() { return this.name; }

    /**
     * Set the {@code name} property (displayed as {@code Name}) of the object.
     * @param name the value to set
     */
    @JsonProperty("name")
    public void setTheName(String name) { this.name = name; }

    /**
     * Retrieve the {@code uses_business_category} property (displayed as '{@literal Uses Business Category}') of the object.
     * @return {@code MainObject}
     */
    @JsonProperty("uses_business_category")
    public MainObject getUsesBusinessCategory() { return this.usesBusinessCategory; }

    /**
     * Set the {@code uses_business_category} property (displayed as {@code Uses Business Category}) of the object.
     * @param usesBusinessCategory the value to set
     */
    @JsonProperty("uses_business_category")
    public void setUsesBusinessCategory(MainObject usesBusinessCategory) { this.usesBusinessCategory = usesBusinessCategory; }

}
