/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCConnectivityException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCIOException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCParsingException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.DynamicPropertyReader;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Paging;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeDetails;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeHeader;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeReference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCCreate;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Base64Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class IGCRestClient {
    private static final Logger log = LoggerFactory.getLogger(IGCRestClient.class);
    private String authorization;
    private String baseURL;
    private Boolean workflowEnabled = false;
    private List<String> cookies = null;
    private RestTemplate restTemplate;
    private IGCVersionEnum igcVersion;
    private HashMap<String, DynamicPropertyReader> typeAndPropertyToAccessor;
    private Set<String> typesThatCanBeCreated;
    private Set<String> typesThatIncludeModificationDetails;
    private Map<String, String> typeToDisplayName;
    private Map<String, List<String>> typeToNonRelationshipProperties;
    private Map<String, List<String>> typeToStringProperties;
    private Map<String, List<String>> typeToAllProperties;
    private Map<String, List<String>> typeToPagedRelationshipProperties;
    private Map<String, Class<?>> registeredTypes;
    private int defaultPageSize = 100;
    private ObjectMapper mapper;
    private ObjectMapper typeMapper;
    private static final String EP_BASE_API = "/ibm/iis/igc-rest/v1";
    private static final String EP_TYPES = "/ibm/iis/igc-rest/v1/types";
    private static final String EP_ASSET = "/ibm/iis/igc-rest/v1/assets";
    private static final String EP_SEARCH = "/ibm/iis/igc-rest/v1/search";
    private static final String EP_LOGOUT = "/ibm/iis/igc-rest/v1/logout";
    private static final String EP_BUNDLES = "/ibm/iis/igc-rest/v1/bundles";
    private static final String EP_BUNDLE_ASSETS = "/ibm/iis/igc-rest/v1/bundles/assets";

    public IGCRestClient(String host, String port, String user, String password) throws IGCConnectivityException {
        this("https://" + host + ":" + port, user, password);
    }

    public IGCRestClient(String baseURL, String user, String password) throws IGCConnectivityException {
        this(baseURL, IGCRestClient.encodeBasicAuth(user, password));
    }

    protected IGCRestClient(String baseURL, String authorization) throws IGCConnectivityException {
        if (baseURL == null || !baseURL.startsWith("https://")) {
            throw new IGCConnectivityException("Cannot instantiate IGCRestClient -- baseURL must be https.", baseURL);
        }
        this.baseURL = baseURL;
        this.authorization = authorization;
        this.mapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.typeMapper = new ObjectMapper();
        this.typeAndPropertyToAccessor = new HashMap();
        this.restTemplate = new RestTemplate();
        List converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        this.typesThatCanBeCreated = new HashSet<String>();
        this.typesThatIncludeModificationDetails = new HashSet<String>();
        this.typeToDisplayName = new HashMap<String, String>();
        this.typeToNonRelationshipProperties = new HashMap<String, List<String>>();
        this.typeToStringProperties = new HashMap<String, List<String>>();
        this.typeToAllProperties = new HashMap<String, List<String>>();
        this.typeToPagedRelationshipProperties = new HashMap<String, List<String>>();
        this.registeredTypes = new HashMap();
        this.typesThatIncludeModificationDetails.add("note");
        this.typeToDisplayName.put("note", "Note");
        this.typeToNonRelationshipProperties.put("note", Arrays.asList("note", "status", "subject", "type"));
        this.typeToStringProperties.put("note", Arrays.asList("note", "status", "subject", "type"));
        this.typeToAllProperties.put("note", Arrays.asList("belonging_to", "note", "status", "subject", "type"));
        this.typeToPagedRelationshipProperties.put("note", Arrays.asList("note", "status", "subject", "type"));
    }

    public boolean start() throws IGCConnectivityException, IGCParsingException {
        IGCSearch igcSearch = new IGCSearch("category");
        igcSearch.addType("term");
        igcSearch.addType("information_governance_policy");
        igcSearch.addType("information_governance_rule");
        igcSearch.setPageSize(1);
        igcSearch.setDevGlossary(true);
        String response = this.searchJson(igcSearch);
        log.debug("Checking for workflow and registering version...");
        ObjectMapper tmpMapper = new ObjectMapper();
        try {
            this.workflowEnabled = ((ItemList)tmpMapper.readValue(response, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<ItemList<Reference>>(){})).getPaging().getNumTotal() > 0;
        }
        catch (IOException e) {
            throw new IGCConnectivityException("Unable to determine if workflow is enabled.", e);
        }
        this.igcVersion = IGCVersionEnum.values()[0];
        List<TypeHeader> igcTypes = this.getTypes(tmpMapper);
        Set typeNames = igcTypes.stream().map(TypeHeader::getId).collect(Collectors.toSet());
        for (IGCVersionEnum aVersion : IGCVersionEnum.values()) {
            if (!aVersion.isHigherThan(this.igcVersion) || !typeNames.contains(aVersion.getTypeNameFirstAvailableInThisVersion()) || typeNames.contains(aVersion.getTypeNameNotAvailableInThisVersion())) continue;
            this.igcVersion = aVersion;
        }
        log.info("Detected IGC version: {}", (Object)this.igcVersion.getVersionString());
        return true;
    }

    private HttpHeaders getHttpHeaders(boolean forceLogin) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache");
        headers.add("Content-Type", "application/json");
        if (this.cookies != null && !forceLogin) {
            headers.addAll("Cookie", this.cookies);
        } else {
            String auth = "Basic " + this.authorization;
            headers.add("Authorization", auth);
        }
        return headers;
    }

    private ResponseEntity<String> openNewSessionWithRequest(String url, HttpMethod method, MediaType contentType, String payload, boolean alreadyTriedNewSession, Exception cause) throws IGCConnectivityException {
        if (alreadyTriedNewSession) {
            String formattedMessage = "Opening a new session already attempted without success -- giving up: " + method + " to " + url + " with: " + payload;
            throw new IGCConnectivityException(formattedMessage, cause);
        }
        this.cookies = null;
        return this.makeRequest(url, method, contentType, payload, true);
    }

    private ResponseEntity<String> openNewSessionWithUpload(String endpoint, HttpMethod method, AbstractResource file, boolean alreadyTriedNewSession, Exception cause) throws IGCConnectivityException {
        if (alreadyTriedNewSession) {
            String formattedMessage = "Opening a new session already attempted without success -- giving up: " + method + " to " + endpoint + " with: " + file.toString();
            throw new IGCConnectivityException(formattedMessage, cause);
        }
        log.info("Session appears to have timed out -- starting a new session and re-trying the upload.");
        this.cookies = null;
        return this.uploadFile(endpoint, method, file, true);
    }

    private void setCookiesFromResponse(ResponseEntity<String> response) throws IGCConnectivityException {
        if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.CREATED || response.getStatusCode() == HttpStatus.ACCEPTED) {
            List candidateCookies;
            HttpHeaders headers = response.getHeaders();
            if (headers.get((Object)"Set-Cookie") != null && (candidateCookies = headers.get((Object)"Set-Cookie")) != null) {
                this.cookies = new ArrayList<String>();
                for (String candidate : candidateCookies) {
                    String[] tokens = candidate.split("=");
                    if (tokens.length < 2) {
                        throw new IGCConnectivityException("An invalid cookie was found, which could present a security problem.", candidate);
                    }
                    String cookieName = tokens[0];
                    if (!IGCRestConstants.getValidCookieNames().contains(cookieName)) {
                        throw new IGCConnectivityException("An invalid cookie was found, which could present a security problem.", candidate);
                    }
                    Matcher m = IGCRestConstants.COOKIE_WHITELIST.matcher(candidate);
                    if (m.matches()) {
                        this.cookies.add(candidate);
                        continue;
                    }
                    throw new IGCConnectivityException("A cookie was found that has invalid characters and could therefore present a security problem.", candidate);
                }
            }
        } else {
            throw new IGCConnectivityException("Unable to make request or unexpected status.", response.getStatusCode().toString());
        }
    }

    public <T extends Reference> T readJSONIntoPOJO(String json) throws IGCParsingException {
        Reference reference;
        try {
            reference = (Reference)this.mapper.readValue(json, new com.fasterxml.jackson.core.type.TypeReference<T>(){});
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to translate JSON into POJO.", json, e);
        }
        return (T)reference;
    }

    public <T extends Reference> ItemList<T> readJSONIntoItemList(String json) throws IGCParsingException {
        ItemList itemList;
        try {
            itemList = (ItemList)this.mapper.readValue(json, new com.fasterxml.jackson.core.type.TypeReference<ItemList<T>>(){});
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to translate JSON into ItemList.", json, e);
        }
        return itemList;
    }

    public String getValueAsJSON(Reference asset) throws IGCParsingException {
        String payload;
        try {
            payload = this.mapper.writeValueAsString((Object)asset);
        }
        catch (JsonProcessingException e) {
            throw new IGCParsingException("Unable to translate asset into JSON.", asset.toString(), e);
        }
        return payload;
    }

    public IGCVersionEnum getIgcVersion() {
        return this.igcVersion;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int pageSize) {
        this.defaultPageSize = pageSize;
    }

    private static String encodeBasicAuth(String username, String password) {
        return Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public static boolean isVirtualAssetRid(String rid) {
        return rid == null || rid.startsWith("extern:");
    }

    public static boolean isEmbeddedAssetRid(String rid) {
        return rid == null || rid.startsWith("deflated:");
    }

    private ResponseEntity<String> uploadFile(String endpoint, HttpMethod method, AbstractResource file, boolean forceLogin) throws IGCConnectivityException {
        ResponseEntity<String> response;
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)file);
        HttpEntity toSend = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = this.baseURL + (endpoint.startsWith("/") ? endpoint : "/" + endpoint);
        try {
            response = this.restTemplate.exchange(url, method, toSend, String.class, new Object[0]);
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.Unauthorized e) {
            log.warn("Request failed -- session may have expired, retrying...", e);
            response = this.openNewSessionWithUpload(endpoint, method, file, forceLogin, (Exception)e);
        }
        catch (RestClientException e) {
            throw new IGCConnectivityException("Request failed -- check IGC environment connectivity and authentication details.", e);
        }
        return response;
    }

    public boolean uploadFile(String endpoint, HttpMethod method, AbstractResource file) throws IGCConnectivityException {
        ResponseEntity<String> response = this.uploadFile(endpoint, method, file, false);
        return response != null && response.getStatusCode() == HttpStatus.OK;
    }

    private ResponseEntity<String> makeRequest(String url, HttpMethod method, MediaType contentType, String payload, boolean forceLogin) throws IGCConnectivityException {
        ResponseEntity response;
        HttpEntity toSend;
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        if (payload != null) {
            headers.setContentType(contentType);
            toSend = new HttpEntity((Object)payload, (MultiValueMap)headers);
        } else {
            toSend = new HttpEntity((MultiValueMap)headers);
        }
        try {
            log.debug("{}ing to {} with: {}", new Object[]{method, url, payload});
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)url).build(true);
            response = this.restTemplate.exchange(uriComponents.toUri(), method, toSend, String.class);
            this.setCookiesFromResponse((ResponseEntity<String>)response);
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.Unauthorized e) {
            log.warn("Request failed -- session may have expired, retrying...", e);
            response = this.openNewSessionWithRequest(url, method, contentType, payload, forceLogin, (Exception)e);
        }
        catch (RestClientException e) {
            throw new IGCConnectivityException("Request failed -- check IGC environment connectivity and authentication details.", e);
        }
        return response;
    }

    public String makeRequest(String endpoint, HttpMethod method, MediaType contentType, String payload) throws IGCConnectivityException {
        ResponseEntity<String> response = this.makeRequest(this.baseURL + (endpoint.startsWith("/") ? endpoint : "/" + endpoint), method, contentType, payload, false);
        String body = null;
        if (response == null) {
            String formattedMessage = method + " to " + endpoint + " with: " + payload;
            throw new IGCConnectivityException("Unable to complete request -- check IGC environment connectivity and authentication details.", formattedMessage);
        }
        if (response.hasBody()) {
            body = (String)response.getBody();
        }
        return body;
    }

    public String makeCreateRequest(String endpoint, HttpMethod method, MediaType contentType, String payload) throws IGCConnectivityException {
        ResponseEntity<String> response = this.makeRequest(this.baseURL + (endpoint.startsWith("/") ? endpoint : "/" + endpoint), method, contentType, payload, false);
        String rid = null;
        if (response == null) {
            String formattedMessage = method + " to " + endpoint + " with: " + payload;
            throw new IGCConnectivityException("Unable to create instance -- check IGC environment connectivity and authentication details.", formattedMessage);
        }
        if (!response.getStatusCode().equals((Object)HttpStatus.CREATED)) {
            String formattedMessage = method + " to " + endpoint + " with: " + payload;
            throw new IGCConnectivityException("Instance creation failed -- check IGC environment connectivity and authentication details.", formattedMessage);
        }
        HttpHeaders headers = response.getHeaders();
        List instanceURLs = headers.get((Object)"Location");
        if (instanceURLs != null && instanceURLs.size() == 1) {
            String instanceURL = (String)instanceURLs.get(0);
            rid = instanceURL.substring(instanceURL.lastIndexOf("/") + 1);
        }
        return rid;
    }

    public List<TypeHeader> getTypes(ObjectMapper objectMapper) throws IGCConnectivityException, IGCParsingException {
        List alTypes;
        String response = this.makeRequest(EP_TYPES, HttpMethod.GET, null, null);
        try {
            alTypes = (List)objectMapper.readValue(response, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<List<TypeHeader>>(){});
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to parse types response.", response, e);
        }
        return alTypes;
    }

    public TypeDetails getTypeDetails(String typeName) throws IGCConnectivityException, IGCParsingException {
        return this.getTypeDetails(typeName, true, true, true);
    }

    public TypeDetails getTypeDetails(String typeName, boolean view, boolean create, boolean edit) throws IGCConnectivityException, IGCParsingException {
        TypeDetails typeDetails;
        String response = this.makeRequest("/ibm/iis/igc-rest/v1/types/" + typeName + "?showViewProperties=" + view + "&showCreateProperties=" + create + "&showEditProperties=" + edit, HttpMethod.GET, null, null);
        try {
            typeDetails = (TypeDetails)this.typeMapper.readValue(response, TypeDetails.class);
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to parse type details response.", response, e);
        }
        return typeDetails;
    }

    public Reference getAssetById(String rid) throws IGCConnectivityException, IGCParsingException {
        return this.getAssetById(rid, null);
    }

    public Reference getAssetById(String rid, ObjectCache cache) throws IGCConnectivityException, IGCParsingException {
        Reference result = null;
        if (cache != null) {
            result = cache.get(rid);
        }
        if (result == null) {
            String url = "/ibm/iis/igc-rest/v1/assets/" + IGCRestClient.getEncodedPathVariable(rid);
            String response = this.makeRequest(url, HttpMethod.GET, null, null);
            result = this.readJSONIntoPOJO(response);
        }
        return result;
    }

    public static String getEncodedPathVariable(String pathVariable) {
        return UriUtils.encode((String)pathVariable, (String)"UTF-8");
    }

    public Reference getAssetRefById(String rid) throws IGCConnectivityException, IGCParsingException {
        IGCSearchCondition condition = new IGCSearchCondition("_id", "=", rid);
        IGCSearchConditionSet conditionSet = new IGCSearchConditionSet(condition);
        IGCSearch igcSearch = new IGCSearch("main_object", conditionSet);
        igcSearch.addType("classification");
        igcSearch.addType("label");
        igcSearch.addType("user");
        igcSearch.addType("group");
        ItemList results = this.search(igcSearch);
        Reference reference = null;
        if (results.getPaging().getNumTotal() > 0) {
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple assets for RID {}, taking only the first.", (Object)rid);
            }
            reference = (Reference)results.getItems().get(0);
        }
        return reference;
    }

    public <T extends Reference> T getAssetWithSubsetOfProperties(String rid, String assetType, List<String> properties) throws IGCConnectivityException, IGCParsingException {
        return this.getAssetWithSubsetOfProperties(rid, assetType, properties, this.defaultPageSize);
    }

    public <T extends Reference> T getAssetWithSubsetOfProperties(String rid, String assetType, String[] properties) throws IGCConnectivityException, IGCParsingException {
        return this.getAssetWithSubsetOfProperties(rid, assetType, properties, this.defaultPageSize);
    }

    public <T extends Reference> T getAssetWithSubsetOfProperties(String rid, String assetType, String[] properties, int pageSize) throws IGCConnectivityException, IGCParsingException {
        return this.getAssetWithSubsetOfProperties(rid, assetType, Arrays.asList(properties), pageSize);
    }

    public <T extends Reference> T getAssetWithSubsetOfProperties(String rid, String assetType, List<String> properties, int pageSize) throws IGCConnectivityException, IGCParsingException {
        ItemList<T> assetsWithProperties;
        if (IGCRestConstants.getTypesThatCannotBeSearched().contains(assetType)) {
            log.debug("Retrieving full asset {}, as it cannot be searched to retrieve only a subset of properties.", (Object)rid);
            Reference full = this.getAssetById(rid);
            return (T)full;
        }
        log.debug("Retrieving asset {} with subset of details: {}", (Object)rid, properties);
        Reference assetWithProperties = null;
        IGCSearchCondition idOnly = new IGCSearchCondition("_id", "=", rid);
        IGCSearchConditionSet idOnlySet = new IGCSearchConditionSet(idOnly);
        IGCSearch igcSearch = new IGCSearch(IGCRestConstants.getAssetTypeForSearch(assetType), properties, idOnlySet);
        if (pageSize > 0) {
            igcSearch.setPageSize(pageSize);
        }
        if (!(assetsWithProperties = this.search(igcSearch)).getItems().isEmpty()) {
            assetWithProperties = (Reference)assetsWithProperties.getItems().get(0);
        }
        return (T)assetWithProperties;
    }

    private String searchJson(IGCSearch igcSearch) throws IGCConnectivityException {
        return this.makeRequest(EP_SEARCH, HttpMethod.POST, MediaType.APPLICATION_JSON, igcSearch.getQuery().toString());
    }

    public <T extends Reference> ItemList<T> search(IGCSearch igcSearch) throws IGCConnectivityException, IGCParsingException {
        ItemList itemList;
        String results = this.searchJson(igcSearch);
        try {
            itemList = (ItemList)this.mapper.readValue(results, new com.fasterxml.jackson.core.type.TypeReference<ItemList<T>>(){});
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to translate JSON results.", results, e);
        }
        return itemList;
    }

    private String updateJson(String rid, JsonNode value) throws IGCConnectivityException {
        return this.makeRequest("/ibm/iis/igc-rest/v1/assets/" + rid, HttpMethod.PUT, MediaType.APPLICATION_JSON, value.toString());
    }

    public boolean update(IGCUpdate igcUpdate) throws IGCConnectivityException {
        String result = this.updateJson(igcUpdate.getRidToUpdate(), igcUpdate.getUpdate());
        return result != null;
    }

    private String createJson(JsonNode value) throws IGCConnectivityException {
        return this.makeCreateRequest(EP_ASSET, HttpMethod.POST, MediaType.APPLICATION_JSON, value.toString());
    }

    public String create(IGCCreate igcCreate) throws IGCConnectivityException {
        return this.createJson(igcCreate.getCreate());
    }

    private String deleteJson(String rid) throws IGCConnectivityException {
        return this.makeRequest("/ibm/iis/igc-rest/v1/assets/" + rid, HttpMethod.DELETE, MediaType.APPLICATION_JSON, null);
    }

    public boolean delete(String rid) throws IGCConnectivityException {
        String result = this.deleteJson(rid);
        if (result != null) {
            throw new IGCConnectivityException("Unable to delete asset.", rid);
        }
        return true;
    }

    public boolean detectLineage(String jobRid) throws IGCConnectivityException {
        ResponseEntity<String> response = this.makeRequest(this.baseURL + EP_BASE_API + "/flows/detectFlows/dsjob/" + jobRid, HttpMethod.GET, MediaType.APPLICATION_JSON, null, false);
        if (response != null) {
            return response.getStatusCode() == HttpStatus.ACCEPTED;
        }
        return false;
    }

    public boolean upsertOpenIgcBundle(String name, AbstractResource file) throws IGCConnectivityException, IGCParsingException {
        List<String> existingBundles = this.getOpenIgcBundles();
        boolean success = existingBundles.contains(name) ? this.uploadFile(EP_BUNDLES, HttpMethod.PUT, file) : this.uploadFile(EP_BUNDLES, HttpMethod.POST, file);
        return success;
    }

    public File createOpenIgcBundleFile(File directory) throws IGCIOException {
        File bundle;
        try {
            bundle = File.createTempFile("openigc", "zip");
        }
        catch (IOException e) {
            throw new IGCIOException("Unable to create temporary file needed for OpenIGC bundle from directory.", directory.getName(), e);
        }
        try (FileOutputStream bundleOut = new FileOutputStream(bundle);
             ZipOutputStream zipOutput = new ZipOutputStream(bundleOut);){
            if (!directory.isDirectory()) {
                throw new IGCIOException("Provided bundle location is not a directory.", directory.getName(), null);
            }
            this.recursivelyZipFiles(directory, "", zipOutput);
        }
        catch (IOException e) {
            throw new IGCIOException("Unable to create temporary file needed for OpenIGC bundle from directory.", directory.getName(), e);
        }
        return bundle;
    }

    private void recursivelyZipFiles(File file, String name, ZipOutputStream zipOutput) throws IGCIOException {
        block23: {
            if (file.isDirectory()) {
                String directoryName = name;
                if (directoryName.length() != 0) {
                    directoryName = directoryName.endsWith(File.separator) ? directoryName : directoryName + File.separator;
                }
                try {
                    File[] files;
                    if (directoryName.length() != 0) {
                        zipOutput.putNextEntry(new ZipEntry(directoryName));
                    }
                    if ((files = file.listFiles()) != null) {
                        for (File subFile : files) {
                            this.recursivelyZipFiles(subFile, directoryName + subFile.getName(), zipOutput);
                        }
                        break block23;
                    }
                    throw new IGCIOException("No files found for the bundle, cannot create.", file.getCanonicalPath(), null);
                }
                catch (IOException e) {
                    throw new IGCIOException("Unable to create directory entry in zip file for directory.", directoryName, e);
                }
            }
            try (FileInputStream fileInput = new FileInputStream(file);){
                int length;
                zipOutput.putNextEntry(new ZipEntry(name));
                byte[] buffer = new byte[1024];
                while ((length = fileInput.read(buffer)) >= 0) {
                    zipOutput.write(buffer, 0, length);
                }
            }
            catch (FileNotFoundException e) {
                throw new IGCIOException("Unable to find file.", file.getName(), e);
            }
            catch (IOException e) {
                throw new IGCIOException("Unable to read/write file.", file.getName(), e);
            }
        }
    }

    public List<String> getOpenIgcBundles() throws IGCConnectivityException, IGCParsingException {
        String bundles = this.makeRequest(EP_BUNDLES, HttpMethod.GET, null, null);
        ArrayList<String> alBundles = new ArrayList<String>();
        try {
            ArrayNode anBundles = (ArrayNode)this.mapper.readValue(bundles, ArrayNode.class);
            for (int i = 0; i < anBundles.size(); ++i) {
                alBundles.add(anBundles.get(i).asText());
            }
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to parse bundle response.", bundles, e);
        }
        return alBundles;
    }

    public String upsertOpenIgcAsset(String assetXML) throws IGCConnectivityException {
        return this.makeRequest(EP_BUNDLE_ASSETS, HttpMethod.POST, MediaType.APPLICATION_XML, assetXML);
    }

    public boolean deleteOpenIgcAsset(String assetXML) throws IGCConnectivityException {
        return this.makeRequest(EP_BUNDLE_ASSETS, HttpMethod.DELETE, MediaType.APPLICATION_XML, assetXML) == null;
    }

    public <T extends Reference> ItemList<T> getNextPage(String propertyName, ItemList<T> list) throws IGCConnectivityException, IGCParsingException {
        return this.getNextPage(propertyName, list.getPaging());
    }

    public <T extends Reference> List<T> getAllPages(String propertyName, ItemList<T> list) throws IGCConnectivityException, IGCParsingException {
        if (list != null) {
            return this.getAllPages(propertyName, list.getItems(), list.getPaging());
        }
        return Collections.emptyList();
    }

    private <T extends Reference> ItemList<T> getNextPage(String propertyName, Paging paging) throws IGCConnectivityException, IGCParsingException {
        ItemList nextPage = null;
        try {
            nextPage = (ItemList)this.mapper.readValue("{}", new com.fasterxml.jackson.core.type.TypeReference<ItemList<T>>(){});
            String sNextURL = paging.getNextPageURL();
            if (sNextURL != null && !sNextURL.equals("null")) {
                String requestUrl;
                if (this.workflowEnabled.booleanValue() && !sNextURL.contains("workflowMode=draft")) {
                    sNextURL = sNextURL + "&workflowMode=draft";
                }
                if (sNextURL.startsWith("extern:")) {
                    requestUrl = "/ibm/iis/igc-rest/v1/assets/" + IGCRestClient.getEncodedPathVariable(sNextURL) + "/" + IGCRestClient.getEncodedPathVariable(propertyName) + "?begin=" + (paging.getEndIndex() + 1) + "&pageSize=" + paging.getPageSize();
                } else {
                    UriComponents components = UriComponentsBuilder.fromHttpUrl((String)sNextURL).build(true);
                    String embeddedHost = "https://" + components.getHost() + ":" + components.getPort();
                    requestUrl = sNextURL.substring(embeddedHost.length() + 1);
                }
                String nextPageBody = this.makeRequest(requestUrl, HttpMethod.GET, null, null);
                if (requestUrl.startsWith(EP_ASSET)) {
                    String remainder = requestUrl.substring(EP_ASSET.length() + 1);
                    String attributeName = remainder.substring(remainder.indexOf(47) + 1, remainder.indexOf(63));
                    nextPageBody = nextPageBody.substring(attributeName.length() + 4, nextPageBody.length() - 1);
                }
                nextPage = (ItemList)this.mapper.readValue(nextPageBody, new com.fasterxml.jackson.core.type.TypeReference<ItemList<T>>(){});
            }
        }
        catch (IOException e) {
            throw new IGCParsingException("Unable to parse next page from JSON.", paging.toString(), e);
        }
        return nextPage;
    }

    private <T extends Reference> List<T> getAllPages(String propertyName, List<T> items, Paging paging) throws IGCConnectivityException, IGCParsingException {
        List<T> allPages = items;
        ItemList<T> results = this.getNextPage(propertyName, paging);
        List<T> resultsItems = results.getItems();
        if (!resultsItems.isEmpty()) {
            resultsItems.addAll(allPages);
            allPages = this.getAllPages(propertyName, resultsItems, results.getPaging());
        }
        return allPages;
    }

    public void disconnect() throws IGCConnectivityException {
        this.makeRequest(EP_LOGOUT, HttpMethod.GET, null, null);
    }

    public void cacheTypeDetails(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        if (typeName != null && !this.typeToDisplayName.containsKey(typeName)) {
            List<TypeProperty> view;
            List<TypeProperty> create;
            TypeDetails typeDetails = this.getTypeDetails(typeName);
            if (typeDetails.getCreateInfo() != null && (create = typeDetails.getCreateInfo().getProperties()) != null && !create.isEmpty()) {
                this.typesThatCanBeCreated.add(typeName);
            }
            if ((view = typeDetails.getViewInfo().getProperties()) != null) {
                TreeSet<String> allProperties = new TreeSet<String>();
                TreeSet<String> nonRelationship = new TreeSet<String>();
                TreeSet<String> stringProperties = new TreeSet<String>();
                TreeSet<String> pagedRelationship = new TreeSet<String>();
                for (TypeProperty property : view) {
                    TypeReference type;
                    String propertyType;
                    DynamicPropertyReader reader;
                    String propertyName = property.getName();
                    if (propertyName == null || (reader = this.getAccessor(typeName, propertyName)) == null || IGCRestConstants.getPropertiesToIgnore().contains(propertyName)) continue;
                    if (propertyName.equals("created_on")) {
                        this.typesThatIncludeModificationDetails.add(typeName);
                    }
                    if ((propertyType = (type = property.getType()).getName()).equals("string") || propertyType.equals("enum")) {
                        stringProperties.add(propertyName);
                        nonRelationship.add(propertyName);
                    } else if (type.getUrl() != null || propertyType.equals("note")) {
                        if (property.getMaxCardinality() < 0) {
                            pagedRelationship.add(propertyName);
                        }
                    } else {
                        nonRelationship.add(propertyName);
                    }
                    allProperties.add(propertyName);
                }
                this.typeToAllProperties.put(typeName, new ArrayList(allProperties));
                this.typeToNonRelationshipProperties.put(typeName, new ArrayList(nonRelationship));
                this.typeToStringProperties.put(typeName, new ArrayList(stringProperties));
                this.typeToPagedRelationshipProperties.put(typeName, new ArrayList(pagedRelationship));
            }
            this.typeToDisplayName.put(typeName, typeDetails.getName());
        }
    }

    public String getDisplayNameForType(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typeToDisplayName.getOrDefault(typeName, null);
        }
        return null;
    }

    public boolean isCreatable(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typesThatCanBeCreated.contains(typeName);
        }
        return false;
    }

    public boolean hasModificationDetails(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typesThatIncludeModificationDetails.contains(typeName);
        }
        return false;
    }

    public List<String> getAllPropertiesForType(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typeToAllProperties.getOrDefault(typeName, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public List<String> getNonRelationshipPropertiesForType(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typeToNonRelationshipProperties.getOrDefault(typeName, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public List<String> getAllStringPropertiesForType(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typeToStringProperties.getOrDefault(typeName, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public List<String> getPagedRelationshipPropertiesForType(String typeName) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.cacheTypeDetails(typeName);
        if (typeName != null) {
            return this.typeToPagedRelationshipProperties.getOrDefault(typeName, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public void registerPOJO(Class<?> clazz) throws IGCIOException {
        JsonTypeName typeName = clazz.getAnnotation(JsonTypeName.class);
        if (typeName == null) {
            throw new IGCIOException("Unable to find JsonTypeName annotation to identify type in POJO.", clazz.getCanonicalName(), null);
        }
        String typeId = typeName.value();
        this.mapper.registerSubtypes(new Class[]{clazz});
        this.registeredTypes.put(typeId, clazz);
        log.info("Registered IGC type {} to be handled by POJO: {}", (Object)typeId, (Object)clazz.getCanonicalName());
    }

    public Class<?> getPOJOForType(String assetType) throws IGCIOException {
        Class<?> igcPOJO = this.registeredTypes.getOrDefault(assetType, null);
        if (igcPOJO == null) {
            StringBuilder sbPojoName = new StringBuilder();
            sbPojoName.append("org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base");
            sbPojoName.append(".");
            sbPojoName.append(IGCRestConstants.getClassNameForAssetType(assetType));
            try {
                igcPOJO = Class.forName(sbPojoName.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IGCIOException("Unable to find POJO class.", sbPojoName.toString(), e);
            }
        }
        return igcPOJO;
    }

    public Boolean isWorkflowEnabled() {
        return this.workflowEnabled;
    }

    private String getDynamicPropertyKey(String typeName, String propertyName) {
        return typeName + "$" + propertyName;
    }

    private DynamicPropertyReader getAccessor(String type, String property) throws IGCIOException {
        String key = this.getDynamicPropertyKey(type, property);
        if (!this.typeAndPropertyToAccessor.containsKey(key)) {
            try {
                DynamicPropertyReader reader = new DynamicPropertyReader(this.getPOJOForType(type), property);
                this.typeAndPropertyToAccessor.put(key, reader);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to setup an accessor for property '{}' on type '{}' - this property will be entirely ignored. If this is a custom property, see https://github.com/odpi/egeria-connector-ibm-information-server/tree/master/igc-clientlibrary#using-your-own-asset-types for how to add your own properties.", new Object[]{property, type, e});
                this.typeAndPropertyToAccessor.put(key, null);
            }
        }
        return this.typeAndPropertyToAccessor.getOrDefault(key, null);
    }

    public Object getPropertyByName(Reference object, String property) throws IGCIOException {
        if (object != null) {
            DynamicPropertyReader accessor = this.getAccessor(object.getType(), property);
            if (accessor != null) {
                return accessor.getProperty(object);
            }
            String formattedMessage = object.getType() + "::" + property;
            throw new IGCIOException("Unable to find accessor for object type and property.", formattedMessage, null);
        }
        return null;
    }

    public <T extends Reference> T getModificationDetails(T object, ObjectCache cache) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        return this.getAssetContext(object, true, cache);
    }

    private <T extends Reference> T getAssetContext(T object, boolean bPopulateModDetails, ObjectCache cache) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        Object populated = object;
        if (object != null) {
            String rid = object.getId();
            Reference fromCache = cache.get(rid);
            if (fromCache == null) {
                boolean bHasModificationDetails = this.hasModificationDetails(object.getType());
                if (!object.isIdentityPopulated() && (object.getContext() == null || object.getContext().isEmpty()) || bHasModificationDetails && !object.areModificationDetailsPopulated() && bPopulateModDetails) {
                    log.debug("Context and / or modification details are empty, and not found in cache; populating...");
                    String assetType = object.getType();
                    if (object.isVirtualAsset() || object.isEmbeddedAsset() || IGCRestConstants.getTypesThatCannotBeSearched().contains(assetType)) {
                        populated = this.getAssetById(rid);
                    } else {
                        ArrayList<String> properties = new ArrayList<String>();
                        if (bHasModificationDetails) {
                            properties.addAll(IGCRestConstants.getModificationProperties());
                        }
                        populated = this.getAssetWithSubsetOfProperties(rid, assetType, properties, 2);
                    }
                    cache.add((Reference)populated);
                }
            } else {
                populated = fromCache;
            }
        }
        return populated;
    }
}

