/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeReference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;

public class IGCRestConstants {
    public static final String NON_IGC_PREFIX = "_";
    public static final String MOD_CREATED_BY = "created_by";
    public static final String MOD_CREATED_ON = "created_on";
    public static final String MOD_MODIFIED_BY = "modified_by";
    public static final String MOD_MODIFIED_ON = "modified_on";
    public static final Pattern NAMING_CHAR_WHITELIST = Pattern.compile("[^a-zA-Z0-9_]");
    public static final Pattern COOKIE_WHITELIST = Pattern.compile("^[{}.+/=:;,\" a-zA-Z0-9_%\\-]+$");
    public static final String IGC_REST_COMMON_MODEL_PKG = "org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common";
    public static final String IGC_REST_BASE_MODEL_PKG = "org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base";
    private static final IGCSearchCondition NO_RESULTS_CONDITION = new IGCSearchCondition("_id", "=", "NONEXISTENT");
    public static final String NOTE = "note";
    public static final String MAIN_OBJECT = "main_object";
    public static final String INFORMATION_ASSET = "information_asset";
    private static final String NON_STEWARD_USER = "non_steward_user";
    private static final String STEWARD_USER = "steward_user";
    private static final String XSD_ELEMENT = "xsd_element";
    private static final String XSD_UNIQUE_KEY = "xsd_unique_key";
    private static final String BI_REPORT = "bi_report";
    private static final String GROUP = "group";
    private static final String DATA_RULE_DEFINITION = "data_rule_definition";
    private static final String DATA_RULE_SET_DEFINITION = "data_rule_set_definition";
    private static final String STAGE_COLUMN = "stage_column";
    private static final String REFERENCE = "reference";
    private static final String DATAGROUP = "datagroup";
    public static final String CLASSIFICATIONENABLEDGROUP = "classificationenabledgroup";
    private static final Set<String> VALID_COOKIE_NAMES = IGCRestConstants.createValidCookieNames();
    private static final Set<String> DATASTAGE_SPECIFIC_TYPES = IGCRestConstants.createDataStageSpecificTypes();
    private static final Set<String> TYPES_THAT_CANNOT_BE_SEARCHED = IGCRestConstants.createTypesThatCannotBeSearched();
    private static final List<String> MODIFICATION_DETAILS = IGCRestConstants.createModificationDetails();
    private static final Map<String, String> NON_UNIQUE_CLASSNAMES = IGCRestConstants.createNonUniqueClassnames();
    private static final List<String> FILE_TYPES = IGCRestConstants.createFileTypes();
    private static final List<String> USER_TYPES = IGCRestConstants.createUserTypes();
    private static final Map<String, String> IMAM_TYPE_TO_IGC_TYPE = IGCRestConstants.createImamTypetoIgcType();
    private static final Set<String> RELATIONSHIP_LEVEL_TYPES = IGCRestConstants.createRelationshipLevelTypes();
    private static final Set<String> QUALIFY_PROPERTIES = IGCRestConstants.createQualifyProperties();
    private static final Map<String, String> BASIC_TYPE_TO_JAVA_TYPE = IGCRestConstants.createBasicTypeToJavaType();
    private static final Set<String> IGNORE_PROPERTIES = IGCRestConstants.createIgnoreProperties();
    private static final Set<String> IGNORE_TYPES = IGCRestConstants.createIgnoreTypes();
    private static final List<String> SUPER_TYPES = IGCRestConstants.createSuperTypes();
    private static final Map<String, String> SUB_TYPE_TO_SUPER_TYPE = IGCRestConstants.createSubTypeToSuperType();
    private static final Set<String> FIXED_MAIN_OBJECT_PROPERTIES = IGCRestConstants.createFixedMainObjectProperties();
    private static final Set<String> FIXED_INFORMATION_ASSET_PROPERTIES = IGCRestConstants.createFixedInformationAssetProperties();

    private static Set<String> createValidCookieNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("LtpaToken2");
        set.add("IIS-LtpaToken2");
        set.add("JSESSIONID");
        set.add("IIS-JSESSIONID");
        set.add("X-IBM-IISSessionId");
        set.add("X-IBM-IISSessionToken");
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> createDataStageSpecificTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("dsjob");
        set.add("stage");
        set.add("link");
        set.add("stage_variable");
        set.add(STAGE_COLUMN);
        set.add("ds_stage_column");
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> createTypesThatCannotBeSearched() {
        HashSet<String> set = new HashSet<String>();
        set.add(NOTE);
        return Collections.unmodifiableSet(set);
    }

    private static List<String> createModificationDetails() {
        ArrayList<String> modDetails = new ArrayList<String>();
        modDetails.add(MOD_CREATED_BY);
        modDetails.add(MOD_CREATED_ON);
        modDetails.add(MOD_MODIFIED_BY);
        modDetails.add(MOD_MODIFIED_ON);
        return Collections.unmodifiableList(modDetails);
    }

    private static Map<String, String> createNonUniqueClassnames() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("valid_value_list", "ValidValueList");
        map.put("validvaluelist", "ValidValueList2");
        map.put("valid_value_range", "ValidValueRange");
        map.put("validvaluerange", "ValidValueRange2");
        map.put("parameter_set", "ParameterSet");
        map.put("parameterset", "ParameterSet2");
        map.put("function_call", "FunctionCall");
        map.put("functioncall", "FunctionCall2");
        return Collections.unmodifiableMap(map);
    }

    private static List<String> createFileTypes() {
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("data_file_field");
        fileTypes.add("data_file_record");
        fileTypes.add("data_file");
        fileTypes.add("data_file_folder");
        return Collections.unmodifiableList(fileTypes);
    }

    private static List<String> createUserTypes() {
        ArrayList<String> userTypes = new ArrayList<String>();
        userTypes.add("user");
        userTypes.add(NON_STEWARD_USER);
        userTypes.add(STEWARD_USER);
        return Collections.unmodifiableList(userTypes);
    }

    private static Map<String, String> createImamTypetoIgcType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("HostSystem", "host");
        map.put("DataConnection", "data_connection");
        map.put("DataFileFolder", "data_file_folder");
        map.put("DataFile", "data_file");
        map.put("DataCollection_in_DataFile", "data_file_record");
        map.put("DataField_in_DataFile", "data_file_field");
        map.put("Database", "database");
        map.put("DataSchema", "database_schema");
        map.put("DataCollection_in_Database", "database_table");
        map.put("DataField_in_Database", "database_column");
        return Collections.unmodifiableMap(map);
    }

    private static Set<String> createRelationshipLevelTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("classification");
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> createQualifyProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("name");
        set.add("type");
        set.add("url");
        set.add("id");
        set.add("context");
        return Collections.unmodifiableSet(set);
    }

    private static Map<String, String> createBasicTypeToJavaType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("string", "String");
        map.put("boolean", "Boolean");
        map.put("datetime", "Date");
        map.put("number", "Number");
        map.put("enum", "String");
        return Collections.unmodifiableMap(map);
    }

    private static Set<String> createIgnoreProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(null);
        set.add("null");
        set.add("assigned_external_assets");
        set.add("implemented_by_external_assets");
        set.add("governs_external_assets");
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> createIgnoreTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("referenced_container");
        return Collections.unmodifiableSet(set);
    }

    private static List<String> createSuperTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(MAIN_OBJECT);
        list.add(INFORMATION_ASSET);
        list.add("host");
        list.add("stage_type");
        list.add(DATAGROUP);
        list.add("data_item");
        list.add("data_item_definition");
        list.add("data_field");
        list.add(CLASSIFICATIONENABLEDGROUP);
        list.add("reportobject");
        list.add("dsjob");
        list.add("user");
        list.add(XSD_ELEMENT);
        list.add(XSD_UNIQUE_KEY);
        list.add(BI_REPORT);
        list.add(GROUP);
        list.add(DATA_RULE_DEFINITION);
        list.add(DATA_RULE_SET_DEFINITION);
        list.add(STAGE_COLUMN);
        return Collections.unmodifiableList(list);
    }

    private static Map<String, String> createSubTypeToSuperType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MAIN_OBJECT, REFERENCE);
        map.put("user", REFERENCE);
        map.put(GROUP, REFERENCE);
        map.put(XSD_UNIQUE_KEY, REFERENCE);
        map.put("data_policy", MAIN_OBJECT);
        map.put("host_(engine)", "host");
        map.put("host", INFORMATION_ASSET);
        map.put("Rule_Execution_Result", INFORMATION_ASSET);
        map.put("customattributedef", INFORMATION_ASSET);
        map.put("stage_type", INFORMATION_ASSET);
        map.put(XSD_ELEMENT, INFORMATION_ASSET);
        map.put(BI_REPORT, INFORMATION_ASSET);
        map.put(DATA_RULE_DEFINITION, INFORMATION_ASSET);
        map.put(DATA_RULE_SET_DEFINITION, INFORMATION_ASSET);
        map.put("dsstage_type", "stage_type");
        map.put(INFORMATION_ASSET, MAIN_OBJECT);
        map.put("database_alias", DATAGROUP);
        map.put("database_table", DATAGROUP);
        map.put("data_file_record", DATAGROUP);
        map.put("view", DATAGROUP);
        map.put("design_table", DATAGROUP);
        map.put("design_view", DATAGROUP);
        map.put("stored_procedure", DATAGROUP);
        map.put("design_stored_procedure", DATAGROUP);
        map.put(DATAGROUP, INFORMATION_ASSET);
        map.put(STAGE_COLUMN, "data_item");
        map.put("ds_stage_column", STAGE_COLUMN);
        map.put("parameter", "data_item");
        map.put("routine_argument", "data_item");
        map.put("stage_type_detail", "data_item");
        map.put("transform_argument", "data_item");
        map.put("data_item", INFORMATION_ASSET);
        map.put("data_element", "data_item_definition");
        map.put("table_definition", "data_item_definition");
        map.put("data_item_definition", "data_item");
        map.put("column_definition", "data_field");
        map.put("data_field", "data_item");
        map.put("database_column", CLASSIFICATIONENABLEDGROUP);
        map.put("data_file_field", CLASSIFICATIONENABLEDGROUP);
        map.put("amazon_s3_data_file_field", CLASSIFICATIONENABLEDGROUP);
        map.put(CLASSIFICATIONENABLEDGROUP, "data_field");
        map.put("bi_report_query_item", "reportobject");
        map.put("reportobject", INFORMATION_ASSET);
        map.put("sequence_job", "dsjob");
        map.put("dsjob", INFORMATION_ASSET);
        map.put(NON_STEWARD_USER, "user");
        map.put(STEWARD_USER, "user");
        map.put("xsd_choice", XSD_ELEMENT);
        map.put("xsd_sequence", XSD_ELEMENT);
        map.put("xsd_primary_key", XSD_UNIQUE_KEY);
        map.put("bi_report_nocontext", BI_REPORT);
        map.put("bi_report_nofolder", BI_REPORT);
        map.put("user_group", GROUP);
        map.put("steward_group", GROUP);
        map.put("published_data_rule_definition", DATA_RULE_DEFINITION);
        map.put("non_published_data_rule_definition", DATA_RULE_DEFINITION);
        map.put("published_data_rule_set", DATA_RULE_SET_DEFINITION);
        map.put("non_published_data_rule_set", DATA_RULE_SET_DEFINITION);
        return Collections.unmodifiableMap(map);
    }

    private static Set<String> createFixedMainObjectProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("assigned_to_terms");
        set.add("governed_by_rules");
        set.add("implements_rules");
        set.add("labels");
        set.add("long_description");
        set.add("name");
        set.add("short_description");
        set.add("stewards");
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> createFixedInformationAssetProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("blueprint_elements");
        set.add("impacted_by");
        set.add("impacts_on");
        set.add("in_collections");
        set.add("native_id");
        set.add("notes");
        set.add("read_by_(design)");
        set.add("read_by_(operational)");
        set.add("read_by_(static)");
        set.add("read_by_(user_defined)");
        set.add("written_by_(design)");
        set.add("written_by_(operational)");
        set.add("written_by_(static)");
        set.add("written_by_(user_defined)");
        return Collections.unmodifiableSet(set);
    }

    public static Set<String> getValidCookieNames() {
        return VALID_COOKIE_NAMES;
    }

    public static Set<String> getDatastageSpecificTypes() {
        return DATASTAGE_SPECIFIC_TYPES;
    }

    public static Set<String> getTypesThatCannotBeSearched() {
        return TYPES_THAT_CANNOT_BE_SEARCHED;
    }

    public static List<String> getModificationProperties() {
        return MODIFICATION_DETAILS;
    }

    public static List<String> getFileTypes() {
        return FILE_TYPES;
    }

    public static List<String> getUserTypes() {
        return USER_TYPES;
    }

    public static Map<String, String> getImamTypeToIgcType() {
        return IMAM_TYPE_TO_IGC_TYPE;
    }

    public static Set<String> getRelationshipLevelTypes() {
        return RELATIONSHIP_LEVEL_TYPES;
    }

    public static Set<String> getPropertiesToIgnore() {
        return IGNORE_PROPERTIES;
    }

    public static List<String> getSuperTypes() {
        return SUPER_TYPES;
    }

    public static Map<String, String> getSubTypeToSuperType() {
        return SUB_TYPE_TO_SUPER_TYPE;
    }

    public static Set<String> getFixedMainObjectProperties() {
        return FIXED_MAIN_OBJECT_PROPERTIES;
    }

    public static Set<String> getFixedInformationAssetProperties() {
        return FIXED_INFORMATION_ASSET_PROPERTIES;
    }

    public static String getJavaTypeForProperty(TypeProperty property) {
        String type;
        TypeReference typeReference = property.getType();
        String nominalType = type = typeReference.getName();
        if (typeReference.getUrl() != null) {
            nominalType = "Reference";
        } else if (BASIC_TYPE_TO_JAVA_TYPE.containsKey(type)) {
            nominalType = BASIC_TYPE_TO_JAVA_TYPE.get(type);
        } else if (!BASIC_TYPE_TO_JAVA_TYPE.containsKey(type)) {
            return null;
        }
        String javaType = property.getMaxCardinality() < 0 ? (nominalType.equals("Reference") ? (IGNORE_TYPES.contains(type) ? "ItemList<Reference>" : "ItemList<" + IGCRestConstants.getClassNameForAssetType(type) + ">") : (nominalType.equals("Boolean") ? nominalType : "List<" + nominalType + ">")) : (nominalType.equals("Reference") ? (IGNORE_TYPES.contains(type) ? "Reference" : IGCRestConstants.getClassNameForAssetType(type)) : nominalType);
        return javaType;
    }

    public static String getClassNameForAssetType(String igcAssetType) {
        if (NON_UNIQUE_CLASSNAMES.containsKey(igcAssetType)) {
            return NON_UNIQUE_CLASSNAMES.get(igcAssetType);
        }
        return IGCRestConstants.getCamelCase(igcAssetType);
    }

    public static String getCamelCase(String input) {
        Matcher m = NAMING_CHAR_WHITELIST.matcher(input);
        String invalidsRemoved = m.replaceAll(NON_IGC_PREFIX);
        StringBuilder sb = new StringBuilder(invalidsRemoved.length());
        for (String token : invalidsRemoved.split(NON_IGC_PREFIX)) {
            if (token.length() <= 0) continue;
            sb.append(token.substring(0, 1).toUpperCase());
            sb.append(token.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String getLowerCamelCase(String input) {
        String cc = IGCRestConstants.getCamelCase(input);
        return cc.substring(0, 1).toLowerCase() + cc.substring(1);
    }

    public static String getAssetTypeForSearch(String assetType) {
        String typeForSearch;
        switch (assetType) {
            case "host_(engine)": {
                typeForSearch = "host";
                break;
            }
            case "non_steward_user": 
            case "steward_user": {
                typeForSearch = "user";
                break;
            }
            default: {
                typeForSearch = assetType;
            }
        }
        return typeForSearch;
    }

    public static IGCSearchCondition getConditionToForceNoSearchResults() {
        return NO_RESULTS_CONDITION;
    }

    public static String getGetterNameForProperty(String propertyName) {
        return "get" + IGCRestConstants.getMethodNameForProperty(propertyName);
    }

    public static String getSetterNameForProperty(String propertyName) {
        return "set" + IGCRestConstants.getMethodNameForProperty(propertyName);
    }

    private static String getMethodNameForProperty(String propertyName) {
        String ccName = QUALIFY_PROPERTIES.contains(propertyName) ? IGCRestConstants.getCamelCase("the_" + propertyName) : IGCRestConstants.getCamelCase(propertyName);
        return ccName;
    }

    private IGCRestConstants() {
    }
}

