/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary;

import java.io.Serializable;

public enum IGCVersionEnum implements Serializable
{
    V11501(11501000, "v11.5.0.1", "xsd_unique_key", "lineage_container"),
    V11501RU5(11501500, "v11.5.0.1 RU5", "development_log", "lineage_container"),
    V11502(11502000, "v11.5.0.2", "term_assignment", "lineage_container"),
    V11502SP3(11502300, "v11.5.0.2 SP3", "Rule_Execution_Result", "lineage_container"),
    V11502SP5(11502500, "v11.5.0.2 SP5", "hbase_namespace", "lineage_container"),
    V11502SP6(11502600, "v11.5.0.2 SP6", "data_file_folder_nobucket", "lineage_container"),
    V11700(11700000, "v11.7.0.0", "binary_infoset_operation", "blueprint"),
    V11701(11701000, "v11.7.0.1", "analytics_project", "blueprint"),
    V11701SP1(11701100, "v11.7.0.1 SP1", "automation_rule", "blueprint"),
    V11702(11702000, "v11.7.0.2", "lineage_container", "blueprint"),
    V11710(11710000, "v11.7.1.0", "data_file_folder_nobucket", "blueprint");

    private static final long serialVersionUID = 1L;
    private int versionCode;
    private String versionName;
    private String typeNameFirstAvailable;
    private String typeNameNotAvailable;

    private IGCVersionEnum(int versionCode, String versionName, String typeNameFirstAvailable, String typeNameNotAvailable) {
        this.versionCode = versionCode;
        this.versionName = versionName;
        this.typeNameFirstAvailable = typeNameFirstAvailable;
        this.typeNameNotAvailable = typeNameNotAvailable;
    }

    private int getOrdinal() {
        return this.versionCode;
    }

    public String getVersionString() {
        return this.versionName;
    }

    public String getTypeNameFirstAvailableInThisVersion() {
        return this.typeNameFirstAvailable;
    }

    public String getTypeNameNotAvailableInThisVersion() {
        return this.typeNameNotAvailable;
    }

    public boolean isLowerThan(IGCVersionEnum version) {
        return this.getOrdinal() < version.getOrdinal();
    }

    public boolean isEqualTo(IGCVersionEnum version) {
        return this.getOrdinal() == version.getOrdinal();
    }

    public boolean isHigherThan(IGCVersionEnum version) {
        return this.getOrdinal() > version.getOrdinal();
    }

    public String toString() {
        return "IGCVersion{versionCode=" + this.versionCode + ", versionName='" + this.versionName + '\'' + '}';
    }
}

