/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeDetails;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeHeader;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.TypeProperty;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.types.ValidValue;
import org.odpi.openmetadata.http.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

public class IGCBeanGenerator {
    private static final Logger log = LoggerFactory.getLogger(IGCBeanGenerator.class);
    private static final String HOSTNAME = "infosvr";
    private static final String PORT = "9446";
    private static final String USERNAME = "isadmin";
    private static final String PASSWORD = "isadmin";
    private static final boolean SKIP_FIXED_ASSET_GENERATION = true;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String DIRECTORY = "igc-clientlibrary" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + "org" + File.separator + "odpi" + File.separator + "egeria" + File.separator + "connectors" + File.separator + "ibm" + File.separator + "igc" + File.separator + "clientlibrary" + File.separator + "model" + File.separator;
    private static final String COMMON_DIRECTORY = DIRECTORY + File.separator + "common";
    private static final String BASE_DIRECTORY = DIRECTORY + File.separator + "base";
    private IGCRestClient igcRestClient;
    private TreeMap<String, TreeMap<String, String>> superTypeToSubTypeToClassName;
    private Map<String, Set<String>> superTypeToProperties;
    private static final Set<String> RESERVED_WORDS = IGCBeanGenerator.createReservedWords();
    private static final Set<String> CORE_TO_IGNORE = IGCBeanGenerator.createCoreToIgnoreProperties();

    public static void main(String[] args) {
        if (HOSTNAME.equals("") || PORT.equals("") || "isadmin".equals("") || "isadmin".equals("")) {
            System.out.println("Inadequate parameters provided.");
            IGCBeanGenerator.printUsage();
            System.exit(1);
        }
        HttpHelper.noStrictSSL();
        IGCBeanGenerator generator = new IGCBeanGenerator();
        generator.generateSuperTypes(true);
        generator.generateForAllIgcTypesInEnvironment(true);
    }

    private static void printUsage() {
        System.out.println("Usage: ");
        System.out.println("  IGCBeanGenerator hostname port username password");
    }

    private IGCBeanGenerator() {
        try {
            this.igcRestClient = new IGCRestClient(HOSTNAME, PORT, "isadmin", "isadmin");
        }
        catch (IGCException e) {
            log.error("Unable to connect to IGC.", (Throwable)e);
        }
        this.superTypeToSubTypeToClassName = new TreeMap();
        this.superTypeToProperties = new HashMap<String, Set<String>>();
    }

    private void generateSuperTypes(boolean skipFixedAssetGeneration) {
        File dir = new File(BASE_DIRECTORY);
        if (!dir.exists()) {
            log.info("Creating directory: " + BASE_DIRECTORY);
            if (!dir.mkdirs()) {
                log.error("Unable to create target directory: {}", (Object)BASE_DIRECTORY);
            }
        }
        for (String typeName : IGCRestConstants.getSuperTypes()) {
            if (!skipFixedAssetGeneration || !typeName.equals("information_asset") && !typeName.equals("main_object")) {
                try {
                    TypeDetails details = this.igcRestClient.getTypeDetails(typeName);
                    this.createPOJOForType(details);
                }
                catch (IGCException e) {
                    log.error("Fatal error processing type details.", (Throwable)e);
                }
                continue;
            }
            if (typeName.equals("information_asset")) {
                this.superTypeToProperties.put("information_asset", IGCRestConstants.getFixedInformationAssetProperties());
                continue;
            }
            if (!typeName.equals("main_object")) continue;
            this.superTypeToProperties.put("main_object", IGCRestConstants.getFixedMainObjectProperties());
        }
    }

    private void generateForAllIgcTypesInEnvironment(boolean skipFixedAssetGeneration) {
        try {
            List<TypeHeader> types = this.igcRestClient.getTypes(mapper);
            for (TypeHeader igcType : types) {
                String type = igcType.getId();
                if (IGCRestConstants.getSuperTypes().contains(type)) continue;
                TypeDetails typeDetails = this.igcRestClient.getTypeDetails(type);
                this.createPOJOForType(typeDetails);
            }
            for (String superTypeName : IGCRestConstants.getSuperTypes()) {
                String superTypeClassName = IGCRestConstants.getClassNameForAssetType(superTypeName);
                if (superTypeClassName.equals("Reference")) continue;
                log.info("Injecting subtype information into {}...", (Object)superTypeClassName);
                Path superTypePath = Paths.get(BASE_DIRECTORY + File.separator + superTypeClassName + ".java", new String[0]);
                if (skipFixedAssetGeneration && (superTypeClassName.equals("InformationAsset") || superTypeClassName.equals("Classificationenabledgroup"))) {
                    this.removeInjectedSubtypes(superTypePath);
                }
                this.injectSubTypes(superTypePath, (Map<String, String>)this.superTypeToSubTypeToClassName.get(superTypeName));
            }
            Path refPath = Paths.get(COMMON_DIRECTORY + File.separator + "Reference.java", new String[0]);
            this.removeInjectedSubtypes(refPath);
            log.info("Injecting subtype information into Reference...");
            this.injectSubTypes(refPath, (Map<String, String>)this.superTypeToSubTypeToClassName.get("reference"));
            this.igcRestClient.disconnect();
        }
        catch (IGCException e) {
            log.error("Fatal error interacting with IGC.", (Throwable)e);
        }
    }

    private void createPOJOForType(TypeDetails typeDetails) {
        String packageName = "org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base";
        String id = typeDetails.getId();
        String name = typeDetails.getName();
        log.info("Processing type: {}", (Object)id);
        String className = IGCRestConstants.getClassNameForAssetType(id);
        String filename = BASE_DIRECTORY + File.separator + className + ".java";
        try (BufferedWriter fs = new BufferedWriter(new FileWriter(filename));){
            fs.append("/* SPDX-License-Identifier: Apache-2.0 */");
            fs.append(System.lineSeparator());
            fs.append("/* Copyright Contributors to the ODPi Egeria project. */");
            fs.append(System.lineSeparator());
            fs.append("package ").append(packageName).append(";");
            fs.append(System.lineSeparator());
            fs.append(System.lineSeparator());
            fs.append("import com.fasterxml.jackson.annotation.JsonTypeInfo;");
            fs.append(System.lineSeparator());
            fs.append("import com.fasterxml.jackson.annotation.JsonAutoDetect;");
            fs.append(System.lineSeparator());
            fs.append("import com.fasterxml.jackson.annotation.JsonIgnoreProperties;");
            fs.append(System.lineSeparator());
            fs.append("import com.fasterxml.jackson.annotation.JsonInclude;");
            fs.append(System.lineSeparator());
            fs.append("import com.fasterxml.jackson.annotation.JsonTypeName;");
            fs.append(System.lineSeparator());
            fs.append("import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;");
            fs.append(System.lineSeparator());
            fs.append("import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;");
            fs.append(System.lineSeparator());
            TypeCharacteristics typeCharacteristics = new TypeCharacteristics(id, typeDetails.getViewInfo().getProperties());
            Collection<PropertyDetail> propertyDetails = typeCharacteristics.getPropertyDetails();
            String superType = typeCharacteristics.getTypeToExtend();
            if (!propertyDetails.isEmpty()) {
                fs.append("import com.fasterxml.jackson.annotation.JsonProperty;");
                fs.append(System.lineSeparator());
                Set<String> dataTypes = typeCharacteristics.getDataTypes();
                if (superType.equals("reference") || dataTypes.contains("Reference")) {
                    fs.append("import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;");
                    fs.append(System.lineSeparator());
                }
                if (dataTypes.contains("ItemList")) {
                    fs.append("import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;");
                    fs.append(System.lineSeparator());
                }
                if (dataTypes.contains("Date")) {
                    fs.append("import java.util.Date;");
                    fs.append(System.lineSeparator());
                }
                if (dataTypes.contains("List")) {
                    fs.append("import java.util.List;");
                    fs.append(System.lineSeparator());
                }
            } else if (superType.equals("reference")) {
                fs.append("import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;");
                fs.append(System.lineSeparator());
            }
            fs.append(System.lineSeparator());
            fs.append(this.getClassHeading(name, id));
            fs.append("@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property=\"_type\", visible=true, defaultImpl=").append(className).append(".class)");
            fs.append(System.lineSeparator());
            fs.append("@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)");
            fs.append(System.lineSeparator());
            fs.append("@JsonInclude(JsonInclude.Include.NON_NULL)");
            fs.append(System.lineSeparator());
            fs.append("@JsonIgnoreProperties(ignoreUnknown=true)");
            fs.append(System.lineSeparator());
            fs.append("@JsonTypeName(\"").append(id).append("\")");
            fs.append(System.lineSeparator());
            String classToExtend = IGCRestConstants.getClassNameForAssetType(superType);
            fs.append("public class ").append(className).append(" extends ").append(classToExtend).append(" {");
            fs.append(System.lineSeparator()).append(System.lineSeparator());
            try {
                for (PropertyDetail detail : propertyDetails) {
                    fs.append(detail.getMember());
                    fs.append(System.lineSeparator());
                }
                for (PropertyDetail detail : propertyDetails) {
                    fs.append(detail.getGetSet());
                    fs.append(System.lineSeparator());
                    fs.append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                log.error("Unable to append property details.", (Throwable)e);
            }
            if (!this.superTypeToSubTypeToClassName.containsKey(superType)) {
                this.superTypeToSubTypeToClassName.put(superType, new TreeMap());
            }
            this.superTypeToSubTypeToClassName.get(superType).put(id, className);
            fs.append("}");
            fs.append(System.lineSeparator());
        }
        catch (IOException e) {
            log.error("Unable to open file output: {}", (Object)filename, (Object)e);
        }
    }

    private String getClassHeading(String displayName, String typeName) {
        return "/**" + System.lineSeparator() + " * POJO for the {@code " + typeName + "} asset type in IGC, displayed as '{@literal " + displayName + "}' in the IGC UI." + System.lineSeparator() + " * <br><br>" + System.lineSeparator() + " * (this code has been created based on out-of-the-box IGC metadata types." + System.lineSeparator() + " *  If modifications are needed, eg. to handle custom attributes," + System.lineSeparator() + " *  extending from this class in your own custom class is the best approach.)" + System.lineSeparator() + " */" + System.lineSeparator();
    }

    private PropertyDetail getPropertyDetail(TypeProperty property) {
        PropertyDetail detail = null;
        String name = property.getName();
        if (name != null && !IGCRestConstants.getPropertiesToIgnore().contains(name) && !CORE_TO_IGNORE.contains(name)) {
            log.debug(" ... adding property: {}", (Object)property.getName());
            String javaType = IGCRestConstants.getJavaTypeForProperty(property);
            if (javaType == null) {
                log.error("Unable to determine Java type for: {}", (Object)property);
            } else {
                detail = new PropertyDetail();
                String propNameActual = property.getName();
                String propertyName = IGCRestConstants.getLowerCamelCase(propNameActual);
                if (RESERVED_WORDS.contains(propertyName)) {
                    propertyName = "z" + propertyName;
                }
                detail.setJavaType(javaType);
                detail.setMember(this.getMemberDeclaration(property, propNameActual, propertyName, javaType));
                detail.setGetSet(this.getGetterAndSetter(property, propNameActual, propertyName, javaType));
            }
        }
        return detail;
    }

    private String getMemberDeclaration(TypeProperty property, String propNameActual, String propertyName, String javaType) {
        StringBuilder declMember = new StringBuilder();
        List<ValidValue> validValues = property.getType().getValidValues();
        if (validValues != null && !validValues.isEmpty()) {
            declMember.append("    /**").append(System.lineSeparator()).append("     * Valid values are:").append(System.lineSeparator()).append("     * <ul>").append(System.lineSeparator());
            for (ValidValue value : validValues) {
                declMember.append("     *   <li>").append(HtmlUtils.htmlEscape((String)value.getId())).append(" (displayed in the UI as '").append(HtmlUtils.htmlEscape((String)value.getDisplayName())).append("')</li>").append(System.lineSeparator());
            }
            declMember.append("     * </ul>").append(System.lineSeparator()).append("     */").append(System.lineSeparator());
        }
        declMember.append("    @JsonProperty(\"").append(propNameActual).append("\")");
        declMember.append(System.lineSeparator());
        declMember.append("    protected ").append(javaType).append(" ").append(propertyName).append(";");
        declMember.append(System.lineSeparator());
        return declMember.toString();
    }

    private String getGetterAndSetter(TypeProperty property, String propNameActual, String propertyName, String javaType) {
        StringBuilder getSetter = new StringBuilder();
        getSetter.append("    /**").append(System.lineSeparator()).append("     * Retrieve the ").append("{@code ").append(propNameActual).append("}").append(" property (displayed as '{@literal ").append(property.getDisplayName()).append("}') of the object.").append(System.lineSeparator()).append("     * @return {@code ").append(javaType).append("}").append(System.lineSeparator()).append("     */");
        getSetter.append(System.lineSeparator());
        getSetter.append("    @JsonProperty(\"").append(propNameActual).append("\")");
        getSetter.append(System.lineSeparator());
        getSetter.append("    public ").append(javaType).append(" ").append(IGCRestConstants.getGetterNameForProperty(propNameActual)).append("() { return this.").append(propertyName).append("; }");
        getSetter.append(System.lineSeparator());
        getSetter.append(System.lineSeparator());
        getSetter.append("    /**").append(System.lineSeparator()).append("     * Set the ").append("{@code ").append(propNameActual).append("}").append(" property (displayed as {@code ").append(property.getDisplayName()).append("}) of the object.").append(System.lineSeparator()).append("     * @param ").append(propertyName).append(" the value to set").append(System.lineSeparator()).append("     */");
        getSetter.append(System.lineSeparator());
        getSetter.append("    @JsonProperty(\"").append(propNameActual).append("\")");
        getSetter.append(System.lineSeparator());
        getSetter.append("    public void ").append(IGCRestConstants.getSetterNameForProperty(propNameActual)).append("(").append(javaType).append(" ").append(propertyName).append(") { this.").append(propertyName).append(" = ").append(propertyName).append("; }");
        return getSetter.toString();
    }

    private static Set<String> createReservedWords() {
        HashSet<String> set = new HashSet<String>();
        set.add("package");
        set.add("final");
        set.add("abstract");
        set.add("default");
        return set;
    }

    private static Set<String> createCoreToIgnoreProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("_name");
        set.add("_type");
        set.add("_url");
        set.add("_id");
        set.add("_context");
        set.add("created_by");
        set.add("created_on");
        set.add("modified_by");
        set.add("modified_on");
        return set;
    }

    private void injectSubTypes(Path path, Map<String, String> mappings) {
        try {
            String line;
            int position;
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (position = 0; position < lines.size() && !(line = lines.get(position)).startsWith("import com.fasterxml.jackson.annotation.JsonAutoDetect;"); ++position) {
            }
            lines.add(++position, "import com.fasterxml.jackson.annotation.JsonSubTypes;");
            while (position < lines.size() && !(line = lines.get(position)).startsWith("@JsonAutoDetect")) {
                ++position;
            }
            lines.add(++position, "@JsonSubTypes({");
            ++position;
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String igcType = entry.getKey();
                String javaClass = entry.getValue();
                lines.add(position, "        @JsonSubTypes.Type(value = " + javaClass + ".class, name = \"" + igcType + "\"),");
                ++position;
            }
            lines.add(position, "})");
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to inject subtypes into file: {}", (Object)path, (Object)e);
        }
    }

    private void removeInjectedSubtypes(Path path) {
        try {
            String line;
            int position;
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            boolean bFound = false;
            for (position = 0; position < lines.size(); ++position) {
                line = lines.get(position);
                if (!line.startsWith("import com.fasterxml.jackson.annotation.JsonSubTypes;")) continue;
                bFound = true;
                break;
            }
            if (bFound) {
                lines.remove(position);
                bFound = false;
            }
            while (position < lines.size()) {
                line = lines.get(position);
                if (line.startsWith("@JsonSubTypes({")) {
                    bFound = true;
                    break;
                }
                ++position;
            }
            if (bFound) {
                lines.remove(position);
                bFound = false;
            }
            ArrayList<String> othersToRemove = new ArrayList<String>();
            while (position < lines.size()) {
                String line2 = lines.get(position);
                if (line2.startsWith("})")) {
                    bFound = true;
                    break;
                }
                othersToRemove.add(line2);
                ++position;
            }
            if (bFound) {
                lines.remove(position);
                lines.removeAll(othersToRemove);
            }
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to remove injected subtypes from file: {}", (Object)path, (Object)e);
        }
    }

    protected class PropertyDetail {
        private String member;
        private String getSet;
        private Set<String> javaTypes = new HashSet<String>();

        PropertyDetail() {
        }

        void setMember(String member) {
            this.member = member;
        }

        void setGetSet(String getSet) {
            this.getSet = getSet;
        }

        void setJavaType(String javaType) {
            if (javaType.startsWith("ItemList<")) {
                this.javaTypes.add("ItemList");
                this.javaTypes.add(javaType.substring(javaType.indexOf("<") + 1, javaType.indexOf(">")));
            } else if (javaType.startsWith("List<")) {
                this.javaTypes.add("List");
                this.javaTypes.add(javaType.substring(javaType.indexOf("<") + 1, javaType.indexOf(">")));
            } else {
                this.javaTypes.add(javaType);
            }
        }

        String getMember() {
            return this.member;
        }

        String getGetSet() {
            return this.getSet;
        }

        Set<String> getJavaTypes() {
            return this.javaTypes;
        }
    }

    protected class TypeCharacteristics {
        private String typeToExtend = "reference";
        private TreeMap<String, PropertyDetail> propertyDetails = new TreeMap();
        private Set<String> dataTypes = new HashSet<String>();

        TypeCharacteristics() {
        }

        TypeCharacteristics(String typeName, List<TypeProperty> properties) {
            this();
            this.initialize(typeName, properties);
        }

        private void initialize(String typeName, List<TypeProperty> properties) {
            this.typeToExtend = IGCRestConstants.getSubTypeToSuperType().getOrDefault(typeName, "reference");
            boolean knownClass = !this.typeToExtend.equals("reference");
            HashSet<String> allPropertyNames = new HashSet<String>();
            for (TypeProperty property : properties) {
                PropertyDetail detail = IGCBeanGenerator.this.getPropertyDetail(property);
                if (detail != null) {
                    this.addPropertyDetail(property.getName(), detail);
                    if (!typeName.equals("collection")) {
                        String propertyName = property.getName();
                        String propertyType = property.getType().getName();
                        if (propertyName.equals("in_collections") && propertyType.equals("collection") && !knownClass) {
                            this.typeToExtend = "information_asset";
                        } else if (propertyName.equals("labels") && propertyType.equals("label") && !typeName.equals("main_object") && !knownClass) {
                            this.typeToExtend = "main_object";
                        }
                    }
                    this.dataTypes.addAll(detail.getJavaTypes());
                }
                allPropertyNames.add(property.getName());
            }
            if (IGCRestConstants.getSuperTypes().contains(typeName)) {
                IGCBeanGenerator.this.superTypeToProperties.put(typeName, allPropertyNames);
            }
            this.removeAllSuperTypeProperties(this.typeToExtend);
        }

        void addPropertyDetail(String propertyName, PropertyDetail detail) {
            this.propertyDetails.put(propertyName, detail);
        }

        void removePropertyDetail(String propertyName) {
            this.propertyDetails.remove(propertyName);
        }

        private void removeAllSuperTypeProperties(String superTypeName) {
            if (!superTypeName.equals("reference")) {
                for (String string : (Set)IGCBeanGenerator.this.superTypeToProperties.get(superTypeName)) {
                    this.removePropertyDetail(string);
                }
                for (Map.Entry entry : IGCRestConstants.getSubTypeToSuperType().entrySet()) {
                    String subTypeName = (String)entry.getKey();
                    String mappedSuperType = (String)entry.getValue();
                    if (!subTypeName.equals(superTypeName)) continue;
                    this.removeAllSuperTypeProperties(mappedSuperType);
                }
            }
        }

        Collection<PropertyDetail> getPropertyDetails() {
            return this.propertyDetails.values();
        }

        String getTypeToExtend() {
            return this.typeToExtend;
        }

        Set<String> getDataTypes() {
            return this.dataTypes;
        }
    }
}

