/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;

public class DynamicPropertyReader {
    private final Function getterFunction;

    public DynamicPropertyReader(Class<?> pojoClass, String propertyName) {
        CallSite site;
        Method getterMethod;
        String getterName = IGCRestConstants.getGetterNameForProperty(propertyName);
        try {
            getterMethod = pojoClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The class (" + pojoClass + ") has doesn't have the getter method (" + getterName + ").", e);
        }
        Class<?> returnType = getterMethod.getReturnType();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), lookup.findVirtual(pojoClass, getterName, MethodType.methodType(returnType)), MethodType.methodType(returnType, pojoClass));
        }
        catch (IllegalAccessException | NoSuchMethodException | LambdaConversionException e) {
            throw new IllegalArgumentException("Lambda creation failed for method (" + getterMethod + ").", e);
        }
        try {
            this.getterFunction = site.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Lambda creation failed for method (" + getterMethod + ").", e);
        }
    }

    public Object getProperty(Object pojo) {
        return this.getterFunction.apply(pojo);
    }
}

