/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCIOException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCParsingException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    private static final Logger log = LoggerFactory.getLogger(Identity.class);
    private static final String SEPARATOR_FOR_COMPONENTS = "::";
    private static final String SEPARATOR_FOR_TYPE_AND_NAME = "=";
    public static final String TYPE_PREFIX = "(";
    private static final String TYPE_POSTFIX = ")";
    private static final int MAX_QN_LENGTH = 16384;
    private static final String LOG_ADDING_SEARCH_CONDITION = "Adding search condition: {} {} {}";
    private static final String SEARCH_STARTS_WITH = "like {0}%";
    private static final String COURTESY_TITLE = "courtesy_title";
    private static final String GIVEN_NAME = "given_name";
    private static final String FULL_NAME = "full_name";
    private List<Reference> context = new ArrayList<Reference>();
    private String assetType = "";
    private String assetName = "";
    private String rid = null;
    private boolean partial;

    public Identity(boolean partial) {
        this.partial = partial;
    }

    public Identity(List<Reference> context, String assetType, String assetName) {
        this(context, assetType, assetName, null);
    }

    public Identity(List<Reference> context, String assetType, String assetName, String rid) {
        this(context, assetType, assetName, rid, false);
    }

    public Identity(List<Reference> context, String assetType, String assetName, String rid, boolean partial) {
        this(partial);
        this.context = context == null ? new ArrayList() : context;
        this.assetType = assetType;
        this.assetName = assetName;
        this.rid = rid;
    }

    public Identity getParentIdentity() {
        Identity parent = null;
        if (!this.context.isEmpty()) {
            int lastIndex = this.context.size() - 1;
            Reference endOfCtx = this.context.get(lastIndex);
            List<Reference> parentCtx = this.context.subList(0, lastIndex);
            parent = new Identity(parentCtx, endOfCtx.getType(), endOfCtx.getName(), endOfCtx.getId());
        }
        return parent;
    }

    public Identity getUltimateParentIdentity() {
        Identity ultimate = this;
        if (!this.context.isEmpty()) {
            Reference top = this.context.get(0);
            ultimate = new Identity(new ArrayList<Reference>(), top.getType(), top.getName(), top.getId());
        }
        return ultimate;
    }

    public String getRid() {
        return this.rid;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getName() {
        return this.assetName;
    }

    public boolean isPartial() {
        return this.partial;
    }

    private static void composeString(StringBuilder sb, String type, String name) {
        sb.append(TYPE_PREFIX);
        sb.append(IGCRestConstants.getAssetTypeForSearch(type));
        sb.append(TYPE_POSTFIX);
        sb.append(SEPARATOR_FOR_TYPE_AND_NAME);
        sb.append(name);
    }

    private static String getPropertyPath(String assetType, String ctxAssetType, String pathSoFar) {
        if (pathSoFar.length() > 0) {
            pathSoFar = pathSoFar + ".";
        }
        if (assetType.equals("database_column") && (ctxAssetType.equals("database_table") || ctxAssetType.equals("view"))) {
            pathSoFar = pathSoFar + "database_table_or_view";
        } else {
            switch (ctxAssetType) {
                case "category": {
                    pathSoFar = pathSoFar + "parent_category";
                    break;
                }
                case "information_governance_policy": {
                    pathSoFar = pathSoFar + "parent_policy";
                    break;
                }
                case "data_class": {
                    pathSoFar = pathSoFar + "parent_data_class";
                    break;
                }
                default: {
                    pathSoFar = pathSoFar + IGCRestConstants.getAssetTypeForSearch(ctxAssetType);
                }
            }
        }
        return pathSoFar;
    }

    private void addSearchCondition(IGCSearchConditionSet igcSearchConditionSet, String propertyPath, String ctxType, String ctxName) {
        String ctxTypeToSearch = IGCRestConstants.getAssetTypeForSearch(ctxType);
        String nameProperty = "name";
        String operator = SEPARATOR_FOR_TYPE_AND_NAME;
        if (ctxTypeToSearch.equals("group")) {
            nameProperty = "group_name";
        }
        String searchFor = propertyPath == null ? nameProperty : propertyPath + "." + nameProperty;
        log.debug(LOG_ADDING_SEARCH_CONDITION, new Object[]{searchFor, operator, ctxName});
        IGCSearchCondition condition = new IGCSearchCondition(searchFor, operator, ctxName);
        igcSearchConditionSet.addCondition(condition);
    }

    public final IGCSearchConditionSet getSearchCriteria() {
        IGCSearchConditionSet igcSearchConditionSet;
        block15: {
            block13: {
                String dataFileHost;
                String dataFilePath;
                String propertyPath;
                block14: {
                    igcSearchConditionSet = new IGCSearchConditionSet();
                    igcSearchConditionSet.setMatchAnyCondition(false);
                    if (!IGCRestConstants.getFileTypes().contains(this.assetType)) break block13;
                    propertyPath = "";
                    dataFilePath = "";
                    dataFileHost = "";
                    for (int i = this.context.size() - 1; i >= 0; --i) {
                        Reference item = this.context.get(i);
                        String type = item.getType();
                        if (type.equals("host")) {
                            dataFileHost = item.getName();
                            continue;
                        }
                        if (type.equals("data_file_folder")) {
                            String path = item.getName();
                            if (path.equals("/")) {
                                dataFilePath = "/" + dataFilePath;
                                continue;
                            }
                            dataFilePath = path + (dataFilePath.length() == 0 ? "" : "/" + dataFilePath);
                            continue;
                        }
                        propertyPath = Identity.getPropertyPath(this.assetType, type, propertyPath);
                        this.addSearchCondition(igcSearchConditionSet, propertyPath, type, item.getName());
                    }
                    if (propertyPath.length() != 0) break block14;
                    String parentName = "";
                    if (dataFilePath.length() != 0) {
                        parentName = dataFilePath;
                        int index = dataFilePath.lastIndexOf("/");
                        if (index >= 0) {
                            parentName = dataFilePath.substring(index + 1);
                        }
                    }
                    if (parentName.length() != 0) {
                        log.debug(LOG_ADDING_SEARCH_CONDITION, new Object[]{"parent_folder.name", SEPARATOR_FOR_TYPE_AND_NAME, parentName});
                        IGCSearchCondition cPath = new IGCSearchCondition("parent_folder.name", SEPARATOR_FOR_TYPE_AND_NAME, parentName);
                        igcSearchConditionSet.addCondition(cPath);
                    }
                    if (dataFileHost.length() != 0) {
                        log.debug(LOG_ADDING_SEARCH_CONDITION, new Object[]{"host.name", SEPARATOR_FOR_TYPE_AND_NAME, dataFileHost});
                        IGCSearchCondition cHost = new IGCSearchCondition("host.name", SEPARATOR_FOR_TYPE_AND_NAME, dataFileHost);
                        igcSearchConditionSet.addCondition(cHost);
                    }
                    break block15;
                }
                if (dataFilePath.length() != 0) {
                    log.debug(LOG_ADDING_SEARCH_CONDITION, new Object[]{propertyPath + ".path", "like %{0}", dataFilePath});
                    IGCSearchCondition cPath = new IGCSearchCondition(propertyPath + ".path", "like %{0}", dataFilePath);
                    igcSearchConditionSet.addCondition(cPath);
                }
                if (dataFileHost.length() == 0) break block15;
                log.debug(LOG_ADDING_SEARCH_CONDITION, new Object[]{propertyPath + ".host.name", SEPARATOR_FOR_TYPE_AND_NAME, dataFileHost});
                IGCSearchCondition cHost = new IGCSearchCondition(propertyPath + ".host.name", SEPARATOR_FOR_TYPE_AND_NAME, dataFileHost);
                igcSearchConditionSet.addCondition(cHost);
                break block15;
            }
            if (IGCRestConstants.getUserTypes().contains(this.assetType)) {
                Identity.getSearchCriteriaForUserName(igcSearchConditionSet, this.assetName);
            } else {
                String propertyPath = "";
                for (int i = this.context.size() - 1; i >= 0; --i) {
                    Reference item = this.context.get(i);
                    String type = item.getType();
                    propertyPath = Identity.getPropertyPath(this.assetType, type, propertyPath);
                    this.addSearchCondition(igcSearchConditionSet, propertyPath, type, item.getName());
                }
            }
        }
        if (!IGCRestConstants.getUserTypes().contains(this.assetType)) {
            this.addSearchCondition(igcSearchConditionSet, null, this.assetType, this.assetName);
        }
        return igcSearchConditionSet;
    }

    public static int isIdentityString(String candidate) {
        int charCount = 0;
        String withoutRegexFlags = candidate;
        if (candidate.startsWith("(?i)")) {
            withoutRegexFlags = candidate.substring(4);
        }
        charCount += withoutRegexFlags.contains(SEPARATOR_FOR_COMPONENTS) ? 2 : 0;
        charCount += withoutRegexFlags.contains(SEPARATOR_FOR_TYPE_AND_NAME) ? 2 : 0;
        charCount += withoutRegexFlags.contains(TYPE_PREFIX) ? 1 : 0;
        return charCount += withoutRegexFlags.contains(TYPE_POSTFIX) ? 1 : 0;
    }

    public static Identity getFromString(String identity, IGCRestClient igcRestClient, StringType stringType) throws IGCParsingException {
        return Identity.getFromString(identity, igcRestClient, stringType, true);
    }

    public static Identity getFromString(String identity, IGCRestClient igcRestClient, StringType stringType, boolean warnOnNotFound) throws IGCParsingException {
        ArrayList<Reference> context = new ArrayList<Reference>();
        String assetType = null;
        String assetName = null;
        String assetId = null;
        List<String> components = Identity.getComponentsOfIdentityString(identity);
        if (components.isEmpty()) {
            List<String> tokens = Identity.getTokensOfComponent(identity, igcRestClient);
            boolean nothingDone = Identity.parseTokensIntoContext(tokens, context);
            if (!context.isEmpty() && !nothingDone) {
                Reference item = Identity.popLastRefFromContext(context);
                assetType = item.getType();
                assetName = item.getName();
                assetId = item.getId();
            }
        } else {
            for (int i = 0; i < components.size(); ++i) {
                String component = components.get(i);
                List<String> tokens = Identity.getTokensOfComponent(component, igcRestClient);
                boolean nothingDone = Identity.parseTokensIntoContext(tokens, context);
                if (i != components.size() - 1 || context.isEmpty() || nothingDone) continue;
                Reference item = Identity.popLastRefFromContext(context);
                assetType = item.getType();
                assetName = item.getName();
                assetId = item.getId();
            }
        }
        Identity ident = null;
        String displayName = null;
        if (warnOnNotFound) {
            try {
                displayName = igcRestClient.getDisplayNameForType(assetType);
            }
            catch (Exception e) {
                log.warn("Unable to find registered IGC type '{}' -- cannot construct an IGC identity.", (Object)assetType, (Object)e);
            }
        }
        if (displayName != null) {
            ident = stringType.equals((Object)StringType.EXACT) ? new Identity(context, assetType, assetName) : new Identity(context, assetType, assetName, assetId, true);
        }
        return ident;
    }

    public static void getSearchCriteriaForUserName(IGCSearchConditionSet igcSearchConditionSet, String name) {
        String[] nameTokens = name.split(" ");
        if (nameTokens.length == 1) {
            IGCSearchCondition cTitle = new IGCSearchCondition(COURTESY_TITLE, SEARCH_STARTS_WITH, nameTokens[0]);
            IGCSearchCondition fName = new IGCSearchCondition(GIVEN_NAME, SEARCH_STARTS_WITH, nameTokens[0]);
            IGCSearchCondition lName = new IGCSearchCondition("surname", SEARCH_STARTS_WITH, nameTokens[0]);
            IGCSearchConditionSet nested = new IGCSearchConditionSet();
            nested.addCondition(cTitle);
            nested.addCondition(fName);
            nested.addCondition(lName);
            nested.setMatchAnyCondition(true);
            igcSearchConditionSet.addNestedConditionSet(nested);
        } else if (nameTokens.length == 2) {
            IGCSearchCondition cTitleAlone = new IGCSearchCondition(COURTESY_TITLE, SEARCH_STARTS_WITH, nameTokens[0]);
            IGCSearchCondition fNameAlone1 = new IGCSearchCondition(GIVEN_NAME, SEARCH_STARTS_WITH, nameTokens[0]);
            IGCSearchCondition fNameAlone2 = new IGCSearchCondition(GIVEN_NAME, SEARCH_STARTS_WITH, nameTokens[1]);
            IGCSearchCondition lNameAlone = new IGCSearchCondition("surname", SEARCH_STARTS_WITH, nameTokens[1]);
            IGCSearchCondition cTitleCombined = new IGCSearchCondition(COURTESY_TITLE, SEARCH_STARTS_WITH, name);
            IGCSearchCondition fNameCombined = new IGCSearchCondition(GIVEN_NAME, SEARCH_STARTS_WITH, name);
            IGCSearchConditionSet nested = new IGCSearchConditionSet();
            IGCSearchConditionSet titleCombined = new IGCSearchConditionSet(cTitleCombined);
            nested.addNestedConditionSet(titleCombined);
            IGCSearchConditionSet titleAndFname = new IGCSearchConditionSet();
            titleAndFname.addCondition(cTitleAlone);
            titleAndFname.addCondition(fNameAlone2);
            titleAndFname.setMatchAnyCondition(false);
            nested.addNestedConditionSet(titleAndFname);
            IGCSearchConditionSet multiWordFname = new IGCSearchConditionSet();
            multiWordFname.addCondition(fNameCombined);
            nested.addNestedConditionSet(multiWordFname);
            IGCSearchConditionSet firstAndLast = new IGCSearchConditionSet();
            firstAndLast.addCondition(fNameAlone1);
            firstAndLast.addCondition(lNameAlone);
            firstAndLast.setMatchAnyCondition(false);
            nested.addNestedConditionSet(firstAndLast);
            nested.setMatchAnyCondition(true);
            igcSearchConditionSet.addNestedConditionSet(nested);
        } else if (nameTokens.length > 2) {
            IGCSearchCondition cTitleCombined = new IGCSearchCondition(COURTESY_TITLE, SEARCH_STARTS_WITH, name);
            IGCSearchCondition fullNameCombined = new IGCSearchCondition(FULL_NAME, SEARCH_STARTS_WITH, name);
            IGCSearchCondition cTitleAlone = new IGCSearchCondition(COURTESY_TITLE, SEARCH_STARTS_WITH, nameTokens[0]);
            StringBuilder combinedName = new StringBuilder();
            for (int i = 1; i < nameTokens.length; ++i) {
                combinedName.append(nameTokens[i]).append(" ");
            }
            combinedName.deleteCharAt(combinedName.length() - 1);
            IGCSearchCondition fullNameAlone = new IGCSearchCondition(FULL_NAME, SEARCH_STARTS_WITH, combinedName.toString());
            IGCSearchConditionSet nested = new IGCSearchConditionSet();
            IGCSearchConditionSet titleOnly = new IGCSearchConditionSet(cTitleCombined);
            nested.addNestedConditionSet(titleOnly);
            IGCSearchConditionSet nameOnly = new IGCSearchConditionSet(fullNameCombined);
            nested.addNestedConditionSet(nameOnly);
            IGCSearchConditionSet titleAndName = new IGCSearchConditionSet();
            titleAndName.addCondition(cTitleAlone);
            titleAndName.addCondition(fullNameAlone);
            titleAndName.setMatchAnyCondition(false);
            nested.addNestedConditionSet(titleAndName);
            nested.setMatchAnyCondition(true);
            igcSearchConditionSet.addNestedConditionSet(nested);
        }
    }

    private static List<String> getComponentsOfIdentityString(String identity) throws IGCParsingException {
        if (identity.contains(SEPARATOR_FOR_COMPONENTS)) {
            if (identity.length() < 16384) {
                return Arrays.asList(identity.split(SEPARATOR_FOR_COMPONENTS));
            }
            throw new IGCParsingException("Identity string exceeds maximum allowed length, cannot parse it.", identity);
        }
        if (identity.contains(SEPARATOR_FOR_TYPE_AND_NAME) || identity.contains(TYPE_PREFIX) && identity.contains(TYPE_POSTFIX)) {
            return Collections.singletonList(identity);
        }
        return Collections.emptyList();
    }

    private static List<String> getTokensOfComponent(String component, IGCRestClient igcRestClient) {
        ArrayList<String> pair = new ArrayList<String>();
        if (component.contains(SEPARATOR_FOR_TYPE_AND_NAME)) {
            String[] tokens = component.split(SEPARATOR_FOR_TYPE_AND_NAME);
            String type = Identity.getTypeFromComponentToken(tokens[0], igcRestClient);
            if (type != null) {
                String name;
                pair.add(type);
                if (tokens.length == 2 && (name = tokens[1]) != null) {
                    pair.add(name);
                }
            }
        } else {
            String type = Identity.getTypeFromComponentToken(component, igcRestClient);
            if (type != null) {
                pair.add(type);
            }
        }
        return pair;
    }

    private static String getTypeFromComponentToken(String token, IGCRestClient igcRestClient) {
        if (token.contains(TYPE_PREFIX) && token.contains(TYPE_POSTFIX)) {
            String type = token.substring(token.indexOf(TYPE_PREFIX) + 1, token.lastIndexOf(TYPE_POSTFIX));
            try {
                Class<?> pojo = igcRestClient.getPOJOForType(type);
                if (pojo != null) {
                    return type;
                }
                return null;
            }
            catch (IGCIOException e) {
                log.warn("Unable to find type '{}', skipping from identity", (Object)type, (Object)e);
                return null;
            }
        }
        return null;
    }

    private static boolean parseTokensIntoContext(List<String> tokens, List<Reference> context) {
        boolean nothingDone = false;
        if (tokens.size() == 2) {
            String type = tokens.get(0);
            String name = tokens.get(1);
            Reference item = new Reference(name, type);
            context.add(item);
        } else if (tokens.size() == 1) {
            String type = tokens.get(0);
            Reference item = new Reference(null, type, null);
            context.add(item);
        } else {
            nothingDone = true;
        }
        return nothingDone;
    }

    private static Reference popLastRefFromContext(List<Reference> context) {
        Reference item = context.get(context.size() - 1);
        context.remove(context.size() - 1);
        return item;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity that = (Identity)obj;
        return Objects.equals(this.toString(), that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.context, this.assetName, this.getAssetType(), this.getRid());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Reference ref : this.context) {
            Identity.composeString(sb, ref.getType(), ref.getName());
            sb.append(SEPARATOR_FOR_COMPONENTS);
        }
        Identity.composeString(sb, this.assetType, this.assetName);
        return sb.toString();
    }

    public static enum StringType {
        EXACT,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS;

    }
}

