/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;

public class IGCSearchCondition {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String property;
    private String operator;
    private String value = null;
    private List<String> values = null;
    private Long min = null;
    private Long max = null;
    private Boolean negated = null;

    public IGCSearchCondition(String property, String operator, String value) {
        this(property, "isNull", (Boolean)false);
        if (value != null) {
            this.operator = operator;
            this.value = value;
            this.negated = null;
        }
    }

    public IGCSearchCondition(String property, String operator, Boolean negated) {
        this.property = property;
        this.operator = operator;
        this.negated = negated;
    }

    public IGCSearchCondition(String property, String operator, String value, Boolean negated) {
        this(property, "isNull", negated);
        if (value != null) {
            if (operator.equals("=") && negated.booleanValue()) {
                this.operator = "<>";
                this.negated = null;
            } else {
                this.operator = operator;
            }
            this.value = value;
        }
    }

    public IGCSearchCondition(String property, List<String> listOfValues) {
        this.property = property;
        this.operator = "in";
        this.values = listOfValues;
    }

    public IGCSearchCondition(String property, List<String> listOfValues, Boolean negated) {
        this(property, listOfValues);
        this.negated = negated;
    }

    public IGCSearchCondition(String property, long from, long to) {
        this.property = property;
        this.operator = "between";
        this.min = from;
        this.max = to;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public Boolean getNegated() {
        return this.negated;
    }

    public void setNegated(Boolean negated) {
        this.negated = negated;
    }

    public ObjectNode getConditionObject() {
        ObjectNode condObj = this.nf.objectNode();
        condObj.set("property", (JsonNode)this.nf.textNode(this.getProperty()));
        condObj.set("operator", (JsonNode)this.nf.textNode(this.getOperator()));
        if (this.values != null && !this.values.isEmpty()) {
            ArrayNode arrayNode = this.nf.arrayNode(this.getValues().size());
            for (String oneValue : this.getValues()) {
                arrayNode.add(oneValue);
            }
            condObj.set("value", (JsonNode)arrayNode);
        } else if (this.value != null) {
            condObj.set("value", (JsonNode)this.nf.textNode(this.getValue()));
        } else if (this.min != null && this.max != null) {
            condObj.set("min", (JsonNode)this.nf.numberNode(this.min));
            condObj.set("max", (JsonNode)this.nf.numberNode(this.max));
        }
        if (this.negated != null) {
            condObj.set("negated", (JsonNode)this.nf.booleanNode(this.getNegated().booleanValue()));
        }
        return condObj;
    }
}

