/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;

public class IGCSearchConditionSet {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private ArrayNode conditions = this.nf.arrayNode();
    private String conditionJoin = "and";
    private boolean negateAll = false;

    public IGCSearchConditionSet() {
    }

    public IGCSearchConditionSet(IGCSearchCondition condition) {
        this();
        this.addCondition(condition);
    }

    public void addCondition(IGCSearchCondition condition) {
        this.conditions.add((JsonNode)condition.getConditionObject());
    }

    public void setMatchAnyCondition(boolean on) {
        this.conditionJoin = on ? "or" : "and";
    }

    public void setNegateAll(boolean on) {
        this.negateAll = on;
    }

    public void addNestedConditionSet(IGCSearchConditionSet igcConditions) {
        this.conditions.add((JsonNode)igcConditions.getConditionSetObject());
    }

    public int size() {
        return this.conditions.size();
    }

    public ObjectNode getConditionSetObject() {
        ObjectNode condSet = this.nf.objectNode();
        if (this.size() > 0) {
            if (this.negateAll) {
                ArrayNode negatedConditions = this.nf.arrayNode(this.conditions.size());
                for (JsonNode condition : this.conditions) {
                    JsonNode existingOperation;
                    if (!(condition instanceof ObjectNode)) continue;
                    ObjectNode onCondition = (ObjectNode)condition;
                    JsonNode existingNegated = onCondition.path("negated");
                    BooleanNode negated = this.nf.booleanNode(true);
                    if (!existingNegated.isMissingNode()) {
                        negated = (BooleanNode)onCondition.get("negated");
                        negated = negated.asBoolean() ? this.nf.booleanNode(false) : this.nf.booleanNode(true);
                    }
                    if (!(existingOperation = onCondition.path("operator")).isMissingNode()) {
                        TextNode operator = (TextNode)existingOperation;
                        if (operator.textValue().equals("=") && negated.booleanValue()) {
                            operator = this.nf.textNode("<>");
                            negated = null;
                        } else if (operator.textValue().equals("<>") && negated.booleanValue()) {
                            operator = this.nf.textNode("=");
                            negated = null;
                        }
                        onCondition.set("operator", (JsonNode)operator);
                    }
                    if (negated != null) {
                        onCondition.set("negated", (JsonNode)negated);
                    }
                    negatedConditions.add((JsonNode)onCondition);
                }
                condSet.set("conditions", (JsonNode)negatedConditions);
                condSet.set("operator", (JsonNode)this.nf.textNode(this.conditionJoin));
            } else {
                condSet.set("conditions", (JsonNode)this.conditions);
                condSet.set("operator", (JsonNode)this.nf.textNode(this.conditionJoin));
            }
        }
        return condSet;
    }
}

