/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;

public class IGCCreate {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String type;
    private Map<String, String> properties;

    public IGCCreate(String type) {
        this.type = type;
        this.properties = new HashMap<String, String>();
    }

    public void addProperty(String propertyName, String value) {
        this.properties.put(propertyName, value);
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public JsonNode getCreate() {
        ObjectNode create = this.nf.objectNode();
        create.put("_type", this.type);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            create.set(entry.getKey(), (JsonNode)this.nf.textNode(entry.getValue()));
        }
        return create;
    }

    public String toString() {
        return this.getCreate().toString();
    }
}

