/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.clientlibrary.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IGCUpdate {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String ridToUpdate;
    private Map<String, String> properties;
    private Map<String, List<String>> relationships;
    private Map<String, String> exclusiveRelationships;
    private UpdateMode relationshipUpdateMode;

    public IGCUpdate(String ridToUpdate) {
        this.ridToUpdate = ridToUpdate;
        this.properties = new HashMap<String, String>();
        this.relationships = new HashMap<String, List<String>>();
        this.exclusiveRelationships = new HashMap<String, String>();
    }

    public void addProperty(String propertyName, String value) {
        this.properties.put(propertyName, value);
    }

    public void addExclusiveRelationship(String propertyName, String relatedRid) {
        this.exclusiveRelationships.put(propertyName, relatedRid);
    }

    public void addRelationship(String propertyName, String relatedRid) {
        if (!this.relationships.containsKey(propertyName)) {
            this.relationships.put(propertyName, new ArrayList());
        }
        this.relationships.get(propertyName).add(relatedRid);
    }

    public void setRelationshipUpdateMode(UpdateMode updateMode) {
        this.relationshipUpdateMode = updateMode;
    }

    public String getRidToUpdate() {
        return this.ridToUpdate;
    }

    public JsonNode getUpdate() {
        ObjectNode update = this.nf.objectNode();
        if (!this.properties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                update.set(entry.getKey(), (JsonNode)this.nf.textNode(entry.getValue()));
            }
        }
        if (!this.relationships.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.relationships.entrySet()) {
                String propertyName = entry.getKey();
                List rids = (List)entry.getValue();
                ArrayNode ridArray = this.nf.arrayNode(rids.size());
                for (String rid : rids) {
                    ridArray.add(rid);
                }
                ObjectNode items = this.nf.objectNode();
                items.set("items", (JsonNode)ridArray);
                if (this.relationshipUpdateMode != null) {
                    TextNode mode = null;
                    mode = this.relationshipUpdateMode == UpdateMode.REPLACE ? this.nf.textNode("replace") : this.nf.textNode("add");
                    items.set("mode", (JsonNode)mode);
                }
                update.set(propertyName, (JsonNode)items);
            }
        }
        if (!this.exclusiveRelationships.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.exclusiveRelationships.entrySet()) {
                update.set(entry.getKey(), (JsonNode)this.nf.textNode((String)entry.getValue()));
            }
        }
        return update;
    }

    public String toString() {
        return this.getUpdate().toString();
    }

    public static enum UpdateMode {
        APPEND,
        REPLACE;

    }
}

