/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.ChangeSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.InfosphereEvents;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.InfosphereEventsAssetEvent;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.InfosphereEventsDCEvent;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.InfosphereEventsIAEvent;
import org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model.InfosphereEventsIMAMEvent;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSRepositoryEventMapper
extends OMRSRepositoryEventMapperBase
implements VirtualConnectorExtension,
OpenMetadataTopicListener {
    private List<Connector> embeddedConnectors = null;
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSRepositoryEventMapper.class);
    private String sourceName = "IGCOMRSRepositoryEventMapper";
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCOMRSMetadataCollection igcomrsMetadataCollection;
    private IGCRestClient igcRestClient;
    private String metadataCollectionId;
    private String originatorServerName;
    private String originatorServerType;
    private IGCVersionEnum igcVersion;
    private Properties igcKafkaProperties;
    private String igcKafkaBootstrap;
    private String igcKafkaTopic;
    private ObjectMapper mapper;

    public void initialize(String repositoryEventMapperName, OMRSRepositoryConnector repositoryConnector) {
        super.initialize(repositoryEventMapperName, repositoryConnector);
        log.info("IGC Event Mapper initializing...");
        this.igcomrsRepositoryConnector = (IGCOMRSRepositoryConnector)this.repositoryConnector;
        this.igcVersion = this.igcomrsRepositoryConnector.getIGCVersion();
        this.igcRestClient = this.igcomrsRepositoryConnector.getIGCRestClient();
        this.igcKafkaTopic = "InfosphereEvents";
        this.igcKafkaBootstrap = this.connectionBean.getEndpoint().getAddress();
        this.igcKafkaProperties = new Properties();
        this.igcKafkaProperties.put("bootstrap.servers", this.igcKafkaBootstrap);
        this.igcKafkaProperties.put("group.id", "IGCOMRSRepositoryEventMapper_consumer");
        this.igcKafkaProperties.put("key.deserializer", StringDeserializer.class.getName());
        this.igcKafkaProperties.put("value.deserializer", StringDeserializer.class.getName());
        this.mapper = new ObjectMapper();
        this.mapper.enableDefaultTyping();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        log.info("IGC Event Mapper starting...");
        this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)this.igcomrsRepositoryConnector.getMetadataCollection();
        this.metadataCollectionId = this.igcomrsRepositoryConnector.getMetadataCollectionId();
        this.originatorServerName = this.igcomrsRepositoryConnector.getServerName();
        this.originatorServerType = this.igcomrsRepositoryConnector.getServerType();
        String methodName = "start";
        if (this.embeddedConnectors != null) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                String topicName = realTopicConnector.registerListener((OpenMetadataTopicListener)this);
                this.eventBusConnectors.add(realTopicConnector);
                if (this.auditLog == null) continue;
                OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_REGISTERED;
                this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.repositoryEventMapperName, topicName}), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.eventBusConnectors.isEmpty() && this.auditLog != null) {
            OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_DEAF;
            this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.repositoryEventMapperName}), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        log.info("Starting consumption from IGC Kafka bus.");
        new Thread(new IGCKafkaConsumerThread()).start();
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public void processEvent(String event) {
        log.debug("Processing event: {}", (Object)event);
        if (this.igcVersion.isEqualTo(IGCVersionEnum.V11702) || this.igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            this.processEventV117(event);
        } else {
            this.processEventV115(event);
        }
    }

    private void processEventV115(String event) {
        try {
            InfosphereEvents eventObj = (InfosphereEvents)this.mapper.readValue(event, InfosphereEvents.class);
            switch (eventObj.getEventType()) {
                case "IMAM_SHARE_EVENT": {
                    this.processIMAMShareEventV115((InfosphereEventsIMAMEvent)eventObj);
                    break;
                }
                case "DC_CREATE_EVENT": 
                case "DC_MERGED_EVENT": {
                    this.processDataConnectionEventV115((InfosphereEventsDCEvent)eventObj);
                    break;
                }
                case "IA_COLUMN_CLASSIFIED_EVENT": 
                case "IA_COLUMN_ANALYZED_EVENT": 
                case "IA_TABLE_RESULTS_PUBLISHED": {
                    this.processIAEventV115((InfosphereEventsIAEvent)eventObj);
                    break;
                }
                case "IA_PROJECT_CREATED_EVENT": 
                case "IA_TABLE_ADDED_TO_PROJECT": 
                case "IA_TABLE_REMOVED_FROM_PROJECT": 
                case "IA_DATARULE_CREATED_EVENT": 
                case "IA_COLUMN_ANALYSIS_SUBMITTED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_SUBMITTED": 
                case "IA_COLUMN_ANALYSIS_STARTED_EVENT": 
                case "IA_PROFILE_BATCH_COMPLETED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_STARTED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_FINISHED_EVENT": {
                    log.info("Found Information Analyzer event that cannot be processed via APIs, skipping.");
                    break;
                }
                default: {
                    this.processAssetEventV115((InfosphereEventsAssetEvent)eventObj);
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to translate event {} into object.", (Object)event, (Object)e);
        }
    }

    private void processIMAMShareEventV115(InfosphereEventsIMAMEvent event) {
        List<String> createdRIDs = this.getRIDsFromEventString(event.getCreatedRIDs());
        List<String> updatedRIDs = this.getRIDsFromEventString(event.getMergedRIDs());
        List<String> deletedRIDs = this.getRIDsFromEventString(event.getDeletedRIDs());
        for (String rid : createdRIDs) {
            this.processAsset(rid, null, null);
        }
        for (String rid : updatedRIDs) {
            this.processAsset(rid, null, null);
        }
        if (!deletedRIDs.isEmpty()) {
            log.warn("Unable to propagate IMAM deleted RIDs, cannot determine type: {}", deletedRIDs);
        }
    }

    private void processDataConnectionEventV115(InfosphereEventsDCEvent event) {
        String action;
        switch (action = event.getEventType()) {
            case "DC_CREATE_EVENT": {
                this.processAsset(event.getCreatedRID(), "data_connection", null);
                break;
            }
            case "DC_MERGED_EVENT": {
                this.processAsset(event.getMergedRID(), "data_connection", null);
                break;
            }
            default: {
                log.warn("Found unhandled action type '{}' for data connection on event: {}", (Object)action, (Object)event);
            }
        }
    }

    private void processAssetEventV115(InfosphereEventsAssetEvent event) {
        String action;
        String assetRid = event.getAssetRid();
        switch (action = event.getAction()) {
            case "CREATE": 
            case "MODIFY": 
            case "DELETE": {
                String igcAssetDisplayName = event.getAssetType();
                if (igcAssetDisplayName == null || igcAssetDisplayName.equals("OMRS Stub")) break;
                String igcAssetType = this.igcomrsMetadataCollection.getIgcAssetTypeForAssetName(igcAssetDisplayName);
                this.processAsset(assetRid, igcAssetType, null);
                break;
            }
            case "ASSIGNED_RELATIONSHIP": {
                log.debug("Ignoring ASSIGNED_RELATIONSHIP event -- should be handled already by an earlier CREATE or MODIFY event: {}", (Object)event);
                break;
            }
            default: {
                log.warn("Action '{}' is not yet implemented: {}", (Object)action, (Object)event);
            }
        }
    }

    private void processIAEventV115(InfosphereEventsIAEvent event) {
        String action;
        switch (action = event.getEventType()) {
            case "IA_COLUMN_ANALYZED_EVENT": 
            case "IA_COLUMN_CLASSIFIED_EVENT": {
                log.warn("Column / field analyzed or classified, but not yet published -- skipping: {}", (Object)event);
                break;
            }
            case "IA_TABLE_RESULTS_PUBLISHED": {
                String containerRid = event.getDataCollectionRid();
                this.processAsset(containerRid, null, null);
                Reference containerAsset = this.igcRestClient.getAssetRefById(containerRid);
                String searchProperty = null;
                String searchAssetType = null;
                switch (containerAsset.getType()) {
                    case "database_table": {
                        searchProperty = "database_table_or_view";
                        searchAssetType = "database_column";
                        break;
                    }
                    case "data_file_record": {
                        searchProperty = "data_file_record";
                        searchAssetType = "data_file_field";
                        break;
                    }
                    default: {
                        log.warn("Unimplemented asset type '{}' for IA publishing: {}", (Object)containerAsset.getType(), (Object)event);
                    }
                }
                IGCSearchCondition igcSearchCondition = new IGCSearchCondition(searchProperty, "=", containerAsset.getId());
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
                IGCSearch igcSearch = new IGCSearch(searchAssetType, new String[]{searchProperty}, igcSearchConditionSet);
                ReferenceList subAssets = this.igcRestClient.search(igcSearch);
                if (subAssets != null) {
                    subAssets.getAllPages(this.igcRestClient);
                    log.debug("Processing {} child assets from IA publication: {}", (Object)subAssets.getPaging().getNumTotal(), (Object)containerRid);
                    for (Reference child : subAssets.getItems()) {
                        this.processAsset(child.getId(), child.getType(), null);
                    }
                    break;
                }
                log.warn("Unable to find any sub-assets for IA published container '{}': {}", (Object)containerRid, (Object)event);
                break;
            }
            default: {
                log.warn("Action '{}' is not yet implemented for IA: {}", (Object)action, (Object)event);
            }
        }
    }

    private EntityDetail getEntityDetailForAsset(Reference asset) {
        return this.getEntityDetailForAssetWithRID(asset, asset.getId());
    }

    private EntityDetail getEntityDetailForAssetWithRID(Reference asset, String rid) {
        EntityDetail detail = null;
        try {
            detail = this.igcomrsMetadataCollection.getEntityDetail(this.localServerUserId, rid, asset);
        }
        catch (EntityNotKnownException e) {
            log.error("Unable to find EntityDetail for RID: {}", (Object)rid, (Object)e);
        }
        catch (RepositoryErrorException e) {
            log.error("Unexpected error in retrieving EntityDetail for RID: {}", (Object)rid, (Object)e);
        }
        return detail;
    }

    private EntityDetail getEntityDetailForStub(OMRSStub stub) {
        return this.getEntityDetailForStubWithRID(stub, null);
    }

    private EntityDetail getEntityDetailForStubWithRID(OMRSStub stub, String rid) {
        EntityDetail detail = null;
        log.debug("Retrieving EntityDetail for stub: {}", (Object)stub);
        log.debug(" ... specifically this payload: {}", (Object)stub.getPayload());
        Reference asset = this.igcomrsRepositoryConnector.getIGCRestClient().readJSONIntoPOJO(stub.getPayload());
        asset.setFullyRetrieved();
        if (rid == null) {
            rid = asset.getId();
        }
        log.debug(" ... retrieved asset from stub: {}", (Object)asset);
        try {
            detail = this.igcomrsMetadataCollection.getEntityDetail(this.localServerUserId, rid, asset);
        }
        catch (EntityNotKnownException e) {
            log.error("Unable to find EntityDetail for stub with RID: {}", (Object)rid, (Object)e);
        }
        catch (RepositoryErrorException e) {
            log.error("Unexpected error in retrieving EntityDetail for stub: {}", (Object)stub.getId());
        }
        return detail;
    }

    private List<String> getRIDsFromEventString(String payload) {
        ArrayList<String> rids = new ArrayList<String>();
        for (String token : payload.split(",")) {
            String[] subTokens = (token = token.trim()).split(":");
            if (subTokens.length == 2) {
                rids.add(subTokens[1]);
                continue;
            }
            log.warn("Unexpected number of tokens ({}) from event payload: {}", (Object)subTokens.length, (Object)payload);
        }
        return rids;
    }

    private void processAsset(String rid, String assetType, String relationshipGUID) {
        block12: {
            Reference latestVersion;
            block11: {
                log.debug("processAsset called with rid {} and type {}", (Object)rid, (Object)assetType);
                latestVersion = this.igcomrsMetadataCollection.getFullAssetDetails(rid);
                if (latestVersion != null) break block11;
                this.sendPurgedEntity(assetType, rid);
                List<EntityMapping> referenceableMappers = this.igcomrsMetadataCollection.getMappers(assetType, this.localServerUserId);
                for (EntityMapping referenceableMapper : referenceableMappers) {
                    List<RelationshipMapping> relationshipMappings = referenceableMapper.getRelationshipMappers();
                    for (RelationshipMapping relationshipMapping : relationshipMappings) {
                        String prefixOne = relationshipMapping.getProxyOneMapping().getIgcRidPrefix();
                        String prefixTwo = relationshipMapping.getProxyTwoMapping().getIgcRidPrefix();
                        if (prefixTwo != null) {
                            this.sendPurgedEntity(assetType, prefixTwo + rid);
                        }
                        if (prefixOne == null) continue;
                        this.sendPurgedEntity(assetType, prefixOne + rid);
                    }
                }
                break block12;
            }
            OMRSStub stub = this.igcomrsMetadataCollection.getOMRSStubForAsset(latestVersion);
            ChangeSet changeSet = new ChangeSet(this.igcRestClient, latestVersion, stub);
            Set<String> changedProperties = changeSet.getChangedProperties();
            if (stub == null) {
                this.sendNewEntity(latestVersion);
            } else if (!changedProperties.isEmpty()) {
                this.sendUpdatedEntity(latestVersion, stub);
            } else {
                log.info("Skipping asset - no changes detected: {}", (Object)latestVersion.getId());
            }
            Map<String, List<RelationshipMapping>> relationshipMap = this.igcomrsMetadataCollection.getIgcPropertiesToRelationshipMappings(latestVersion.getType(), this.localServerUserId);
            log.debug(" ... found mappings: {}", relationshipMap);
            if (!changedProperties.isEmpty()) {
                for (String igcProperty : changeSet.getChangedProperties()) {
                    log.debug(" ... checking for any relationship on: {}", (Object)igcProperty);
                    if (!relationshipMap.containsKey(igcProperty)) continue;
                    List<ChangeSet.Change> changesForProperty = changeSet.getChangesForProperty(igcProperty);
                    log.debug(" ...... found differences for property: {}", changesForProperty);
                    for (RelationshipMapping relationshipMapping : relationshipMap.get(igcProperty)) {
                        this.processRelationships(relationshipMapping, latestVersion, changesForProperty, relationshipGUID);
                    }
                }
            }
            if (!relationshipMap.containsKey("__SELF__")) break block12;
            for (RelationshipMapping relationshipMapping : relationshipMap.get("__SELF__")) {
                this.processSelfReferencingRelationship(relationshipMapping, latestVersion, stub, relationshipGUID);
            }
        }
    }

    private void processRelationships(RelationshipMapping relationshipMapping, Reference latestVersion, List<ChangeSet.Change> changesForProperty, String relationshipTriggerGUID) {
        log.debug("processRelationships called with relationshipMapping {}, reference {} and changes {}", new Object[]{relationshipMapping, latestVersion, changesForProperty});
        for (ChangeSet.Change change : changesForProperty) {
            String assetType = latestVersion.getType();
            Class pojo = this.igcRestClient.getPOJOForType(assetType);
            if (pojo != null) {
                List referenceListProperties = Reference.getPagedRelationalPropertiesFromPOJO((Class)pojo);
                Object relatedValue = change.getNewValue(referenceListProperties);
                log.debug(" ... found value: {}", relatedValue);
                if (relatedValue != null) {
                    Reference relatedAsset;
                    if (Reference.isReferenceList((Object)relatedValue).booleanValue()) {
                        log.debug(" ... found ReferenceList, processing each item");
                        ReferenceList related = (ReferenceList)relatedValue;
                        for (Reference relatedAsset2 : related.getItems()) {
                            this.processOneOrMoreRelationships(relationshipMapping, latestVersion, relatedAsset2, change, relationshipTriggerGUID);
                        }
                        continue;
                    }
                    if (Reference.isReference((Object)relatedValue).booleanValue()) {
                        log.debug(" ... found single Reference, processing it");
                        relatedAsset = (Reference)relatedValue;
                        this.processOneOrMoreRelationships(relationshipMapping, latestVersion, relatedAsset, change, relationshipTriggerGUID);
                        continue;
                    }
                    if (change.getIgcPropertyPath().endsWith("_id") && Reference.isSimpleType((Object)relatedValue).booleanValue()) {
                        log.debug(" ... found single Reference by '_id', processing it");
                        relatedAsset = this.igcRestClient.getAssetRefById((String)relatedValue);
                        this.processOneOrMoreRelationships(relationshipMapping, latestVersion, relatedAsset, change, relationshipTriggerGUID);
                        continue;
                    }
                    log.warn("Expected relationship for path '{}' for guid {} but found neither Reference nor ReferenceList: {}", new Object[]{change.getIgcPropertyPath(), latestVersion.getId(), relatedValue});
                    continue;
                }
                log.warn("Expected relationship for path '{}' for guid {} but found nothing: {}", new Object[]{change.getIgcPropertyPath(), latestVersion.getId(), relatedValue});
                continue;
            }
            log.warn("No registered POJO to translate asset type '{}' for guid {} -- skipping its relationships.", (Object)assetType, (Object)latestVersion.getId());
        }
    }

    private void processOneOrMoreRelationships(RelationshipMapping relationshipMapping, Reference latestVersion, Reference relatedAsset, ChangeSet.Change change, String relationshipTriggerGUID) {
        String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
        String latestVersionRID = latestVersion.getId();
        String relatedRID = relatedAsset.getId();
        if (relatedRID != null && !relatedRID.equals("null")) {
            log.debug("processOneOrMoreRelationships processing between {} and {} for type: {}", new Object[]{latestVersionRID, relatedRID, omrsRelationshipType});
            RelationshipMapping.ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
            RelationshipMapping.ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
            String latestVersionType = latestVersion.getType();
            String relatedAssetType = relatedAsset.getType();
            List<Object> proxyOnes = new ArrayList();
            List<Object> proxyTwos = new ArrayList();
            if (pmOne.matchesAssetType(latestVersionType) && pmTwo.matchesAssetType(relatedAssetType)) {
                proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
            } else if (pmTwo.matchesAssetType(latestVersionType) && pmOne.matchesAssetType(relatedAssetType)) {
                proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
            } else if (relationshipMapping.hasLinkingAsset()) {
                String linkingType = relationshipMapping.getLinkingAssetType();
                if (latestVersionType.equals(linkingType) && pmTwo.matchesAssetType(relatedAssetType) || relatedAssetType.equals(linkingType) && pmOne.matchesAssetType(latestVersionType)) {
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
                } else if (relatedAssetType.equals(linkingType) && pmTwo.matchesAssetType(latestVersionType) || latestVersionType.equals(linkingType) && pmOne.matchesAssetType(relatedAssetType)) {
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
                } else {
                    log.warn("Unable to match assets to proxies through linking asset '{}' for guids {} and {} through relationship type {} -- skipped, but this is likely indicative of a problem with the mapping.", new Object[]{linkingType, latestVersion.getId(), relatedAsset.getId(), omrsRelationshipType});
                }
            } else {
                log.warn("Unable to match assets {} and {} to proxies for any asset translation for relationship type {} -- skipped, but this is likely indicative of a problem with the mapping.", new Object[]{latestVersion.getId(), relatedAsset.getId(), omrsRelationshipType});
                proxyOnes.add(latestVersion);
                proxyTwos.add(relatedAsset);
            }
            for (Reference reference : proxyOnes) {
                for (Reference reference2 : proxyTwos) {
                    this.processSingleRelationship(relationshipMapping, reference, reference2, change, relationshipTriggerGUID);
                }
            }
        } else {
            log.warn("Related RID for guid {} and relationship {} was null -- skipped.", (Object)latestVersion.getId(), (Object)omrsRelationshipType);
        }
    }

    private void processSingleRelationship(RelationshipMapping relationshipMapping, Reference latestVersion, Reference relatedAsset, ChangeSet.Change change, String relationshipTriggerGUID) {
        String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
        String latestVersionRID = latestVersion.getId();
        String relatedRID = relatedAsset.getId();
        if (relatedRID != null && !relatedRID.equals("null")) {
            log.debug("processSingleRelationship processing between {} and {} for type: {}", new Object[]{latestVersionRID, relatedRID, omrsRelationshipType});
            RelationshipMapping.ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
            RelationshipMapping.ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
            String relationshipGUID = RelationshipMapping.getRelationshipGUID(relationshipMapping, latestVersion, relatedAsset, change.getIgcPropertyName(), null);
            log.debug(" ... calculated relationship GUID: {}", (Object)relationshipGUID);
            if (relationshipTriggerGUID == null || !relationshipTriggerGUID.equals(relationshipGUID)) {
                String changeType = change.getOp();
                log.debug(" ... change action: {}", (Object)changeType);
                if (changeType.equals("remove")) {
                    try {
                        RelationshipDef relationshipDef = (RelationshipDef)this.igcomrsMetadataCollection.getTypeDefByName(this.localServerUserId, omrsRelationshipType);
                        this.sendPurgedRelationship(relationshipDef, relationshipGUID);
                        this.processAsset(RelationshipMapping.getProxyOneGUIDFromRelationshipGUID(relationshipGUID), pmOne.getIgcAssetType(), relationshipGUID);
                        this.processAsset(RelationshipMapping.getProxyTwoGUIDFromRelationshipGUID(relationshipGUID), pmTwo.getIgcAssetType(), relationshipGUID);
                    }
                    catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException e) {
                        log.error("Unable to retrieve relationship type definition: {}", (Object)omrsRelationshipType, (Object)e);
                    }
                    catch (UserNotAuthorizedException e) {
                        log.error("User not authorized to retrieve type definition: {}", (Object)omrsRelationshipType, (Object)e);
                    }
                } else {
                    try {
                        Relationship relationship = this.igcomrsMetadataCollection.getRelationship(this.localServerUserId, relationshipGUID);
                        log.debug(" ... retrieved relationship: {}", (Object)relationship);
                        this.processAsset(relatedRID, relatedAsset.getType(), relationshipGUID);
                        this.processAsset(latestVersionRID, latestVersion.getType(), relationshipGUID);
                        switch (changeType) {
                            case "add": {
                                this.sendNewRelationship(relationship);
                                break;
                            }
                            case "replace": {
                                this.sendUpdatedRelationship(relationship);
                                break;
                            }
                            default: {
                                log.warn("Unknown action '{}' for relationship {}", (Object)changeType, (Object)relationshipGUID);
                                break;
                            }
                        }
                    }
                    catch (RelationshipNotKnownException e) {
                        log.error("Unable to find relationship with GUID: {}", (Object)relationshipGUID);
                    }
                    catch (InvalidParameterException | RepositoryErrorException e) {
                        log.error("Unknown error occurred trying to retrieve relationship: {}", (Object)relationshipGUID, (Object)e);
                    }
                    catch (UserNotAuthorizedException e) {
                        log.error("User not authorized to retrieve relationship: {}", (Object)relationshipGUID, (Object)e);
                    }
                }
            } else {
                log.info("Relationship was same as one that triggered this processing -- skipping: {}", (Object)relationshipTriggerGUID);
            }
        } else {
            log.warn("Related RID for relationship type {} and guid {} was null.", (Object)omrsRelationshipType, (Object)latestVersionRID);
        }
    }

    private void processSelfReferencingRelationship(RelationshipMapping relationshipMapping, Reference latestVersion, OMRSStub stub, String relationshipTriggerGUID) {
        block7: {
            String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
            String latestVersionRID = latestVersion.getId();
            log.debug("processSelfReferencingRelationship processing for {} and type: {}", (Object)latestVersionRID, (Object)omrsRelationshipType);
            String relationshipGUID = RelationshipMapping.getRelationshipGUID(relationshipMapping, latestVersion, latestVersion, "__SELF__", null);
            log.debug(" ... calculated relationship GUID: {}", (Object)relationshipGUID);
            if (relationshipTriggerGUID == null || !relationshipTriggerGUID.equals(relationshipGUID)) {
                try {
                    Relationship relationship = this.igcomrsMetadataCollection.getRelationship(this.localServerUserId, relationshipGUID);
                    log.debug(" ... retrieved relationship: {}", (Object)relationship);
                    if (stub == null) {
                        this.sendNewRelationship(relationship);
                        break block7;
                    }
                    this.sendUpdatedRelationship(relationship);
                }
                catch (RelationshipNotKnownException e) {
                    log.error("Unable to find relationship with GUID: {}", (Object)relationshipGUID);
                }
                catch (InvalidParameterException | RepositoryErrorException e) {
                    log.error("Unknown error occurred trying to retrieve relationship: {}", (Object)relationshipGUID, (Object)e);
                }
                catch (UserNotAuthorizedException e) {
                    log.error("User not authorized to retrieve relationship: {}", (Object)relationshipGUID, (Object)e);
                }
            } else {
                log.info("Relationship was same as the one that triggered this processing -- skipping: {}", (Object)relationshipTriggerGUID);
            }
        }
    }

    private void sendNewRelationship(Relationship relationship) {
        if (relationship != null) {
            this.repositoryEventProcessor.processNewRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, relationship);
        }
    }

    private void sendUpdatedRelationship(Relationship relationship) {
        if (relationship != null) {
            this.repositoryEventProcessor.processUpdatedRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, null, relationship);
        }
    }

    private void sendPurgedRelationship(RelationshipDef omrsRelationshipDef, String relationshipGUID) {
        this.repositoryEventProcessor.processPurgedRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, omrsRelationshipDef.getGUID(), omrsRelationshipDef.getName(), relationshipGUID);
    }

    private void sendNewEntity(Reference asset) {
        EntityDetail detail = this.getEntityDetailForAsset(asset);
        if (detail != null) {
            this.repositoryEventProcessor.processNewEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
            List classifications = detail.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    this.sendNewClassification(detail);
                }
            }
            List<EntityMapping> referenceableMappers = this.igcomrsMetadataCollection.getMappers(asset.getType(), this.localServerUserId);
            for (EntityMapping referenceableMapper : referenceableMappers) {
                String ridPrefix = referenceableMapper.getIgcRidPrefix();
                if (ridPrefix != null) {
                    EntityDetail genDetail = this.getEntityDetailForAssetWithRID(asset, ridPrefix + asset.getId());
                    if (genDetail != null) {
                        this.repositoryEventProcessor.processNewEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, genDetail);
                        classifications = genDetail.getClassifications();
                        if (classifications == null) continue;
                        for (Classification classification : classifications) {
                            this.sendNewClassification(genDetail);
                        }
                        continue;
                    }
                    log.warn("Unable to generate new entity for asset type {} with prefix {} and RID: {}", new Object[]{asset.getType(), ridPrefix, asset.getId()});
                    continue;
                }
                log.debug("No prefix found in mapper {}, skipping for generated new entity.", (Object)referenceableMapper.getClass().getCanonicalName());
            }
            this.igcomrsMetadataCollection.upsertOMRSStubForAsset(asset);
        } else {
            log.error("EntityDetail could not be retrieved for RID: {}", (Object)asset.getId());
        }
    }

    private void sendUpdatedEntity(Reference latestVersion, OMRSStub stub) {
        EntityDetail latest = this.getEntityDetailForAsset(latestVersion);
        if (latest != null) {
            EntityDetail last = this.getEntityDetailForStub(stub);
            this.repositoryEventProcessor.processUpdatedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, last, latest);
            this.processClassifications(latest, latest.getClassifications(), last == null ? new ArrayList() : last.getClassifications());
            List<EntityMapping> referenceableMappers = this.igcomrsMetadataCollection.getMappers(latestVersion.getType(), this.localServerUserId);
            for (EntityMapping referenceableMapper : referenceableMappers) {
                String ridPrefix = referenceableMapper.getIgcRidPrefix();
                if (ridPrefix != null) {
                    String prefixedRID = ridPrefix + latestVersion.getId();
                    EntityDetail genDetail = this.getEntityDetailForAssetWithRID(latestVersion, prefixedRID);
                    if (genDetail != null) {
                        EntityDetail genLast = this.getEntityDetailForStubWithRID(stub, prefixedRID);
                        this.repositoryEventProcessor.processUpdatedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, genLast, genDetail);
                        this.processClassifications(genDetail, genDetail.getClassifications(), genLast == null ? new ArrayList() : genLast.getClassifications());
                        continue;
                    }
                    log.warn("Unable to generate updated entity for asset type {} with prefix {} and RID: {}", new Object[]{latestVersion.getType(), ridPrefix, latestVersion.getId()});
                    continue;
                }
                log.debug("No prefix found in mapper {}, skipping for generated update entity.", (Object)referenceableMapper.getClass().getCanonicalName());
            }
            this.igcomrsMetadataCollection.upsertOMRSStubForAsset(latestVersion);
        } else {
            log.error("Latest EntityDetail could not be retrieved for RID: {}", (Object)latestVersion.getId());
        }
    }

    private void processClassifications(EntityDetail detail, List<Classification> latestClassifications, List<Classification> lastClassifications) {
        Map<String, Classification> latestClassificationByGUID = this.getClassificationMapFromList(latestClassifications);
        Map<String, Classification> lastClassificationByGUID = this.getClassificationMapFromList(lastClassifications);
        ArrayList<String> matchingGUIDs = new ArrayList<String>();
        for (String guid : latestClassificationByGUID.keySet()) {
            if (!lastClassificationByGUID.containsKey(guid)) {
                this.sendNewClassification(detail);
                continue;
            }
            matchingGUIDs.add(guid);
        }
        for (String guid : lastClassificationByGUID.keySet()) {
            if (latestClassificationByGUID.containsKey(guid)) continue;
            this.sendRemovedClassification(detail);
        }
        for (String matchingGUID : matchingGUIDs) {
            Classification last;
            Classification latest = latestClassificationByGUID.get(matchingGUID);
            if (latest.equals((Object)(last = lastClassificationByGUID.get(matchingGUID)))) continue;
            this.sendChangedClassification(detail);
        }
    }

    private Map<String, Classification> getClassificationMapFromList(List<Classification> classifications) {
        HashMap<String, Classification> map = new HashMap<String, Classification>();
        if (classifications != null) {
            for (Classification classification : classifications) {
                String typeGUID = classification.getType().getTypeDefGUID();
                if (map.containsKey(typeGUID)) {
                    log.warn("Found multiple classifications of type {} -- clobbering!", (Object)typeGUID);
                }
                map.put(typeGUID, classification);
            }
        }
        return map;
    }

    private void sendNewClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processClassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendChangedClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processReclassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendRemovedClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processDeclassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendPurgedEntity(String igcAssetType, String rid) {
        if (igcAssetType != null) {
            List<EntityMapping> referenceableMappers = this.igcomrsMetadataCollection.getMappers(igcAssetType, this.localServerUserId);
            for (EntityMapping referenceableMapper : referenceableMappers) {
                String typeDefName = referenceableMapper.getOmrsTypeDefName();
                TypeDef typeDef = this.igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(this.igcomrsRepositoryConnector.getRepositoryName(), typeDefName);
                String ridToPurge = rid;
                String ridPrefix = referenceableMapper.getIgcRidPrefix();
                if (ridPrefix != null) {
                    ridToPurge = ridPrefix + ridToPurge;
                }
                this.repositoryEventProcessor.processPurgedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, typeDef.getGUID(), typeDef.getName(), ridToPurge);
            }
            this.igcomrsMetadataCollection.deleteOMRSStubForAsset(rid, igcAssetType);
        } else {
            log.warn("No asset type was provided for purged RID {} -- cannot generate purgeEntity event.", (Object)rid);
        }
    }

    private void processEventV117(String event) {
        log.debug("Not yet implemented as v11.7-specific -- backing to v11.5 processing: {}", (Object)event);
        this.processEventV115(event);
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }

    private class IGCKafkaConsumerThread
    implements Runnable {
        private IGCKafkaConsumerThread() {
        }

        @Override
        public void run() {
            log.info("Starting IGC Event Mapper consumer thread.");
            KafkaConsumer consumer = new KafkaConsumer(IGCOMRSRepositoryEventMapper.this.igcKafkaProperties);
            consumer.subscribe(Collections.singletonList(IGCOMRSRepositoryEventMapper.this.igcKafkaTopic));
            while (true) {
                try {
                    block3: while (true) {
                        ConsumerRecords events = consumer.poll(100L);
                        Iterator iterator = events.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            ConsumerRecord event = (ConsumerRecord)iterator.next();
                            IGCOMRSRepositoryEventMapper.this.processEvent((String)event.value());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("Failed trying to consume IGC events from Kafka.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

