/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.eventmapper.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.model.OMRSStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSet {
    private static final Logger log = LoggerFactory.getLogger(ChangeSet.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private IGCRestClient igcRestClient;
    private JsonNode patch;
    private HashMap<String, List<Change>> changesByProperty = new HashMap();

    public ChangeSet(IGCRestClient igcRestClient, Reference asset, OMRSStub stub) {
        this.igcRestClient = igcRestClient;
        if (stub == null) {
            stub = new OMRSStub();
            stub.setPayload("{}");
        }
        try {
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            this.patch = JsonDiff.asJson((JsonNode)this.objectMapper.readTree(stub.getPayload()), (JsonNode)this.objectMapper.readTree(this.igcRestClient.getValueAsJSON(asset)), (EnumSet)flags);
            log.debug("Found the following changes: {}", (Object)this.patch.toString());
            ArrayNode changes = (ArrayNode)this.patch;
            for (int i = 0; i < changes.size(); ++i) {
                JsonNode change = changes.get(i);
                if (change.path("path").asText().contains("/paging/")) continue;
                Change theChange = new Change(change);
                String igcProperty = theChange.getIgcPropertyName();
                if (!this.changesByProperty.containsKey(igcProperty)) {
                    this.changesByProperty.put(igcProperty, new ArrayList());
                }
                this.changesByProperty.get(igcProperty).add(theChange);
            }
        }
        catch (IOException e) {
            log.error("Unable to parse JSON for diff operation: {}, {}", new Object[]{asset, stub, e});
        }
    }

    public Set<String> getChangedProperties() {
        return this.changesByProperty.keySet();
    }

    public List<Change> getChangesForProperty(String property) {
        return this.changesByProperty.get(property);
    }

    public class Change {
        private String op;
        private String path;
        private JsonNode value;

        public Change(JsonNode patch) {
            this.op = patch.get("op").asText();
            this.path = patch.get("path").asText();
            this.value = patch.get("value");
        }

        public Change(String op, String path, JsonNode value) {
            this.op = op;
            this.path = path;
            this.value = value;
        }

        public String getOp() {
            return this.op;
        }

        public String getIgcPropertyName() {
            String[] aTokens = this.path.split("/");
            if (aTokens.length > 1) {
                return aTokens[1];
            }
            log.error("Unable to find any property in path: {}", (Object)this.path);
            return null;
        }

        public String getIgcPropertyPath() {
            return this.path;
        }

        public Object getNewValue(List<String> referenceListProperties) {
            Object actualValue = null;
            JsonNodeType jsonType = this.value.getNodeType();
            switch (jsonType) {
                case NULL: {
                    actualValue = null;
                    break;
                }
                case BOOLEAN: {
                    actualValue = this.value.asBoolean();
                    break;
                }
                case NUMBER: {
                    actualValue = this.value.asDouble();
                    break;
                }
                case OBJECT: {
                    if (referenceListProperties.contains(this.getIgcPropertyName()) && !this.path.contains("/items/")) {
                        actualValue = ChangeSet.this.igcRestClient.readJSONIntoReferenceList(this.value.toString());
                        break;
                    }
                    actualValue = ChangeSet.this.igcRestClient.readJSONIntoPOJO(this.value.toString());
                    break;
                }
                case STRING: {
                    actualValue = this.value.asText();
                    break;
                }
                default: {
                    log.warn("Unhandled value type '{}': {}", (Object)jsonType, (Object)this.value);
                }
            }
            return actualValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Change: {");
            sb.append(" op=");
            sb.append(this.op);
            sb.append(", path=");
            sb.append(this.path);
            sb.append(", value=");
            sb.append(this.value.toString());
            sb.append("}");
            return sb.toString();
        }
    }
}

