/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.PropertyMappingSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores.AttributeMappingStore;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores.ClassificationMappingStore;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores.EntityMappingStore;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores.RelationshipMappingStore;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSMetadataCollection.class);
    public static final String MAPPING_PKG = "org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.";
    public static final String DEFAULT_IGC_TYPE = "main_object";
    public static final String DEFAULT_IGC_TYPE_DISPLAY_NAME = "Main Object";
    public static final String GENERATED_TYPE_PREFIX = "__|";
    public static final String GENERATED_TYPE_POSTFIX = "|__";
    private IGCRestClient igcRestClient;
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private TypeDefStore typeDefStore;
    private EntityMappingStore entityMappingStore;
    private RelationshipMappingStore relationshipMappingStore;
    private ClassificationMappingStore classificationMappingStore;
    private AttributeMappingStore attributeMappingStore;
    private XMLOutputFactory xmlOutputFactory;

    public IGCOMRSMetadataCollection(IGCOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        log.debug("Constructing IGCOMRSMetadataCollection with name: {}", (Object)repositoryName);
        parentConnector.setRepositoryName(repositoryName);
        this.igcRestClient = parentConnector.getIGCRestClient();
        this.igcomrsRepositoryConnector = parentConnector;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.typeDefStore = new TypeDefStore();
        this.entityMappingStore = new EntityMappingStore();
        this.relationshipMappingStore = new RelationshipMappingStore();
        this.classificationMappingStore = new ClassificationMappingStore();
        this.attributeMappingStore = new AttributeMappingStore();
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        this.validateRepositoryConnector("getAllTypes");
        this.parentConnector.validateRepositoryIsActive("getAllTypes");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAllTypes");
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        log.debug("Retrieved {} implemented TypeDefs for this repository.", (Object)typeDefs.size());
        typeDefGallery.setTypeDefs(typeDefs);
        List<AttributeTypeDef> attributeTypeDefs = this.attributeMappingStore.getAllAttributeTypeDefs();
        log.debug("Retrieved {} implemented AttributeTypeDefs for this repository.", (Object)attributeTypeDefs.size());
        typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
        return typeDefGallery;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByCategory");
        this.repositoryValidator.validateTypeDefCategory(this.repositoryName, "category", category, "findTypeDefsByCategory");
        List<TypeDef> typeDefs = new ArrayList<TypeDef>();
        switch (category) {
            case ENTITY_DEF: {
                typeDefs = this.entityMappingStore.getTypeDefs();
                break;
            }
            case RELATIONSHIP_DEF: {
                typeDefs = this.relationshipMappingStore.getTypeDefs();
                break;
            }
            case CLASSIFICATION_DEF: {
                typeDefs = this.classificationMappingStore.getTypeDefs();
            }
        }
        return typeDefs;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findAttributeTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateAttributeTypeDefCategory(this.repositoryName, "category", category, "findAttributeTypeDefsByCategory");
        return this.attributeMappingStore.getAttributeTypeDefsByCategory(category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        this.validateRepositoryConnector("findTypeDefsByProperty");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", matchCriteria, "findTypeDefsByProperty");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        List<TypeDef> results = new ArrayList<TypeDef>();
        if (matchCriteria != null) {
            Map properties = matchCriteria.getTypeDefProperties();
            for (TypeDef candidate : typeDefs) {
                List candidateProperties = candidate.getPropertiesDefinition();
                for (TypeDefAttribute candidateAttribute : candidateProperties) {
                    String candidateName = candidateAttribute.getAttributeName();
                    if (!properties.containsKey(candidateName)) continue;
                    results.add(candidate);
                }
            }
            results = typeDefs;
        }
        return results;
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        ArrayList<TypeDef> results;
        String methodName = "findTypesByExternalID";
        this.validateRepositoryConnector("findTypesByExternalID");
        this.parentConnector.validateRepositoryIsActive("findTypesByExternalID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByExternalID");
        this.repositoryValidator.validateExternalId(this.repositoryName, standard, organization, identifier, "findTypesByExternalID");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        if (standard == null && organization == null && identifier == null) {
            results = typeDefs;
        } else {
            results = new ArrayList();
            for (TypeDef typeDef : typeDefs) {
                List externalStandardMappings = typeDef.getExternalStandardMappings();
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    String candidateStandard = externalStandardMapping.getStandardName();
                    String candidateOrg = externalStandardMapping.getStandardOrganization();
                    String candidateId = externalStandardMapping.getStandardTypeName();
                    if (standard != null && !standard.equals(candidateStandard) || organization != null && !organization.equals(candidateOrg) || identifier != null && !identifier.equals(candidateId)) continue;
                    results.add(typeDef);
                }
            }
        }
        return results;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.validateRepositoryConnector("searchForTypeDefs");
        this.parentConnector.validateRepositoryIsActive("searchForTypeDefs");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "searchForTypeDefs");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "searchForTypeDefs");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.entityMappingStore.getTypeDefs()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.relationshipMappingStore.getTypeDefs()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.classificationMappingStore.getTypeDefs()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getTypeDefByGUID");
        TypeDef found = this.typeDefStore.getTypeDefByGUID(guid);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "guid", "getTypeDefByGUID", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getAttributeTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getAttributeTypeDefByGUID");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByGUID(guid);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ATTRIBUTE_TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"unknown", guid, "getAttributeTypeDefByGUID", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getTypeDefByName");
        TypeDef found = this.typeDefStore.getTypeDefByName(name);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "getTypeDefByName", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getAttributeTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getAttributeTypeDefByName");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByName(name);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ATTRIBUTE_TYPEDEF_NAME_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "getAttributeTypeDefByName", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        ArrayList typeDefs;
        String methodName = "addTypeDefGallery";
        String galleryParameterName = "newTypes";
        this.validateRepositoryConnector("addTypeDefGallery");
        this.parentConnector.validateRepositoryIsActive("addTypeDefGallery");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addTypeDefGallery");
        this.repositoryValidator.validateTypeDefGallery(this.repositoryName, "newTypes", newTypes, "addTypeDefGallery");
        List attributeTypeDefs = newTypes.getAttributeTypeDefs();
        if (attributeTypeDefs != null) {
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                this.addAttributeTypeDef(userId, attributeTypeDef);
            }
        }
        if ((typeDefs = newTypes.getTypeDefs()) != null) {
            for (TypeDef typeDef : typeDefs) {
                this.addTypeDef(userId, typeDef);
            }
        }
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        this.validateRepositoryConnector("addTypeDef");
        this.parentConnector.validateRepositoryIsActive("addTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
        this.repositoryValidator.validateUnknownTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
        TypeDefCategory typeDefCategory = newTypeDef.getCategory();
        String omrsTypeDefName = newTypeDef.getName();
        log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)typeDefCategory.getName());
        StringBuilder sbMapperClassname = new StringBuilder();
        sbMapperClassname.append(MAPPING_PKG);
        switch (typeDefCategory) {
            case RELATIONSHIP_DEF: {
                sbMapperClassname.append("relationships.");
                break;
            }
            case CLASSIFICATION_DEF: {
                sbMapperClassname.append("classifications.");
                break;
            }
            case ENTITY_DEF: {
                sbMapperClassname.append("entities.");
            }
        }
        sbMapperClassname.append(omrsTypeDefName);
        sbMapperClassname.append("Mapper");
        try {
            Class<?> mappingClass = Class.forName(sbMapperClassname.toString());
            log.debug(" ... found mapping class: {}", mappingClass);
            boolean success = false;
            switch (typeDefCategory) {
                case RELATIONSHIP_DEF: {
                    success = this.relationshipMappingStore.addMapping(newTypeDef, mappingClass);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    success = this.classificationMappingStore.addMapping(newTypeDef, mappingClass);
                    break;
                }
                case ENTITY_DEF: {
                    success = this.entityMappingStore.addMapping(newTypeDef, mappingClass, this.igcomrsRepositoryConnector, userId);
                }
            }
            if (!success) {
                this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
                throw new TypeDefNotSupportedException(404, IGCOMRSMetadataCollection.class.getName(), "addTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
            }
            this.typeDefStore.addTypeDef(newTypeDef);
        }
        catch (ClassNotFoundException e) {
            this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
            throw new TypeDefNotSupportedException(404, IGCOMRSMetadataCollection.class.getName(), "addTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        this.validateRepositoryConnector("addAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("addAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        this.repositoryValidator.validateUnknownAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        AttributeTypeDefCategory attributeTypeDefCategory = newAttributeTypeDef.getCategory();
        String omrsTypeDefName = newAttributeTypeDef.getName();
        log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)attributeTypeDefCategory.getName());
        StringBuilder sbMapperClassname = new StringBuilder();
        sbMapperClassname.append(MAPPING_PKG);
        sbMapperClassname.append("attributes.");
        sbMapperClassname.append(omrsTypeDefName);
        sbMapperClassname.append("Mapper");
        try {
            Class<?> mappingClass = Class.forName(sbMapperClassname.toString());
            log.debug(" ... found mapping class: {}", mappingClass);
            this.attributeMappingStore.addMapping(newAttributeTypeDef, mappingClass);
        }
        catch (ClassNotFoundException e) {
            throw new TypeDefNotSupportedException(404, IGCOMRSMetadataCollection.class.getName(), "addAttributeTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.validateRepositoryConnector("verifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "typeDef", typeDef, "verifyTypeDef");
        String guid = typeDef.getGUID();
        if (this.typeDefStore.getUnimplementedTypeDefByGUID(guid) != null) {
            throw new TypeDefNotSupportedException(404, IGCOMRSMetadataCollection.class.getName(), "verifyTypeDef", typeDef.getName() + " is not supported.", "", "Request support through Egeria GitHub issue.");
        }
        if (this.typeDefStore.getTypeDefByGUID(guid) != null) {
            HashSet validStatuses = new HashSet(typeDef.getValidInstanceStatusList());
            boolean bVerified = false;
            ArrayList<String> issues = new ArrayList<String>();
            Set<Object> mappedProperties = new HashSet();
            HashSet<Object> implementedStatuses = new HashSet();
            switch (typeDef.getCategory()) {
                case ENTITY_DEF: {
                    EntityMapping entityMapping = this.entityMappingStore.getMappingByOmrsTypeGUID(guid);
                    if (entityMapping == null) break;
                    mappedProperties = entityMapping.getPropertyMappings().getAllMappedOmrsProperties();
                    implementedStatuses = new HashSet<InstanceStatus>(entityMapping.getSupportedStatuses());
                    break;
                }
                case RELATIONSHIP_DEF: {
                    RelationshipMapping relationshipMapping = this.relationshipMappingStore.getMappingByOmrsTypeGUID(guid);
                    if (relationshipMapping == null) break;
                    mappedProperties = relationshipMapping.getMappedOmrsPropertyNames();
                    implementedStatuses = new HashSet<InstanceStatus>(relationshipMapping.getSupportedStatuses());
                    break;
                }
                case CLASSIFICATION_DEF: {
                    ClassificationMapping classificationMapping = this.classificationMappingStore.getMappingByOmrsTypeGUID(guid);
                    if (classificationMapping == null) break;
                    mappedProperties = classificationMapping.getMappedOmrsPropertyNames();
                    implementedStatuses = new HashSet<InstanceStatus>(classificationMapping.getSupportedStatuses());
                }
            }
            bVerified = validStatuses.equals(implementedStatuses);
            if (bVerified) {
                List properties = typeDef.getPropertiesDefinition();
                for (TypeDefAttribute typeDefAttribute : properties) {
                    String omrsPropertyName = typeDefAttribute.getAttributeName();
                    if (mappedProperties.contains(omrsPropertyName)) continue;
                    bVerified = false;
                    issues.add("list of mapped properties does not match");
                }
            } else {
                issues.add("list of valid statuses does not match");
            }
            if (!bVerified) {
                throw new TypeDefNotSupportedException(404, IGCOMRSMetadataCollection.class.getName(), "verifyTypeDef", typeDef.getName() + " is not supported: " + String.join((CharSequence)",", issues), "", "Request support through Egeria GitHub issue.");
            }
            return true;
        }
        return false;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        boolean bImplemented;
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.validateRepositoryConnector("verifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "attributeTypeDef", attributeTypeDef, "verifyAttributeTypeDef");
        switch (attributeTypeDef.getCategory()) {
            case PRIMITIVE: {
                bImplemented = true;
                break;
            }
            case UNKNOWN_DEF: {
                bImplemented = false;
                break;
            }
            case COLLECTION: {
                bImplemented = true;
                break;
            }
            case ENUM_DEF: {
                bImplemented = this.attributeMappingStore.getAttributeTypeDefByGUID(attributeTypeDef.getGUID()) != null;
                break;
            }
            default: {
                bImplemented = false;
            }
        }
        return bImplemented;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("isEntityKnown");
        this.parentConnector.validateRepositoryIsActive("isEntityKnown");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "isEntityKnown");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "isEntityKnown");
        EntityDetail detail = null;
        try {
            detail = this.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.info("Entity {} not known to the repository, or only a proxy.", (Object)guid, (Object)e);
        }
        return detail;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getEntitySummary");
        this.parentConnector.validateRepositoryIsActive("getEntitySummary");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntitySummary");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getEntitySummary");
        log.debug("getEntitySummary with guid = {}", (Object)guid);
        String rid = IGCOMRSMetadataCollection.getRidFromGeneratedId(guid);
        Reference asset = this.igcRestClient.getAssetRefById(rid);
        EntitySummary summary = null;
        String prefix = IGCOMRSMetadataCollection.getPrefixFromGeneratedId(guid);
        if (asset == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "getEntitySummary", this.repositoryName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (asset.getType().equals(DEFAULT_IGC_TYPE)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_ENTITY_FROM_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.repositoryName, "getEntitySummary", asset.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        ReferenceableMapper referenceMapper = this.getMapperForParameters(asset, prefix, userId);
        if (referenceMapper == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{prefix + asset.getType(), "IGC asset", "getEntitySummary", this.repositoryName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        summary = referenceMapper.getOMRSEntitySummary();
        return summary;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getEntityDetail");
        this.parentConnector.validateRepositoryIsActive("getEntityDetail");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityDetail");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getEntityDetail");
        String rid = IGCOMRSMetadataCollection.getRidFromGeneratedId(guid);
        Reference asset = this.igcRestClient.getAssetRefById(rid);
        return this.getEntityDetail(userId, guid, asset);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        String guidParameterName = "entityGUID";
        String typeGUIDParameter = "relationshipTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("getRelationshipsForEntity");
        this.parentConnector.validateRepositoryIsActive("getRelationshipsForEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelationshipsForEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getRelationshipsForEntity");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelationshipsForEntity");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "getRelationshipsForEntity");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelationshipsForEntity");
        ArrayList<Relationship> alRelationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelationshipsForEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (sequencingProperty != null || sequencingOrder != null && (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING) || sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING))) {
            OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelationshipsForEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            String rid = IGCOMRSMetadataCollection.getRidFromGeneratedId(entityGUID);
            String prefix = IGCOMRSMetadataCollection.getPrefixFromGeneratedId(entityGUID);
            Reference asset = this.igcRestClient.getAssetRefById(rid);
            if (asset == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelationshipsForEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            ReferenceableMapper referenceMapper = this.getMapperForParameters(asset, prefix, userId);
            if (referenceMapper != null) {
                alRelationships.addAll(referenceMapper.getOMRSRelationships(relationshipTypeGUID, fromRelationshipElement, sequencingOrder, pageSize));
            } else {
                OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{prefix + asset.getType(), "IGC asset", "getRelationshipsForEntity", this.repositoryName});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        return alRelationships.isEmpty() ? null : alRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchProperties";
        String typeGUIDParameterName = "entityTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("findEntitiesByProperty");
        this.parentConnector.validateRepositoryIsActive("findEntitiesByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findEntitiesByProperty");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByProperty");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByProperty");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchProperties", matchCriteria, matchProperties, "findEntitiesByProperty");
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"findEntitiesByProperty", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                String igcAssetType = mapping.getIgcAssetType();
                IGCSearchConditionSet classificationLimiters = this.getSearchCriteriaForClassifications(igcAssetType, limitResultsByClassification);
                if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty() && classificationLimiters == null) {
                    log.info("Classification limiters were specified, but none apply to thie asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
                    continue;
                }
                IGCSearch igcSearch = new IGCSearch();
                igcSearch.addType(igcAssetType);
                PropertyMappingSet propertyMappingSet = this.getEntityPropertiesFromMapping(mapping, userId);
                ArrayList<String> properties = new ArrayList<String>();
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
                Iterator iPropertyNames = matchProperties.getPropertyNames();
                while (propertyMappingSet != null && iPropertyNames.hasNext()) {
                    String omrsPropertyName = (String)iPropertyNames.next();
                    InstancePropertyValue value = matchProperties.getPropertyValue(omrsPropertyName);
                    this.addSearchConditionFromValue(igcSearchConditionSet, omrsPropertyName, properties, propertyMappingSet, value);
                }
                if (classificationLimiters != null) {
                    igcSearchConditionSet.addNestedConditionSet(classificationLimiters);
                }
                IGCSearchSorting igcSearchSorting = null;
                if (sequencingProperty == null && sequencingOrder != null) {
                    igcSearchSorting = IGCSearchSorting.sortFromNonPropertySequencingOrder((SequencingOrder)sequencingOrder);
                }
                if (matchCriteria != null) {
                    switch (matchCriteria) {
                        case ALL: {
                            igcSearchConditionSet.setMatchAnyCondition(false);
                            break;
                        }
                        case ANY: {
                            igcSearchConditionSet.setMatchAnyCondition(true);
                            break;
                        }
                        case NONE: {
                            igcSearchConditionSet.setMatchAnyCondition(false);
                            igcSearchConditionSet.setNegateAll(true);
                        }
                    }
                }
                igcSearch.addProperties(properties);
                igcSearch.addConditions(igcSearchConditionSet);
                this.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                if (igcSearchSorting != null) {
                    igcSearch.addSortingCriteria(igcSearchSorting);
                }
                this.processResults(mapping, this.igcRestClient.search(igcSearch), entityDetails, pageSize, userId);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        String classificationParameterName = "classificationName";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchClassificationProperties";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("findEntitiesByClassification");
        this.parentConnector.validateRepositoryIsActive("findEntitiesByClassification");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findEntitiesByClassification");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByClassification");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByClassification");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByClassification");
        if (entityTypeGUID != null) {
            TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByClassification");
            this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "entityTypeGUID", entityTypeDef, "findEntitiesByClassification");
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityTypeDef.getName(), "findEntitiesByClassification");
        }
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchClassificationProperties", matchCriteria, matchClassificationProperties, "findEntitiesByClassification");
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"findEntitiesByClassification", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                ClassificationMapping foundMapping = null;
                List<ClassificationMapping> classificationMappings = mapping.getClassificationMappers();
                for (ClassificationMapping classificationMapping : classificationMappings) {
                    String candidateName = classificationMapping.getOmrsClassificationType();
                    if (!candidateName.equals(classificationName)) continue;
                    foundMapping = classificationMapping;
                    break;
                }
                if (foundMapping != null) {
                    IGCSearch igcSearch = new IGCSearch();
                    igcSearch.addType(mapping.getIgcAssetType());
                    IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
                    List<String> igcClassificationProperties = foundMapping.getIgcRelationshipProperties();
                    IGCSearchConditionSet baseCriteria = foundMapping.getIGCSearchCriteria(matchClassificationProperties);
                    igcSearchConditionSet.addNestedConditionSet(baseCriteria);
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCSearchSorting.sortFromNonPropertySequencingOrder((SequencingOrder)sequencingOrder);
                    }
                    if (matchCriteria != null) {
                        switch (matchCriteria) {
                            case ALL: {
                                igcSearchConditionSet.setMatchAnyCondition(false);
                                break;
                            }
                            case ANY: {
                                igcSearchConditionSet.setMatchAnyCondition(true);
                                break;
                            }
                            case NONE: {
                                igcSearchConditionSet.setMatchAnyCondition(false);
                                igcSearchConditionSet.setNegateAll(true);
                            }
                        }
                    }
                    igcSearch.addProperties(igcClassificationProperties);
                    igcSearch.addConditions(igcSearchConditionSet);
                    this.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    this.processResults(mapping, this.igcRestClient.search(igcSearch), entityDetails, pageSize, userId);
                    continue;
                }
                log.info("No classification mapping has been implemented for {} on entity {} -- skipping from search.", (Object)classificationName, (Object)mapping.getOmrsTypeDefName());
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        String searchCriteriaParameterName = "searchCriteria";
        String typeGUIDParameter = "entityTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("findEntitiesByPropertyValue");
        this.parentConnector.validateRepositoryIsActive("findEntitiesByPropertyValue");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByPropertyValue");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByPropertyValue");
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"findEntitiesByPropertyValue", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByPropertyValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                IGCSearch igcSearch;
                String igcAssetType = this.addTypeToSearch(mapping, igcSearch = new IGCSearch());
                Class pojo = this.igcRestClient.getPOJOForType(igcAssetType);
                if (pojo != null) {
                    IGCSearchConditionSet classificationLimiters = this.getSearchCriteriaForClassifications(igcAssetType, limitResultsByClassification);
                    if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty() && classificationLimiters == null) {
                        log.info("Classification limiters were specified, but none apply to thie asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
                        continue;
                    }
                    ArrayList<String> properties = Reference.getStringPropertiesFromPOJO((Class)pojo);
                    if (this.igcRestClient.getIgcVersion().isEqualTo(IGCVersionEnum.V11702)) {
                        ArrayList<String> propertiesWithoutLongDescription = new ArrayList<String>();
                        for (String property : properties) {
                            if (property.equals("long_description")) continue;
                            propertiesWithoutLongDescription.add(property);
                        }
                        properties = propertiesWithoutLongDescription;
                    }
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCSearchSorting.sortFromNonPropertySequencingOrder((SequencingOrder)sequencingOrder);
                    }
                    IGCSearchConditionSet outerConditions = new IGCSearchConditionSet();
                    IGCSearchConditionSet innerConditions = new IGCSearchConditionSet();
                    innerConditions.setMatchAnyCondition(true);
                    for (String property : properties) {
                        innerConditions.addCondition(new IGCSearchCondition(property, "like %{0}%", searchCriteria));
                    }
                    outerConditions.addNestedConditionSet(innerConditions);
                    if (classificationLimiters != null) {
                        outerConditions.addNestedConditionSet(classificationLimiters);
                        outerConditions.setMatchAnyCondition(false);
                    }
                    igcSearch.addConditions(outerConditions);
                    this.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    this.processResults(mapping, this.igcRestClient.search(igcSearch), entityDetails, pageSize, userId);
                    continue;
                }
                log.warn("Unable to find POJO to handle IGC asset type '{}' -- skipping search against this asset type.", (Object)igcAssetType);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("isRelationshipKnown");
        this.parentConnector.validateRepositoryIsActive("isRelationshipKnown");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "isRelationshipKnown");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "isRelationshipKnown");
        Relationship relationship = null;
        try {
            relationship = this.getRelationship(userId, guid);
        }
        catch (RelationshipNotKnownException e) {
            log.info("Could not find relationship {} in repository.", (Object)guid, (Object)e);
        }
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        Reference proxyTwo;
        Reference proxyOne;
        RelationshipMapping relationshipMapping;
        String relationshipLevelRid;
        String methodName = "getRelationship";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getRelationship");
        this.parentConnector.validateRepositoryIsActive("getRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getRelationship");
        String proxyOneRid = RelationshipMapping.getProxyOneGUIDFromRelationshipGUID(guid);
        String proxyTwoRid = RelationshipMapping.getProxyTwoGUIDFromRelationshipGUID(guid);
        String omrsRelationshipName = RelationshipMapping.getRelationshipTypeFromRelationshipGUID(guid);
        String proxyOneIgcRid = proxyOneRid;
        String proxyTwoIgcRid = proxyTwoRid;
        if (IGCOMRSMetadataCollection.isGeneratedGUID(proxyOneRid)) {
            proxyOneIgcRid = IGCOMRSMetadataCollection.getRidFromGeneratedId(proxyOneRid);
        }
        if (IGCOMRSMetadataCollection.isGeneratedGUID(proxyTwoRid)) {
            proxyTwoIgcRid = IGCOMRSMetadataCollection.getRidFromGeneratedId(proxyTwoRid);
        }
        log.debug("Looking up relationship: {}", (Object)guid);
        String string = relationshipLevelRid = proxyOneRid.equals(proxyTwoRid) ? proxyOneRid : null;
        if (relationshipLevelRid != null) {
            Reference relationshipAsset = this.igcRestClient.getAssetRefById(proxyOneIgcRid);
            String relationshipAssetType = relationshipAsset.getType();
            relationshipMapping = this.relationshipMappingStore.getMappingByTypes(omrsRelationshipName, relationshipAssetType, relationshipAssetType);
            proxyOne = relationshipMapping.getProxyOneAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
            proxyTwo = relationshipMapping.getProxyTwoAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
        } else {
            proxyOne = this.igcRestClient.getAssetRefById(proxyOneIgcRid);
            proxyTwo = this.igcRestClient.getAssetRefById(proxyTwoIgcRid);
            relationshipMapping = this.relationshipMappingStore.getMappingByTypes(omrsRelationshipName, proxyOne.getType(), proxyTwo.getType());
        }
        Relationship found = null;
        if (relationshipMapping != null) {
            try {
                RelationshipDef omrsRelationshipDef = (RelationshipDef)this.getTypeDefByName(userId, omrsRelationshipName);
                String igcPropertyName = relationshipMapping.getProxyOneMapping().getIgcRelationshipProperties().get(0);
                log.debug(" ... using property: {}", (Object)igcPropertyName);
                found = RelationshipMapping.getMappedRelationship(this.igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, proxyOne, proxyTwo, igcPropertyName, userId, relationshipLevelRid);
            }
            catch (TypeDefNotKnownException e) {
                OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{omrsRelationshipName, guid, "guid", "getRelationship", this.repositoryName});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{omrsRelationshipName, guid, "guid", "getRelationship", this.repositoryName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchProperties";
        String guidParameterName = "relationshipTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("findRelationshipsByProperty");
        this.parentConnector.validateRepositoryIsActive("findRelationshipsByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findRelationshipsByProperty");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "findRelationshipsByProperty");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findRelationshipsByProperty");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findRelationshipsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchProperties", matchCriteria, matchProperties, "findRelationshipsByProperty");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"findRelationshipsByProperty", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        if (asOfTime == null) {
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyName";
        String asOfTimeParameter = "asOfTime";
        String typeGUIDParameter = "relationshipTypeGUID";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("findRelationshipsByPropertyName");
        this.parentConnector.validateRepositoryIsActive("findRelationshipsByPropertyName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findRelationshipsByPropertyName");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "findRelationshipsByPropertyName");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findRelationshipsByPropertyName");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findRelationshipsByPropertyName");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"findRelationshipsByPropertyName", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        if (asOfTime == null) {
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByPropertyName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByPropertyName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        String startEntityGUIDParameterName = "startEntityGUID";
        String endEntityGUIDParameterName = "entityGUID";
        String asOfTimeParameter = "asOfTime";
        this.validateRepositoryConnector("getLinkingEntities");
        this.parentConnector.validateRepositoryIsActive("getLinkingEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getLinkingEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getLinkingEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", endEntityGUID, "getLinkingEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getLinkingEntities");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getLinkingEntities", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getLinkingEntities", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        String entityGUIDParameterName = "entityGUID";
        String entityTypeGUIDParameterName = "entityTypeGUIDs";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUIDs";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        String asOfTimeParameter = "asOfTime";
        this.validateRepositoryConnector("getEntityNeighborhood");
        this.parentConnector.validateRepositoryIsActive("getEntityNeighborhood");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityNeighborhood");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getEntityNeighborhood");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getEntityNeighborhood");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (relationshipTypeGUIDs != null) {
            for (String guid : relationshipTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getEntityNeighborhood");
            }
        }
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getEntityNeighborhood", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntityNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        String entityGUIDParameterName = "startEntityGUID";
        String instanceTypesParameter = "instanceTypes";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("getRelatedEntities");
        this.parentConnector.validateRepositoryIsActive("getRelatedEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelatedEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getRelatedEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelatedEntities");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelatedEntities");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "instanceTypes", guid, "getRelatedEntities");
            }
        }
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelatedEntities", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelatedEntities", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        String entityGUIDParameterName = "entityGUID";
        String statusParameterName = "newStatus";
        this.validateRepositoryConnector("updateEntityStatus");
        this.parentConnector.validateRepositoryIsActive("updateEntityStatus");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateEntityStatus");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "updateEntityStatus");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityStatus", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        String entityGUIDParameterName = "entityGUID";
        this.validateRepositoryConnector("updateEntityProperties");
        this.parentConnector.validateRepositoryIsActive("updateEntityProperties");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateEntityProperties");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "updateEntityProperties");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityProperties", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String typeDefGUIDParameterName = "typeDefGUID";
        String typeDefNameParameterName = "typeDefName";
        String entityGUIDParameterName = "deletedEntityGUID";
        this.validateRepositoryConnector("purgeEntity");
        this.parentConnector.validateRepositoryIsActive("purgeEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "purgeEntity");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedEntityGUID", deletedEntityGUID, "purgeEntity");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"purgeEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "purgeEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        EntityDetail entityDetail = null;
        try {
            ClassificationMapping classificationMapping;
            Reference igcEntity;
            TypeDef classificationTypeDef = this.getTypeDefByName(userId, classificationName);
            if (classificationTypeDef != null) {
                String rid = IGCOMRSMetadataCollection.getRidFromGeneratedId(entityGUID);
                igcEntity = this.igcRestClient.getAssetRefById(rid);
                if (igcEntity == null) {
                    OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, "classifyEntity", this.repositoryName});
                    throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                classificationMapping = this.classificationMappingStore.getMappingByOmrsTypeName(classificationName);
                if (classificationMapping == null) {
                    OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, "classifyEntity", this.repositoryName});
                    throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            } else {
                OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, "classificationName", "classifyEntity", this.repositoryName});
                throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            entityDetail = classificationMapping.addClassificationToIGCAsset(this.igcomrsRepositoryConnector, igcEntity, entityGUID, classificationProperties, userId);
        }
        catch (TypeDefNotKnownException e) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, "classificationName", "classifyEntity", this.repositoryName});
            throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityDetail;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        this.validateRepositoryConnector("declassifyEntity");
        this.parentConnector.validateRepositoryIsActive("declassifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "declassifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "declassifyEntity");
        this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, "declassifyEntity");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"declassifyEntity", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "declassifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "properties";
        this.validateRepositoryConnector("updateEntityClassification");
        this.parentConnector.validateRepositoryIsActive("updateEntityClassification");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateEntityClassification");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "updateEntityClassification");
        this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, "updateEntityClassification");
        try {
            this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "properties", properties, "updateEntityClassification");
        }
        catch (PropertyErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.UNKNOWN_CLASSIFICATION;
            throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", error.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction());
        }
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityClassification", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        String guidParameterName = "relationshipTypeGUID";
        String propertiesParameterName = "initialProperties";
        String initialStatusParameterName = "initialStatus";
        this.validateRepositoryConnector("addRelationship");
        this.parentConnector.validateRepositoryIsActive("addRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addRelationship");
        this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "addRelationship");
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "addRelationship");
        this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "relationshipTypeGUID", typeDef, "addRelationship");
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "initialProperties", typeDef, initialProperties, "addRelationship");
        this.repositoryValidator.validateInstanceStatus(this.repositoryName, "initialStatus", initialStatus, typeDef, "addRelationship");
        Relationship relationship = null;
        if (initialStatus != null && initialStatus != InstanceStatus.ACTIVE) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_INSTANCE_STATUS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{initialStatus.getName(), "initialStatus", "addRelationship", this.repositoryName, relationshipTypeGUID});
            throw new StatusNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            RelationshipMapping relationshipMapping;
            Reference entityTwo;
            Reference entityOne;
            TypeDef relationshipTypeDef = this.getTypeDefByGUID(userId, relationshipTypeGUID);
            if (relationshipTypeDef != null) {
                String relationshipTypeName = relationshipTypeDef.getName();
                entityOne = this.igcRestClient.getAssetRefById(entityOneGUID);
                entityTwo = this.igcRestClient.getAssetRefById(entityTwoGUID);
                if (entityOne == null) {
                    OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityOneGUID, "addRelationship", this.repositoryName});
                    throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                if (entityTwo == null) {
                    OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityTwoGUID, "addRelationship", this.repositoryName});
                    throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                relationshipMapping = this.relationshipMappingStore.getMappingByTypes(relationshipTypeName, entityOne.getType(), entityTwo.getType());
                if (relationshipMapping == null) {
                    OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipTypeName, "addRelationship", this.repositoryName});
                    throw new TypeErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            } else {
                OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipTypeGUID, "relationshipTypeGUID", "addRelationship", this.repositoryName});
                throw new TypeErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            relationship = RelationshipMapping.addIgcRelationship(this.igcomrsRepositoryConnector, relationshipMapping, initialProperties, entityOne, entityTwo, userId);
        }
        catch (TypeDefNotKnownException e) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipTypeGUID, "relationshipTypeGUID", "addRelationship", this.repositoryName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationship;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        String guidParameterName = "relationshipGUID";
        String statusParameterName = "newStatus";
        this.validateRepositoryConnector("updateRelationshipStatus");
        this.parentConnector.validateRepositoryIsActive("updateRelationshipStatus");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateRelationshipStatus");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "updateRelationshipStatus");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateRelationshipStatus", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateRelationshipStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        String guidParameterName = "relationshipGUID";
        String propertiesParameterName = "properties";
        this.validateRepositoryConnector("updateRelationshipProperties");
        this.parentConnector.validateRepositoryIsActive("updateRelationshipProperties");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateRelationshipProperties");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "updateRelationshipProperties");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateRelationshipProperties", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateRelationshipProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "deletedRelationshipGUID";
        this.validateRepositoryConnector("purgeRelationship");
        this.parentConnector.validateRepositoryIsActive("purgeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "purgeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedRelationshipGUID", deletedRelationshipGUID, "purgeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeRelationship");
        OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"purgeRelationship", ((Object)((Object)this)).getClass().getName(), this.repositoryName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "purgeRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public Map<String, List<RelationshipMapping>> getIgcPropertiesToRelationshipMappings(String assetType, String userId) {
        HashMap<String, List<RelationshipMapping>> map = new HashMap<String, List<RelationshipMapping>>();
        List<EntityMapping> mappers = this.getMappers(assetType, userId);
        for (EntityMapping mapper : mappers) {
            List<RelationshipMapping> relationshipMappings = mapper.getRelationshipMappers();
            for (RelationshipMapping relationshipMapping : relationshipMappings) {
                if (relationshipMapping.getProxyOneMapping().matchesAssetType(assetType)) {
                    List<String> relationshipNamesOne = relationshipMapping.getProxyOneMapping().getIgcRelationshipProperties();
                    for (String relationshipName : relationshipNamesOne) {
                        if (!map.containsKey(relationshipName)) {
                            map.put(relationshipName, new ArrayList());
                        }
                        if (map.get(relationshipName).contains(relationshipMapping)) continue;
                        map.get(relationshipName).add(relationshipMapping);
                    }
                }
                if (!relationshipMapping.getProxyTwoMapping().matchesAssetType(assetType)) continue;
                List<String> relationshipNamesTwo = relationshipMapping.getProxyTwoMapping().getIgcRelationshipProperties();
                for (String relationshipName : relationshipNamesTwo) {
                    if (!map.containsKey(relationshipName)) {
                        map.put(relationshipName, new ArrayList());
                    }
                    if (map.get(relationshipName).contains(relationshipMapping)) continue;
                    map.get(relationshipName).add(relationshipMapping);
                }
            }
        }
        return map;
    }

    private String addTypeToSearch(EntityMapping mapping, IGCSearch igcSearch) {
        String igcType = DEFAULT_IGC_TYPE;
        if (mapping == null) {
            igcSearch.addType(igcType);
        } else {
            igcType = mapping.getIgcAssetType();
            igcSearch.addType(igcType);
        }
        return igcType;
    }

    private PropertyMappingSet getEntityPropertiesFromMapping(EntityMapping mapping, String userId) {
        PropertyMappingSet propertyMappingSet = null;
        if (mapping != null) {
            propertyMappingSet = mapping.getPropertyMappings();
        }
        return propertyMappingSet;
    }

    private void setPagingForSearch(IGCSearch igcSearch, int beginAt, int pageSize) {
        if (pageSize > 0) {
            igcSearch.setPageSize(pageSize);
        } else {
            igcSearch.setPageSize(this.igcomrsRepositoryConnector.getMaxPageSize());
        }
        igcSearch.setBeginAt(beginAt);
    }

    private void processResults(EntityMapping mapper, ReferenceList results, List<EntityDetail> entityDetails, int pageSize, String userId) throws RepositoryErrorException {
        if (pageSize == 0) {
            results.getAllPages(this.igcRestClient);
        }
        for (Reference reference : results.getItems()) {
            String idToLookup;
            if (reference.getType().equals(DEFAULT_IGC_TYPE)) continue;
            EntityDetail ed = null;
            log.debug("processResults with mapper: {}", (Object)mapper.getClass().getCanonicalName());
            if (mapper.igcRidNeedsPrefix()) {
                log.debug(" ... prefix required, getEntityDetail with: {}", (Object)(mapper.getIgcRidPrefix() + reference.getId()));
                idToLookup = mapper.getIgcRidPrefix() + reference.getId();
            } else {
                log.debug(" ... no prefix required, getEntityDetail with: {}", (Object)reference.getId());
                idToLookup = reference.getId();
            }
            try {
                ed = this.getEntityDetail(userId, idToLookup, reference);
            }
            catch (EntityNotKnownException e) {
                log.error("Unable to find entity: {}", (Object)idToLookup);
            }
            if (ed == null) continue;
            entityDetails.add(ed);
        }
        if (results.hasMorePages().booleanValue() && entityDetails.size() < pageSize) {
            results.getNextPage(this.igcRestClient);
            this.processResults(mapper, results, entityDetails, pageSize, userId);
        }
    }

    private IGCSearchConditionSet getSearchCriteriaForClassification(String igcAssetType, String classificationName) {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        ClassificationMapping classificationMapping = this.classificationMappingStore.getMappingByOmrsTypeName(classificationName);
        if (classificationMapping.matchesAssetType(igcAssetType)) {
            igcSearchConditionSet = classificationMapping.getIGCSearchCriteria(null);
        } else {
            log.warn("Classification {} cannot be applied to IGC asset type {} - excluding from search limitations.", (Object)classificationName, (Object)igcAssetType);
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    private IGCSearchConditionSet getSearchCriteriaForClassifications(String igcAssetType, List<String> classificationNames) {
        String methodName = "getSearchCriteriaForClassifications";
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (classificationNames != null && !classificationNames.isEmpty()) {
            for (String classificationName : classificationNames) {
                IGCSearchConditionSet classificationLimiter = this.getSearchCriteriaForClassification(igcAssetType, classificationName);
                if (classificationLimiter == null) continue;
                igcSearchConditionSet.addNestedConditionSet(classificationLimiter);
                igcSearchConditionSet.setMatchAnyCondition(false);
            }
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    private List<EntityMapping> getMappingsToSearch(String entityTypeGUID, String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        ArrayList<EntityMapping> mappingsToSearch = new ArrayList<EntityMapping>();
        if (entityTypeGUID == null) {
            for (EntityMapping candidate : this.entityMappingStore.getAllMappings()) {
                if (candidate.getOmrsTypeDefName().equals("Referenceable")) continue;
                mappingsToSearch.add(candidate);
            }
        } else {
            String requestedTypeName;
            EntityMapping mappingExact = this.entityMappingStore.getMappingByOmrsTypeGUID(entityTypeGUID);
            if (mappingExact == null) {
                TypeDef unimplemented = this.typeDefStore.getUnimplementedTypeDefByGUID(entityTypeGUID);
                requestedTypeName = unimplemented.getName();
            } else {
                requestedTypeName = mappingExact.getOmrsTypeDefName();
            }
            List<TypeDef> allEntityTypes = this.findTypeDefsByCategory(userId, TypeDefCategory.ENTITY_DEF);
            for (TypeDef typeDef : allEntityTypes) {
                EntityMapping implementedMapping = this.entityMappingStore.getMappingByOmrsTypeGUID(typeDef.getGUID());
                if (implementedMapping == null || !this.repositoryHelper.isTypeOf(this.metadataCollectionId, typeDef.getName(), requestedTypeName)) continue;
                mappingsToSearch.add(implementedMapping);
            }
        }
        return mappingsToSearch;
    }

    public EntityDetail getEntityDetail(String userId, String guid, Reference asset) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        log.debug("getEntityDetail with guid = {}", (Object)guid);
        EntityDetail detail = null;
        String prefix = IGCOMRSMetadataCollection.getPrefixFromGeneratedId(guid);
        if (asset == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "getEntityDetail", this.repositoryName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntityDetail", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (asset.getType().equals(DEFAULT_IGC_TYPE)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_ENTITY_FROM_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.repositoryName, "getEntityDetail", asset.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntityDetail", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        ReferenceableMapper referenceMapper = this.getMapperForParameters(asset, prefix, userId);
        if (referenceMapper == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{prefix + asset.getType(), "IGC asset", "getEntityDetail", this.repositoryName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntityDetail", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        detail = referenceMapper.getOMRSEntityDetail();
        return detail;
    }

    public ReferenceableMapper getMapperForParameters(Reference igcObject, String prefix, String userId) {
        String igcAssetType = igcObject.getType();
        log.debug("Looking for mapper for type {} with prefix {}", (Object)igcAssetType, (Object)prefix);
        EntityMapping found = this.entityMappingStore.getMappingByIgcAssetTypeAndPrefix(igcAssetType, prefix);
        ReferenceableMapper referenceMapper = null;
        if (found != null) {
            log.debug("Found mapper class: {} ({})", (Object)found.getClass().getCanonicalName(), (Object)found);
            referenceMapper = ((ReferenceableMapper)found).initialize(found.getBaseIgcAssetFromAlternative(igcObject), igcObject);
        } else {
            log.debug("No mapper class found!");
        }
        return referenceMapper;
    }

    public List<EntityMapping> getMappers(String igcAssetType, String userId) {
        EntityMapping defaultMapper;
        List<EntityMapping> mappers = this.entityMappingStore.getMappingsByIgcAssetType(igcAssetType);
        if (mappers.isEmpty() && (defaultMapper = this.entityMappingStore.getDefaultEntityMapper(this.igcomrsRepositoryConnector, userId)) != null) {
            mappers.add(defaultMapper);
        }
        return mappers;
    }

    public Map<String, TypeDefAttribute> getTypeDefAttributesForType(String omrsTypeName) {
        return this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
    }

    public String getIgcAssetTypeForAssetName(String igcAssetName) {
        EntityMapping mapping = this.entityMappingStore.getMappingByIgcAssetDisplayName(igcAssetName);
        if (mapping != null) {
            return mapping.getIgcAssetType();
        }
        return null;
    }

    public void addSearchConditionFromValue(IGCSearchConditionSet igcSearchConditionSet, String omrsPropertyName, List<String> igcProperties, PropertyMappingSet propertyMappingSet, InstancePropertyValue value) {
        String igcPropertyName = propertyMappingSet.getIgcPropertyName(omrsPropertyName);
        if (igcPropertyName != null) {
            igcProperties.add(igcPropertyName);
            InstancePropertyCategory category = value.getInstancePropertyCategory();
            block0 : switch (category) {
                case PRIMITIVE: {
                    PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                    switch (primitiveType) {
                        case OM_PRIMITIVE_TYPE_BOOLEAN: 
                        case OM_PRIMITIVE_TYPE_BYTE: 
                        case OM_PRIMITIVE_TYPE_CHAR: {
                            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", actualValue.getPrimitiveValue().toString()));
                            break block0;
                        }
                        case OM_PRIMITIVE_TYPE_SHORT: 
                        case OM_PRIMITIVE_TYPE_INT: 
                        case OM_PRIMITIVE_TYPE_LONG: 
                        case OM_PRIMITIVE_TYPE_FLOAT: 
                        case OM_PRIMITIVE_TYPE_DOUBLE: 
                        case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                        case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", actualValue.getPrimitiveValue().toString()));
                            break block0;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            Date date = (Date)actualValue.getPrimitiveValue();
                            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", "" + date.getTime()));
                            break block0;
                        }
                    }
                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "like %{0}%", actualValue.getPrimitiveValue().toString()));
                    break;
                }
                case ENUM: {
                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", ((EnumPropertyValue)value).getSymbolicName()));
                    break;
                }
                case STRUCT: {
                    Map structValues = ((StructPropertyValue)value).getAttributes().getInstanceProperties();
                    for (Map.Entry nextEntry : structValues.entrySet()) {
                        this.addSearchConditionFromValue(igcSearchConditionSet, (String)nextEntry.getKey(), igcProperties, propertyMappingSet, (InstancePropertyValue)nextEntry.getValue());
                    }
                    break;
                }
                case MAP: {
                    Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
                    for (Map.Entry nextEntry : mapValues.entrySet()) {
                        this.addSearchConditionFromValue(igcSearchConditionSet, (String)nextEntry.getKey(), igcProperties, propertyMappingSet, (InstancePropertyValue)nextEntry.getValue());
                    }
                    break;
                }
                case ARRAY: {
                    Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                    for (Map.Entry nextEntry : arrayValues.entrySet()) {
                        this.addSearchConditionFromValue(igcSearchConditionSet, igcPropertyName, igcProperties, propertyMappingSet, (InstancePropertyValue)nextEntry.getValue());
                    }
                    break;
                }
            }
        }
    }

    public static final String getRidFromGeneratedId(String guid) {
        if (IGCOMRSMetadataCollection.isGeneratedGUID(guid)) {
            return guid.substring(guid.indexOf(GENERATED_TYPE_POSTFIX) + GENERATED_TYPE_POSTFIX.length());
        }
        return guid;
    }

    public static final String getPrefixFromGeneratedId(String guid) {
        if (IGCOMRSMetadataCollection.isGeneratedGUID(guid)) {
            return guid.substring(0, guid.indexOf(GENERATED_TYPE_POSTFIX) + GENERATED_TYPE_POSTFIX.length());
        }
        return null;
    }

    public static final boolean isGeneratedGUID(String guid) {
        return guid.startsWith(GENERATED_TYPE_PREFIX);
    }

    public static final String generateTypePrefix(String moniker) {
        return GENERATED_TYPE_PREFIX + moniker + GENERATED_TYPE_POSTFIX;
    }

    public OMRSStub getOMRSStubForAsset(Reference asset) {
        String stubName = IGCOMRSMetadataCollection.getStubNameFromAsset(asset);
        IGCSearchCondition condition = new IGCSearchCondition("name", "=", stubName);
        String[] properties = new String[]{"$sourceRID", "$sourceType", "$payload"};
        IGCSearchConditionSet conditionSet = new IGCSearchConditionSet(condition);
        IGCSearch igcSearch = new IGCSearch("$OMRS-Stub", properties, conditionSet);
        ReferenceList results = this.igcRestClient.search(igcSearch);
        OMRSStub stub = null;
        if (results.getPaging().getNumTotal() > 0) {
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple stubs for asset, taking only the first: {}", (Object)stubName);
            }
            stub = (OMRSStub)((Object)results.getItems().get(0));
        } else {
            log.info("No stub found for asset: {}", (Object)stubName);
        }
        return stub;
    }

    public String upsertOMRSStubForAsset(Reference asset) {
        String stubName = IGCOMRSMetadataCollection.getStubNameFromAsset(asset);
        String payload = this.igcRestClient.getValueAsJSON(asset);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceType", asset.getType());
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceRID", asset.getId());
            this.addAttributeToAssetXML(xmlStreamWriter, "$payload", payload);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("importAction");
            xmlStreamWriter.writeAttribute("completeAssetIDs", "stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream: {}", (Object)asset, (Object)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub: {}", (Object)stubXML);
        JsonNode results = this.igcRestClient.upsertOpenIgcAsset(stubXML);
        return results.path("stub1").asText();
    }

    private void addAttributeToAssetXML(XMLStreamWriter xmlStreamWriter, String attrName, String attrValue) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("attribute");
        xmlStreamWriter.writeAttribute("name", attrName);
        xmlStreamWriter.writeAttribute("value", attrValue);
        xmlStreamWriter.writeEndElement();
    }

    public boolean deleteOMRSStubForAsset(String rid, String assetType) {
        String stubName = IGCOMRSMetadataCollection.getStubNameForAsset(rid, assetType);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("assetsToDelete");
            xmlStreamWriter.writeCharacters("stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream.", (Throwable)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub deletion: {}", (Object)stubXML);
        return this.igcRestClient.deleteOpenIgcAsset(stubXML);
    }

    public static String getStubNameFromAsset(Reference asset) {
        return IGCOMRSMetadataCollection.getStubNameForAsset(asset.getId(), asset.getType());
    }

    public static String getStubNameForAsset(String rid, String assetType) {
        return assetType + "_" + rid;
    }

    public Reference getFullAssetDetails(String rid) {
        Reference assetRef = this.igcRestClient.getAssetRefById(rid);
        Reference fullAsset = null;
        if (assetRef != null) {
            Class pojoClass = this.igcRestClient.getPOJOForType(assetRef.getType());
            if (pojoClass != null) {
                List allProps = Reference.getAllPropertiesFromPOJO((Class)pojoClass);
                fullAsset = assetRef.getAssetWithSubsetOfProperties(this.igcRestClient, allProps.toArray(new String[0]), this.igcRestClient.getDefaultPageSize());
                if (fullAsset != null) {
                    List allPaged = Reference.getPagedRelationalPropertiesFromPOJO((Class)pojoClass);
                    for (String pagedProperty : allPaged) {
                        ReferenceList pagedValue = (ReferenceList)fullAsset.getPropertyByName(pagedProperty);
                        if (pagedValue == null) continue;
                        pagedValue.getAllPages(this.igcRestClient);
                    }
                    fullAsset.setFullyRetrieved();
                }
            } else {
                log.debug("No registered POJO for asset type {} -- returning basic reference.", (Object)assetRef.getType());
                fullAsset = assetRef;
            }
        } else {
            log.info("Unable to retrieve any asset with RID {} -- assume it was deleted.", (Object)rid);
        }
        return fullAsset;
    }
}

