/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector;

import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;

public class IGCOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSRepositoryConnector.class);
    private IGCRestClient igcRestClient;
    private IGCVersionEnum igcVersion;
    private boolean successfulInit;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        String methodName = "initialize";
        log.debug("Initializing IGCOMRSRepositoryConnector...");
        String baseURL = (String)this.connectionBean.getAdditionalProperties().get("igcBaseURL");
        String auth = (String)this.connectionBean.getAdditionalProperties().get("igcAuthorization");
        this.igcRestClient = new IGCRestClient(baseURL, auth);
        if (this.igcRestClient.isSuccessfullyInitialised()) {
            if (this.getMaxPageSize() > 0) {
                this.igcRestClient.setDefaultPageSize(this.getMaxPageSize());
            }
            this.igcVersion = this.igcRestClient.getIgcVersion();
            try {
                boolean success = this.upsertOMRSBundleZip();
                this.igcRestClient.registerPOJO(OMRSStub.class);
                this.successfulInit = success;
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to create necessary OMRS objects -- failing.", (Throwable)e);
                this.successfulInit = false;
            }
        } else {
            this.successfulInit = false;
        }
        if (!this.successfulInit) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REST_CLIENT_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(baseURL);
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public IGCVersionEnum getIGCVersion() {
        return this.igcVersion;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        if (this.successfulInit) {
            this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId);
        }
    }

    public void disconnect() {
        this.igcRestClient.disconnect();
    }

    public OMRSMetadataCollection getMetadataCollection() {
        if (this.metadataCollection == null) {
            throw new NullPointerException("Local metadata collection id is not set up");
        }
        return this.metadataCollection;
    }

    public IGCRestClient getIGCRestClient() {
        return this.igcRestClient;
    }

    private boolean upsertOMRSBundleZip() throws RepositoryErrorException {
        String methodName = "upsertOMRSBundleZip";
        ClassPathResource bundleResource = new ClassPathResource("OMRS.zip");
        boolean success = this.igcRestClient.upsertOpenIgcBundle("OMRS", (AbstractResource)bundleResource);
        if (!success) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("open");
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "upsertOMRSBundleZip", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return success;
    }
}

