/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes;

import java.util.Date;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(AttributeMapping.class);
    private IGCPropertyType igcPropertyType;
    private String omrsAttributeTypeDefName;
    private String igcAssetType;
    private String igcPropertyName;

    public AttributeMapping(IGCPropertyType igcPropertyType, String omrsAttributeTypeDefName) {
        this(null, null, igcPropertyType, omrsAttributeTypeDefName);
    }

    public AttributeMapping(String igcAssetType, String igcPropertyName, IGCPropertyType igcPropertyType, String omrsAttributeTypeDefName) {
        this.igcAssetType = igcAssetType;
        this.igcPropertyName = igcPropertyName;
        this.igcPropertyType = igcPropertyType;
        this.omrsAttributeTypeDefName = omrsAttributeTypeDefName;
    }

    public boolean isForGeneralAttribute() {
        return this.igcAssetType == null;
    }

    public boolean isForSpecificAttribute() {
        return !this.isForGeneralAttribute();
    }

    public String getIgcAssetType() {
        return this.igcAssetType;
    }

    public String getOmrsAttributeTypeDefName() {
        return this.omrsAttributeTypeDefName;
    }

    public IGCPropertyType getIgcPropertyType() {
        return this.igcPropertyType;
    }

    public boolean matchesProperty(String igcAssetType, String igcPropertyName) {
        return false;
    }

    public static InstanceProperties addPrimitivePropertyToInstance(OMRSRepositoryHelper omrsRepositoryHelper, String sourceName, InstanceProperties properties, TypeDefAttribute property, Object propertyValue, String methodName) {
        InstanceProperties resultingProperties = properties;
        if (propertyValue != null) {
            String propertyName = property.getAttributeName();
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (property.getAttributeType().getCategory() == AttributeTypeDefCategory.PRIMITIVE) {
                try {
                    PrimitiveDef primitiveDef = (PrimitiveDef)property.getAttributeType();
                    switch (primitiveDef.getPrimitiveDefCategory()) {
                        case OM_PRIMITIVE_TYPE_BOOLEAN: {
                            boolean booleanValue = propertyValue instanceof Boolean ? ((Boolean)propertyValue).booleanValue() : Boolean.valueOf(propertyValue.toString()).booleanValue();
                            resultingProperties = omrsRepositoryHelper.addBooleanPropertyToInstance(sourceName, properties, propertyName, booleanValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_INT: {
                            int intValue = propertyValue instanceof Integer ? (Integer)propertyValue : (propertyValue instanceof Number ? ((Number)propertyValue).intValue() : Integer.valueOf(propertyValue.toString()).intValue());
                            resultingProperties = omrsRepositoryHelper.addIntPropertyToInstance(sourceName, properties, propertyName, intValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_LONG: {
                            long longValue = propertyValue instanceof Long ? (Long)propertyValue : (propertyValue instanceof Number ? ((Number)propertyValue).longValue() : Long.valueOf(propertyValue.toString()).longValue());
                            resultingProperties = omrsRepositoryHelper.addLongPropertyToInstance(sourceName, properties, propertyName, longValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_FLOAT: {
                            float floatValue = propertyValue instanceof Float ? ((Float)propertyValue).floatValue() : (propertyValue instanceof Number ? ((Number)propertyValue).floatValue() : Float.valueOf(propertyValue.toString()).floatValue());
                            resultingProperties = omrsRepositoryHelper.addFloatPropertyToInstance(sourceName, properties, propertyName, floatValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String stringValue = propertyValue instanceof String ? (String)propertyValue : propertyValue.toString();
                            resultingProperties = omrsRepositoryHelper.addStringPropertyToInstance(sourceName, properties, propertyName, stringValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (propertyValue instanceof Date) {
                                resultingProperties = omrsRepositoryHelper.addDatePropertyToInstance(sourceName, properties, propertyName, (Date)propertyValue, methodName);
                                break;
                            }
                            log.warn("Unable to parse date automatically -- must be first converted before passing in: {}", propertyValue);
                            break;
                        }
                        default: {
                            log.error("Unhandled primitive type {} for {}", (Object)primitiveDef.getPrimitiveDefCategory(), (Object)propertyName);
                            break;
                        }
                    }
                }
                catch (ClassCastException e) {
                    log.error("Unable to cast {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                }
                catch (NumberFormatException e) {
                    log.error("Unable to convert {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                }
            } else {
                log.error("Cannot translate non-primitive property {} this way.", (Object)propertyName);
            }
        } else {
            log.debug("Null property");
        }
        return resultingProperties;
    }

    public static enum IGCPropertyType {
        STRING,
        BOOLEAN,
        DATETIME,
        NUMBER,
        ENUM,
        STRING_ARRAY,
        NUMBER_ARRAY,
        DATETIME_ARRAY,
        REFERENCE,
        REFERENCE_LIST;

    }
}

