/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes;

import java.util.HashMap;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumMapping
extends AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(EnumMapping.class);
    private HashMap<String, EnumElementDef> enumDefByIgcValue = new HashMap();
    private EnumElementDef defaultEnum;

    public EnumMapping(String omrsAttributeTypeDefName) {
        super(AttributeMapping.IGCPropertyType.STRING, omrsAttributeTypeDefName);
    }

    public EnumMapping(String omrsAttributeTypeDefName, String igcAssetType, String igcPropertyName) {
        super(igcAssetType, igcPropertyName, AttributeMapping.IGCPropertyType.STRING, omrsAttributeTypeDefName);
    }

    public void addDefaultEnumMapping(int omrsOrdinal, String omrsSymbolicName) {
        this.defaultEnum = new EnumElementDef();
        this.defaultEnum.setOrdinal(omrsOrdinal);
        this.defaultEnum.setValue(omrsSymbolicName);
    }

    public void addEnumMapping(String igcValue, int omrsOrdinal, String omrsSymbolicName) {
        EnumElementDef enumElementDef = new EnumElementDef();
        enumElementDef.setOrdinal(omrsOrdinal);
        enumElementDef.setValue(omrsSymbolicName);
        this.enumDefByIgcValue.put(igcValue, enumElementDef);
    }

    public EnumPropertyValue getEnumMappingByIgcValue(String igcValue) {
        EnumPropertyValue value = new EnumPropertyValue();
        EnumElementDef element = null;
        if (this.enumDefByIgcValue.containsKey(igcValue)) {
            element = this.enumDefByIgcValue.get(igcValue);
        } else if (this.defaultEnum != null) {
            element = this.defaultEnum;
        } else {
            log.error("Could not find corresponding enum value for {}, and no default enum defined for {}.", (Object)igcValue, (Object)this.getOmrsAttributeTypeDefName());
        }
        if (element != null) {
            value.setOrdinal(element.getOrdinal());
            value.setSymbolicName(element.getValue());
        }
        return value;
    }

    public String getIgcValueForOrdinal(int omrsOrdinal) {
        String igcValue = null;
        for (String candidateValue : this.enumDefByIgcValue.keySet()) {
            EnumElementDef element = this.enumDefByIgcValue.get(candidateValue);
            if (element.getOrdinal() != omrsOrdinal) continue;
            igcValue = candidateValue;
            break;
        }
        return igcValue;
    }
}

