/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMapping.class);
    private String igcAssetType;
    private List<String> igcRelationshipProperties;
    private String omrsClassificationType;
    private Set<String> excludeIgcAssetType;
    private List<InstanceStatus> omrsSupportedStatuses;
    private Set<String> mappedOmrsPropertyNames;

    public ClassificationMapping(String igcAssetType, String igcRelationshipProperty, String omrsClassificationType) {
        this.igcAssetType = igcAssetType;
        this.igcRelationshipProperties = new ArrayList<String>();
        this.igcRelationshipProperties.add(igcRelationshipProperty);
        this.omrsClassificationType = omrsClassificationType;
        this.excludeIgcAssetType = new HashSet<String>();
        this.omrsSupportedStatuses = new ArrayList<InstanceStatus>();
        this.mappedOmrsPropertyNames = new HashSet<String>();
        this.addSupportedStatus(InstanceStatus.ACTIVE);
        this.addSupportedStatus(InstanceStatus.DELETED);
    }

    public void addSupportedStatus(InstanceStatus status) {
        this.omrsSupportedStatuses.add(status);
    }

    public List<InstanceStatus> getSupportedStatuses() {
        return this.omrsSupportedStatuses;
    }

    public void addMappedOmrsProperty(String name) {
        this.mappedOmrsPropertyNames.add(name);
    }

    public Set<String> getMappedOmrsPropertyNames() {
        return this.mappedOmrsPropertyNames;
    }

    public String getIgcAssetType() {
        return this.igcAssetType;
    }

    public List<String> getIgcRelationshipProperties() {
        return this.igcRelationshipProperties;
    }

    public String getOmrsClassificationType() {
        return this.omrsClassificationType;
    }

    public void addExcludedIgcAssetType(String igcAssetType) {
        this.excludeIgcAssetType.add(igcAssetType);
    }

    public void addIgcRelationshipProperty(String property) {
        this.igcRelationshipProperties.add(property);
    }

    public abstract void addMappedOMRSClassifications(IGCOMRSRepositoryConnector var1, List<Classification> var2, Reference var3, String var4);

    public abstract IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties var1);

    public abstract EntityDetail addClassificationToIGCAsset(IGCOMRSRepositoryConnector var1, Reference var2, String var3, InstanceProperties var4, String var5) throws RepositoryErrorException, EntityNotKnownException;

    public boolean matchesAssetType(String igcAssetType) {
        String simplifiedType = Reference.getAssetTypeForSearch((String)igcAssetType);
        log.debug("checking for matching asset between {} and {}", (Object)this.igcAssetType, (Object)simplifiedType);
        return this.igcAssetType.equals(simplifiedType) || this.igcAssetType.equals("main_object") && !this.excludeIgcAssetType.contains(simplifiedType);
    }

    protected static Classification getMappedClassification(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String omrsClassificationType, String omrsEntityType, InstanceProperties classificationProperties, Reference fromIgcObject, String userId) throws RepositoryErrorException {
        String methodName = "getMappedClassification";
        Classification classification = null;
        try {
            classification = igcomrsRepositoryConnector.getRepositoryHelper().getNewClassification(igcomrsRepositoryConnector.getRepositoryName(), userId, omrsClassificationType, omrsEntityType, ClassificationOrigin.ASSIGNED, null, classificationProperties);
            if (fromIgcObject.hasModificationDetails()) {
                classification.setCreatedBy((String)fromIgcObject.getPropertyByName("created_by"));
                classification.setCreateTime((Date)fromIgcObject.getPropertyByName("created_on"));
                classification.setUpdateTime((Date)fromIgcObject.getPropertyByName("modified_on"));
                classification.setUpdatedBy((String)fromIgcObject.getPropertyByName("modified_by"));
                if (classification.getUpdateTime() != null) {
                    classification.setVersion(classification.getUpdateTime().getTime());
                }
            }
        }
        catch (TypeErrorException e) {
            log.error("Unable to create a new classification.", (Throwable)e);
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{omrsClassificationType, omrsEntityType});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ClassificationMapping.class.getName(), "getMappedClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return classification;
    }
}

