/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Identity;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update.IGCUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes.ConfidentialityLevelMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialityMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);

    public static ConfidentialityMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private ConfidentialityMapper() {
        super("main_object", "assigned_to_terms", "Confidentiality");
        this.addMappedOmrsProperty("level");
        this.addExcludedIgcAssetType("connector");
        this.addExcludedIgcAssetType("data_connection");
        this.addExcludedIgcAssetType("group");
        this.addExcludedIgcAssetType("information_governance_policy");
        this.addExcludedIgcAssetType("label");
        this.addExcludedIgcAssetType("user");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ReferenceList assignedToTerms = (ReferenceList)fromIgcObject.getPropertyByName("assigned_to_terms");
        assignedToTerms.getAllPages(igcRestClient);
        for (Reference assignedTerm : assignedToTerms.getItems()) {
            Identity termIdentity = assignedTerm.getIdentity(igcRestClient);
            Identity catIdentity = termIdentity.getParentIdentity();
            if (!catIdentity.toString().endsWith("Confidentiality")) continue;
            InstanceProperties classificationProperties = new InstanceProperties();
            ConfidentialityLevelMapper confidentialityLevelMapper = ConfidentialityLevelMapper.getInstance();
            EnumPropertyValue level = confidentialityLevelMapper.getEnumMappingByIgcValue(assignedTerm.getName());
            classificationProperties.setProperty("level", (InstancePropertyValue)level);
            try {
                Classification classification = ConfidentialityMapper.getMappedClassification(igcomrsRepositoryConnector, "Confidentiality", "Referenceable", classificationProperties, fromIgcObject, userId);
                classifications.add(classification);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map Confidentiality classification.", (Throwable)e);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.parent_category.name", "=", "Confidentiality");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("level")) {
            EnumPropertyValue level = (EnumPropertyValue)properties.get("level");
            ConfidentialityLevelMapper confidentialityLevelMapper = ConfidentialityLevelMapper.getInstance();
            String igcTermName = confidentialityLevelMapper.getIgcValueForOrdinal(level.getOrdinal());
            IGCSearchCondition propertyCondition = new IGCSearchCondition("assigned_to_terms.name", "=", igcTermName);
            igcSearchConditionSet.addCondition(propertyCondition);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        return igcSearchConditionSet;
    }

    @Override
    public EntityDetail addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties == null || classificationProperties.isEmpty()) {
            log.error("Confidentiality classification requires the 'level' property for IGC.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_INSUFFICIENT_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (classificationProperties.size() == 1 && classificationProperties.containsKey("level")) {
            EnumPropertyValue level = (EnumPropertyValue)classificationProperties.get("level");
            ConfidentialityLevelMapper confidentialityLevelMapper = ConfidentialityLevelMapper.getInstance();
            String igcTermName = confidentialityLevelMapper.getIgcValueForOrdinal(level.getOrdinal());
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            IGCSearchCondition findTerm = new IGCSearchCondition("name", "=", igcTermName);
            IGCSearchCondition inConfidentiality = new IGCSearchCondition("parent_category.name", "=", "Confidentiality");
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(findTerm);
            igcSearchConditionSet.addCondition(inConfidentiality);
            igcSearchConditionSet.setMatchAnyCondition(false);
            IGCSearch igcSearch = new IGCSearch("term", igcSearchConditionSet);
            ReferenceList results = igcRestClient.search(igcSearch);
            if (results == null || results.getPaging().getNumTotal() < 1) {
                log.error("No Confidentiality found with level: {}", (Object)igcTermName);
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple Confidentiality terms matching {}, taking the first.", (Object)igcTermName);
            }
            String confidentialityTermRid = ((Reference)results.getItems().get(0)).getId();
            IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
            igcUpdate.addRelationship("assigned_to_terms", confidentialityTermRid);
            igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.APPEND);
            if (!igcRestClient.update(igcUpdate)) {
                log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
            }
        } else {
            log.error("More than only a 'level' property was provided for the Confidentiality classification.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        IGCOMRSMetadataCollection collection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        return collection.getEntityDetail(userId, entityGUID, igcEntity);
    }

    private static class Singleton {
        private static final ConfidentialityMapper INSTANCE = new ConfidentialityMapper();

        private Singleton() {
        }
    }
}

