/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ConfidentialityMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);
    private static final String C_PRIMARY_KEY = "PrimaryKey";
    private static final String T_RELATIONAL_COLUMN = "RelationalColumn";

    public static PrimaryKeyMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private PrimaryKeyMapper() {
        super("database_column", "defined_primary_key", C_PRIMARY_KEY);
        this.addIgcRelationshipProperty("selected_primary_key");
        this.addMappedOmrsProperty("name");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        String methodName = "addMappedOMRSClassifications";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Boolean bSelectedPK = (Boolean)fromIgcObject.getPropertyByName("selected_primary_key");
        ReferenceList definedPK = (ReferenceList)fromIgcObject.getPropertyByName("defined_primary_key");
        if (definedPK.getItems().isEmpty()) {
            if (bSelectedPK.booleanValue()) {
                try {
                    InstanceProperties classificationProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                    Classification classification = PrimaryKeyMapper.getMappedClassification(igcomrsRepositoryConnector, C_PRIMARY_KEY, T_RELATIONAL_COLUMN, classificationProperties, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to create classification.", (Throwable)e);
                }
            }
        } else {
            definedPK.getAllPages(igcRestClient);
            for (Reference candidateKey : definedPK.getItems()) {
                try {
                    InstanceProperties classificationProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "name", candidateKey.getName(), "addMappedOMRSClassifications");
                    Classification classification = PrimaryKeyMapper.getMappedClassification(igcomrsRepositoryConnector, C_PRIMARY_KEY, T_RELATIONAL_COLUMN, classificationProperties, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to create classification.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_primary_key", "=", "true");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("name")) {
            PrimitivePropertyValue name = (PrimitivePropertyValue)properties.get("name");
            String keyName = (String)name.getPrimitiveValue();
            IGCSearchCondition propertyCondition = new IGCSearchCondition("defined_primary_key.name", "=", keyName);
            igcSearchConditionSet.addCondition(propertyCondition);
            igcSearchConditionSet.setMatchAnyCondition(true);
        }
        return igcSearchConditionSet;
    }

    @Override
    public EntityDetail addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException {
        String methodName = "addClassificationToIGCAsset";
        log.error("PrimaryKey classification cannot be changed through IGC REST API.");
        IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_EDITABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private static class Singleton {
        private static final PrimaryKeyMapper INSTANCE = new PrimaryKeyMapper();

        private Singleton() {
        }
    }
}

