/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Identity;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update.IGCUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpineObjectMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(SpineObjectMapper.class);

    public static SpineObjectMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private SpineObjectMapper() {
        super("term", "category_path", "SpineObject");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        Identity termIdentity = fromIgcObject.getIdentity(igcomrsRepositoryConnector.getIGCRestClient());
        Identity catIdentity = termIdentity.getParentIdentity();
        if (catIdentity.toString().endsWith("Spine Objects")) {
            try {
                Classification classification = SpineObjectMapper.getMappedClassification(igcomrsRepositoryConnector, "SpineObject", "GlossaryTerm", null, fromIgcObject, userId);
                classifications.add(classification);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map SpineObject classification.", (Throwable)e);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("parent_category.name", "=", "Spine Objects");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        igcSearchConditionSet.setMatchAnyCondition(false);
        return igcSearchConditionSet;
    }

    @Override
    public EntityDetail addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException, EntityNotKnownException {
        IGCSearchCondition findCategory;
        IGCSearchConditionSet igcSearchConditionSet;
        IGCSearch igcSearch;
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties != null && !classificationProperties.isEmpty()) {
            log.error("SpineObject classification has no properties, yet properties were included: {}", (Object)initialProperties);
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ReferenceList results = igcRestClient.search(igcSearch = new IGCSearch("category", igcSearchConditionSet = new IGCSearchConditionSet(findCategory = new IGCSearchCondition("name", "=", "Spine Objects"))));
        if (results == null || results.getPaging().getNumTotal() < 1) {
            log.error("No Spine Objects category found -- cannot continue.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (results.getPaging().getNumTotal() > 1) {
            log.warn("Found multiple Spine Objects categories, taking the first.");
        }
        String spineObjectCatRid = ((Reference)results.getItems().get(0)).getId();
        IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
        igcUpdate.addExclusiveRelationship("parent_category", spineObjectCatRid);
        if (!igcRestClient.update(igcUpdate)) {
            log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
        }
        IGCOMRSMetadataCollection collection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        return collection.getEntityDetail(userId, entityGUID, igcEntity);
    }

    private static class Singleton {
        private static final SpineObjectMapper INSTANCE = new SpineObjectMapper();

        private Singleton() {
        }
    }
}

