/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update.IGCUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaMapper.class);

    public static SubjectAreaMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private SubjectAreaMapper() {
        super("category", "category_path", "SubjectArea");
        this.addMappedOmrsProperty("name");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        String methodName = "addMappedOMRSClassifications";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ReferenceList categoryPath = (ReferenceList)fromIgcObject.getPropertyByName("category_path");
        if (categoryPath != null) {
            categoryPath.getAllPages(igcRestClient);
            boolean isSubjectArea = false;
            for (Reference category : categoryPath.getItems()) {
                String categoryName = category.getName();
                if (categoryName == null || !categoryName.startsWith("Subject Area")) continue;
                isSubjectArea = true;
                break;
            }
            if (isSubjectArea) {
                InstanceProperties classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                try {
                    Classification classification = SubjectAreaMapper.getMappedClassification(igcomrsRepositoryConnector, "SubjectArea", "GlossaryCategory", classificationProperties, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map classification.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("parent_category.parent_category.name", "=", "Subject Area");
        IGCSearchConditionSet subjectAreaAncestor = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearchCondition igcSearchCondition2 = new IGCSearchCondition("parent_category.parent_category.parent_category.name", "=", "Subject Area");
        subjectAreaAncestor.addCondition(igcSearchCondition2);
        subjectAreaAncestor.setMatchAnyCondition(true);
        IGCSearchConditionSet byName = new IGCSearchConditionSet();
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("name")) {
            PrimitivePropertyValue name = (PrimitivePropertyValue)properties.get("name");
            String subjectAreaName = (String)name.getPrimitiveValue();
            IGCSearchCondition propertyCondition = new IGCSearchCondition("parent_category.name", "=", subjectAreaName);
            byName.addCondition(propertyCondition);
            IGCSearchCondition propertyCondition2 = new IGCSearchCondition("parent_category.parent_category.name", "=", subjectAreaName);
            byName.addCondition(propertyCondition2);
            byName.setMatchAnyCondition(true);
        }
        if (byName.size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(subjectAreaAncestor);
            igcSearchConditionSet.addNestedConditionSet(byName);
            igcSearchConditionSet.setMatchAnyCondition(false);
            return igcSearchConditionSet;
        }
        return subjectAreaAncestor;
    }

    @Override
    public EntityDetail addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties == null || classificationProperties.isEmpty()) {
            log.error("Confidentiality classification requires the 'name' property for IGC.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_INSUFFICIENT_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (classificationProperties.size() == 1 && classificationProperties.containsKey("name")) {
            String subjectAreaName = (String)((PrimitivePropertyValue)classificationProperties.get("name")).getPrimitiveValue();
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            IGCSearchCondition findCategory = new IGCSearchCondition("name", "=", subjectAreaName);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(findCategory);
            IGCSearchCondition inSubjectArea = new IGCSearchCondition("parent_category.name", "=", "Subject Areas");
            IGCSearchCondition inSubjectArea2 = new IGCSearchCondition("parent_category.parent_category.name", "=", "Subject Areas");
            IGCSearchConditionSet inSubjectAreas = new IGCSearchConditionSet(inSubjectArea);
            inSubjectAreas.addCondition(inSubjectArea2);
            inSubjectAreas.setMatchAnyCondition(true);
            igcSearchConditionSet.addNestedConditionSet(inSubjectAreas);
            igcSearchConditionSet.setMatchAnyCondition(false);
            IGCSearch igcSearch = new IGCSearch("category", igcSearchConditionSet);
            ReferenceList results = igcRestClient.search(igcSearch);
            if (results == null || results.getPaging().getNumTotal() < 1) {
                log.error("No SubjectArea found with name: {}", (Object)subjectAreaName);
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple SubjectArea categories matching {}, taking the first.", (Object)subjectAreaName);
            }
            String subjectAreaCatRid = ((Reference)results.getItems().get(0)).getId();
            IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
            igcUpdate.addRelationship("referencing_categories", subjectAreaCatRid);
            igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.APPEND);
            if (!igcRestClient.update(igcUpdate)) {
                log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
            }
        } else {
            log.error("More than only a 'name' property was provided for the SubjectArea classification.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        IGCOMRSMetadataCollection collection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        return collection.getEntityDetail(userId, entityGUID, igcEntity);
    }

    private static class Singleton {
        private static final SubjectAreaMapper INSTANCE = new SubjectAreaMapper();

        private Singleton() {
        }
    }
}

