/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes.ContactMethodTypeMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.ContactThroughMapper_Person;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.ContactThroughMapper_Team;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

public class ContactDetailsMapper
extends ReferenceableMapper {
    public static final String IGC_RID_PREFIX = IGCOMRSMetadataCollection.generateTypePrefix("CD");

    public ContactDetailsMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        super(igcomrsRepositoryConnector, "user", "User", "ContactDetails", userId, IGC_RID_PREFIX);
        this.addOtherIGCAssetType("group");
        this.addComplexIgcProperty("email_address");
        this.addComplexOmrsProperty("contactMethodType");
        this.addComplexOmrsProperty("contactMethodValue");
        this.addRelationshipMapper(ContactThroughMapper_Team.getInstance());
        this.addRelationshipMapper(ContactThroughMapper_Person.getInstance());
    }

    @Override
    protected void complexPropertyMappings(InstanceProperties instanceProperties) {
        String methodName = "complexPropertyMappings";
        String emailAddress = (String)this.igcEntity.getPropertyByName("email_address");
        if (emailAddress != null && !emailAddress.equals("")) {
            EnumPropertyValue contactMethod = ContactMethodTypeMapper.getInstance().getEnumMappingByIgcValue("email");
            instanceProperties.setProperty("contactMethodType", (InstancePropertyValue)contactMethod);
            instanceProperties = this.igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(this.igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "contactMethodValue", emailAddress, "complexPropertyMappings");
        }
    }
}

