/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import java.util.ArrayList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.DataClassAssignmentMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.DataClassHierarchyMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassMapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(DataClassMapper.class);

    public DataClassMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        super(igcomrsRepositoryConnector, "data_class", "Data Class", "DataClass", userId);
        this.addOtherIGCAssetType("classification");
        this.addSimplePropertyMapping("name", "name");
        this.addSimplePropertyMapping("short_description", "description");
        this.addSimplePropertyMapping("class_code", "classCode");
        this.addSimplePropertyMapping("default_threshold", "defaultThreshold");
        this.addSimplePropertyMapping("example", "example");
        this.addComplexIgcProperty("data_type_filter_elements_enum");
        this.addComplexIgcProperty("data_class_type_single");
        this.addComplexIgcProperty("java_class_name_single");
        this.addComplexIgcProperty("regular_expression_single");
        this.addComplexIgcProperty("valid_value_strings");
        this.addComplexIgcProperty("validValueReferenceFile");
        this.addComplexOmrsProperty("dataType");
        this.addComplexOmrsProperty("specificationDetails");
        this.addComplexOmrsProperty("specification");
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            this.addComplexIgcProperty("expression");
            this.addComplexIgcProperty("script");
            this.addComplexIgcProperty("provider");
            this.addComplexIgcProperty("filters");
            this.addComplexOmrsProperty("userDefined");
        }
        this.addRelationshipMapper(DataClassHierarchyMapper.getInstance());
        this.addRelationshipMapper(DataClassAssignmentMapper.getInstance());
    }

    @Override
    public Reference getBaseIgcAssetFromAlternative(Reference otherAsset) {
        return DataClassAssignmentMapper.getInstance().getProxyTwoAssetFromAsset(otherAsset, this.igcomrsRepositoryConnector.getIGCRestClient()).get(0);
    }

    @Override
    protected void complexPropertyMappings(InstanceProperties instanceProperties) {
        String methodName = "complexPropertyMappings";
        OMRSRepositoryHelper repositoryHelper = this.igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = this.igcomrsRepositoryConnector.getRepositoryName();
        ArrayList dataTypes = (ArrayList)this.igcEntity.getPropertyByName("data_type_filter_elements_enum");
        String dataType = null;
        for (String type : dataTypes) {
            if (dataType == null) {
                dataType = type;
                continue;
            }
            if (!type.equals("string") && type.equals(dataType)) continue;
            dataType = "string";
            break;
        }
        instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "dataType", dataType, "complexPropertyMappings");
        String dataClassType = (String)this.igcEntity.getPropertyByName("data_class_type_single");
        instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "specificationDetails", dataClassType, "complexPropertyMappings");
        String dataClassDetails = "";
        switch (dataClassType) {
            case "Regex": {
                dataClassDetails = (String)this.igcEntity.getPropertyByName("regular_expression_single");
                break;
            }
            case "ValidValues": {
                ArrayList validValues = (ArrayList)this.igcEntity.getPropertyByName("valid_value_strings");
                if (validValues == null || validValues.isEmpty()) {
                    dataClassDetails = (String)this.igcEntity.getPropertyByName("validValueReferenceFile");
                    break;
                }
                dataClassDetails = String.join((CharSequence)", ", validValues);
                break;
            }
            case "Script": {
                dataClassDetails = (String)this.igcEntity.getPropertyByName("script");
                break;
            }
            case "ColumnSimilarity": {
                dataClassDetails = (String)this.igcEntity.getPropertyByName("expression");
                break;
            }
            case "UnstructuredFilter": {
                ReferenceList filters = (ReferenceList)this.igcEntity.getPropertyByName("filters");
                if (filters.getItems().isEmpty()) break;
                filters.getAllPages(this.igcomrsRepositoryConnector.getIGCRestClient());
                ArrayList<String> filterNames = new ArrayList<String>();
                for (Reference filter : filters.getItems()) {
                    filterNames.add(filter.getName());
                }
                dataClassDetails = String.join((CharSequence)", ", filterNames);
                break;
            }
            default: {
                dataClassDetails = (String)this.igcEntity.getPropertyByName("java_class_name_single");
            }
        }
        instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "specification", dataClassDetails, "complexPropertyMappings");
        IGCVersionEnum igcVersion = this.igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            String provider = (String)this.igcEntity.getPropertyByName("provider");
            instanceProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, instanceProperties, "userDefined", provider == null || !provider.equals("IBM"), "complexPropertyMappings");
        }
    }
}

