/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.ConnectionEndpointMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointMapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(EndpointMapper.class);

    public EndpointMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        super(igcomrsRepositoryConnector, "host", "Host", "Endpoint", userId);
        this.addOtherIGCAssetType("host_(engine)");
        this.addSimplePropertyMapping("name", "name");
        this.addSimplePropertyMapping("short_description", "description");
        this.addRelationshipMapper(ConnectionEndpointMapper.getInstance());
        this.addComplexIgcProperty("name");
        this.addComplexOmrsProperty("networkAddress");
    }

    @Override
    public Reference getBaseIgcAssetFromAlternative(Reference otherAsset) {
        String otherAssetType = otherAsset.getType();
        if (otherAssetType.equals("host_(engine)")) {
            IGCSearchCondition igcSearchCondition = new IGCSearchCondition("_id", "=", otherAsset.getId());
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
            IGCSearch igcSearch = new IGCSearch("host", igcSearchConditionSet);
            igcSearch.setPageSize(2);
            ReferenceList hosts = this.igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
            if (!hosts.getItems().isEmpty()) {
                return (Reference)hosts.getItems().get(0);
            }
            log.warn("Unable to translate host_(engine) to host, returning host_(engine): {}", (Object)otherAsset);
            return otherAsset;
        }
        log.debug("Not a host_(engine) asset, just returning as-is: {}", (Object)otherAsset);
        return otherAsset;
    }

    @Override
    protected void complexPropertyMappings(InstanceProperties instanceProperties) {
        String methodName = "complexPropertyMappings";
        String networkAddress = (String)this.igcEntity.getPropertyByName("name");
        instanceProperties = this.igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(this.igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "networkAddress", networkAddress, "complexPropertyMappings");
    }
}

