/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.PropertyMappingSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityMapping {
    private static final Logger log = LoggerFactory.getLogger(EntityMapping.class);
    private String igcAssetType;
    private String igcAssetTypeDisplayName;
    private String omrsTypeDefName;
    private Class igcPOJO;
    private String igcRidPrefix;
    private ArrayList<String> otherIgcTypes;
    private ArrayList<Class> otherPOJOs;
    private PropertyMappingSet propertyMappings;
    private ArrayList<RelationshipMapping> relationshipMappers;
    private ArrayList<ClassificationMapping> classificationMappers;
    protected IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    protected IGCOMRSMetadataCollection igcomrsMetadataCollection;
    protected String userId;
    protected Reference igcEntity;
    protected Reference igcEntityAlternative;
    protected EntitySummary omrsSummary;
    protected EntityDetail omrsDetail;
    protected ArrayList<Classification> omrsClassifications;
    protected ArrayList<Relationship> omrsRelationships;
    private ArrayList<InstanceStatus> omrsSupportedStatuses;

    public EntityMapping(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String igcAssetType, String igcAssetTypeDisplayName, String omrsTypeDefName, String userId, String igcRidPrefix) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        this.userId = userId;
        this.igcAssetType = igcAssetType;
        this.igcAssetTypeDisplayName = igcAssetTypeDisplayName;
        this.omrsTypeDefName = omrsTypeDefName;
        this.igcRidPrefix = igcRidPrefix;
        this.propertyMappings = new PropertyMappingSet();
        this.relationshipMappers = new ArrayList();
        this.classificationMappers = new ArrayList();
        this.omrsRelationships = new ArrayList();
        this.omrsSupportedStatuses = new ArrayList();
        this.addSupportedStatus(InstanceStatus.ACTIVE);
        this.addSupportedStatus(InstanceStatus.DELETED);
        this.otherIgcTypes = new ArrayList();
        this.otherPOJOs = new ArrayList();
        StringBuilder sbPojoName = new StringBuilder();
        if (igcAssetType.equals("main_object")) {
            sbPojoName.append("org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common");
            sbPojoName.append(".MainObject");
        } else {
            sbPojoName.append("org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.generated");
            sbPojoName.append(".");
            sbPojoName.append(igcomrsRepositoryConnector.getIGCVersion().getVersionString());
            sbPojoName.append(".");
            sbPojoName.append(IGCRestConstants.getClassNameForAssetType((String)igcAssetType));
        }
        try {
            this.igcPOJO = Class.forName(sbPojoName.toString());
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find POJO class: {}", (Object)sbPojoName.toString(), (Object)e);
        }
    }

    public void addSupportedStatus(InstanceStatus status) {
        this.omrsSupportedStatuses.add(status);
    }

    public List<InstanceStatus> getSupportedStatuses() {
        return this.omrsSupportedStatuses;
    }

    public String getIgcAssetType() {
        return this.igcAssetType;
    }

    public String getIgcAssetTypeDisplayName() {
        return this.igcAssetTypeDisplayName;
    }

    public Class getIgcPOJO() {
        return this.igcPOJO;
    }

    public boolean igcRidNeedsPrefix() {
        return this.igcRidPrefix != null;
    }

    public String getIgcRidPrefix() {
        return this.igcRidPrefix;
    }

    public String getOmrsTypeDefName() {
        return this.omrsTypeDefName;
    }

    public boolean matchesAssetType(String igcAssetType) {
        String matchType = Reference.getAssetTypeForSearch((String)igcAssetType);
        log.debug("checking for matching asset between {} and {}", (Object)this.igcAssetType, (Object)matchType);
        return this.igcAssetType.equals(matchType) || this.igcAssetType.equals("main_object");
    }

    public void addOtherIGCAssetType(String igcAssetTypeName) {
        this.otherIgcTypes.add(igcAssetTypeName);
        StringBuilder sbPojoName = new StringBuilder();
        sbPojoName.append("org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.generated");
        sbPojoName.append(".");
        sbPojoName.append(this.igcomrsRepositoryConnector.getIGCVersion().getVersionString());
        sbPojoName.append(".");
        sbPojoName.append(IGCRestConstants.getClassNameForAssetType((String)igcAssetTypeName));
        try {
            Class<?> pojo = Class.forName(sbPojoName.toString());
            this.otherPOJOs.add(pojo);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find POJO with name: {}", (Object)sbPojoName.toString());
        }
    }

    public List<String> getOtherIGCAssetTypes() {
        return this.otherIgcTypes;
    }

    public List<Class> getOtherIGCPOJOs() {
        return this.otherPOJOs;
    }

    public Reference getBaseIgcAssetFromAlternative(Reference otherAsset) {
        return otherAsset;
    }

    public final void addSimplePropertyMapping(String igcPropertyName, String omrsPropertyName) {
        this.propertyMappings.addSimpleMapping(igcPropertyName, omrsPropertyName);
    }

    public final void addComplexIgcProperty(String igcPropertyName) {
        this.propertyMappings.addComplexIgc(igcPropertyName);
    }

    public final void addComplexOmrsProperty(String omrsPropertyName) {
        this.propertyMappings.addComplexOmrs(omrsPropertyName);
    }

    public PropertyMappingSet getPropertyMappings() {
        return this.propertyMappings;
    }

    public final void addRelationshipMapper(RelationshipMapping relationshipMapping) {
        this.relationshipMappers.add(relationshipMapping);
    }

    public List<RelationshipMapping> getRelationshipMappers() {
        return this.relationshipMappers;
    }

    public final void addClassificationMapper(ClassificationMapping classificationMapping) {
        this.classificationMappers.add(classificationMapping);
    }

    public List<ClassificationMapping> getClassificationMappers() {
        return this.classificationMappers;
    }

    protected abstract void complexPropertyMappings(InstanceProperties var1);

    protected final void mapIGCToOMRSEntitySummary() {
        if (this.omrsSummary == null) {
            this.omrsSummary = new EntitySummary();
            String guid = this.igcEntity.getId();
            if (this.igcRidPrefix != null) {
                guid = this.igcRidPrefix + guid;
            }
            this.omrsSummary.setGUID(guid);
            this.omrsSummary.setInstanceURL(this.igcEntity.getUrl());
        }
    }

    protected final void mapIGCToOMRSEntityDetail() {
        if (this.omrsDetail == null) {
            try {
                this.omrsDetail = this.igcomrsRepositoryConnector.getRepositoryHelper().getSkeletonEntity(this.igcomrsRepositoryConnector.getRepositoryName(), this.igcomrsRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, this.userId, this.omrsTypeDefName);
                this.omrsDetail.setStatus(InstanceStatus.ACTIVE);
                String guid = this.igcEntity.getId();
                if (this.igcRidPrefix != null) {
                    guid = this.igcRidPrefix + guid;
                }
                this.omrsDetail.setGUID(guid);
                this.omrsDetail.setInstanceURL(this.igcEntity.getUrl());
            }
            catch (TypeErrorException e) {
                log.error("Unable to get skeleton detail entity.", (Throwable)e);
            }
        }
    }
}

