/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertyMappingSet {
    public static final String COMPLEX_MAPPING_SENTINEL = "__COMPLEX_PROPERTY__";
    private Map<String, PropertyMapping> mappingByIgcProperty = new HashMap<String, PropertyMapping>();
    private Map<String, PropertyMapping> mappingByOmrsProperty = new HashMap<String, PropertyMapping>();
    private HashSet<String> complexIgcProperties = new HashSet();
    private HashSet<String> complexOmrsProperties = new HashSet();

    public Set<String> getSimpleMappedIgcProperties() {
        return this.mappingByIgcProperty.keySet();
    }

    public Set<String> getComplexMappedIgcProperties() {
        return this.complexIgcProperties;
    }

    public Set<String> getAllMappedIgcProperties() {
        HashSet<String> igcProperties = new HashSet<String>(this.getSimpleMappedIgcProperties());
        igcProperties.addAll(this.complexIgcProperties);
        return igcProperties;
    }

    public Set<String> getSimpleMappedOmrsProperties() {
        return this.mappingByOmrsProperty.keySet();
    }

    public Set<String> getComplexMappedOmrsProperties() {
        return this.complexOmrsProperties;
    }

    public Set<String> getAllMappedOmrsProperties() {
        Set<String> omrsProperties = this.getSimpleMappedOmrsProperties();
        omrsProperties.addAll(this.complexOmrsProperties);
        return omrsProperties;
    }

    public void addSimpleMapping(String igcPropertyName, String omrsPropertyName) {
        PropertyMapping pm = new PropertyMapping(igcPropertyName, omrsPropertyName);
        this.mappingByOmrsProperty.put(omrsPropertyName, pm);
        this.mappingByIgcProperty.put(igcPropertyName, pm);
    }

    public void addComplexIgc(String igcPropertyName) {
        this.complexIgcProperties.add(igcPropertyName);
    }

    public void addComplexOmrs(String omrsPropertyName) {
        this.complexOmrsProperties.add(omrsPropertyName);
    }

    public String getIgcPropertyName(String omrsPropertyName) {
        String igcPropertyName = null;
        if (this.isOmrsPropertySimpleMapped(omrsPropertyName)) {
            igcPropertyName = this.mappingByOmrsProperty.get(omrsPropertyName).getIgcPropertyName();
        } else if (this.isOmrsPropertyComplexMapped(omrsPropertyName)) {
            igcPropertyName = COMPLEX_MAPPING_SENTINEL;
        }
        return igcPropertyName;
    }

    public String getOmrsPropertyName(String igcPropertyName) {
        String omrsPropertyName = null;
        if (this.isIgcPropertySimpleMapped(igcPropertyName)) {
            omrsPropertyName = this.mappingByIgcProperty.get(igcPropertyName).getOmrsPropertyName();
        } else if (this.isIgcPropertyComplexMapped(igcPropertyName)) {
            omrsPropertyName = COMPLEX_MAPPING_SENTINEL;
        }
        return omrsPropertyName;
    }

    public boolean isIgcPropertySimpleMapped(String igcPropertyName) {
        return this.mappingByIgcProperty.containsKey(igcPropertyName);
    }

    public boolean isIgcPropertyComplexMapped(String igcPropertyName) {
        return this.complexIgcProperties.contains(igcPropertyName);
    }

    public boolean isOmrsPropertySimpleMapped(String omrsPropertyName) {
        return this.mappingByOmrsProperty.containsKey(omrsPropertyName);
    }

    public boolean isOmrsPropertyComplexMapped(String omrsPropertyName) {
        return this.complexOmrsProperties.contains(omrsPropertyName);
    }

    public class PropertyMapping {
        private String igcPropertyName;
        private String omrsPropertyName;

        public PropertyMapping(String igcPropertyName, String omrsPropertyName) {
            this.igcPropertyName = igcPropertyName;
            this.omrsPropertyName = omrsPropertyName;
        }

        public String getIgcPropertyName() {
            return this.igcPropertyName;
        }

        public String getOmrsPropertyName() {
            return this.omrsPropertyName;
        }
    }
}

