/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.PropertyMappingSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.AttachedTagMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceableMapper
extends EntityMapping {
    private static final Logger log = LoggerFactory.getLogger(ReferenceableMapper.class);

    public ReferenceableMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        this(igcomrsRepositoryConnector, "main_object", "Main Object", "Referenceable", userId);
    }

    public ReferenceableMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String userId) {
        this(igcomrsRepositoryConnector, igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, userId, null);
    }

    public ReferenceableMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String userId, String igcRidPrefix) {
        this(igcomrsRepositoryConnector, igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, userId, igcRidPrefix, true);
    }

    public ReferenceableMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String userId, String igcRidPrefix, boolean includeDefaultRelationships) {
        super(igcomrsRepositoryConnector, igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, userId, igcRidPrefix);
        if (includeDefaultRelationships) {
            this.addRelationshipMapper(SemanticAssignmentMapper.getInstance());
            this.addRelationshipMapper(AttachedTagMapper.getInstance());
        }
    }

    protected ReferenceableMapper getNewInstance() {
        ReferenceableMapper mapper = null;
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(IGCOMRSRepositoryConnector.class, String.class);
            mapper = (ReferenceableMapper)constructor.newInstance(new Object[]{this.igcomrsRepositoryConnector, this.userId});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to construct new instance of: {}", (Object)clazz.getCanonicalName(), (Object)e);
        }
        return mapper;
    }

    public ReferenceableMapper initialize(Reference baseObject, Reference receivedObject) {
        ReferenceableMapper mapper = this.getNewInstance();
        mapper.igcEntity = baseObject;
        if (receivedObject != null && !baseObject.equals(receivedObject)) {
            mapper.igcEntityAlternative = receivedObject;
        }
        if (mapper.igcEntity != null && mapper.igcEntity.hasModificationDetails()) {
            for (String property : IGCRestConstants.getModificationProperties()) {
                mapper.addComplexIgcProperty(property);
            }
        }
        return mapper;
    }

    @Override
    protected void complexPropertyMappings(InstanceProperties instanceProperties) {
    }

    public EntitySummary getOMRSEntitySummary() {
        ArrayList<String> allProperties = new ArrayList<String>();
        for (ClassificationMapping classificationMapping : this.getClassificationMappers()) {
            allProperties.addAll(classificationMapping.getIgcRelationshipProperties());
        }
        allProperties.addAll(this.getPropertyMappings().getAllMappedIgcProperties());
        if (!this.igcEntity.isFullyRetrieved()) {
            this.igcEntity = this.igcEntity.getAssetWithSubsetOfProperties(this.igcomrsRepositoryConnector.getIGCRestClient(), allProperties.toArray(new String[0]));
        }
        this.mapIGCToOMRSEntitySummary();
        this.setupEntityObj(this.omrsSummary);
        return this.omrsSummary;
    }

    public EntityDetail getOMRSEntityDetail() {
        List nonRelationshipProperties = Reference.getNonRelationshipPropertiesFromPOJO(this.igcEntity.getClass());
        ArrayList<String> allProperties = new ArrayList<String>();
        PropertyMappingSet propertyMappingSet = this.getPropertyMappings();
        allProperties.addAll(propertyMappingSet.getAllMappedIgcProperties());
        for (ClassificationMapping classificationMapping : this.getClassificationMappers()) {
            allProperties.addAll(classificationMapping.getIgcRelationshipProperties());
        }
        allProperties.addAll(nonRelationshipProperties);
        if (!this.igcEntity.isFullyRetrieved()) {
            this.igcEntity = this.igcEntity.getAssetWithSubsetOfProperties(this.igcomrsRepositoryConnector.getIGCRestClient(), allProperties.toArray(new String[0]));
        }
        this.mapIGCToOMRSEntityDetail();
        this.setupEntityObj((EntitySummary)this.omrsDetail);
        InstanceProperties instanceProperties = this.getMappedInstanceProperties(propertyMappingSet, nonRelationshipProperties);
        this.omrsDetail.setProperties(instanceProperties);
        return this.omrsDetail;
    }

    private void setupEntityObj(EntitySummary omrsObj) {
        List<ClassificationMapping> classificationMappings;
        if (this.igcEntity.hasModificationDetails()) {
            omrsObj.setCreatedBy((String)this.igcEntity.getPropertyByName("created_by"));
            omrsObj.setCreateTime((Date)this.igcEntity.getPropertyByName("created_on"));
            omrsObj.setUpdatedBy((String)this.igcEntity.getPropertyByName("modified_by"));
            omrsObj.setUpdateTime((Date)this.igcEntity.getPropertyByName("modified_on"));
            if (omrsObj.getUpdateTime() != null) {
                omrsObj.setVersion(omrsObj.getUpdateTime().getTime());
            }
        }
        if (!(classificationMappings = this.getClassificationMappers()).isEmpty() && this.omrsClassifications == null) {
            this.omrsClassifications = new ArrayList();
            for (ClassificationMapping classificationMapping : classificationMappings) {
                classificationMapping.addMappedOMRSClassifications(this.igcomrsRepositoryConnector, this.omrsClassifications, this.igcEntity, this.userId);
            }
        }
        omrsObj.setClassifications((List)this.omrsClassifications);
    }

    private InstanceProperties getMappedInstanceProperties(PropertyMappingSet mappings, List<String> nonRelationshipProperties) {
        String methodName = "getMappedInstanceProperties";
        OMRSRepositoryHelper omrsRepositoryHelper = this.igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = this.igcomrsRepositoryConnector.getRepositoryName();
        String qualifiedName = this.igcEntity.getIdentity(this.igcomrsRepositoryConnector.getIGCRestClient()).toString();
        InstanceProperties instanceProperties = omrsRepositoryHelper.addStringPropertyToInstance(repositoryName, null, "qualifiedName", qualifiedName, "getMappedInstanceProperties");
        Map<String, TypeDefAttribute> omrsAttributeMap = this.igcomrsMetadataCollection.getTypeDefAttributesForType(this.getOmrsTypeDefName());
        for (String igcPropertyName : mappings.getSimpleMappedIgcProperties()) {
            String omrsAttribute = mappings.getOmrsPropertyName(igcPropertyName);
            if (omrsAttributeMap.containsKey(omrsAttribute)) {
                TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsAttribute);
                instanceProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, instanceProperties, typeDefAttribute, this.igcEntity.getPropertyByName(igcPropertyName), "getMappedInstanceProperties");
                continue;
            }
            log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsAttribute, (Object)this.getOmrsTypeDefName());
        }
        this.complexPropertyMappings(instanceProperties);
        if (omrsAttributeMap.containsKey("additionalProperties")) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            Set<String> alreadyMapped = mappings.getAllMappedIgcProperties();
            if (nonRelationshipProperties != null) {
                HashSet<String> nonRelationshipsSet = new HashSet<String>(nonRelationshipProperties);
                nonRelationshipsSet.removeAll(alreadyMapped);
                for (String propertyName : nonRelationshipsSet) {
                    Object propertyValue = this.igcEntity.getPropertyByName(propertyName);
                    String value = null;
                    if (propertyValue instanceof ArrayList) {
                        StringBuilder sb = new StringBuilder();
                        List list = (List)propertyValue;
                        if (!list.isEmpty()) {
                            for (int i = 0; i < list.size() - 1; ++i) {
                                sb.append(list.get(i).toString() + ", ");
                            }
                            sb.append(list.get(list.size() - 1));
                        }
                        value = sb.toString();
                    } else if (propertyValue != null) {
                        value = propertyValue.toString();
                    }
                    if (value == null) continue;
                    additionalProperties.put(propertyName, value);
                }
                instanceProperties = omrsRepositoryHelper.addMapPropertyToInstance(repositoryName, instanceProperties, "additionalProperties", additionalProperties, "getMappedInstanceProperties");
            }
        }
        return instanceProperties;
    }

    public List<Relationship> getOMRSRelationships(String relationshipTypeGUID, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize) {
        List<RelationshipMapping> relationshipMappers = this.getRelationshipMappers();
        if (!this.igcEntity.isFullyRetrieved()) {
            ArrayList<String> allProperties = new ArrayList<String>();
            for (RelationshipMapping mapping : relationshipMappers) {
                log.debug("Adding properties from mapping: {}", (Object)mapping);
                allProperties.addAll(mapping.getIgcRelationshipPropertiesForType(this.igcEntity.getType()));
            }
            allProperties.addAll(IGCRestConstants.getModificationProperties());
            IGCSearchSorting sort = IGCSearchSorting.sortFromNonPropertySequencingOrder((SequencingOrder)sequencingOrder);
            this.igcEntity = this.igcEntity.getAssetWithSubsetOfProperties(this.igcomrsRepositoryConnector.getIGCRestClient(), allProperties.toArray(new String[0]), pageSize, sort);
        }
        RelationshipMapping.getMappedRelationships(this.igcomrsRepositoryConnector, this.omrsRelationships, relationshipMappers, relationshipTypeGUID, this.igcEntity, this.userId);
        return this.omrsRelationships;
    }
}

