/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionEndpointMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(ConnectionEndpointMapper.class);

    public static ConnectionEndpointMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private ConnectionEndpointMapper() {
        super("host", "data_connection", "data_connections", "data_connectors", "ConnectionEndpoint", "connectionEndpoint", "connections");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.setLinkingAssetType("connector");
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference connectorAsset, IGCRestClient igcRestClient) {
        String otherAssetType = connectorAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("connector")) {
            Reference withHost = connectorAsset.getAssetWithSubsetOfProperties(igcRestClient, new String[]{"host", "data_connections"});
            asList.add((Reference)withHost.getPropertyByName("host"));
        } else {
            log.debug("Not a connector asset, just returning as-is: {}", (Object)connectorAsset);
            asList.add(connectorAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference connectorAsset, IGCRestClient igcRestClient) {
        String otherAssetType = connectorAsset.getType();
        if (otherAssetType.equals("connector")) {
            Reference withDataConnections = connectorAsset.getAssetWithSubsetOfProperties(igcRestClient, new String[]{"host", "data_connections"});
            ReferenceList dataConnections = (ReferenceList)withDataConnections.getPropertyByName("data_connections");
            dataConnections.getAllPages(igcRestClient);
            return dataConnections.getItems();
        }
        log.debug("Not a connector asset, just returning as-is: {}", (Object)connectorAsset);
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(connectorAsset);
        return referenceAsList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String assetType = Reference.getAssetTypeForSearch((String)fromIgcObject.getType());
        if (assetType.equals("host")) {
            this.addMappedOMRSRelationships_host(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        } else if (assetType.equals("data_connection")) {
            this.addMappedOMRSRelationships_connection(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        } else if (assetType.equals("connector")) {
            List<Reference> connections = this.getProxyTwoAssetFromAsset(fromIgcObject, igcomrsRepositoryConnector.getIGCRestClient());
            for (Reference connection : connections) {
                this.addMappedOMRSRelationships_connection(igcomrsRepositoryConnector, relationships, connection, userId);
            }
        } else {
            log.warn("Found unexpected asset type during relationship mapping: {}", (Object)fromIgcObject);
        }
    }

    private void addMappedOMRSRelationships_host(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_connectors.host", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] properties = new String[]{"name"};
        IGCSearch igcSearch = new IGCSearch("data_connection", properties, igcSearchConditionSet);
        ReferenceList dataConnections = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        dataConnections.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference dataConnection : dataConnections.getItems()) {
            if (dataConnection == null || dataConnection.getType().equals("main_object")) continue;
            try {
                log.debug("Retrieved connection: {}", (Object)dataConnection);
                Relationship relationship = ConnectionEndpointMapper.getMappedRelationship(igcomrsRepositoryConnector, ConnectionEndpointMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "ConnectionEndpoint"), fromIgcObject, dataConnection, "data_connections", userId);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void addMappedOMRSRelationships_connection(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_connections", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] properties = new String[]{"host"};
        IGCSearch igcSearch = new IGCSearch("connector", properties, igcSearchConditionSet);
        ReferenceList dataConnectors = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        dataConnectors.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference dataConnector : dataConnectors.getItems()) {
            if (dataConnector == null || dataConnector.getType().equals("main_object")) continue;
            try {
                log.debug("Retrieved connector: {}", (Object)dataConnector);
                Reference host = (Reference)dataConnector.getPropertyByName("host");
                log.debug("Retrieved host: {}", (Object)host);
                Relationship relationship = ConnectionEndpointMapper.getMappedRelationship(igcomrsRepositoryConnector, ConnectionEndpointMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "ConnectionEndpoint"), host, fromIgcObject, "data_connections", userId);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private static class Singleton {
        private static final ConnectionEndpointMapper INSTANCE = new ConnectionEndpointMapper();

        private Singleton() {
        }
    }
}

