/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.attributes.DataClassAssignmentStatusMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.DataClassMapper;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(DataClassMapper.class);
    private static final String R_DATA_CLASS_ASSIGNMENT = "DataClassAssignment";
    private static final String P_THRESHOLD = "threshold";

    public static DataClassAssignmentMapper getInstance() {
        return Singleton.INSTANCE;
    }

    private DataClassAssignmentMapper() {
        super("main_object", "data_class", "detected_classifications", "classified_assets_detected", R_DATA_CLASS_ASSIGNMENT, "elementsAssignedToDataClass", "dataClassesAssignedToElement");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.addAlternativePropertyFromOne("selected_classification");
        this.addAlternativePropertyFromTwo("classifications_selected");
        this.setRelationshipLevelIgcAsset("classification");
        this.addMappedOmrsProperty("confidence");
        this.addMappedOmrsProperty(P_THRESHOLD);
        this.addMappedOmrsProperty("partialMatch");
        this.addMappedOmrsProperty("valueFrequency");
        this.addMappedOmrsProperty("status");
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference withDataClass = relationshipAsset.getAssetWithSubsetOfProperties(igcRestClient, new String[]{"data_class", "classifies_asset"});
            Reference classifiedObj = (Reference)withDataClass.getPropertyByName("classifies_asset");
            asList.add(classifiedObj);
        } else {
            log.debug("Not a classification asset, just returning as-is: {}", (Object)relationshipAsset);
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference withAsset = relationshipAsset.getAssetWithSubsetOfProperties(igcRestClient, new String[]{"data_class", "classifies_asset"});
            Reference dataClass = (Reference)withAsset.getPropertyByName("data_class");
            asList.add(dataClass);
        } else {
            log.debug("Not a classification asset, just returning as-is: {}", (Object)relationshipAsset);
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String assetType = Reference.getAssetTypeForSearch((String)fromIgcObject.getType());
        if (assetType.equals("data_class")) {
            this.mapDetectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
            this.mapSelectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        } else {
            this.mapDetectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
            this.mapSelectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        }
    }

    private void mapDetectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String methodName = "mapDetectedClassifications_fromDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_class", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] classificationProperties = new String[]{"classifies_asset", "confidencePercent", P_THRESHOLD};
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        ReferenceList detectedClassifications = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        detectedClassifications.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference detectedClassification : detectedClassifications.getItems()) {
            Reference classifiedObj = (Reference)detectedClassification.getPropertyByName("classifies_asset");
            if (classifiedObj == null || classifiedObj.getType().equals("main_object")) continue;
            try {
                Object valFreq;
                Object threshold;
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), classifiedObj, fromIgcObject, "detected_classifications", userId, detectedClassification.getId());
                Object confidence = detectedClassification.getPropertyByName("confidencePercent");
                InstanceProperties relationshipProperties = new InstanceProperties();
                if (confidence != null) {
                    int confidenceVal = ((Number)confidence).intValue();
                    relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, "mapDetectedClassifications_fromDataClass");
                    relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, "mapDetectedClassifications_fromDataClass");
                }
                if ((threshold = detectedClassification.getPropertyByName(P_THRESHOLD)) != null) {
                    relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, ((Float)threshold).floatValue(), "mapDetectedClassifications_fromDataClass");
                }
                if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = detectedClassification.getPropertyByName("value_frequency")) != null) {
                    relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", ((Long)valFreq).longValue(), "mapDetectedClassifications_fromDataClass");
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance().getEnumMappingByIgcValue("discovered");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                log.debug("mapDetectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_classification", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearch igcSearch = new IGCSearch("amazon_s3_data_file_field", igcSearchConditionSet);
        igcSearch.addType("data_file_field");
        igcSearch.addType("database_column");
        igcSearch.addProperty("selected_classification");
        igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        ReferenceList assetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        assetsWithSelected.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference assetWithSelected : assetsWithSelected.getItems()) {
            try {
                InstanceProperties relationshipProperties = new InstanceProperties();
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), assetWithSelected, fromIgcObject, "selected_classification", userId);
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance().getEnumMappingByIgcValue("selected");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                log.debug("mapSelectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapDetectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String methodName = "mapDetectedClassifications_toDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("classifies_asset", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] classificationProperties = new String[]{"data_class", "confidencePercent", P_THRESHOLD};
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        ReferenceList detectedClassifications = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        detectedClassifications.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference detectedClassification : detectedClassifications.getItems()) {
            Reference dataClassObj = (Reference)detectedClassification.getPropertyByName("data_class");
            if (dataClassObj == null || dataClassObj.getType().equals("main_object")) continue;
            try {
                Object valFreq;
                Object threshold;
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), fromIgcObject, dataClassObj, "detected_classifications", userId, detectedClassification.getId());
                Object confidence = detectedClassification.getPropertyByName("confidencePercent");
                InstanceProperties relationshipProperties = new InstanceProperties();
                if (confidence != null) {
                    int confidenceVal = ((Number)confidence).intValue();
                    relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, "mapDetectedClassifications_toDataClass");
                    relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, "mapDetectedClassifications_toDataClass");
                }
                if ((threshold = detectedClassification.getPropertyByName(P_THRESHOLD)) != null) {
                    relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, ((Float)threshold).floatValue(), "mapDetectedClassifications_toDataClass");
                }
                if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = detectedClassification.getPropertyByName("value_frequency")) != null) {
                    relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", ((Long)valFreq).longValue(), "mapDetectedClassifications_toDataClass");
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance().getEnumMappingByIgcValue("discovered");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                log.debug("mapDetectedClassifications_toDataClass - adding relationship: {}", (Object)relationship);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        if (fromIgcObject.hasProperty("selected_classification")) {
            Reference withSelectedClassification = fromIgcObject.getAssetWithSubsetOfProperties(igcomrsRepositoryConnector.getIGCRestClient(), new String[]{"selected_classification"});
            Reference selectedClassification = (Reference)withSelectedClassification.getPropertyByName("selected_classification");
            if (selectedClassification != null && selectedClassification.getType() != null) {
                try {
                    InstanceProperties relationshipProperties = new InstanceProperties();
                    Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), fromIgcObject, (Reference)withSelectedClassification.getPropertyByName("selected_classification"), "selected_classification", userId);
                    EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance().getEnumMappingByIgcValue("selected");
                    relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                    relationship.setProperties(relationshipProperties);
                    log.debug("mapSelectedClassifications_toDataClass - adding relationship: {}", (Object)relationship);
                    relationships.add(relationship);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map relationship.", (Throwable)e);
                }
            } else {
                log.debug("No selected_classification set for asset -- skipping.");
            }
        } else {
            log.info("Provided asset has no selected_classification property: {}", (Object)fromIgcObject.getId());
        }
    }

    private static class Singleton {
        private static final DataClassAssignmentMapper INSTANCE = new DataClassAssignmentMapper();

        private Singleton() {
        }
    }
}

