/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update.IGCUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    public static final String SELF_REFERENCE_SENTINEL = "__SELF__";
    private ProxyMapping one;
    private ProxyMapping two;
    private String omrsRelationshipType;
    private OptimalStart optimalStart;
    private List<RelationshipMapping> subtypes;
    private String relationshipLevelIgcAsset;
    private String linkingAssetType;
    private ArrayList<InstanceStatus> omrsSupportedStatuses;
    private Set<String> mappedOmrsPropertyNames;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RelationshipMapping: ");
        sb.append("omrsRelationshipType=");
        sb.append(this.omrsRelationshipType);
        sb.append(", ");
        sb.append("one={ ");
        sb.append(this.one);
        sb.append(" }, ");
        sb.append("two={ ");
        sb.append(this.two);
        sb.append(" }");
        return sb.toString();
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty) {
        this(igcAssetTypeProxyOne, igcAssetTypeProxyTwo, igcRelationshipPropertyFromOne, igcRelationshipPropertyFromTwo, omrsRelationshipType, omrsRelationshipProxyOneProperty, omrsRelationshipProxyTwoProperty, null, null);
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty, String igcProxyOneRidPrefix, String igcProxyTwoRidPrefix) {
        this.one = new ProxyMapping(igcAssetTypeProxyOne, igcRelationshipPropertyFromOne, omrsRelationshipProxyOneProperty, igcProxyOneRidPrefix);
        this.two = new ProxyMapping(igcAssetTypeProxyTwo, igcRelationshipPropertyFromTwo, omrsRelationshipProxyTwoProperty, igcProxyTwoRidPrefix);
        this.omrsRelationshipType = omrsRelationshipType;
        this.optimalStart = OptimalStart.OPPOSITE;
        this.subtypes = new ArrayList<RelationshipMapping>();
        this.omrsSupportedStatuses = new ArrayList();
        this.mappedOmrsPropertyNames = new HashSet<String>();
        this.addSupportedStatus(InstanceStatus.ACTIVE);
        this.addSupportedStatus(InstanceStatus.DELETED);
    }

    public void addSupportedStatus(InstanceStatus status) {
        this.omrsSupportedStatuses.add(status);
    }

    public List<InstanceStatus> getSupportedStatuses() {
        return this.omrsSupportedStatuses;
    }

    public void addMappedOmrsProperty(String name) {
        this.mappedOmrsPropertyNames.add(name);
    }

    public Set<String> getMappedOmrsPropertyNames() {
        return this.mappedOmrsPropertyNames;
    }

    public void setRelationshipLevelIgcAsset(String igcAssetType) {
        this.relationshipLevelIgcAsset = igcAssetType;
    }

    public boolean hasRelationshipLevelAsset() {
        return this.relationshipLevelIgcAsset != null;
    }

    public String getRelationshipLevelIgcAsset() {
        return this.relationshipLevelIgcAsset;
    }

    public void setLinkingAssetType(String igcAssetType) {
        this.linkingAssetType = igcAssetType;
    }

    public boolean hasLinkingAsset() {
        return this.linkingAssetType != null;
    }

    public String getLinkingAssetType() {
        return this.linkingAssetType;
    }

    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public boolean hasSubTypes() {
        return !this.subtypes.isEmpty();
    }

    public void addSubType(RelationshipMapping subRelationshipMapping) {
        this.subtypes.add(subRelationshipMapping);
    }

    public List<RelationshipMapping> getSubTypes() {
        return this.subtypes;
    }

    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
    }

    public String getOmrsRelationshipType() {
        return this.omrsRelationshipType;
    }

    public void setOptimalStart(OptimalStart optimalStart) {
        this.optimalStart = optimalStart;
    }

    public OptimalStart getOptimalStart() {
        return this.optimalStart;
    }

    public void addAlternativePropertyFromOne(String property) {
        this.one.addAlternativeIgcRelationshipProperty(property);
    }

    public void addAlternativePropertyFromTwo(String property) {
        this.two.addAlternativeIgcRelationshipProperty(property);
    }

    public boolean isSelfReferencing() {
        return this.one.isSelfReferencing() || this.two.isSelfReferencing();
    }

    public ProxyMapping getProxyOneMapping() {
        return this.one;
    }

    public ProxyMapping getProxyTwoMapping() {
        return this.two;
    }

    public boolean sameTypeOnBothEnds() {
        return this.one.getIgcAssetType().equals(this.two.getIgcAssetType());
    }

    public boolean samePropertiesOnBothEnds() {
        List<String> pOneProperties = this.one.getIgcRelationshipProperties();
        List<String> pTwoProperties = this.two.getIgcRelationshipProperties();
        return new HashSet<String>(pOneProperties).equals(new HashSet<String>(pTwoProperties));
    }

    public ProxyMapping getProxyFromType(String igcAssetType) {
        ProxyMapping same = null;
        if (igcAssetType == null) {
            log.error("No asset type provided: {}", (Object)igcAssetType);
        } else {
            String simpleType = Reference.getAssetTypeForSearch((String)igcAssetType);
            if (simpleType.equals(this.one.getIgcAssetType())) {
                same = this.one;
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                same = this.two;
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                same = this.one;
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                same = this.two;
            } else {
                log.error("getProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return same;
    }

    public ProxyMapping getOtherProxyFromType(String igcAssetType) {
        ProxyMapping other = null;
        if (igcAssetType == null) {
            log.error("No asset type provided: {}", (Object)igcAssetType);
        } else {
            String simpleType = Reference.getAssetTypeForSearch((String)igcAssetType);
            if (simpleType.equals(this.one.getIgcAssetType())) {
                other = this.two;
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                other = this.one;
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                other = this.two;
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                other = this.one;
            } else {
                log.error("getOtherProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return other;
    }

    public List<String> getIgcRelationshipPropertiesForType(String igcAssetType) {
        ArrayList<String> properties = new ArrayList<String>();
        if (igcAssetType == null) {
            log.error("No asset type provided: {}", (Object)igcAssetType);
        } else {
            String simpleType = Reference.getAssetTypeForSearch((String)igcAssetType);
            if (this.sameTypeOnBothEnds() && simpleType.equals(this.one.getIgcAssetType())) {
                this.addRealPropertiesToList(this.one.getIgcRelationshipProperties(), properties);
                this.addRealPropertiesToList(this.two.getIgcRelationshipProperties(), properties);
            } else if (simpleType.equals(this.one.getIgcAssetType())) {
                this.addRealPropertiesToList(this.one.getIgcRelationshipProperties(), properties);
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                this.addRealPropertiesToList(this.two.getIgcRelationshipProperties(), properties);
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                this.addRealPropertiesToList(this.one.getIgcRelationshipProperties(), properties);
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                this.addRealPropertiesToList(this.two.getIgcRelationshipProperties(), properties);
            } else {
                log.warn("getIgcRelationshipPropertiesForType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return properties;
    }

    private void addRealPropertiesToList(List<String> candidates, List<String> realProperties) {
        for (String propertyName : candidates) {
            if (propertyName.equals(SELF_REFERENCE_SENTINEL) || propertyName.equals("") || realProperties.contains(propertyName)) continue;
            realProperties.add(propertyName);
        }
    }

    public static String getRelationshipGUID(RelationshipMapping relationshipMapping, Reference endOne, Reference endTwo, String igcPropertyName, String relationshipLevelRid) {
        String proxyTwoRid;
        String proxyOneRid;
        ProxyMapping pmTwo;
        ProxyMapping pmOne;
        String omrsRelationshipName;
        block25: {
            List<String> pmTwoProperties;
            List<String> pmOneProperties;
            String endTwoType;
            String endOneType;
            block26: {
                block27: {
                    block24: {
                        omrsRelationshipName = relationshipMapping.getOmrsRelationshipType();
                        endOneType = Reference.getAssetTypeForSearch((String)endOne.getType());
                        endTwoType = Reference.getAssetTypeForSearch((String)endTwo.getType());
                        log.debug("Calculating relationship GUID from {} to {} via {} for {} (with mapper: {})", new Object[]{endOneType, endTwoType, igcPropertyName, omrsRelationshipName, relationshipMapping.getClass().getCanonicalName()});
                        if (relationshipMapping.hasRelationshipLevelAsset()) {
                            String relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
                            if (endOneType.equals(relationshipLevelType)) {
                                relationshipLevelRid = endOne.getId();
                            } else if (endTwoType.equals(relationshipLevelType)) {
                                relationshipLevelRid = endTwo.getId();
                            }
                        }
                        pmOne = relationshipMapping.getProxyOneMapping();
                        pmTwo = relationshipMapping.getProxyTwoMapping();
                        pmOneProperties = pmOne.getIgcRelationshipProperties();
                        pmTwoProperties = pmTwo.getIgcRelationshipProperties();
                        proxyOneRid = null;
                        proxyTwoRid = null;
                        if (igcPropertyName == null || !igcPropertyName.equals(SELF_REFERENCE_SENTINEL)) break block24;
                        proxyOneRid = endOne.getId();
                        proxyTwoRid = endTwo.getId();
                        if (pmOne.getIgcRidPrefix() == null && pmTwo.getIgcRidPrefix() == null) {
                            log.warn("Self-referencing relationship expected, but no prefix found for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid, igcPropertyName});
                        }
                        if (!proxyOneRid.equals(proxyTwoRid)) {
                            log.warn("Self-referencing relationship expected for {}, but RIDs of ends do not match: {} and {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid});
                        }
                        break block25;
                    }
                    if (!relationshipMapping.sameTypeOnBothEnds() || !pmOne.matchesAssetType(endOneType)) break block26;
                    if (!relationshipMapping.samePropertiesOnBothEnds()) break block27;
                    String endOneRid = endOne.getId();
                    String endTwoRid = endTwo.getId();
                    log.debug(" ... same types, same properties: alphabetically sorting RIDs.");
                    if (endOneRid.compareTo(endTwoRid) > 0) {
                        proxyOneRid = endOneRid;
                        proxyTwoRid = endTwoRid;
                    } else {
                        proxyOneRid = endTwoRid;
                        proxyTwoRid = endOneRid;
                    }
                    break block25;
                }
                switch (relationshipMapping.getOptimalStart()) {
                    case OPPOSITE: {
                        if (pmOneProperties.contains(igcPropertyName)) {
                            log.debug(" ... same types, opposite lookup, property matches one: reversing RIDs.");
                            proxyOneRid = endTwo.getId();
                            proxyTwoRid = endOne.getId();
                            break;
                        }
                        if (pmTwoProperties.contains(igcPropertyName)) {
                            log.debug(" ... same types, opposite lookup, property matches two: keeping RID direction.");
                            proxyOneRid = endOne.getId();
                            proxyTwoRid = endTwo.getId();
                            break;
                        }
                        break block25;
                    }
                    default: {
                        if (pmOneProperties.contains(igcPropertyName)) {
                            log.debug(" ... same types, direct lookup, property matches one: keeping RID direction.");
                            proxyOneRid = endOne.getId();
                            proxyTwoRid = endTwo.getId();
                            break;
                        }
                        if (pmTwoProperties.contains(igcPropertyName)) {
                            log.debug(" ... same types, direct lookup, property matches two: reversing RIDs.");
                            proxyOneRid = endTwo.getId();
                            proxyTwoRid = endOne.getId();
                            break;
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (pmOne.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmTwo.matchesAssetType(endTwoType)) {
                log.debug(" ... one matches one, two matches two: keeping RID direction.");
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
            } else if (pmTwo.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmOne.matchesAssetType(endTwoType)) {
                log.debug(" ... two matches one, one matches two: reversing RIDs.");
                proxyOneRid = endTwo.getId();
                proxyTwoRid = endOne.getId();
            } else if (relationshipLevelRid == null) {
                log.error("Unable to find matching ends for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, endOne.getId(), endTwo.getId(), igcPropertyName});
            }
        }
        String proxyOnePrefix = pmOne.getIgcRidPrefix();
        String proxyTwoPrefix = pmTwo.getIgcRidPrefix();
        StringBuilder sbGUID = new StringBuilder();
        if (relationshipLevelRid != null) {
            sbGUID.append(relationshipLevelRid);
            sbGUID.append("::");
            sbGUID.append(omrsRelationshipName);
            sbGUID.append("::");
            sbGUID.append(relationshipLevelRid);
        } else {
            if (proxyOnePrefix != null) {
                proxyOneRid = proxyOnePrefix + proxyOneRid;
            }
            if (proxyTwoPrefix != null) {
                proxyTwoRid = proxyTwoPrefix + proxyTwoRid;
            }
            sbGUID.append(proxyOneRid);
            sbGUID.append("::");
            sbGUID.append(omrsRelationshipName);
            sbGUID.append("::");
            sbGUID.append(proxyTwoRid);
        }
        return sbGUID.toString();
    }

    public static String getProxyOneGUIDFromRelationshipGUID(String relationshipGUID) {
        return RelationshipMapping.getRelationshipGUIDToken(relationshipGUID, 0);
    }

    public static String getProxyTwoGUIDFromRelationshipGUID(String relationshipGUID) {
        return RelationshipMapping.getRelationshipGUIDToken(relationshipGUID, 2);
    }

    public static String getRelationshipTypeFromRelationshipGUID(String relationshipGUID) {
        return RelationshipMapping.getRelationshipGUIDToken(relationshipGUID, 1);
    }

    private static String getRelationshipGUIDToken(String relationshipGUID, int index) {
        String[] aTokens = relationshipGUID.split("::");
        if (aTokens.length != 3) {
            log.warn("Unexpected number of tokens from relationship GUID: {}", (Object)relationshipGUID);
        }
        if (aTokens.length >= index) {
            return aTokens[index];
        }
        log.error("Unable to translate provided relationship GUID: {}", (Object)relationshipGUID);
        return null;
    }

    public static EntityProxy getEntityProxyForObject(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcObj, String userId, String ridPrefix) {
        EntityProxy entityProxy;
        block10: {
            String methodName = "getEntityProxyForObject";
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            String igcType = igcObj.getType();
            entityProxy = null;
            if (igcType != null) {
                IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
                ReferenceableMapper referenceableMapper = igcomrsMetadataCollection.getMapperForParameters(igcObj, ridPrefix, userId);
                if (referenceableMapper != null) {
                    String identity = igcObj.getIdentity(igcRestClient).toString();
                    if (ridPrefix != null) {
                        identity = ridPrefix + identity;
                    }
                    InstanceProperties uniqueProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "qualifiedName", identity, "getEntityProxyForObject");
                    try {
                        entityProxy = igcomrsRepositoryConnector.getRepositoryHelper().getNewEntityProxy(igcomrsRepositoryConnector.getRepositoryName(), igcomrsRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, userId, referenceableMapper.getOmrsTypeDefName(), uniqueProperties, null);
                        if (ridPrefix != null) {
                            entityProxy.setGUID(ridPrefix + igcObj.getId());
                        } else {
                            entityProxy.setGUID(igcObj.getId());
                        }
                        if (!igcObj.hasModificationDetails()) break block10;
                        igcObj.populateModificationDetails(igcRestClient);
                        entityProxy.setCreatedBy((String)igcObj.getPropertyByName("created_by"));
                        entityProxy.setCreateTime((Date)igcObj.getPropertyByName("created_on"));
                        entityProxy.setUpdatedBy((String)igcObj.getPropertyByName("modified_by"));
                        entityProxy.setUpdateTime((Date)igcObj.getPropertyByName("modified_on"));
                        if (entityProxy.getUpdateTime() != null) {
                            entityProxy.setVersion(entityProxy.getUpdateTime().getTime());
                        }
                    }
                    catch (TypeErrorException e) {
                        log.error("Unable to create new EntityProxy.", (Throwable)e);
                    }
                } else {
                    log.error("Unable to find mapper for IGC object type '{}' with prefix '{}', cannot setup EntityProxy for {}", new Object[]{igcType, ridPrefix, igcObj.getId()});
                }
            } else {
                log.error("Unable to find type for provided IGC object: {}", (Object)igcObj);
            }
        }
        return entityProxy;
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, String relationshipTypeGUID, Reference fromIgcObject, String userId) {
        for (RelationshipMapping mapping : mappings) {
            RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
            if (relationshipTypeGUID != null && !relationshipTypeGUID.equals(omrsRelationshipDef.getGUID())) continue;
            OptimalStart optimalStart = mapping.getOptimalStart();
            String fromAssetType = fromIgcObject.getType();
            ProxyMapping pmOne = mapping.getProxyOneMapping();
            ProxyMapping pmTwo = mapping.getProxyTwoMapping();
            if (mapping.isSelfReferencing()) {
                RelationshipMapping.addSelfReferencingRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, userId);
            } else if (!optimalStart.equals((Object)OptimalStart.CUSTOM)) {
                if (fromIgcObject == null) {
                    log.error("Object received to lookup {} relationship was null, cannot proceed.", (Object)relationshipTypeGUID);
                } else if (fromIgcObject.isFullyRetrieved() || optimalStart.equals((Object)OptimalStart.ONE) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.TWO) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addDirectRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, userId);
                } else if (optimalStart.equals((Object)OptimalStart.OPPOSITE) || optimalStart.equals((Object)OptimalStart.TWO) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.ONE) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addInvertedRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, userId);
                } else {
                    log.warn("Ran out of options for finding the relationship: {}", (Object)omrsRelationshipDef.getName());
                }
            }
            mapping.addMappedOMRSRelationships(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        }
    }

    private static void addSelfReferencingRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        try {
            Relationship relationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, fromIgcObject, fromIgcObject, SELF_REFERENCE_SENTINEL, userId);
            log.debug("addSelfReferencingRelationship - adding relationship: {}", (Object)relationship);
            relationships.add(relationship);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to add self-referencing relationship for: {}", (Object)fromIgcObject, (Object)e);
        }
    }

    private static void addDirectRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        for (String igcRelationshipName : mapping.getIgcRelationshipPropertiesForType(fromIgcObject.getType())) {
            Object directRelationships = fromIgcObject.getPropertyByName(igcRelationshipName);
            if (directRelationships != null && Reference.isReference((Object)directRelationships).booleanValue()) {
                RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, (Reference)directRelationships, igcRelationshipName, userId);
                continue;
            }
            if (directRelationships != null && Reference.isReferenceList((Object)directRelationships).booleanValue()) {
                RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, (ReferenceList)directRelationships, igcRelationshipName, userId);
                continue;
            }
            log.debug(" ... skipping relationship {}, either empty or neither reference or list {}", (Object)igcRelationshipName, directRelationships);
        }
    }

    private static void addInvertedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String assetType = fromIgcObject.getType();
        log.debug("Adding inverted relationship for mapping: {}", (Object)mapping);
        if (mapping.sameTypeOnBothEnds()) {
            List<String> igcProperties = mapping.getIgcRelationshipPropertiesForType(assetType);
            for (String igcRelationshipName : igcProperties) {
                IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(condition);
                RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, igcSearchConditionSet, assetType, igcRelationshipName, userId);
            }
        } else {
            ProxyMapping otherSide = mapping.getOtherProxyFromType(assetType);
            log.debug(" ... found other proxy: {}", (Object)otherSide);
            ProxyMapping thisSide = mapping.getProxyFromType(assetType);
            log.debug(" ... found this proxy: {}", (Object)thisSide);
            String anIgcRelationshipProperty = null;
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
            igcSearchConditionSet.setMatchAnyCondition(true);
            for (String igcRelationshipName : otherSide.getIgcRelationshipProperties()) {
                IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                igcSearchConditionSet.addCondition(condition);
                anIgcRelationshipProperty = igcRelationshipName;
            }
            String sourceAssetType = otherSide.getIgcAssetType();
            RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, igcSearchConditionSet, sourceAssetType, anIgcRelationshipProperty, userId);
        }
    }

    private static void addSearchResultsToRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, IGCSearchConditionSet igcSearchConditionSet, String assetType, String igcPropertyName, String userId) {
        Class pojo;
        IGCSearch igcSearch = new IGCSearch(assetType, igcSearchConditionSet);
        if (!assetType.equals("main_object") && (pojo = igcomrsRepositoryConnector.getIGCRestClient().getPOJOForType(assetType)) != null && Reference.hasModificationDetails((Class)pojo)) {
            igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        }
        ReferenceList foundRelationships = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, foundRelationships, igcPropertyName, userId);
    }

    private static void addListOfMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, ReferenceList igcRelationships, String igcPropertyName, String userId) {
        log.debug(" ... list of references: {}", (Object)mapping.getOmrsRelationshipType());
        igcRelationships.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference relation : igcRelationships.getItems()) {
            RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, relation, igcPropertyName, userId);
        }
    }

    private static void addSingleMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, Reference igcRelationship, String igcPropertyName, String userId) {
        log.debug(" ... single reference: {}", (Object)igcRelationship);
        if (igcRelationship != null && igcRelationship.getType() != null && !igcRelationship.getType().equals("null")) {
            try {
                Relationship omrsRelationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, fromIgcObject, igcRelationship, igcPropertyName, userId);
                log.debug("addSingleMappedRelationship - adding relationship: {}", (Object)omrsRelationship);
                relationships.add(omrsRelationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to add relationship {} for object {}", (Object)mapping.getOmrsRelationshipType(), (Object)igcRelationship);
            }
        }
    }

    private static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, Reference fromIgcObject, Reference relation, String igcPropertyName, String userId) throws RepositoryErrorException {
        RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, omrsRelationshipDef, fromIgcObject, relation, igcPropertyName, userId);
    }

    protected static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId) throws RepositoryErrorException {
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, proxyOne, proxyTwo, igcPropertyName, userId, null);
    }

    public static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId, String relationshipLevelRid) throws RepositoryErrorException {
        String methodName = "getMappedRelationship";
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        String omrsRelationshipName = omrsRelationshipDef.getName();
        Relationship relationship = new Relationship();
        try {
            InstanceType instanceType = igcomrsRepositoryConnector.getRepositoryHelper().getNewInstanceType(igcomrsRepositoryConnector.getRepositoryName(), (TypeDefSummary)omrsRelationshipDef);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("Unable to construct and set InstanceType -- skipping relationship: {}", (Object)omrsRelationshipName);
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMappedRelationship", omrsRelationshipDef.getName()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), RelationshipMapping.class.getName(), "getMappedRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (proxyOne != null && proxyTwo != null) {
            String relationshipGUID = RelationshipMapping.getRelationshipGUID(relationshipMapping, proxyOne, proxyTwo, igcPropertyName, relationshipLevelRid);
            if (relationshipGUID == null) {
                log.error("Unable to construct relationship GUID -- skipping relationship: {}", (Object)omrsRelationshipName);
                String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
                String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
                OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), RelationshipMapping.class.getName(), "getMappedRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            relationship.setGUID(relationshipGUID);
            relationship.setMetadataCollectionId(igcomrsRepositoryConnector.getMetadataCollectionId());
            relationship.setStatus(InstanceStatus.ACTIVE);
            relationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            String guidForEP1 = RelationshipMapping.getProxyOneGUIDFromRelationshipGUID(relationshipGUID);
            String guidForEP2 = RelationshipMapping.getProxyTwoGUIDFromRelationshipGUID(relationshipGUID);
            String ridForEP1 = IGCOMRSMetadataCollection.getRidFromGeneratedId(guidForEP1);
            String ridForEP2 = IGCOMRSMetadataCollection.getRidFromGeneratedId(guidForEP2);
            EntityProxy ep1 = null;
            EntityProxy ep2 = null;
            if (relationshipLevelRid != null || ridForEP1.equals(proxyOne.getId()) && ridForEP2.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyOne, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyTwo, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else if (ridForEP2.equals(proxyOne.getId()) && ridForEP1.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyTwo, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyOne, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else {
                log.error("Unable to determine both ends of the relationship {} from {} to {}", new Object[]{omrsRelationshipName, proxyOne.getId(), proxyTwo.getId()});
                String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
                String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
                OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), RelationshipMapping.class.getName(), "getMappedRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (ep1 != null && ep1.getUpdateTime() != null) {
                relationship.setVersion(ep1.getUpdateTime().getTime());
                relationship.setCreateTime(ep1.getUpdateTime());
                relationship.setCreatedBy(ep1.getCreatedBy());
                relationship.setUpdatedBy(ep1.getUpdatedBy());
                relationship.setUpdateTime(ep1.getUpdateTime());
            } else if (ep2 != null && ep2.getUpdateTime() != null) {
                relationship.setVersion(ep2.getUpdateTime().getTime());
                relationship.setCreateTime(ep2.getUpdateTime());
                relationship.setCreatedBy(ep2.getCreatedBy());
                relationship.setUpdatedBy(ep2.getUpdatedBy());
                relationship.setUpdateTime(ep2.getUpdateTime());
            }
            if (ep1 != null && ep2 != null) {
                relationship.setEntityOneProxy(ep1);
                relationship.setEntityTwoProxy(ep2);
            }
        } else {
            String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
            String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), RelationshipMapping.class.getName(), "getMappedRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationship;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Relationship addIgcRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, InstanceProperties initialProperties, Reference proxyOne, Reference proxyTwo, String userId) throws RepositoryErrorException {
        String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
        String propertyUsed = null;
        Map relationshipProperties = null;
        if (initialProperties != null) {
            relationshipProperties = initialProperties.getInstanceProperties();
        }
        if (!relationshipMapping.isSelfReferencing()) {
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
            String methodName = "addIgcRelationship";
            String className = "RelationshipMapping";
            if (relationshipMapping.hasRelationshipLevelAsset()) {
                String relationshipLevelAssetType = relationshipMapping.getRelationshipLevelIgcAsset();
                Class pojo = igcRestClient.getPOJOForType(relationshipLevelAssetType);
                if (Reference.isCreatableFromPOJO((Class)pojo)) {
                    log.info("Creating a relationship-level asset for IGC type {} is not yet implemented.", (Object)relationshipLevelAssetType);
                }
                OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_LOGIC_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName, methodName, "Cannot create relationship for IGC asset type: " + relationshipLevelAssetType});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (relationshipProperties != null && !relationshipProperties.isEmpty()) {
                OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_LOGIC_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName, methodName, "Cannot capture any relationship-level properties in IGC: " + initialProperties});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OptimalStart direction = relationshipMapping.getOptimalStart();
            List<String> igcRelationshipProperties = null;
            String entityToUpdateRid = null;
            String relatedEntityRid = null;
            switch (relationshipMapping.getOptimalStart()) {
                case OPPOSITE: 
                case ONE: {
                    igcRelationshipProperties = relationshipMapping.getProxyOneMapping().getIgcRelationshipProperties();
                    entityToUpdateRid = proxyOne.getId();
                    relatedEntityRid = proxyTwo.getId();
                    break;
                }
                case TWO: {
                    igcRelationshipProperties = relationshipMapping.getProxyTwoMapping().getIgcRelationshipProperties();
                    entityToUpdateRid = proxyTwo.getId();
                    relatedEntityRid = proxyOne.getId();
                    break;
                }
            }
            if (igcRelationshipProperties != null && !igcRelationshipProperties.isEmpty()) {
                IGCUpdate igcUpdate = new IGCUpdate(entityToUpdateRid);
                propertyUsed = igcRelationshipProperties.get(0);
                igcUpdate.addRelationship(propertyUsed, relatedEntityRid);
                igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.APPEND);
                if (igcomrsRepositoryConnector.getIGCRestClient().update(igcUpdate)) return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, proxyOne, proxyTwo, propertyUsed, userId);
                OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_LOGIC_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName, methodName, "Failed to create relationship: " + omrsRelationshipType});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_LOGIC_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName, methodName, "Cannot create relationships of this type: " + omrsRelationshipType});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        log.info("Relationship {} is self-referencing in IGC; skipping.", (Object)omrsRelationshipType);
        propertyUsed = SELF_REFERENCE_SENTINEL;
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, proxyOne, proxyTwo, propertyUsed, userId);
    }

    public class ProxyMapping {
        private String igcAssetType;
        private ArrayList<String> igcRelationshipProperties;
        private String omrsRelationshipProperty;
        private String igcRidPrefix;
        private Set<String> excludeIgcAssetType;

        public ProxyMapping(String igcAssetType, String igcRelationshipProperty, String omrsRelationshipProperty, String igcRidPrefix) {
            this.igcAssetType = igcAssetType;
            this.igcRelationshipProperties = new ArrayList();
            this.igcRelationshipProperties.add(igcRelationshipProperty);
            this.omrsRelationshipProperty = omrsRelationshipProperty;
            this.igcRidPrefix = igcRidPrefix;
            this.excludeIgcAssetType = new HashSet<String>();
        }

        public String getIgcAssetType() {
            return this.igcAssetType;
        }

        public List<String> getIgcRelationshipProperties() {
            return this.igcRelationshipProperties;
        }

        public void addAlternativeIgcRelationshipProperty(String igcRelationshipProperty) {
            this.igcRelationshipProperties.add(igcRelationshipProperty);
        }

        public String getOmrsRelationshipProperty() {
            return this.omrsRelationshipProperty;
        }

        public String getIgcRidPrefix() {
            return this.igcRidPrefix;
        }

        public boolean isSelfReferencing() {
            return this.igcRelationshipProperties.contains(RelationshipMapping.SELF_REFERENCE_SENTINEL);
        }

        public void addExcludedIgcAssetType(String igcAssetType) {
            this.excludeIgcAssetType.add(igcAssetType);
        }

        public boolean matchesAssetType(String igcAssetType) {
            String simplifiedType = Reference.getAssetTypeForSearch((String)igcAssetType);
            log.debug("checking for matching asset between {} and {}", (Object)this.igcAssetType, (Object)simplifiedType);
            return this.igcAssetType.equals(simplifiedType) || this.igcAssetType.equals("main_object") && !this.excludeIgcAssetType.contains(simplifiedType) || RelationshipMapping.this.hasLinkingAsset() && simplifiedType.equals(RelationshipMapping.this.getLinkingAssetType());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("igcAssetType=");
            sb.append(this.igcAssetType);
            sb.append(", omrsRelationshipProperty=");
            sb.append(this.omrsRelationshipProperty);
            sb.append(", igcRidPrefix=");
            sb.append(this.igcRidPrefix);
            sb.append(", igcRelationshipProperties=");
            sb.append(this.igcRelationshipProperties);
            return sb.toString();
        }
    }

    public static enum OptimalStart {
        ONE,
        TWO,
        OPPOSITE,
        CUSTOM;

    }
}

